# generated by datamodel-codegen:
#   filename:  data.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from datetime import datetime, timedelta
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel, constr


class DataType(str, Enum):
    """
    Type of data source that determines how the data is accessed and processed. Each type requires different configuration in the dataSpec property.
    """

    oceanql = 'oceanql'
    zarr = 'zarr'
    dataset = 'dataset'
    geojson = 'geojson'
    transform = 'transform'


class Point(EidosModel):
    """
    Point Model
    """

    coordinates: List[Union[float, int]] = Field(..., title='Coordinates')
    type: Literal['Point'] = Field('Point', title='Type')


class MultiPoint(EidosModel):
    """
    MultiPoint Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=1, title='Coordinates'
    )
    type: Literal['MultiPoint'] = Field('MultiPoint', title='Type')


class LineString(EidosModel):
    """
    LineString Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=2, title='Coordinates'
    )
    type: Literal['LineString'] = Field('LineString', title='Type')


class Coordinate(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class MultiLineString(EidosModel):
    """
    MultiLineString Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiLineString'] = Field('MultiLineString', title='Type')


class Polygon(EidosModel):
    """
    Polygon Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['Polygon'] = Field('Polygon', title='Type')


class Coordinate2Item(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class Coordinate2(RootModel[List[Coordinate2Item]]):
    root: List[Coordinate2Item]


class MultiPolygon(EidosModel):
    """
    MultiPolygon Model
    """

    coordinates: List[Coordinate2] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiPolygon'] = Field('MultiPolygon', title='Type')


class Type(str, Enum):
    Feature = 'Feature'


class AggregateOps(str, Enum):
    mean = 'mean'
    min = 'min'
    max = 'max'
    std = 'std'
    sum = 'sum'


class CoordSelector(EidosModel):
    coord: str = Field(..., title='Coordinate name')
    values: List[Union[str, int, float]] = Field(
        ..., title='List of coordinate values to select by'
    )


class GeoFilterType(str, Enum):
    """
    Type of the geofilter. Can be one of:
    - 'feature': Select with a geojson feature
    - 'bbox': Select with a bounding box
    - 'radius': Select within radius of point
    """

    feature = 'feature'
    radius = 'radius'
    bbox = 'bbox'


class ResampleType(str, Enum):
    mean = 'mean'
    nearest = 'nearest'


class TimeFilterType(str, Enum):
    """
    Type of the timefilter. Can be one of:
    - 'range': Select within a time range
    """

    range = 'range'
    series = 'series'


class Coordkeys(RootModel[Dict[constr(pattern=r'^[xyztg]$'), str]]):
    root: Dict[constr(pattern=r'^[xyztg]$'), str]
    """
    Coordinate keys mapping variables to dimensions (x: longitude, y: latitude, z: depth/altitude, g: geometry, t: time)
    """


class Zarr(EidosModel):
    group: str
    """
    Zarr group URL
    """
    headers: Optional[Dict[constr(pattern=r'^.*$'), str]] = None
    """
    Headers for zarr dataset
    """
    coordkeys: Coordkeys


class Dtype(str, Enum):
    int32 = 'int32'
    int64 = 'int64'
    float32 = 'float32'
    float64 = 'float64'
    string = 'string'


class DataVariable(EidosModel):
    attributes: Optional[Dict[constr(pattern=r'^.*$'), Union[str, float]]] = None
    """
    Attributes of the data variable
    """
    data: List[Optional[Union[float, str, List]]]
    """
    Data of the variable
    """
    dimensions: List[str]
    """
    Dimensions of the variable
    """
    dtype: Optional[Dtype] = None


class Dataset(EidosModel):
    """
    Inline dataset
    """

    model_config = ConfigDict(
        extra='allow',
    )
    name: Optional[str] = None
    attributes: Optional[
        Dict[constr(pattern=r'^[A-Za-z0-9_]*$'), Union[str, float, int]]
    ] = None
    """
    Attributes of the dataset
    """
    variables: Dict[constr(pattern=r'^[A-Za-z0-9_]*$'), DataVariable]
    """
    Data variables
    """
    dimensions: Dict[constr(pattern=r'^.*$'), int]
    """
    Dimensions
    """
    coordkeys: Coordkeys


class OutputType(str, Enum):
    """
    Output data type
    """

    dataset = 'dataset'
    geojson = 'geojson'


class Transform(EidosModel):
    """
    Specification for data transform.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[str] = None
    """
    Human readable name of this transform instance
    """
    modules: Optional[Dict[str, Any]] = None
    """
    Modules to add as key:<Module URL>
    """
    inputs: List
    """
    Source inputs
    """
    outputType: Optional[OutputType] = 'dataset'
    """
    Output data type
    """
    code: str = Field(..., title='Transform code')
    """
    Transform code as body of function
    """


class Aggregate(EidosModel):
    operations: Optional[List[AggregateOps]] = Field(
        ['mean'], title='Aggregate operations to perform'
    )
    spatial: Optional[bool] = Field(True, title='Aggregate over spatial filter')
    temporal: Optional[bool] = Field(True, title='Aggregate over temporal filter')


class TimeFilter(EidosModel):
    type: Optional[TimeFilterType] = Field('range', title='Timefilter type')
    times: List[Optional[Union[datetime, timedelta]]] = Field(
        ..., title='Time range or series'
    )
    resolution: Optional[str] = Field('native', title='Temporal resolution of data')
    resample: Optional[ResampleType] = Field('mean', title='Resampling operator')


class EidosData(EidosModel):
    """
    Data source specification for EIDOS visualizations. Defines how to access and process data from various sources including Oceanum Datamesh, Zarr arrays, inline datasets, GeoJSON features, and data transformations. Each data source has a unique ID that can be referenced by visualization components.
    """

    id: constr(pattern=r'^[A-Za-z0-9_-]+$') = Field(
        ...,
        examples=[
            'sig-wave-height-trki',
            'ship-positions',
            'weather-data',
            'hs-1',
            'spec-1',
        ],
    )
    """
    Unique identifier for this data source within the specification. Must be alphanumeric with hyphens and underscores only. This ID is used to reference the data source from visualization layers and components.
    """
    dataType: DataType = Field(..., examples=['dataset', 'geojson', 'transform'])
    """
    Type of data source that determines how the data is accessed and processed. Each type requires different configuration in the dataSpec property.
    """
    dataSpec: Union[Dataset, Transform, FeatureCollection, Feature, Oceanql, Zarr]


class FeatureCollection(EidosModel):
    type: Literal['FeatureCollection']
    features: List[Feature]


class GeometryCollection(EidosModel):
    """
    GeometryCollection Model
    """

    type: Literal['GeometryCollection'] = Field('GeometryCollection', title='Type')
    geometries: List[Geometry] = Field(..., title='Geometries')


class Geometry(
    RootModel[
        Union[
            Point,
            MultiPoint,
            LineString,
            MultiLineString,
            Polygon,
            MultiPolygon,
            GeometryCollection,
        ]
    ]
):
    root: Union[
        Point,
        MultiPoint,
        LineString,
        MultiLineString,
        Polygon,
        MultiPolygon,
        GeometryCollection,
    ] = Field(..., title='Geometry')
    """
    Geometry Model
    """


class Feature(EidosModel):
    """
    Feature Model
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type = Field(..., title='Type')
    geometry: Geometry
    properties: Optional[Dict[str, Any]] = Field(None, title='Properties')
    id: Optional[str] = Field(None, title='Id')
    bbox: Optional[List[Union[float, int]]] = Field(None, title='Bbox')


class Oceanql(EidosModel):
    datasource: str = Field(..., title='The id of the datasource')
    parameters: Optional[Dict[str, Any]] = Field({}, title='Datasource parameters')
    description: Optional[str] = Field(None, title='Optional description of this query')
    variables: Optional[List[str]] = Field(None, title='List of selected variables')
    timefilter: Optional[TimeFilter] = Field(None, title='Time filter')
    geofilter: Optional[GeoFilter] = Field(None, title='Spatial filter or interpolator')
    coordfilter: Optional[List[CoordSelector]] = Field(
        None, title='List of additional coordinate filters'
    )
    crs: Optional[Union[int, str]] = Field(
        None, title='Spatial reference for filter and output'
    )
    aggregate: Optional[Aggregate] = Field(None, title='Aggregate operations')
    limit: Optional[int] = Field(None, title='Limit size of response')
    id: Optional[str] = Field(None, title='Unique ID of this query')


class GeoFilter(EidosModel):
    type: Optional[GeoFilterType] = Field('bbox', title='GeoFilter type')
    geom: Union[List[float], Feature] = Field(..., title='bbox OR geojson Feature')
    resolution: Optional[float] = Field(0.0, title='Maximum spatial resolution of data')
    alltouched: Optional[bool] = Field(None, title='Include all touched grid pixels')


EidosData.model_rebuild()
FeatureCollection.model_rebuild()
GeometryCollection.model_rebuild()
Oceanql.model_rebuild()
