# generated by datamodel-codegen:
#   filename:  geojson.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel


class GeoJSON(EidosModel):
    """
    GeoJSON schemas
    """


class Point(EidosModel):
    """
    Point Model
    """

    coordinates: List[Union[float, int]] = Field(..., title='Coordinates')
    type: Literal['Point'] = Field('Point', title='Type')


class MultiPoint(EidosModel):
    """
    MultiPoint Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=1, title='Coordinates'
    )
    type: Literal['MultiPoint'] = Field('MultiPoint', title='Type')


class LineString(EidosModel):
    """
    LineString Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=2, title='Coordinates'
    )
    type: Literal['LineString'] = Field('LineString', title='Type')


class Coordinate(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class MultiLineString(EidosModel):
    """
    MultiLineString Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiLineString'] = Field('MultiLineString', title='Type')


class Polygon(EidosModel):
    """
    Polygon Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['Polygon'] = Field('Polygon', title='Type')


class Coordinate5Item(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class Coordinate5(RootModel[List[Coordinate5Item]]):
    root: List[Coordinate5Item]


class MultiPolygon(EidosModel):
    """
    MultiPolygon Model
    """

    coordinates: List[Coordinate5] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiPolygon'] = Field('MultiPolygon', title='Type')


class Type(str, Enum):
    Feature = 'Feature'


class GeometryCollection(EidosModel):
    """
    GeometryCollection Model
    """

    type: Literal['GeometryCollection'] = Field('GeometryCollection', title='Type')
    geometries: List[Geometry] = Field(..., title='Geometries')


class Geometry(
    RootModel[
        Union[
            Point,
            MultiPoint,
            LineString,
            MultiLineString,
            Polygon,
            MultiPolygon,
            GeometryCollection,
        ]
    ]
):
    root: Union[
        Point,
        MultiPoint,
        LineString,
        MultiLineString,
        Polygon,
        MultiPolygon,
        GeometryCollection,
    ] = Field(..., title='Geometry')
    """
    Geometry Model
    """


class Feature(EidosModel):
    """
    Feature Model
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type = Field(..., title='Type')
    geometry: Geometry
    properties: Optional[Dict[str, Any]] = Field(None, title='Properties')
    id: Optional[str] = Field(None, title='Id')
    bbox: Optional[List[Union[float, int]]] = Field(None, title='Bbox')


class FeatureCollection(EidosModel):
    type: Literal['FeatureCollection']
    features: List[Feature]


GeometryCollection.model_rebuild()
