# generated by datamodel-codegen:
#   filename:  node/grid.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from typing import List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, conint

from . import document, plot, world


class GridSize(EidosModel):
    """
    Defines the overall grid dimensions. All child nodes must fit within these bounds. The grid acts as a responsive layout container that adapts to screen size while maintaining relative proportions.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    columns: conint(ge=1) = Field(..., examples=[2, 3, 4, 6, 12])
    """
    Number of columns in the grid layout. Determines horizontal subdivision of the container.
    """
    rows: conint(ge=1) = Field(..., examples=[1, 2, 3, 4])
    """
    Number of rows in the grid layout. Determines vertical subdivision of the container.
    """


class GridLayoutItem(EidosModel):
    """
    Grid position and size specification for a child node. Defines where and how large each child appears within the grid.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    w: conint(ge=1) = Field(..., examples=[1, 2, 3])
    """
    Width in grid columns. How many columns this child spans horizontally.
    """
    h: conint(ge=1) = Field(..., examples=[1, 2])
    """
    Height in grid rows. How many rows this child spans vertically.
    """
    x: conint(ge=0) = Field(..., examples=[0, 1, 2])
    """
    Horizontal starting position (column index, 0-based). Left edge of the child within the grid.
    """
    y: conint(ge=0) = Field(..., examples=[0, 1, 2])
    """
    Vertical starting position (row index, 0-based). Top edge of the child within the grid.
    """


class Grid(EidosModel):
    """
    Layout node that arranges child nodes in a responsive grid pattern. Grid nodes are containers that organize multiple visualization components (maps, plots, documents) into rows and columns. Each child node can span multiple grid cells, allowing for flexible dashboard-style layouts.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str = Field(..., examples=['main-grid', 'dashboard-layout', 'analysis-grid'])
    """
    Unique identifier for this grid node within the specification. Used for referencing this node in events, interactions, and programmatic access.
    """
    nodeType: Literal['grid'] = 'grid'
    """
    Node type identifier. Must be 'grid' for layout containers that arrange children in a grid pattern.
    """
    gridSize: GridSize
    """
    Defines the overall grid dimensions. All child nodes must fit within these bounds. The grid acts as a responsive layout container that adapts to screen size while maintaining relative proportions.
    """
    gridLayout: Optional[List[GridLayoutItem]] = None
    """
    Optional array defining precise positioning for each child node. If provided, must have the same length as the children array. Each element defines the grid position and size for the corresponding child.
    """
    children: List[Union[world.World, plot.Plot, document.Document]]
    """
    Array of child nodes to display within the grid. Children are positioned automatically if gridLayout is not specified, or according to the gridLayout array if provided. Can contain any type of EIDOS node.
    """


Grid.model_rebuild()
