# generated by datamodel-codegen:
#   filename:  node/plot.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from enum import Enum
from typing import Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict

from .. import common, vegaspec


class PlotType(str, Enum):
    vega = 'vega'
    vega_lite = 'vega-lite'


class Actions(EidosModel):
    """
    Actions to enable for the plot
    """

    export: Optional[bool] = False
    """
    Enable export of the plot to SVG and PNG formats
    """


class Plot(EidosModel):
    """
    Specification for plot view environmental digital twin display and interaction
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    """
    Unique id of the node
    """
    nodeType: Literal['plot'] = 'plot'
    plotType: Optional[PlotType] = None
    plotSpec: vegaspec.TopLevelSpec
    actions: Optional[Actions] = None
    """
    Actions to enable for the plot
    """
    timezone: Optional[common.Timezone] = None
    currentTime: Optional[common.CurrentTime] = None
    timeControl: Optional[common.TimeControl] = None
