# generated by datamodel-codegen:
#   filename:  node/world.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel, confloat

from .. import common
from .worldlayer import feature, gridded, label, scenegraph, seasurface, track


class BaseLayerPreset(str, Enum):
    """
    Base layer type
    """

    oceanum = 'oceanum'
    terrain = 'terrain'


class ViewType(str, Enum):
    """
    Type of world view
    """

    map = 'map'
    globe = 'globe'


class View(EidosModel):
    """
    Camera configuration defining the initial viewport of the map including position, zoom level, and orientation. This sets how users first see the map when it loads.
    """

    viewType: Optional[ViewType] = 'map'
    """
    Type of world view
    """
    longitude: confloat(ge=-180.0, le=180.0) = Field(..., examples=[174.3, -122.4, 2.3])
    """
    Longitude coordinate of the map center in decimal degrees (-180 to 180). Positive values are East, negative values are West.
    """
    latitude: confloat(ge=-90.0, le=90.0) = Field(..., examples=[-38.5, 37.7, 48.9])
    """
    Latitude coordinate of the map center in decimal degrees (-90 to 90). Positive values are North, negative values are South.
    """
    pitch: Optional[float] = 0
    """
    Pitch angle of view
    """
    bearing: Optional[float] = 0
    """
    Bearing angle of view
    """
    maxZoom: Optional[float] = 20
    """
    Maximum zoom level
    """
    zoom: Optional[confloat(ge=0.0)] = Field(0, examples=[2, 8, 12, 16])
    """
    Initial zoom level of the map. Higher values show more detail. Typically ranges from 0 (world view) to 20+ (street level).
    """
    maxPitch: Optional[float] = 60
    """
    Maximum pitch angle
    """


class HoverInfo(EidosModel):
    """
    Properties for tooltip shown on hover
    """

    template: str
    """
    Tooltip as Handlebars template. The picked object is passed as the render context.
    """


class NodeType(str, Enum):
    """
    Control type
    """

    points = 'points'
    polygon = 'polygon'
    bbox = 'bbox'
    radius = 'radius'
    drop = 'drop'
    measure = 'measure'


class CursorOffset(EidosModel):
    """
    Cursor offset
    """

    x: Optional[float] = 0
    y: Optional[float] = 0


class Icon(EidosModel):
    """
    Icon URLs
    """

    default: str
    """
    Default icon URL
    """
    hover: Optional[str] = None
    """
    Active hover icon URL
    """
    dark: Optional[str] = None
    """
    Dark theme icon URL
    """
    cursorOffset: Optional[CursorOffset] = None
    """
    Cursor offset
    """


class Control(EidosModel):
    """
    Control properties
    """

    nodeType: NodeType
    """
    Control type
    """
    id: str
    """
    Control id
    """
    active: Optional[bool] = None
    """
    Control active state
    """
    disabled: Optional[bool] = None
    """
    Control disabled state
    """
    state: Optional[Dict[str, Any]] = None
    """
    Control state
    """
    icon: Optional[Icon] = None
    """
    Icon URLs
    """
    tooltip: Optional[str] = None
    """
    Tooltip text
    """
    config: Optional[Dict[str, Any]] = None


class Orientation(str, Enum):
    horizontal = 'horizontal'
    vertical = 'vertical'


class ControlGroup(EidosModel):
    """
    Control group
    """

    id: str
    """
    Control group id
    """
    nodeType: Literal['controlgroup'] = 'controlgroup'
    orientation: Optional[Orientation] = None
    children: List[Control]
    """
    Control list
    """
    visible: Optional[bool] = True
    """
    Visibility of control group
    """


class LayerSelector(EidosModel):
    """
    Layer selector
    """

    open: Optional[bool] = True
    """
    Visibility of layer selector
    """


class Mode(str, Enum):
    nearest = 'nearest'
    exact = 'exact'
    range = 'range'


class Aggregate(str, Enum):
    """
    Aggregation method for time range
    """

    last = 'last'
    first = 'first'
    sum = 'sum'
    mean = 'mean'
    max = 'max'
    min = 'min'


class TimeSelect(EidosModel):
    mode: Mode
    toleration: Optional[str] = None
    """
    Time toleration duration for nearest time select
    """
    aggregate: Optional[Aggregate] = Field('last', title='Time aggregation')
    """
    Aggregation method for time range
    """
    groupby: Optional[str] = None
    """
    Data field to group by
    """


class BaseLayer(RootModel[Union[BaseLayerPreset, Dict[str, Any]]]):
    root: Union[BaseLayerPreset, Dict[str, Any]]


class World(EidosModel):
    """
    Interactive 2D/3D map node for displaying geospatial and oceanic data. World nodes can contain multiple data layers (gridded data, features, tracks, etc.) and provide map controls, time navigation, and spatial interaction capabilities. Ideal for visualizing spatial data, environmental conditions, and geographic features.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str = Field(..., examples=['map-1', 'world-view', 'main-map'])
    """
    Unique identifier for this world node within the specification. Used for referencing this node in events, interactions, and programmatic access.
    """
    nodeType: Literal['world'] = 'world'
    """
    Node type identifier. Must be 'world' for map/globe visualizations.
    """
    children: Optional[List[Union[WorldLayer, ControlGroup]]] = None
    """
    Array of world layers and controls to display on this map. Each layer represents a different data visualization (e.g., gridded data, vector features, tracks, 3D objects). Layers are rendered in order with later layers appearing on top.
    """
    baseLayer: Optional[BaseLayer] = None
    """
    Base map layer providing the background cartography. Can be a preset like 'oceanum' or 'terrain', or a custom tile layer configuration.
    """
    viewState: Optional[View] = None
    """
    Initial camera position and orientation for the map view, including center coordinates, zoom level, pitch, and bearing.
    """
    timezone: Optional[common.Timezone] = None
    currentTime: Optional[common.CurrentTime] = None
    timeControl: Optional[common.TimeControl] = None
    layerSelector: Optional[Union[bool, LayerSelector]] = None
    """
    Layer selector control configuration. Set to true/false to show/hide the layer selector, or provide an object to customize its appearance and behavior.
    """
    mapControls: Optional[List[ControlGroup]] = None
    """
    Interactive map controls for spatial selection, measurement, and drawing. Controls appear as toolbar buttons and allow users to interact with the map (e.g., draw polygons, measure distances, drop points).
    """


class LayerSpec(
    RootModel[
        Union[
            feature.FeatureLayer,
            gridded.GriddedLayer,
            label.LabelLayer,
            scenegraph.ScenegraphLayer,
            seasurface.SeaSurfaceLayer,
            track.TrackLayer,
        ]
    ]
):
    root: Union[
        feature.FeatureLayer,
        gridded.GriddedLayer,
        label.LabelLayer,
        scenegraph.ScenegraphLayer,
        seasurface.SeaSurfaceLayer,
        track.TrackLayer,
    ]
    """
    Layer specification
    """


class WorldLayer(EidosModel):
    """
    A data layer displayed on a world map. World layers visualize different types of geospatial data including gridded datasets (like temperature, wave height), vector features (points, lines, polygons), tracks (moving objects), and 3D scene elements.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: str = Field(..., examples=['wave-height', 'ship-tracks', 'weather-stations'])
    """
    Unique identifier for this layer within the world node. Used for layer management, visibility control, and programmatic access.
    """
    name: Optional[str] = Field(
        None, examples=['Significant Wave Height', 'Ship Positions', 'Weather Stations']
    )
    """
    Display name for this layer shown in the layer selector and legend. Should be descriptive and user-friendly.
    """
    nodeType: Literal['worldlayer']
    dataId: Optional[str] = Field(
        None, examples=['hs-1', 'sig-wave-height-trki', 'ship-positions']
    )
    """
    Reference to a data source defined in the root 'data' array. This connects the layer to its data source for visualization.
    """
    visible: Optional[bool] = True
    """
    Whether this layer is initially visible when the map loads. Users can toggle visibility through the layer selector.
    """
    showWith: Optional[List] = []
    """
    Other layers than can be shown at same time as this layer
    """
    linked: Optional[str] = None
    """
    Linked layer id which controls this layer visibility
    """
    hoverInfo: Optional[HoverInfo] = None
    """
    Configuration for tooltips displayed when hovering over layer elements. Uses Handlebars templates for dynamic content.
    """
    layerSpec: LayerSpec
    minZoom: Optional[float] = 0
    """
    Minimum zoom level at which layer is visible
    """
    maxZoom: Optional[float] = 20
    """
    Maximum zoom level at which layer is visible
    """
    timeSelect: Optional[TimeSelect] = None
    """
    Time selection criteria for layer
    """


World.model_rebuild()
