# generated by datamodel-codegen:
#   filename:  node/worldlayer/common.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from typing import List, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import Field, RootModel


class WorldlayerCommonProperties(EidosModel):
    """
    Common properties for worldlayer nodes
    """


class Colormap(EidosModel):
    """
    Scale and domain argument for chroma.scale colormap definition
    """

    scale: Optional[Union[List[str], str]] = None
    domain: Optional[List[Union[float, str]]] = None


class Color(RootModel[Union[List[float], str]]):
    root: Union[List[float], str] = Field(..., title='Color')
    """
    Color definition
    """


class StyleAccessorString(RootModel[str]):
    root: str = Field(..., title='Style accessor constant string')
    """
    Constant value
    """


class StyleAccessorNumber(RootModel[float]):
    root: float = Field(..., title='Style accessor constant number')
    """
    Constant value
    """


class StyleAccessorArray(RootModel[List[float]]):
    """
    Array of constant values
    """

    root: List[float] = Field(..., title='Style accessor constant array')
    """
    Array of constant values
    """


class StyleAccessorTemplate(EidosModel):
    """
    Template accessor
    """

    template: str
    """
    Template string
    """


class StyleAccessorFunction(EidosModel):
    """
    Accessor function
    """

    function: str
    """
    Accessor function identifier
    """
    args: List[str]
    """
    Arguments for accessor function
    """


class Legend1(EidosModel):
    """
    Legend properties
    """

    labels: Optional[List[Union[str, float]]] = None
    """
    Legend labels
    """


class Legend(RootModel[Optional[Union[Legend1, bool]]]):
    root: Optional[Union[Legend1, bool]] = Field(..., title='Legend definition')
    """
    Legend properties
    """


class StyleAccessor(
    RootModel[
        Union[
            StyleAccessorString,
            StyleAccessorNumber,
            StyleAccessorFunction,
            StyleAccessorArray,
            StyleAccessorTemplate,
        ]
    ]
):
    root: Union[
        StyleAccessorString,
        StyleAccessorNumber,
        StyleAccessorFunction,
        StyleAccessorArray,
        StyleAccessorTemplate,
    ] = Field(..., title='Style accessor definition')
    """
    Style properties
    """
