# generated by datamodel-codegen:
#   filename:  node/worldlayer/gridded.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from typing import List, Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel

from . import common


class GriddedProps(EidosModel):
    altitude: Optional[float] = None
    zscale: Optional[float] = None
    colormap: Optional[bool] = None
    opacity: Optional[float] = 1.0
    color: Optional[common.Color] = None


class Pcolor(RootModel[GriddedProps]):
    root: GriddedProps


class Particles(GriddedProps):
    size: Optional[float] = None
    length: Optional[float] = 10
    speed: Optional[float] = 0.2


class Mesh(EidosModel):
    shape: Optional[str] = None
    length: Optional[float] = None
    width: Optional[float] = None


class Partmesh(GriddedProps):
    speed: Optional[float] = 0.2
    mesh: Optional[Mesh] = None


class Contour(GriddedProps):
    levels: Optional[List[float]] = None
    linewidth: Optional[int] = 1


class GridLayerDatakeys(EidosModel):
    """
    Mapping from data variables to x,y and c(scalar value)
    """

    x: Optional[str] = None
    y: Optional[str] = None
    c: Optional[str] = None
    d: Optional[str] = None
    m: Optional[str] = None
    u: Optional[str] = None
    v: Optional[str] = None


class GriddedLayer(EidosModel):
    """
    World layer for visualizing gridded datasets such as sea surface temperature, wave height, wind speed, or any regularly-spaced data. Supports multiple visualization modes including pseudocolor plots, contour lines, particle animations, and vector fields. Ideal for environmental and oceanographic data visualization.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    layerType: Literal['gridded']
    """
    Layer type identifier. Must be 'gridded' for regularly-spaced data visualizations.
    """
    datakeys: GridLayerDatakeys
    """
    Mapping of data variables to coordinate and value fields. Defines how the data structure maps to spatial and temporal dimensions for visualization.
    """
    legend: Optional[common.Legend] = None
    """
    Configuration for the color scale legend display. Controls the appearance, position, and formatting of the legend that shows the data value to color mapping.
    """
    colormap: common.Colormap
    """
    Color mapping configuration that translates data values to colors. Defines the color scale, value ranges, and visual encoding for the gridded data.
    """
    pcolor: Optional[Pcolor] = None
    particles: Optional[Particles] = None
    partmesh: Optional[Particles] = None
    contour: Optional[Contour] = None
    scale: Optional[float] = Field(1, examples=[1, 0.01, 100, 3.6])
    """
    Scaling factor applied to data values before visualization. Useful for unit conversion or value adjustment (e.g., scale: 0.01 to convert from centimeters to meters).
    """
    offset: Optional[float] = Field(0, examples=[0, -273.15, 32])
    """
    Offset value added to data values after scaling but before visualization. Useful for shifting data ranges or converting units (e.g., Kelvin to Celsius).
    """
    units: Optional[str] = None
    precision: Optional[float] = 1
    landmask: Optional[bool] = None
    global_: Optional[bool] = Field(None, alias='global')
