# generated by datamodel-codegen:
#   filename:  panel.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from typing import Any, Dict, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import Field

from . import common
from .node import document, grid, menu, plot, world


class EidosPanel(EidosModel):
    """
    Spec for panel node (world, plot, document, grid or menu). A panel node is displayed as a modal window on top of the parent element. Opening can be triggered by an event.
    """

    id: str
    """
    Unique ID of the panel
    """
    node: Union[world.World, plot.Plot, document.Document, grid.Grid, menu.Menu]
    trigger: Optional[Dict[str, Any]] = None
    """
    event object that triggers panel
    """
    exclusive: Optional[bool] = False
    """
    If true, this panel is exclusive and will close other panels when opened
    """
    height: Optional[common.CssSpec] = None
    """
    Height of panel (CSS string or pixels)
    """
    width: Optional[common.CssSpec] = None
    """
    Width of panel (CSS string or pixels)
    """
    position: Optional[common.Position] = Field(
        default_factory=lambda: common.Position.model_validate(
            {'top': None, 'left': None, 'bottom': None, 'right': None}
        )
    )
    """
    Location of panel relative to parent element
    """
    title: Optional[str] = None
    """
    Title of panel
    """


EidosPanel.model_rebuild()
