# generated by datamodel-codegen:
#   filename:  root.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from typing import List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, constr

from . import data as data_1
from . import panel
from . import theme as theme_1
from .node import document, grid, menu, plot, world


class EidosSpecification(EidosModel):
    """
    Complete specification for defining interactive oceanic and geospatial data visualizations using the EIDOS framework. An EIDOS specification is a declarative JSON document that describes the entire structure, layout, data sources, and interactions for a data visualization application. This top-level schema defines the root structure that contains metadata, data definitions, theming, and the hierarchical node structure that defines the user interface.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    version: Literal['0.7'] = '0.7'
    """
    Version of EIDOS
    """
    id: constr(pattern=r'^[a-z0-9-_]+$') = Field(
        ...,
        examples=[
            'seastate-demo',
            'plot-demo',
            'grid-layout-demo',
            'doc-demo',
            'overlay-demo',
        ],
    )
    """
    Unique identifier for this specification. Must be URL-safe using only lowercase letters, numbers, hyphens, and underscores. This ID is used for referencing the specification in URLs, file systems, and databases. It should be descriptive but concise.
    """
    name: str = Field(
        ..., examples=['DemoOverlay', 'DemoPlot', 'DemoGrid', 'DemoDoc', 'DemoMenu']
    )
    """
    Human-readable display name for this specification. This is the name shown to users in lists, menus, and interfaces. It can contain spaces, special characters, and mixed case. Should be descriptive and meaningful to end users.
    """
    description: Optional[str] = Field(
        '',
        examples=[
            'Demonstration overlay',
            'Demonstration grid layout',
            'Demonstration document',
            'Demonstration menu layout',
        ],
    )
    """
    Detailed description of what this specification does and its purpose. This is primarily for documentation and metadata purposes - it's not typically displayed in the main interface but may be shown in tooltips, help text, or specification listings. Useful for developers and content creators.
    """
    title: Optional[str] = None
    """
    Title displayed at top of screen
    """
    logo: Optional[str] = None
    """
    URL of logo image
    """
    theme: Optional[theme_1.EidosTheme] = None
    data: Optional[List[data_1.EidosData]] = Field(
        None,
        examples=[
            [
                {
                    'id': 'sig-wave-height-trki',
                    'dataType': 'oceanumDatamesh',
                    'dataSpec': {
                        'datasource': 'oceanum_wave_trki_era5_v1_grid',
                        'variables': ['hs', 'tps'],
                        'geofilter': {
                            'type': 'feature',
                            'geom': {
                                'type': 'Feature',
                                'geometry': {
                                    'type': 'Point',
                                    'coordinates': [174.3, -38.5],
                                },
                            },
                        },
                        'timefilter': {
                            'times': ['2018-01-01 00:00:00Z', '2019-01-01 00:00:00Z']
                        },
                    },
                }
            ]
        ],
        title='Data Sources',
    )
    """
    Array of data source definitions that provide data to the visualization components. Each data source can be a static dataset, OceanQL query, Oceanum Datamesh source, or other supported data provider. Data sources are referenced by ID throughout the specification.
    """
    root: Union[world.World, plot.Plot, document.Document, grid.Grid, menu.Menu]
    panels: Optional[List[panel.EidosPanel]] = None


EidosSpecification.model_rebuild()
