# generated by datamodel-codegen:
#   filename:  theme.json
#   timestamp: 2025-09-13T04:49:25+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from oceanum.eidos._basemodel import EidosModel


class Preset(str, Enum):
    """
    Color scheme for the view
    """

    default = 'default'
    dark = 'dark'


class ColorStyle(EidosModel):
    """
    Color palette configuration
    """

    primary: Optional[str] = '#0d2d3f'
    """
    Primary color of the view
    """
    secondary: Optional[str] = '#a9dce0'
    """
    Secondary color of the view
    """
    accent: Optional[str] = '#b84528'
    """
    Accent color of the view
    """
    background: Optional[str] = '#ffffff'
    """
    Background color of the view
    """


class TextStyle(EidosModel):
    """
    Typography configuration
    """

    color: Optional[str] = '#212529'
    """
    Text color of the view
    """
    fontFamily: Optional[str] = (
        'system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", "Noto Sans", "Liberation Sans", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"'
    )
    """
    Font family of the view
    """
    fontSize: Optional[Union[str, int]] = '14px'
    """
    Font size of the text
    """
    fontWeight: Optional[str] = '400'
    """
    Font weight of the text
    """
    lineHeight: Optional[Union[str, int]] = '1.5'
    """
    Line height of the text
    """
    align: Optional[str] = 'left'
    """
    Text alignment of the view
    """
    titleSize: Optional[Union[str, int]] = '2.0rem'
    """
    Size of the title
    """
    subtitleSize: Optional[Union[str, int]] = '1.5rem'
    """
    Size of the subtitle
    """
    headingSize: Optional[Union[str, int]] = '1.15rem'
    """
    Size of the heading
    """


class ControlStyle(EidosModel):
    """
    Control element styling
    """

    opacity: Optional[str] = '0.5'
    """
    Opacity of control elements
    """
    borderColor: Optional[str] = '#ffffff77'
    """
    Border color of control elements
    """
    backgroundColor: Optional[str] = '#ffffff55'
    """
    Background color of control elements
    """
    textColor: Optional[str] = '#212529'
    """
    Text color of control elements
    """
    borderWidth: Optional[Union[str, int]] = '1px'
    """
    Border width of control elements
    """
    borderStyle: Optional[str] = 'solid'
    """
    Border style of control elements
    """
    borderRadius: Optional[Union[str, int]] = '0.375rem'
    """
    Border radius of control elements
    """
    backdropFilter: Optional[str] = 'blur(18px)'
    """
    Backdrop filter effect for controls
    """
    boxShadow: Optional[str] = '0 0.5rem 1rem rgba(0, 0, 0, 0.15)'
    """
    Box shadow effect for controls
    """
    boxShadowInset: Optional[str] = 'inset 0 0px 8px #575757'
    """
    Inset box shadow effect for controls
    """


class PanelStyle(EidosModel):
    """
    Panel element styling
    """

    opacity: Optional[str] = '1.0'
    """
    Opacity of panel elements
    """
    borderColor: Optional[str] = '#ffffff77'
    """
    Border color of panel elements
    """
    backgroundColor: Optional[str] = '#ffffff55'
    """
    Background color of panel elements
    """
    textColor: Optional[str] = '#212529'
    """
    Text color of panel elements
    """
    borderWidth: Optional[Union[str, int]] = '1px'
    """
    Border width of panel elements
    """
    borderStyle: Optional[str] = 'solid'
    """
    Border style of panel elements
    """
    borderRadius: Optional[Union[str, int]] = '0.375rem'
    """
    Border radius of panel elements
    """
    backdropFilter: Optional[str] = 'blur(18px)'
    """
    Backdrop filter effect for panels
    """
    boxShadow: Optional[str] = '0 0.5rem 1rem rgba(0, 0, 0, 0.15)'
    """
    Box shadow effect for panels
    """
    boxShadowInset: Optional[str] = 'inset 0 0px 8px #575757'
    """
    Inset box shadow effect for panels
    """


class GridStyle(EidosModel):
    """
    Grid element styling
    """

    borderWidth: Optional[Union[str, int]] = '0px'
    """
    Border width of grid elements
    """
    borderRadius: Optional[Union[str, int]] = '0.375rem'
    """
    Border radius of grid elements
    """
    borderStyle: Optional[str] = 'solid'
    """
    Border style of grid elements
    """
    borderColor: Optional[str] = '#0d2d3f'
    """
    Border color of grid elements
    """
    padding: Optional[Union[str, int]] = '0'
    """
    Padding of grid elements
    """
    margin: Optional[Union[str, int]] = '0'
    """
    Margin of grid elements
    """


class EidosStyle(EidosModel):
    """
    Style properties organized by category
    """

    color: Optional[ColorStyle] = None
    text: Optional[TextStyle] = None
    control: Optional[ControlStyle] = None
    panel: Optional[PanelStyle] = None
    grid: Optional[GridStyle] = None


class EidosTheme(EidosModel):
    preset: Optional[Preset] = 'default'
    """
    Color scheme for the view
    """
    style: Optional[EidosStyle] = None
