from ck.pgm import PGM


class Alarm(PGM):
    """
    This PGM is the well known, pedagogical 'Alarm' Bayesian network.
    """

    def __init__(self):
        super().__init__(self.__class__.__name__)

        MinVol = self.new_rv('MinVol', ('Zero', 'Low', 'Normal', 'High'))
        Press = self.new_rv('Press', ('Zero', 'Low', 'Normal', 'High'))
        PAP = self.new_rv('PAP', ('Low', 'Normal', 'High'))
        ExpCO2 = self.new_rv('ExpCO2', ('Zero', 'Low', 'Normal', 'High'))
        HRBP = self.new_rv('HRBP', ('Low', 'Normal', 'High'))
        ErrLowOutput = self.new_rv('ErrLowOutput', ('True', 'False'))
        HRSat = self.new_rv('HRSat', ('Low', 'Normal', 'High'))
        HREKG = self.new_rv('HREKG', ('Low', 'Normal', 'High'))
        ErrCauter = self.new_rv('ErrCauter', ('True', 'False'))
        BP = self.new_rv('BP', ('Low', 'Normal', 'High'))
        History = self.new_rv('History', ('True', 'False'))
        CO = self.new_rv('CO', ('Low', 'Normal', 'High'))
        HR = self.new_rv('HR', ('Low', 'Normal', 'High'))
        Catechol = self.new_rv('Catechol', ('Normal', 'High'))
        ArtCO2 = self.new_rv('ArtCO2', ('Low', 'Normal', 'High'))
        TPR = self.new_rv('TPR', ('Low', 'Normal', 'High'))
        Anaphylaxis = self.new_rv('Anaphylaxis', ('True', 'False'))
        SaO2 = self.new_rv('SaO2', ('Low', 'Normal', 'High'))
        PVSat = self.new_rv('PVSat', ('Low', 'Normal', 'High'))
        FiO2 = self.new_rv('FiO2', ('Low', 'Normal'))
        VentAlv = self.new_rv('VentAlv', ('Zero', 'Low', 'Normal', 'High'))
        VentLung = self.new_rv('VentLung', ('Zero', 'Low', 'Normal', 'High'))
        VentTube = self.new_rv('VentTube', ('Zero', 'Low', 'Normal', 'High'))
        Disconnect = self.new_rv('Disconnect', ('True', 'False'))
        VentMach = self.new_rv('VentMach', ('Zero', 'Low', 'Normal', 'High'))
        MinVolSet = self.new_rv('MinVolSet', ('Low', 'Normal', 'High'))
        KinkedTube = self.new_rv('KinkedTube', ('True', 'False'))
        Shunt = self.new_rv('Shunt', ('Normal', 'High'))
        Intubation = self.new_rv('Intubation', ('Normal', 'Esophageal', 'OneSided'))
        PulmEmbolus = self.new_rv('PulmEmbolus', ('True', 'False'))
        InsuffAnesth = self.new_rv('InsuffAnesth', ('True', 'False'))
        PCWP = self.new_rv('PCWP', ('Low', 'Normal', 'High'))
        CVP = self.new_rv('CVP', ('Low', 'Normal', 'High'))
        StrokeVolume = self.new_rv('StrokeVolume', ('Low', 'Normal', 'High'))
        LVEDVolume = self.new_rv('LVEDVolume', ('Low', 'Normal', 'High'))
        LVFailure = self.new_rv('LVFailure', ('True', 'False'))
        Hypovolemia = self.new_rv('Hypovolemia', ('True', 'False'))

        pgm_factor0 = self.new_factor(MinVol, VentLung, Intubation)
        pgm_function_2759353723488 = pgm_factor0.set_cpt()
        pgm_function_2759353723488.set_cpd((0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((1, 0), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((2, 0), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759353723488.set_cpd((3, 0), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759353723488.set_cpd((0, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((1, 1), (0.6, 0.38, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((2, 1), (0.5, 0.48, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((3, 1), (0.5, 0.48, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((0, 2), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((1, 2), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759353723488.set_cpd((2, 2), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759353723488.set_cpd((3, 2), (0.01, 0.01, 0.01, 0.97))
        pgm_factor1 = self.new_factor(Press, KinkedTube, Intubation, VentTube)
        pgm_function_2759353724528 = pgm_factor1.set_cpt()
        pgm_function_2759353724528.set_cpd((0, 0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((1, 0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((0, 1, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((1, 1, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((0, 2, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((1, 2, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((0, 0, 1), (0.01, 0.49, 0.3, 0.2))
        pgm_function_2759353724528.set_cpd((1, 0, 1), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((0, 1, 1), (0.1, 0.84, 0.05, 0.01))
        pgm_function_2759353724528.set_cpd((1, 1, 1), (0.4, 0.58, 0.01, 0.01))
        pgm_function_2759353724528.set_cpd((0, 2, 1), (0.01, 0.29, 0.3, 0.4))
        pgm_function_2759353724528.set_cpd((1, 2, 1), (0.01, 0.9, 0.08, 0.01))
        pgm_function_2759353724528.set_cpd((0, 0, 2), (0.01, 0.01, 0.08, 0.9))
        pgm_function_2759353724528.set_cpd((1, 0, 2), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759353724528.set_cpd((0, 1, 2), (0.05, 0.25, 0.25, 0.45))
        pgm_function_2759353724528.set_cpd((1, 1, 2), (0.2, 0.75, 0.04, 0.01))
        pgm_function_2759353724528.set_cpd((0, 2, 2), (0.01, 0.01, 0.08, 0.9))
        pgm_function_2759353724528.set_cpd((1, 2, 2), (0.01, 0.01, 0.38, 0.6))
        pgm_function_2759353724528.set_cpd((0, 0, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759353724528.set_cpd((1, 0, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759353724528.set_cpd((0, 1, 3), (0.01, 0.15, 0.25, 0.59))
        pgm_function_2759353724528.set_cpd((1, 1, 3), (0.2, 0.7, 0.09, 0.01))
        pgm_function_2759353724528.set_cpd((0, 2, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759353724528.set_cpd((1, 2, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_factor2 = self.new_factor(PAP, PulmEmbolus)
        pgm_function_2759353723904 = pgm_factor2.set_cpt()
        pgm_function_2759353723904.set_cpd((0,), (0.01, 0.19, 0.8))
        pgm_function_2759353723904.set_cpd((1,), (0.05, 0.9, 0.05))
        pgm_factor3 = self.new_factor(ExpCO2, ArtCO2, VentLung)
        pgm_function_2759353724112 = pgm_factor3.set_cpt()
        pgm_function_2759353724112.set_cpd((0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724112.set_cpd((1, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724112.set_cpd((2, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759353724112.set_cpd((0, 1), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759353724112.set_cpd((1, 1), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759353724112.set_cpd((2, 1), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759353724112.set_cpd((0, 2), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759353724112.set_cpd((1, 2), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759353724112.set_cpd((2, 2), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759353724112.set_cpd((0, 3), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759353724112.set_cpd((1, 3), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759353724112.set_cpd((2, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_factor4 = self.new_factor(HRBP, ErrLowOutput, HR)
        pgm_function_2759353721200 = pgm_factor4.set_cpt()
        pgm_function_2759353721200.set_cpd((0, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353721200.set_cpd((1, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353721200.set_cpd((0, 1), (0.4, 0.59, 0.01))
        pgm_function_2759353721200.set_cpd((1, 1), (0.01, 0.98, 0.01))
        pgm_function_2759353721200.set_cpd((0, 2), (0.3, 0.4, 0.3))
        pgm_function_2759353721200.set_cpd((1, 2), (0.01, 0.01, 0.98))
        pgm_factor5 = self.new_factor(ErrLowOutput)
        pgm_function_2759353722448 = pgm_factor5.set_cpt()
        pgm_function_2759353722448.set_cpd((), (0.05, 0.95))
        pgm_factor6 = self.new_factor(HRSat, HR, ErrCauter)
        pgm_function_2759353722656 = pgm_factor6.set_cpt()
        pgm_function_2759353722656.set_cpd((0, 0), (0.33333333, 0.33333333, 0.33333333))
        pgm_function_2759353722656.set_cpd((1, 0), (0.33333333, 0.33333333, 0.33333333))
        pgm_function_2759353722656.set_cpd((2, 0), (0.33333333, 0.33333333, 0.33333333))
        pgm_function_2759353722656.set_cpd((0, 1), (0.98, 0.01, 0.01))
        pgm_function_2759353722656.set_cpd((1, 1), (0.01, 0.98, 0.01))
        pgm_function_2759353722656.set_cpd((2, 1), (0.01, 0.01, 0.98))
        pgm_factor7 = self.new_factor(HREKG, HR, ErrCauter)
        pgm_function_2759353722032 = pgm_factor7.set_cpt()
        pgm_function_2759353722032.set_cpd((0, 0), (0.33333333, 0.33333333, 0.33333333))
        pgm_function_2759353722032.set_cpd((1, 0), (0.33333333, 0.33333333, 0.33333333))
        pgm_function_2759353722032.set_cpd((2, 0), (0.33333333, 0.33333333, 0.33333333))
        pgm_function_2759353722032.set_cpd((0, 1), (0.98, 0.01, 0.01))
        pgm_function_2759353722032.set_cpd((1, 1), (0.01, 0.98, 0.01))
        pgm_function_2759353722032.set_cpd((2, 1), (0.01, 0.01, 0.98))
        pgm_factor8 = self.new_factor(ErrCauter)
        pgm_function_2759353722864 = pgm_factor8.set_cpt()
        pgm_function_2759353722864.set_cpd((), (0.1, 0.9))
        pgm_factor9 = self.new_factor(BP, CO, TPR)
        pgm_function_2759353721408 = pgm_factor9.set_cpt()
        pgm_function_2759353721408.set_cpd((0, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353721408.set_cpd((1, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353721408.set_cpd((2, 0), (0.9, 0.09, 0.01))
        pgm_function_2759353721408.set_cpd((0, 1), (0.98, 0.01, 0.01))
        pgm_function_2759353721408.set_cpd((1, 1), (0.1, 0.85, 0.05))
        pgm_function_2759353721408.set_cpd((2, 1), (0.05, 0.2, 0.75))
        pgm_function_2759353721408.set_cpd((0, 2), (0.3, 0.6, 0.1))
        pgm_function_2759353721408.set_cpd((1, 2), (0.05, 0.4, 0.55))
        pgm_function_2759353721408.set_cpd((2, 2), (0.01, 0.09, 0.9))
        pgm_factor10 = self.new_factor(History, LVFailure)
        pgm_function_2759353720992 = pgm_factor10.set_cpt()
        pgm_function_2759353720992.set_cpd((0,), (0.9, 0.1))
        pgm_function_2759353720992.set_cpd((1,), (0.01, 0.99))
        pgm_factor11 = self.new_factor(CO, HR, StrokeVolume)
        pgm_function_2759353723280 = pgm_factor11.set_cpt()
        pgm_function_2759353723280.set_cpd((0, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353723280.set_cpd((1, 0), (0.95, 0.04, 0.01))
        pgm_function_2759353723280.set_cpd((2, 0), (0.8, 0.19, 0.01))
        pgm_function_2759353723280.set_cpd((0, 1), (0.95, 0.04, 0.01))
        pgm_function_2759353723280.set_cpd((1, 1), (0.04, 0.95, 0.01))
        pgm_function_2759353723280.set_cpd((2, 1), (0.01, 0.04, 0.95))
        pgm_function_2759353723280.set_cpd((0, 2), (0.3, 0.69, 0.01))
        pgm_function_2759353723280.set_cpd((1, 2), (0.01, 0.3, 0.69))
        pgm_function_2759353723280.set_cpd((2, 2), (0.01, 0.01, 0.98))
        pgm_factor12 = self.new_factor(HR, Catechol)
        pgm_function_2759353723072 = pgm_factor12.set_cpt()
        pgm_function_2759353723072.set_cpd((0,), (0.1, 0.89, 0.01))
        pgm_function_2759353723072.set_cpd((1,), (0.01, 0.09, 0.9))
        pgm_factor13 = self.new_factor(Catechol, InsuffAnesth, SaO2, TPR, ArtCO2)
        pgm_function_2759353724320 = pgm_factor13.set_cpt()
        pgm_function_2759353724320.set_cpd((0, 0, 0, 0), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 0, 0), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((0, 1, 0, 0), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 0, 0), (0.1, 0.9))
        pgm_function_2759353724320.set_cpd((0, 2, 0, 0), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 2, 0, 0), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 0, 1, 0), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 1, 0), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((0, 1, 1, 0), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 1, 0), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 2, 1, 0), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((1, 2, 1, 0), (0.99, 0.01))
        pgm_function_2759353724320.set_cpd((0, 0, 2, 0), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 2, 0), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((0, 1, 2, 0), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((1, 1, 2, 0), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 2, 2, 0), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((1, 2, 2, 0), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 0, 0, 1), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 0, 1), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((0, 1, 0, 1), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 0, 1), (0.1, 0.9))
        pgm_function_2759353724320.set_cpd((0, 2, 0, 1), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 2, 0, 1), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 0, 1, 1), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 1, 1), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((0, 1, 1, 1), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 1, 1), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 2, 1, 1), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((1, 2, 1, 1), (0.99, 0.01))
        pgm_function_2759353724320.set_cpd((0, 0, 2, 1), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 2, 1), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((0, 1, 2, 1), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((1, 1, 2, 1), (0.95, 0.05))
        pgm_function_2759353724320.set_cpd((0, 2, 2, 1), (0.05, 0.95))
        pgm_function_2759353724320.set_cpd((1, 2, 2, 1), (0.99, 0.01))
        pgm_function_2759353724320.set_cpd((0, 0, 0, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 0, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((0, 1, 0, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 0, 2), (0.1, 0.9))
        pgm_function_2759353724320.set_cpd((0, 2, 0, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 2, 0, 2), (0.3, 0.7))
        pgm_function_2759353724320.set_cpd((0, 0, 1, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 1, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((0, 1, 1, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 1, 2), (0.3, 0.7))
        pgm_function_2759353724320.set_cpd((0, 2, 1, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 2, 1, 2), (0.99, 0.01))
        pgm_function_2759353724320.set_cpd((0, 0, 2, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 0, 2, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((0, 1, 2, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 1, 2, 2), (0.3, 0.7))
        pgm_function_2759353724320.set_cpd((0, 2, 2, 2), (0.01, 0.99))
        pgm_function_2759353724320.set_cpd((1, 2, 2, 2), (0.3, 0.7))
        pgm_factor14 = self.new_factor(ArtCO2, VentAlv)
        pgm_function_2759353720784 = pgm_factor14.set_cpt()
        pgm_function_2759353720784.set_cpd((0,), (0.01, 0.01, 0.98))
        pgm_function_2759353720784.set_cpd((1,), (0.01, 0.01, 0.98))
        pgm_function_2759353720784.set_cpd((2,), (0.04, 0.92, 0.04))
        pgm_function_2759353720784.set_cpd((3,), (0.9, 0.09, 0.01))
        pgm_factor15 = self.new_factor(TPR, Anaphylaxis)
        pgm_function_2759353721616 = pgm_factor15.set_cpt()
        pgm_function_2759353721616.set_cpd((0,), (0.98, 0.01, 0.01))
        pgm_function_2759353721616.set_cpd((1,), (0.3, 0.4, 0.3))
        pgm_factor16 = self.new_factor(Anaphylaxis)
        pgm_function_2759353721824 = pgm_factor16.set_cpt()
        pgm_function_2759353721824.set_cpd((), (0.01, 0.99))
        pgm_factor17 = self.new_factor(SaO2, Shunt, PVSat)
        pgm_function_2759353722240 = pgm_factor17.set_cpt()
        pgm_function_2759353722240.set_cpd((0, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353722240.set_cpd((1, 0), (0.98, 0.01, 0.01))
        pgm_function_2759353722240.set_cpd((0, 1), (0.01, 0.98, 0.01))
        pgm_function_2759353722240.set_cpd((1, 1), (0.98, 0.01, 0.01))
        pgm_function_2759353722240.set_cpd((0, 2), (0.01, 0.01, 0.98))
        pgm_function_2759353722240.set_cpd((1, 2), (0.69, 0.3, 0.01))
        pgm_factor18 = self.new_factor(PVSat, VentAlv, FiO2)
        pgm_function_2759355657712 = pgm_factor18.set_cpt()
        pgm_function_2759355657712.set_cpd((0, 0), (0.98, 0.01, 0.01))
        pgm_function_2759355657712.set_cpd((1, 0), (0.98, 0.01, 0.01))
        pgm_function_2759355657712.set_cpd((2, 0), (0.95, 0.04, 0.01))
        pgm_function_2759355657712.set_cpd((3, 0), (0.95, 0.04, 0.01))
        pgm_function_2759355657712.set_cpd((0, 1), (0.98, 0.01, 0.01))
        pgm_function_2759355657712.set_cpd((1, 1), (0.98, 0.01, 0.01))
        pgm_function_2759355657712.set_cpd((2, 1), (0.01, 0.95, 0.04))
        pgm_function_2759355657712.set_cpd((3, 1), (0.01, 0.01, 0.98))
        pgm_factor19 = self.new_factor(FiO2)
        pgm_function_2759355653760 = pgm_factor19.set_cpt()
        pgm_function_2759355653760.set_cpd((), (0.01, 0.99))
        pgm_factor20 = self.new_factor(VentAlv, Intubation, VentLung)
        pgm_function_2759355654384 = pgm_factor20.set_cpt()
        pgm_function_2759355654384.set_cpd((0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355654384.set_cpd((1, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355654384.set_cpd((2, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355654384.set_cpd((0, 1), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759355654384.set_cpd((1, 1), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759355654384.set_cpd((2, 1), (0.03, 0.95, 0.01, 0.01))
        pgm_function_2759355654384.set_cpd((0, 2), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759355654384.set_cpd((1, 2), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759355654384.set_cpd((2, 2), (0.01, 0.94, 0.04, 0.01))
        pgm_function_2759355654384.set_cpd((0, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759355654384.set_cpd((1, 3), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759355654384.set_cpd((2, 3), (0.01, 0.88, 0.1, 0.01))
        pgm_factor21 = self.new_factor(VentLung, KinkedTube, VentTube, Intubation)
        pgm_function_2759355650848 = pgm_factor21.set_cpt()
        pgm_function_2759355650848.set_cpd((0, 0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 1, 0), (0.95, 0.03, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 1, 0), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 2, 0), (0.4, 0.58, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 2, 0), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759355650848.set_cpd((0, 3, 0), (0.3, 0.68, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 3, 0), (0.01, 0.01, 0.01, 0.97))
        pgm_function_2759355650848.set_cpd((0, 0, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 0, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 1, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 1, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 2, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 2, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 3, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 3, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 0, 2), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 0, 2), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 1, 2), (0.95, 0.03, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 1, 2), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((0, 2, 2), (0.5, 0.48, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 2, 2), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759355650848.set_cpd((0, 3, 2), (0.3, 0.68, 0.01, 0.01))
        pgm_function_2759355650848.set_cpd((1, 3, 2), (0.01, 0.01, 0.01, 0.97))
        pgm_factor22 = self.new_factor(VentTube, VentMach, Disconnect)
        pgm_function_2759355653968 = pgm_factor22.set_cpt()
        pgm_function_2759355653968.set_cpd((0, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355653968.set_cpd((1, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355653968.set_cpd((2, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355653968.set_cpd((3, 0), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355653968.set_cpd((0, 1), (0.97, 0.01, 0.01, 0.01))
        pgm_function_2759355653968.set_cpd((1, 1), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759355653968.set_cpd((2, 1), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759355653968.set_cpd((3, 1), (0.01, 0.01, 0.01, 0.97))
        pgm_factor23 = self.new_factor(Disconnect)
        pgm_function_2759355654592 = pgm_factor23.set_cpt()
        pgm_function_2759355654592.set_cpd((), (0.05, 0.95))
        pgm_factor24 = self.new_factor(VentMach, MinVolSet)
        pgm_function_2759355652720 = pgm_factor24.set_cpt()
        pgm_function_2759355652720.set_cpd((0,), (0.01, 0.97, 0.01, 0.01))
        pgm_function_2759355652720.set_cpd((1,), (0.01, 0.01, 0.97, 0.01))
        pgm_function_2759355652720.set_cpd((2,), (0.01, 0.01, 0.01, 0.97))
        pgm_factor25 = self.new_factor(MinVolSet)
        pgm_function_2759355654800 = pgm_factor25.set_cpt()
        pgm_function_2759355654800.set_cpd((), (0.01, 0.98, 0.01))
        pgm_factor26 = self.new_factor(KinkedTube)
        pgm_function_2759355651056 = pgm_factor26.set_cpt()
        pgm_function_2759355651056.set_cpd((), (0.04, 0.96))
        pgm_factor27 = self.new_factor(Shunt, PulmEmbolus, Intubation)
        pgm_function_2759355656464 = pgm_factor27.set_cpt()
        pgm_function_2759355656464.set_cpd((0, 0), (0.1, 0.9))
        pgm_function_2759355656464.set_cpd((1, 0), (0.95, 0.05))
        pgm_function_2759355656464.set_cpd((0, 1), (0.1, 0.9))
        pgm_function_2759355656464.set_cpd((1, 1), (0.95, 0.05))
        pgm_function_2759355656464.set_cpd((0, 2), (0.01, 0.99))
        pgm_function_2759355656464.set_cpd((1, 2), (0.05, 0.95))
        pgm_factor28 = self.new_factor(Intubation)
        pgm_function_2759355657920 = pgm_factor28.set_cpt()
        pgm_function_2759355657920.set_cpd((), (0.92, 0.03, 0.05))
        pgm_factor29 = self.new_factor(PulmEmbolus)
        pgm_function_2759355652304 = pgm_factor29.set_cpt()
        pgm_function_2759355652304.set_cpd((), (0.01, 0.99))
        pgm_factor30 = self.new_factor(InsuffAnesth)
        pgm_function_2759355650224 = pgm_factor30.set_cpt()
        pgm_function_2759355650224.set_cpd((), (0.2, 0.8))
        pgm_factor31 = self.new_factor(PCWP, LVEDVolume)
        pgm_function_2759355658128 = pgm_factor31.set_cpt()
        pgm_function_2759355658128.set_cpd((0,), (0.95, 0.04, 0.01))
        pgm_function_2759355658128.set_cpd((1,), (0.04, 0.95, 0.01))
        pgm_function_2759355658128.set_cpd((2,), (0.01, 0.04, 0.95))
        pgm_factor32 = self.new_factor(CVP, LVEDVolume)
        pgm_function_2759355656256 = pgm_factor32.set_cpt()
        pgm_function_2759355656256.set_cpd((0,), (0.95, 0.04, 0.01))
        pgm_function_2759355656256.set_cpd((1,), (0.04, 0.95, 0.01))
        pgm_function_2759355656256.set_cpd((2,), (0.01, 0.29, 0.7))
        pgm_factor33 = self.new_factor(StrokeVolume, LVFailure, Hypovolemia)
        pgm_function_2759355650432 = pgm_factor33.set_cpt()
        pgm_function_2759355650432.set_cpd((0, 0), (0.98, 0.01, 0.01))
        pgm_function_2759355650432.set_cpd((1, 0), (0.95, 0.04, 0.01))
        pgm_function_2759355650432.set_cpd((0, 1), (0.5, 0.49, 0.01))
        pgm_function_2759355650432.set_cpd((1, 1), (0.05, 0.9, 0.05))
        pgm_factor34 = self.new_factor(LVEDVolume, Hypovolemia, LVFailure)
        pgm_function_2759355652512 = pgm_factor34.set_cpt()
        pgm_function_2759355652512.set_cpd((0, 0), (0.95, 0.04, 0.01))
        pgm_function_2759355652512.set_cpd((1, 0), (0.01, 0.09, 0.9))
        pgm_function_2759355652512.set_cpd((0, 1), (0.98, 0.01, 0.01))
        pgm_function_2759355652512.set_cpd((1, 1), (0.05, 0.9, 0.05))
        pgm_factor35 = self.new_factor(LVFailure)
        pgm_function_2759355655216 = pgm_factor35.set_cpt()
        pgm_function_2759355655216.set_cpd((), (0.05, 0.95))
        pgm_factor36 = self.new_factor(Hypovolemia)
        pgm_function_2759355656672 = pgm_factor36.set_cpt()
        pgm_function_2759355656672.set_cpd((), (0.2, 0.8))
