from ck.pgm import PGM


class Insurance(PGM):
    """
    This PGM is the well known 'Insurance' Bayesian network.
    """

    def __init__(self):
        super().__init__(self.__class__.__name__)

        GoodStudent = self.new_rv('GoodStudent', ('True', 'False'))
        Age = self.new_rv('Age', ('Adolescent', 'Adult', 'Senior'))
        SocioEcon = self.new_rv('SocioEcon', ('Prole', 'Middle', 'UpperMiddle', 'Wealthy'))
        RiskAversion = self.new_rv('RiskAversion', ('Psychopath', 'Adventurous', 'Normal', 'Cautious'))
        VehicleYear = self.new_rv('VehicleYear', ('Current', 'Older'))
        ThisCarDam = self.new_rv('ThisCarDam', ('None', 'Mild', 'Moderate', 'Severe'))
        RuggedAuto = self.new_rv('RuggedAuto', ('EggShell', 'Football', 'Tank'))
        Accident = self.new_rv('Accident', ('None', 'Mild', 'Moderate', 'Severe'))
        MakeModel = self.new_rv('MakeModel', ('SportsCar', 'Economy', 'FamilySedan', 'Luxury', 'SuperLuxury'))
        DrivQuality = self.new_rv('DrivQuality', ('Poor', 'Normal', 'Excellent'))
        Mileage = self.new_rv('Mileage', ('FiveThou', 'TwentyThou', 'FiftyThou', 'Domino'))
        Antilock = self.new_rv('Antilock', ('True', 'False'))
        DrivingSkill = self.new_rv('DrivingSkill', ('SubStandard', 'Normal', 'Expert'))
        SeniorTrain = self.new_rv('SeniorTrain', ('True', 'False'))
        ThisCarCost = self.new_rv('ThisCarCost', ('Thousand', 'TenThou', 'HundredThou', 'Million'))
        Theft = self.new_rv('Theft', ('True', 'False'))
        CarValue = self.new_rv('CarValue', ('FiveThou', 'TenThou', 'TwentyThou', 'FiftyThou', 'Million'))
        HomeBase = self.new_rv('HomeBase', ('Secure', 'City', 'Suburb', 'Rural'))
        AntiTheft = self.new_rv('AntiTheft', ('True', 'False'))
        PropCost = self.new_rv('PropCost', ('Thousand', 'TenThou', 'HundredThou', 'Million'))
        OtherCarCost = self.new_rv('OtherCarCost', ('Thousand', 'TenThou', 'HundredThou', 'Million'))
        OtherCar = self.new_rv('OtherCar', ('True', 'False'))
        MedCost = self.new_rv('MedCost', ('Thousand', 'TenThou', 'HundredThou', 'Million'))
        Cushioning = self.new_rv('Cushioning', ('Poor', 'Fair', 'Good', 'Excellent'))
        Airbag = self.new_rv('Airbag', ('True', 'False'))
        ILiCost = self.new_rv('ILiCost', ('Thousand', 'TenThou', 'HundredThou', 'Million'))
        DrivHist = self.new_rv('DrivHist', ('Zero', 'One', 'Many'))

        pgm_factor0 = self.new_factor(GoodStudent, SocioEcon, Age)
        pgm_function0 = pgm_factor0.set_cpt()
        pgm_function0.set_cpd((0, 0), (0.1, 0.9))
        pgm_function0.set_cpd((1, 0), (0.2, 0.8))
        pgm_function0.set_cpd((2, 0), (0.5, 0.5))
        pgm_function0.set_cpd((3, 0), (0.4, 0.6))
        pgm_function0.set_cpd((0, 1), (0.0, 1.0))
        pgm_function0.set_cpd((1, 1), (0.0, 1.0))
        pgm_function0.set_cpd((2, 1), (0.0, 1.0))
        pgm_function0.set_cpd((3, 1), (0.0, 1.0))
        pgm_function0.set_cpd((0, 2), (0.0, 1.0))
        pgm_function0.set_cpd((1, 2), (0.0, 1.0))
        pgm_function0.set_cpd((2, 2), (0.0, 1.0))
        pgm_function0.set_cpd((3, 2), (0.0, 1.0))
        pgm_factor1 = self.new_factor(Age)
        pgm_function1 = pgm_factor1.set_cpt()
        pgm_function1.set_cpd((), (0.2, 0.6, 0.2))
        pgm_factor2 = self.new_factor(SocioEcon, Age)
        pgm_function2 = pgm_factor2.set_cpt()
        pgm_function2.set_cpd((0,), (0.4, 0.4, 0.19, 0.01))
        pgm_function2.set_cpd((1,), (0.4, 0.4, 0.19, 0.01))
        pgm_function2.set_cpd((2,), (0.5, 0.2, 0.29, 0.01))
        pgm_factor3 = self.new_factor(RiskAversion, Age, SocioEcon)
        pgm_function3 = pgm_factor3.set_cpt()
        pgm_function3.set_cpd((0, 0), (0.02, 0.58, 0.3, 0.1))
        pgm_function3.set_cpd((1, 0), (0.015, 0.285, 0.5, 0.2))
        pgm_function3.set_cpd((2, 0), (0.01, 0.09, 0.4, 0.5))
        pgm_function3.set_cpd((0, 1), (0.02, 0.38, 0.5, 0.1))
        pgm_function3.set_cpd((1, 1), (0.015, 0.185, 0.6, 0.2))
        pgm_function3.set_cpd((2, 1), (0.01, 0.04, 0.35, 0.6))
        pgm_function3.set_cpd((0, 2), (0.02, 0.48, 0.4, 0.1))
        pgm_function3.set_cpd((1, 2), (0.015, 0.285, 0.5, 0.2))
        pgm_function3.set_cpd((2, 2), (0.01, 0.09, 0.4, 0.5))
        pgm_function3.set_cpd((0, 3), (0.02, 0.58, 0.3, 0.1))
        pgm_function3.set_cpd((1, 3), (0.015, 0.285, 0.4, 0.3))
        pgm_function3.set_cpd((2, 3), (0.01, 0.09, 0.4, 0.5))
        pgm_factor4 = self.new_factor(VehicleYear, SocioEcon, RiskAversion)
        pgm_function4 = pgm_factor4.set_cpt()
        pgm_function4.set_cpd((0, 0), (0.15, 0.85))
        pgm_function4.set_cpd((1, 0), (0.3, 0.7))
        pgm_function4.set_cpd((2, 0), (0.8, 0.2))
        pgm_function4.set_cpd((3, 0), (0.9, 0.1))
        pgm_function4.set_cpd((0, 1), (0.15, 0.85))
        pgm_function4.set_cpd((1, 1), (0.3, 0.7))
        pgm_function4.set_cpd((2, 1), (0.8, 0.2))
        pgm_function4.set_cpd((3, 1), (0.9, 0.1))
        pgm_function4.set_cpd((0, 2), (0.15, 0.85))
        pgm_function4.set_cpd((1, 2), (0.3, 0.7))
        pgm_function4.set_cpd((2, 2), (0.8, 0.2))
        pgm_function4.set_cpd((3, 2), (0.9, 0.1))
        pgm_function4.set_cpd((0, 3), (0.15, 0.85))
        pgm_function4.set_cpd((1, 3), (0.3, 0.7))
        pgm_function4.set_cpd((2, 3), (0.8, 0.2))
        pgm_function4.set_cpd((3, 3), (0.9, 0.1))
        pgm_factor5 = self.new_factor(ThisCarDam, Accident, RuggedAuto)
        pgm_function5 = pgm_factor5.set_cpt()
        pgm_function5.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((1, 0), (0.001, 0.9, 0.098, 0.001))
        pgm_function5.set_cpd((2, 0), (1e-06, 0.000999, 0.7, 0.299))
        pgm_function5.set_cpd((3, 0), (1e-06, 9e-06, 9e-05, 0.9999))
        pgm_function5.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((1, 1), (0.2, 0.75, 0.049999, 1e-06))
        pgm_function5.set_cpd((2, 1), (0.001, 0.099, 0.8, 0.1))
        pgm_function5.set_cpd((3, 1), (1e-06, 0.000999, 0.009, 0.99))
        pgm_function5.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function5.set_cpd((1, 2), (0.7, 0.29, 0.009999, 1e-06))
        pgm_function5.set_cpd((2, 2), (0.05, 0.6, 0.3, 0.05))
        pgm_function5.set_cpd((3, 2), (0.05, 0.2, 0.2, 0.55))
        pgm_factor6 = self.new_factor(RuggedAuto, MakeModel, VehicleYear)
        pgm_function6 = pgm_factor6.set_cpt()
        pgm_function6.set_cpd((0, 0), (0.95, 0.04, 0.01))
        pgm_function6.set_cpd((1, 0), (0.5, 0.5, 0.0))
        pgm_function6.set_cpd((2, 0), (0.2, 0.6, 0.2))
        pgm_function6.set_cpd((3, 0), (0.1, 0.6, 0.3))
        pgm_function6.set_cpd((4, 0), (0.05, 0.55, 0.4))
        pgm_function6.set_cpd((0, 1), (0.95, 0.04, 0.01))
        pgm_function6.set_cpd((1, 1), (0.9, 0.1, 0.0))
        pgm_function6.set_cpd((2, 1), (0.05, 0.55, 0.4))
        pgm_function6.set_cpd((3, 1), (0.1, 0.6, 0.3))
        pgm_function6.set_cpd((4, 1), (0.05, 0.55, 0.4))
        pgm_factor7 = self.new_factor(Accident, Antilock, Mileage, DrivQuality)
        pgm_function7 = pgm_factor7.set_cpt()
        pgm_function7.set_cpd((0, 0, 0), (0.7, 0.2, 0.07, 0.03))
        pgm_function7.set_cpd((1, 0, 0), (0.6, 0.2, 0.1, 0.1))
        pgm_function7.set_cpd((0, 1, 0), (0.4, 0.3, 0.2, 0.1))
        pgm_function7.set_cpd((1, 1, 0), (0.3, 0.2, 0.2, 0.3))
        pgm_function7.set_cpd((0, 2, 0), (0.3, 0.3, 0.2, 0.2))
        pgm_function7.set_cpd((1, 2, 0), (0.2, 0.2, 0.2, 0.4))
        pgm_function7.set_cpd((0, 3, 0), (0.2, 0.2, 0.3, 0.3))
        pgm_function7.set_cpd((1, 3, 0), (0.1, 0.1, 0.3, 0.5))
        pgm_function7.set_cpd((0, 0, 1), (0.99, 0.007, 0.002, 0.001))
        pgm_function7.set_cpd((1, 0, 1), (0.98, 0.01, 0.005, 0.005))
        pgm_function7.set_cpd((0, 1, 1), (0.98, 0.01, 0.005, 0.005))
        pgm_function7.set_cpd((1, 1, 1), (0.96, 0.02, 0.015, 0.005))
        pgm_function7.set_cpd((0, 2, 1), (0.97, 0.02, 0.007, 0.003))
        pgm_function7.set_cpd((1, 2, 1), (0.95, 0.03, 0.015, 0.005))
        pgm_function7.set_cpd((0, 3, 1), (0.95, 0.03, 0.01, 0.01))
        pgm_function7.set_cpd((1, 3, 1), (0.94, 0.03, 0.02, 0.01))
        pgm_function7.set_cpd((0, 0, 2), (0.999, 0.0007, 0.0002, 0.0001))
        pgm_function7.set_cpd((1, 0, 2), (0.995, 0.003, 0.001, 0.001))
        pgm_function7.set_cpd((0, 1, 2), (0.995, 0.003, 0.001, 0.001))
        pgm_function7.set_cpd((1, 1, 2), (0.99, 0.007, 0.002, 0.001))
        pgm_function7.set_cpd((0, 2, 2), (0.99, 0.007, 0.002, 0.001))
        pgm_function7.set_cpd((1, 2, 2), (0.98, 0.01, 0.005, 0.005))
        pgm_function7.set_cpd((0, 3, 2), (0.985, 0.01, 0.003, 0.002))
        pgm_function7.set_cpd((1, 3, 2), (0.98, 0.01, 0.007, 0.003))
        pgm_factor8 = self.new_factor(MakeModel, SocioEcon, RiskAversion)
        pgm_function8 = pgm_factor8.set_cpt()
        pgm_function8.set_cpd((0, 0), (0.1, 0.7, 0.2, 0.0, 0.0))
        pgm_function8.set_cpd((1, 0), (0.15, 0.2, 0.65, 0.0, 0.0))
        pgm_function8.set_cpd((2, 0), (0.2, 0.05, 0.3, 0.45, 0.0))
        pgm_function8.set_cpd((3, 0), (0.3, 0.01, 0.09, 0.4, 0.2))
        pgm_function8.set_cpd((0, 1), (0.1, 0.7, 0.2, 0.0, 0.0))
        pgm_function8.set_cpd((1, 1), (0.15, 0.2, 0.65, 0.0, 0.0))
        pgm_function8.set_cpd((2, 1), (0.2, 0.05, 0.3, 0.45, 0.0))
        pgm_function8.set_cpd((3, 1), (0.3, 0.01, 0.09, 0.4, 0.2))
        pgm_function8.set_cpd((0, 2), (0.1, 0.7, 0.2, 0.0, 0.0))
        pgm_function8.set_cpd((1, 2), (0.15, 0.2, 0.65, 0.0, 0.0))
        pgm_function8.set_cpd((2, 2), (0.2, 0.05, 0.3, 0.45, 0.0))
        pgm_function8.set_cpd((3, 2), (0.3, 0.01, 0.09, 0.4, 0.2))
        pgm_function8.set_cpd((0, 3), (0.1, 0.7, 0.2, 0.0, 0.0))
        pgm_function8.set_cpd((1, 3), (0.15, 0.2, 0.65, 0.0, 0.0))
        pgm_function8.set_cpd((2, 3), (0.2, 0.05, 0.3, 0.45, 0.0))
        pgm_function8.set_cpd((3, 3), (0.3, 0.01, 0.09, 0.4, 0.2))
        pgm_factor9 = self.new_factor(DrivQuality, DrivingSkill, RiskAversion)
        pgm_function9 = pgm_factor9.set_cpt()
        pgm_function9.set_cpd((0, 0), (1.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 0), (0.5, 0.2, 0.3))
        pgm_function9.set_cpd((2, 0), (0.3, 0.2, 0.5))
        pgm_function9.set_cpd((0, 1), (1.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 1), (0.3, 0.4, 0.3))
        pgm_function9.set_cpd((2, 1), (0.01, 0.01, 0.98))
        pgm_function9.set_cpd((0, 2), (1.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 2), (0.0, 1.0, 0.0))
        pgm_function9.set_cpd((2, 2), (0.0, 0.0, 1.0))
        pgm_function9.set_cpd((0, 3), (1.0, 0.0, 0.0))
        pgm_function9.set_cpd((1, 3), (0.0, 0.8, 0.2))
        pgm_function9.set_cpd((2, 3), (0.0, 0.0, 1.0))
        pgm_factor10 = self.new_factor(Mileage)
        pgm_function10 = pgm_factor10.set_cpt()
        pgm_function10.set_cpd((), (0.1, 0.4, 0.4, 0.1))
        pgm_factor11 = self.new_factor(Antilock, MakeModel, VehicleYear)
        pgm_function11 = pgm_factor11.set_cpt()
        pgm_function11.set_cpd((0, 0), (0.9, 0.1))
        pgm_function11.set_cpd((1, 0), (0.001, 0.999))
        pgm_function11.set_cpd((2, 0), (0.4, 0.6))
        pgm_function11.set_cpd((3, 0), (0.99, 0.01))
        pgm_function11.set_cpd((4, 0), (0.99, 0.01))
        pgm_function11.set_cpd((0, 1), (0.1, 0.9))
        pgm_function11.set_cpd((1, 1), (0.0, 1.0))
        pgm_function11.set_cpd((2, 1), (0.0, 1.0))
        pgm_function11.set_cpd((3, 1), (0.3, 0.7))
        pgm_function11.set_cpd((4, 1), (0.15, 0.85))
        pgm_factor12 = self.new_factor(DrivingSkill, Age, SeniorTrain)
        pgm_function12 = pgm_factor12.set_cpt()
        pgm_function12.set_cpd((0, 0), (0.5, 0.45, 0.05))
        pgm_function12.set_cpd((1, 0), (0.3, 0.6, 0.1))
        pgm_function12.set_cpd((2, 0), (0.1, 0.6, 0.3))
        pgm_function12.set_cpd((0, 1), (0.5, 0.45, 0.05))
        pgm_function12.set_cpd((1, 1), (0.3, 0.6, 0.1))
        pgm_function12.set_cpd((2, 1), (0.4, 0.5, 0.1))
        pgm_factor13 = self.new_factor(SeniorTrain, Age, RiskAversion)
        pgm_function13 = pgm_factor13.set_cpt()
        pgm_function13.set_cpd((0, 0), (0.0, 1.0))
        pgm_function13.set_cpd((1, 0), (0.0, 1.0))
        pgm_function13.set_cpd((2, 0), (1e-06, 0.999999))
        pgm_function13.set_cpd((0, 1), (0.0, 1.0))
        pgm_function13.set_cpd((1, 1), (0.0, 1.0))
        pgm_function13.set_cpd((2, 1), (1e-06, 0.999999))
        pgm_function13.set_cpd((0, 2), (0.0, 1.0))
        pgm_function13.set_cpd((1, 2), (0.0, 1.0))
        pgm_function13.set_cpd((2, 2), (0.3, 0.7))
        pgm_function13.set_cpd((0, 3), (0.0, 1.0))
        pgm_function13.set_cpd((1, 3), (0.0, 1.0))
        pgm_function13.set_cpd((2, 3), (0.9, 0.1))
        pgm_factor14 = self.new_factor(ThisCarCost, ThisCarDam, CarValue, Theft)
        pgm_function14 = pgm_factor14.set_cpt()
        pgm_function14.set_cpd((0, 0, 0), (0.2, 0.8, 0.0, 0.0))
        pgm_function14.set_cpd((1, 0, 0), (0.15, 0.85, 0.0, 0.0))
        pgm_function14.set_cpd((2, 0, 0), (0.05, 0.95, 0.0, 0.0))
        pgm_function14.set_cpd((3, 0, 0), (0.03, 0.97, 0.0, 0.0))
        pgm_function14.set_cpd((0, 1, 0), (0.05, 0.95, 0.0, 0.0))
        pgm_function14.set_cpd((1, 1, 0), (0.03, 0.97, 0.0, 0.0))
        pgm_function14.set_cpd((2, 1, 0), (0.01, 0.99, 0.0, 0.0))
        pgm_function14.set_cpd((3, 1, 0), (1e-06, 0.999999, 0.0, 0.0))
        pgm_function14.set_cpd((0, 2, 0), (0.04, 0.01, 0.95, 0.0))
        pgm_function14.set_cpd((1, 2, 0), (0.03, 0.02, 0.95, 0.0))
        pgm_function14.set_cpd((2, 2, 0), (0.001, 0.001, 0.998, 0.0))
        pgm_function14.set_cpd((3, 2, 0), (1e-06, 1e-06, 0.999998, 0.0))
        pgm_function14.set_cpd((0, 3, 0), (0.04, 0.01, 0.95, 0.0))
        pgm_function14.set_cpd((1, 3, 0), (0.03, 0.02, 0.95, 0.0))
        pgm_function14.set_cpd((2, 3, 0), (0.001, 0.001, 0.998, 0.0))
        pgm_function14.set_cpd((3, 3, 0), (1e-06, 1e-06, 0.999998, 0.0))
        pgm_function14.set_cpd((0, 4, 0), (0.04, 0.01, 0.2, 0.75))
        pgm_function14.set_cpd((1, 4, 0), (0.02, 0.03, 0.25, 0.7))
        pgm_function14.set_cpd((2, 4, 0), (0.001, 0.001, 0.018, 0.98))
        pgm_function14.set_cpd((3, 4, 0), (1e-06, 1e-06, 0.009998, 0.99))
        pgm_function14.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 0, 1), (0.95, 0.05, 0.0, 0.0))
        pgm_function14.set_cpd((2, 0, 1), (0.25, 0.75, 0.0, 0.0))
        pgm_function14.set_cpd((3, 0, 1), (0.05, 0.95, 0.0, 0.0))
        pgm_function14.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 1, 1), (0.95, 0.05, 0.0, 0.0))
        pgm_function14.set_cpd((2, 1, 1), (0.15, 0.85, 0.0, 0.0))
        pgm_function14.set_cpd((3, 1, 1), (0.01, 0.99, 0.0, 0.0))
        pgm_function14.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 2, 1), (0.99, 0.01, 0.0, 0.0))
        pgm_function14.set_cpd((2, 2, 1), (0.01, 0.01, 0.98, 0.0))
        pgm_function14.set_cpd((3, 2, 1), (0.005, 0.005, 0.99, 0.0))
        pgm_function14.set_cpd((0, 3, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 3, 1), (0.99, 0.01, 0.0, 0.0))
        pgm_function14.set_cpd((2, 3, 1), (0.005, 0.005, 0.99, 0.0))
        pgm_function14.set_cpd((3, 3, 1), (0.001, 0.001, 0.998, 0.0))
        pgm_function14.set_cpd((0, 4, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function14.set_cpd((1, 4, 1), (0.98, 0.01, 0.01, 0.0))
        pgm_function14.set_cpd((2, 4, 1), (0.003, 0.003, 0.044, 0.95))
        pgm_function14.set_cpd((3, 4, 1), (1e-06, 1e-06, 0.029998, 0.97))
        pgm_factor15 = self.new_factor(Theft, AntiTheft, HomeBase, CarValue)
        pgm_function15 = pgm_factor15.set_cpt()
        pgm_function15.set_cpd((0, 0, 0), (1e-06, 0.999999))
        pgm_function15.set_cpd((1, 0, 0), (1e-06, 0.999999))
        pgm_function15.set_cpd((0, 1, 0), (0.0005, 0.9995))
        pgm_function15.set_cpd((1, 1, 0), (0.001, 0.999))
        pgm_function15.set_cpd((0, 2, 0), (1e-05, 0.99999))
        pgm_function15.set_cpd((1, 2, 0), (1e-05, 0.99999))
        pgm_function15.set_cpd((0, 3, 0), (1e-05, 0.99999))
        pgm_function15.set_cpd((1, 3, 0), (1e-05, 0.99999))
        pgm_function15.set_cpd((0, 0, 1), (2e-06, 0.999998))
        pgm_function15.set_cpd((1, 0, 1), (2e-06, 0.999998))
        pgm_function15.set_cpd((0, 1, 1), (0.002, 0.998))
        pgm_function15.set_cpd((1, 1, 1), (0.005, 0.995))
        pgm_function15.set_cpd((0, 2, 1), (0.0001, 0.9999))
        pgm_function15.set_cpd((1, 2, 1), (0.0002, 0.9998))
        pgm_function15.set_cpd((0, 3, 1), (2e-05, 0.99998))
        pgm_function15.set_cpd((1, 3, 1), (0.0001, 0.9999))
        pgm_function15.set_cpd((0, 0, 2), (3e-06, 0.999997))
        pgm_function15.set_cpd((1, 0, 2), (3e-06, 0.999997))
        pgm_function15.set_cpd((0, 1, 2), (0.005, 0.995))
        pgm_function15.set_cpd((1, 1, 2), (0.01, 0.99))
        pgm_function15.set_cpd((0, 2, 2), (0.0003, 0.9997))
        pgm_function15.set_cpd((1, 2, 2), (0.0005, 0.9995))
        pgm_function15.set_cpd((0, 3, 2), (5e-05, 0.99995))
        pgm_function15.set_cpd((1, 3, 2), (0.0002, 0.9998))
        pgm_function15.set_cpd((0, 0, 3), (2e-06, 0.999998))
        pgm_function15.set_cpd((1, 0, 3), (2e-06, 0.999998))
        pgm_function15.set_cpd((0, 1, 3), (0.005, 0.995))
        pgm_function15.set_cpd((1, 1, 3), (0.01, 0.99))
        pgm_function15.set_cpd((0, 2, 3), (0.0003, 0.9997))
        pgm_function15.set_cpd((1, 2, 3), (0.0005, 0.9995))
        pgm_function15.set_cpd((0, 3, 3), (5e-05, 0.99995))
        pgm_function15.set_cpd((1, 3, 3), (0.0002, 0.9998))
        pgm_function15.set_cpd((0, 0, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((1, 0, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((0, 1, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((1, 1, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((0, 2, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((1, 2, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((0, 3, 4), (1e-06, 0.999999))
        pgm_function15.set_cpd((1, 3, 4), (1e-06, 0.999999))
        pgm_factor16 = self.new_factor(CarValue, MakeModel, VehicleYear, Mileage)
        pgm_function16 = pgm_factor16.set_cpt()
        pgm_function16.set_cpd((0, 0, 0), (0.0, 0.1, 0.8, 0.09, 0.01))
        pgm_function16.set_cpd((1, 0, 0), (0.1, 0.8, 0.1, 0.0, 0.0))
        pgm_function16.set_cpd((2, 0, 0), (0.0, 0.1, 0.9, 0.0, 0.0))
        pgm_function16.set_cpd((3, 0, 0), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function16.set_cpd((4, 0, 0), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function16.set_cpd((0, 1, 0), (0.03, 0.3, 0.6, 0.06, 0.01))
        pgm_function16.set_cpd((1, 1, 0), (0.25, 0.7, 0.05, 0.0, 0.0))
        pgm_function16.set_cpd((2, 1, 0), (0.2, 0.3, 0.5, 0.0, 0.0))
        pgm_function16.set_cpd((3, 1, 0), (0.01, 0.09, 0.2, 0.7, 0.0))
        pgm_function16.set_cpd((4, 1, 0), (1e-06, 1e-06, 1e-06, 1e-06, 0.999996))
        pgm_function16.set_cpd((0, 0, 1), (0.0, 0.1, 0.8, 0.09, 0.01))
        pgm_function16.set_cpd((1, 0, 1), (0.1, 0.8, 0.1, 0.0, 0.0))
        pgm_function16.set_cpd((2, 0, 1), (0.0, 0.1, 0.9, 0.0, 0.0))
        pgm_function16.set_cpd((3, 0, 1), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function16.set_cpd((4, 0, 1), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function16.set_cpd((0, 1, 1), (0.16, 0.5, 0.3, 0.03, 0.01))
        pgm_function16.set_cpd((1, 1, 1), (0.7, 0.2999, 0.0001, 0.0, 0.0))
        pgm_function16.set_cpd((2, 1, 1), (0.5, 0.3, 0.2, 0.0, 0.0))
        pgm_function16.set_cpd((3, 1, 1), (0.05, 0.15, 0.3, 0.5, 0.0))
        pgm_function16.set_cpd((4, 1, 1), (1e-06, 1e-06, 1e-06, 1e-06, 0.999996))
        pgm_function16.set_cpd((0, 0, 2), (0.0, 0.1, 0.8, 0.09, 0.01))
        pgm_function16.set_cpd((1, 0, 2), (0.1, 0.8, 0.1, 0.0, 0.0))
        pgm_function16.set_cpd((2, 0, 2), (0.0, 0.1, 0.9, 0.0, 0.0))
        pgm_function16.set_cpd((3, 0, 2), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function16.set_cpd((4, 0, 2), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function16.set_cpd((0, 1, 2), (0.4, 0.47, 0.1, 0.02, 0.01))
        pgm_function16.set_cpd((1, 1, 2), (0.99, 0.009999, 1e-06, 0.0, 0.0))
        pgm_function16.set_cpd((2, 1, 2), (0.7, 0.2, 0.1, 0.0, 0.0))
        pgm_function16.set_cpd((3, 1, 2), (0.1, 0.3, 0.3, 0.3, 0.0))
        pgm_function16.set_cpd((4, 1, 2), (1e-06, 1e-06, 1e-06, 1e-06, 0.999996))
        pgm_function16.set_cpd((0, 0, 3), (0.0, 0.1, 0.8, 0.09, 0.01))
        pgm_function16.set_cpd((1, 0, 3), (0.1, 0.8, 0.1, 0.0, 0.0))
        pgm_function16.set_cpd((2, 0, 3), (0.0, 0.1, 0.9, 0.0, 0.0))
        pgm_function16.set_cpd((3, 0, 3), (0.0, 0.0, 0.0, 1.0, 0.0))
        pgm_function16.set_cpd((4, 0, 3), (0.0, 0.0, 0.0, 0.0, 1.0))
        pgm_function16.set_cpd((0, 1, 3), (0.9, 0.06, 0.02, 0.01, 0.01))
        pgm_function16.set_cpd((1, 1, 3), (0.999998, 1e-06, 1e-06, 0.0, 0.0))
        pgm_function16.set_cpd((2, 1, 3), (0.99, 0.009999, 1e-06, 0.0, 0.0))
        pgm_function16.set_cpd((3, 1, 3), (0.2, 0.2, 0.3, 0.3, 0.0))
        pgm_function16.set_cpd((4, 1, 3), (1e-06, 1e-06, 1e-06, 1e-06, 0.999996))
        pgm_factor17 = self.new_factor(HomeBase, RiskAversion, SocioEcon)
        pgm_function17 = pgm_factor17.set_cpt()
        pgm_function17.set_cpd((0, 0), (1e-06, 0.8, 0.049999, 0.15))
        pgm_function17.set_cpd((1, 0), (1e-06, 0.8, 0.05, 0.149999))
        pgm_function17.set_cpd((2, 0), (1e-06, 0.8, 0.05, 0.149999))
        pgm_function17.set_cpd((3, 0), (1e-06, 0.8, 0.05, 0.149999))
        pgm_function17.set_cpd((0, 1), (0.15, 0.8, 0.04, 0.01))
        pgm_function17.set_cpd((1, 1), (0.01, 0.25, 0.6, 0.14))
        pgm_function17.set_cpd((2, 1), (0.299999, 1e-06, 0.6, 0.1))
        pgm_function17.set_cpd((3, 1), (0.95, 1e-06, 0.024445, 0.025554))
        pgm_function17.set_cpd((0, 2), (0.35, 0.6, 0.04, 0.01))
        pgm_function17.set_cpd((1, 2), (0.2, 0.4, 0.3, 0.1))
        pgm_function17.set_cpd((2, 2), (0.5, 1e-06, 0.4, 0.099999))
        pgm_function17.set_cpd((3, 2), (0.999997, 1e-06, 1e-06, 1e-06))
        pgm_function17.set_cpd((0, 3), (0.489999, 0.5, 1e-06, 0.01))
        pgm_function17.set_cpd((1, 3), (0.95, 1e-06, 1e-06, 0.049998))
        pgm_function17.set_cpd((2, 3), (0.85, 1e-06, 0.001, 0.148999))
        pgm_function17.set_cpd((3, 3), (0.999997, 1e-06, 1e-06, 1e-06))
        pgm_factor18 = self.new_factor(AntiTheft, RiskAversion, SocioEcon)
        pgm_function18 = pgm_factor18.set_cpt()
        pgm_function18.set_cpd((0, 0), (1e-06, 0.999999))
        pgm_function18.set_cpd((1, 0), (1e-06, 0.999999))
        pgm_function18.set_cpd((2, 0), (0.1, 0.9))
        pgm_function18.set_cpd((3, 0), (0.95, 0.05))
        pgm_function18.set_cpd((0, 1), (1e-06, 0.999999))
        pgm_function18.set_cpd((1, 1), (1e-06, 0.999999))
        pgm_function18.set_cpd((2, 1), (0.3, 0.7))
        pgm_function18.set_cpd((3, 1), (0.999999, 1e-06))
        pgm_function18.set_cpd((0, 2), (0.05, 0.95))
        pgm_function18.set_cpd((1, 2), (0.2, 0.8))
        pgm_function18.set_cpd((2, 2), (0.9, 0.1))
        pgm_function18.set_cpd((3, 2), (0.999999, 1e-06))
        pgm_function18.set_cpd((0, 3), (0.5, 0.5))
        pgm_function18.set_cpd((1, 3), (0.5, 0.5))
        pgm_function18.set_cpd((2, 3), (0.8, 0.2))
        pgm_function18.set_cpd((3, 3), (0.999999, 1e-06))
        pgm_factor19 = self.new_factor(PropCost, OtherCarCost, ThisCarCost)
        pgm_function19 = pgm_factor19.set_cpt()
        pgm_function19.set_cpd((0, 0), (0.7, 0.3, 0.0, 0.0))
        pgm_function19.set_cpd((1, 0), (0.0, 0.95, 0.05, 0.0))
        pgm_function19.set_cpd((2, 0), (0.0, 0.0, 0.98, 0.02))
        pgm_function19.set_cpd((3, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function19.set_cpd((0, 1), (0.0, 0.95, 0.05, 0.0))
        pgm_function19.set_cpd((1, 1), (0.0, 0.6, 0.4, 0.0))
        pgm_function19.set_cpd((2, 1), (0.0, 0.0, 0.8, 0.2))
        pgm_function19.set_cpd((3, 1), (0.0, 0.0, 0.0, 1.0))
        pgm_function19.set_cpd((0, 2), (0.0, 0.0, 0.98, 0.02))
        pgm_function19.set_cpd((1, 2), (0.0, 0.0, 0.95, 0.05))
        pgm_function19.set_cpd((2, 2), (0.0, 0.0, 0.6, 0.4))
        pgm_function19.set_cpd((3, 2), (0.0, 0.0, 0.0, 1.0))
        pgm_function19.set_cpd((0, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function19.set_cpd((1, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function19.set_cpd((2, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_function19.set_cpd((3, 3), (0.0, 0.0, 0.0, 1.0))
        pgm_factor20 = self.new_factor(OtherCarCost, Accident, RuggedAuto)
        pgm_function20 = pgm_factor20.set_cpt()
        pgm_function20.set_cpd((0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function20.set_cpd((1, 0), (0.99, 0.005, 0.00499, 1e-05))
        pgm_function20.set_cpd((2, 0), (0.6, 0.2, 0.19998, 2e-05))
        pgm_function20.set_cpd((3, 0), (0.2, 0.4, 0.39996, 4e-05))
        pgm_function20.set_cpd((0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function20.set_cpd((1, 1), (0.9799657, 0.00999965, 0.009984651, 4.999825e-05))
        pgm_function20.set_cpd((2, 1), (0.5, 0.2, 0.29997, 3e-05))
        pgm_function20.set_cpd((3, 1), (0.1, 0.5, 0.39994, 6e-05))
        pgm_function20.set_cpd((0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function20.set_cpd((1, 2), (0.95, 0.03, 0.01998, 2e-05))
        pgm_function20.set_cpd((2, 2), (0.4, 0.3, 0.29996, 4e-05))
        pgm_function20.set_cpd((3, 2), (0.005, 0.55, 0.4449, 0.0001))
        pgm_factor21 = self.new_factor(OtherCar, SocioEcon)
        pgm_function21 = pgm_factor21.set_cpt()
        pgm_function21.set_cpd((0,), (0.5, 0.5))
        pgm_function21.set_cpd((1,), (0.8, 0.2))
        pgm_function21.set_cpd((2,), (0.9, 0.1))
        pgm_function21.set_cpd((3,), (0.95, 0.05))
        pgm_factor22 = self.new_factor(MedCost, Accident, Age, Cushioning)
        pgm_function22 = pgm_factor22.set_cpt()
        pgm_function22.set_cpd((0, 0, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 0, 0), (0.96, 0.03, 0.009, 0.001))
        pgm_function22.set_cpd((2, 0, 0), (0.5, 0.2, 0.2, 0.1))
        pgm_function22.set_cpd((3, 0, 0), (0.3, 0.3, 0.2, 0.2))
        pgm_function22.set_cpd((0, 1, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 1, 0), (0.96, 0.03, 0.009, 0.001))
        pgm_function22.set_cpd((2, 1, 0), (0.5, 0.2, 0.2, 0.1))
        pgm_function22.set_cpd((3, 1, 0), (0.3, 0.3, 0.2, 0.2))
        pgm_function22.set_cpd((0, 2, 0), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 2, 0), (0.9, 0.07, 0.02, 0.01))
        pgm_function22.set_cpd((2, 2, 0), (0.3, 0.3, 0.2, 0.2))
        pgm_function22.set_cpd((3, 2, 0), (0.2, 0.2, 0.3, 0.3))
        pgm_function22.set_cpd((0, 0, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 0, 1), (0.98, 0.019, 0.0009, 0.0001))
        pgm_function22.set_cpd((2, 0, 1), (0.8, 0.15, 0.03, 0.02))
        pgm_function22.set_cpd((3, 0, 1), (0.5, 0.2, 0.2, 0.1))
        pgm_function22.set_cpd((0, 1, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 1, 1), (0.98, 0.019, 0.0009, 0.0001))
        pgm_function22.set_cpd((2, 1, 1), (0.8, 0.15, 0.03, 0.02))
        pgm_function22.set_cpd((3, 1, 1), (0.5, 0.2, 0.2, 0.1))
        pgm_function22.set_cpd((0, 2, 1), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 2, 1), (0.95, 0.04, 0.007, 0.003))
        pgm_function22.set_cpd((2, 2, 1), (0.5, 0.2, 0.2, 0.1))
        pgm_function22.set_cpd((3, 2, 1), (0.3, 0.3, 0.2, 0.2))
        pgm_function22.set_cpd((0, 0, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 0, 2), (0.99, 0.0099, 9e-05, 1e-05))
        pgm_function22.set_cpd((2, 0, 2), (0.95, 0.02, 0.02, 0.01))
        pgm_function22.set_cpd((3, 0, 2), (0.9, 0.07, 0.02, 0.01))
        pgm_function22.set_cpd((0, 1, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 1, 2), (0.99, 0.0099, 9e-05, 1e-05))
        pgm_function22.set_cpd((2, 1, 2), (0.95, 0.02, 0.02, 0.01))
        pgm_function22.set_cpd((3, 1, 2), (0.9, 0.07, 0.02, 0.01))
        pgm_function22.set_cpd((0, 2, 2), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 2, 2), (0.97, 0.025, 0.003, 0.002))
        pgm_function22.set_cpd((2, 2, 2), (0.9, 0.07, 0.02, 0.01))
        pgm_function22.set_cpd((3, 2, 2), (0.6, 0.3, 0.07, 0.03))
        pgm_function22.set_cpd((0, 0, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 0, 3), (0.999, 0.00099, 9e-06, 1e-06))
        pgm_function22.set_cpd((2, 0, 3), (0.99, 0.007, 0.002, 0.001))
        pgm_function22.set_cpd((3, 0, 3), (0.95, 0.03, 0.01, 0.01))
        pgm_function22.set_cpd((0, 1, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 1, 3), (0.999, 0.00099, 9e-06, 1e-06))
        pgm_function22.set_cpd((2, 1, 3), (0.99, 0.007, 0.002, 0.001))
        pgm_function22.set_cpd((3, 1, 3), (0.95, 0.03, 0.01, 0.01))
        pgm_function22.set_cpd((0, 2, 3), (1.0, 0.0, 0.0, 0.0))
        pgm_function22.set_cpd((1, 2, 3), (0.99, 0.007, 0.002, 0.001))
        pgm_function22.set_cpd((2, 2, 3), (0.95, 0.03, 0.01, 0.01))
        pgm_function22.set_cpd((3, 2, 3), (0.9, 0.05, 0.03, 0.02))
        pgm_factor23 = self.new_factor(Cushioning, RuggedAuto, Airbag)
        pgm_function23 = pgm_factor23.set_cpt()
        pgm_function23.set_cpd((0, 0), (0.5, 0.3, 0.2, 0.0))
        pgm_function23.set_cpd((1, 0), (0.0, 0.1, 0.6, 0.3))
        pgm_function23.set_cpd((2, 0), (0.0, 0.0, 0.0, 1.0))
        pgm_function23.set_cpd((0, 1), (0.7, 0.3, 0.0, 0.0))
        pgm_function23.set_cpd((1, 1), (0.1, 0.6, 0.3, 0.0))
        pgm_function23.set_cpd((2, 1), (0.0, 0.0, 0.7, 0.3))
        pgm_factor24 = self.new_factor(Airbag, MakeModel, VehicleYear)
        pgm_function24 = pgm_factor24.set_cpt()
        pgm_function24.set_cpd((0, 0), (1.0, 0.0))
        pgm_function24.set_cpd((1, 0), (1.0, 0.0))
        pgm_function24.set_cpd((2, 0), (1.0, 0.0))
        pgm_function24.set_cpd((3, 0), (1.0, 0.0))
        pgm_function24.set_cpd((4, 0), (1.0, 0.0))
        pgm_function24.set_cpd((0, 1), (0.1, 0.9))
        pgm_function24.set_cpd((1, 1), (0.05, 0.95))
        pgm_function24.set_cpd((2, 1), (0.2, 0.8))
        pgm_function24.set_cpd((3, 1), (0.6, 0.4))
        pgm_function24.set_cpd((4, 1), (0.1, 0.9))
        pgm_factor25 = self.new_factor(ILiCost, Accident)
        pgm_function25 = pgm_factor25.set_cpt()
        pgm_function25.set_cpd((0,), (1.0, 0.0, 0.0, 0.0))
        pgm_function25.set_cpd((1,), (0.999, 0.000998, 1e-06, 1e-06))
        pgm_function25.set_cpd((2,), (0.9, 0.05, 0.03, 0.02))
        pgm_function25.set_cpd((3,), (0.8, 0.1, 0.06, 0.04))
        pgm_factor26 = self.new_factor(DrivHist, DrivingSkill, RiskAversion)
        pgm_function26 = pgm_factor26.set_cpt()
        pgm_function26.set_cpd((0, 0), (0.001, 0.004, 0.995))
        pgm_function26.set_cpd((1, 0), (0.1, 0.3, 0.6))
        pgm_function26.set_cpd((2, 0), (0.3, 0.3, 0.4))
        pgm_function26.set_cpd((0, 1), (0.002, 0.008, 0.99))
        pgm_function26.set_cpd((1, 1), (0.5, 0.3, 0.2))
        pgm_function26.set_cpd((2, 1), (0.6, 0.3, 0.1))
        pgm_function26.set_cpd((0, 2), (0.03, 0.15, 0.82))
        pgm_function26.set_cpd((1, 2), (0.9, 0.07, 0.03))
        pgm_function26.set_cpd((2, 2), (0.99, 0.009999, 1e-06))
        pgm_function26.set_cpd((0, 3), (0.3, 0.3, 0.4))
        pgm_function26.set_cpd((1, 3), (0.95, 0.04, 0.01))
        pgm_function26.set_cpd((2, 3), (0.999998, 1e-06, 1e-06))
