# Copyright (c) 2023, NVIDIA CORPORATION.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from nvflare.apis.fl_component import FLComponent
from nvflare.apis.fl_context import FLContext
from nvflare.app_common.ccwf import SwarmClientController
from nvflare.app_common.ccwf.common import Constant


class CWEResultPrinter(FLComponent):
    def handle_event(self, event_type: str, fl_ctx: FLContext):
        if event_type == Constant.EXECUTOR_FINALIZED:
            e = fl_ctx.get_prop(Constant.EXECUTOR)
            if not isinstance(e, SwarmClientController):
                return

            if e.best_result:
                self.log_info(fl_ctx, f"My Best Round: {e.best_round}")
                self.log_info(fl_ctx, f"My Best Metric: {e.best_metric}")
                self.log_info(fl_ctx, f"My Best Result: {e.best_result}")
            else:
                self.log_info(fl_ctx, "I have no best result")
