# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/ml.experiment.ipynb.

# %% auto 0
__all__ = ['make_experiment_dir', 'prepare_config', 'make_run_experiment_sweep', 'main']

# %% ../../nbs/ml.experiment.ipynb 3
from pathlib import Path
import wandb
import json
from ..utils import NestedDict, flatten_dict

# %% ../../nbs/ml.experiment.ipynb 4
def make_experiment_dir(root=".experiments", name=None):
    if name is None:
        from bellek.utils import generate_time_id
        name = generate_time_id()
    experiment_dir = Path(root) / name
    experiment_dir.mkdir(parents=True, exist_ok=True)
    return experiment_dir

# %% ../../nbs/ml.experiment.ipynb 5
def prepare_config(config, resolve_paths=True, exclude_resolving_paths=None):
    if "device" not in config:
        import torch
        config["device"] = torch.device("cuda" if torch.cuda.is_available() else "cpu")

    if resolve_paths:
        exclude_resolving_paths = exclude_resolving_paths or []
        for k, v in config.flat().items():
            if isinstance(k, str) and k.endswith("path") and k not in exclude_resolving_paths:
                config.set(k, str(Path(v).resolve()))
    return config

# %% ../../nbs/ml.experiment.ipynb 6
def make_run_experiment_sweep(run_experiment, config_defaults):
    def func():
        wandb_params = config_defaults["wandb"]
        with wandb.init(config=flatten_dict(config_defaults), **wandb_params) as wandb_run:
            run_experiment(wandb_run)
    return func

def main(run_experiment, args, prepare_config_kwargs=None):
    with open(args.cfg) as f:
        config = prepare_config(NestedDict(json.load(f)), **(prepare_config_kwargs or {}))

    is_sweep = hasattr(args, "sweep_cfg") and args.sweep_cfg
    if is_sweep:
        with open(args.sweep_cfg) as f:
            sweep_config = json.load(f)
    else:
        sweep_config = {}

    run_experiment_sweep = make_run_experiment_sweep(run_experiment, config)
    wandb_params = config["wandb"]
    if is_sweep:
        count = sweep_config.pop("count") if "count" in sweep_config else None
        sweep_id = wandb.sweep(
            sweep_config,
            entity=wandb_params["entity"],
            project=wandb_params["project"],
        )
        wandb.agent(sweep_id, run_experiment_sweep, count=count)
    else:
        run_experiment_sweep()

