# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals
from vtool import keypoint as ktool
import vtool.util_math as mtool
import numpy as np
import utool as ut
from vtool.util_math import TAU


DEFAULT_DTYPE = ktool.KPTS_DTYPE


def testdata_dummy_sift(nPts=10, asint=True, rng=None):
    r"""
    Makes a demodata sift descriptor that has the uint8 * 512 hack
    like hesaff returns

    Args:
        nPts (int): (default = 10)

    CommandLine:
        python -m vtool.demodata --test-testdata_dummy_sift

    Example:
        >>> # ENABLE_DOCTEST
        >>> from vtool.demodata import *  # NOQA
        >>> import vtool as vt
        >>> nPts = 10
        >>> rng = np.random.RandomState(0)
        >>> sift = testdata_dummy_sift(nPts, rng)
        >>> assert vt.check_sift_validity(sift), 'bad SIFT properties'
        >>> #assert np.allclose(((sift / 512) ** 2).sum(axis=1), 1, rtol=.01), 'bad SIFT property'
        >>> #assert np.all(sift / 512 < .2), 'bad SIFT property'
    """
    if rng is None:
        rng = np.random
    import vtool as vt

    sift_ = rng.rand(nPts, 128)
    # normalize
    sift_ = vt.normalize_rows(rng.rand(nPts, 128))
    # clip bin values
    sift_[sift_ > 0.2] = 0.2
    # renormalize
    sift_ = vt.normalize_rows(rng.rand(nPts, 128))
    # compress into uint8
    # sift = (sift_ * 512).round().astype(np.uint8)
    if asint:
        sift = (sift_ * 512).astype(np.uint8)
    else:
        sift = sift_
    return sift


def testdata_nonmonotonic():
    arr = np.array(
        [
            0.44603,
            0.44698,
            0.44792,
            0.44886,
            0.44979,
            0.45072,
            0.45164,
            0.45256,
            0.45347,
            0.45438,
            0.45528,
            0.45618,
            0.45707,
            0.45796,
            0.45885,
            0.45972,
            0.4606,
            0.46147,
            0.46233,
            0.46319,
            0.46404,
            0.46489,
            0.46573,
            0.46657,
            0.4674,
            0.46823,
            0.46906,
            0.46987,
            0.47069,
            0.47149,
            0.4723,
            0.47309,
            0.47388,
            0.47467,
            0.47545,
            0.47623,
            0.477,
            0.47776,
            0.47852,
            0.47928,
            0.48003,
            0.48077,
            0.48151,
            0.48224,
            0.48297,
            0.48369,
            0.48441,
            0.48512,
            0.48583,
            0.48653,
            0.48723,
            0.48792,
            0.4886,
            0.48928,
            0.48995,
            0.49062,
            0.49128,
            0.49194,
            0.49259,
            0.49324,
            0.49388,
            0.49452,
            0.49515,
            0.49577,
            0.49639,
            0.497,
            0.49761,
            0.49821,
            0.49881,
            0.4994,
            0.49999,
            0.50057,
            0.50114,
            0.50171,
            0.50227,
            0.50283,
            0.50338,
            0.50393,
            0.50447,
            0.505,
            0.50553,
            0.50606,
            0.50658,
            0.50709,
            0.5076,
            0.5081,
            0.50859,
            0.50908,
            0.50957,
            0.51005,
            0.51052,
            0.51099,
            0.51145,
            0.51191,
            0.51236,
            0.5128,
            0.51324,
            0.51368,
            0.51411,
            0.51453,
            0.51495,
            0.51536,
            0.51576,
            0.51616,
            0.51656,
            0.51695,
            0.51733,
            0.51771,
            0.51808,
            0.51845,
            0.51881,
            0.51916,
            0.51951,
            0.51985,
            0.52019,
            0.52053,
            0.52085,
            0.52117,
            0.52149,
            0.5218,
            0.5221,
            0.5224,
            0.52269,
            0.52298,
            0.52326,
            0.52354,
            0.52381,
            0.52408,
            0.52433,
            0.52459,
            0.52484,
            0.52508,
            0.52531,
            0.52555,
            0.52577,
            0.52599,
            0.52621,
            0.52641,
            0.52662,
            0.52681,
            0.52701,
            0.52719,
            0.52737,
            0.52755,
            0.52772,
            0.52788,
            0.52804,
            0.52819,
            0.52834,
            0.52848,
            0.52862,
            0.52875,
            0.52887,
            0.52899,
            0.5291,
            0.52921,
            0.52931,
            0.52941,
            0.5295,
            0.52959,
            0.52967,
            0.52974,
            0.52981,
            0.52988,
            0.52994,
            0.52999,
            0.53003,
            0.53008,
            0.53011,
            0.53014,
            0.53017,
            0.53019,
            0.5302,
            0.53021,
            0.53021,
            0.53021,
            0.5302,
            0.53019,
            0.53017,
            0.53015,
            0.53012,
            0.53008,
            0.53004,
            0.52999,
            0.52994,
            0.52988,
            0.52982,
            0.52975,
            0.52968,
            0.5296,
            0.52952,
            0.52943,
            0.52933,
            0.52923,
            0.52912,
            0.52901,
            0.52889,
            0.52877,
            0.52864,
            0.52851,
            0.52837,
            0.52823,
            0.52808,
            0.52792,
            0.52776,
            0.5276,
            0.52743,
            0.52725,
            0.52707,
            0.52688,
            0.52669,
            0.52649,
            0.52629,
            0.52608,
            0.52587,
            0.52565,
            0.52543,
            0.5252,
            0.52496,
            0.52472,
            0.52448,
            0.52423,
            0.52397,
            0.52371,
            0.52344,
            0.52317,
            0.52289,
            0.52261,
            0.52232,
            0.52203,
            0.52173,
            0.52143,
            0.52112,
            0.52081,
            0.52049,
            0.52017,
            0.51984,
            0.5195,
            0.51916,
            0.51882,
            0.51847,
            0.51811,
            0.51775,
            0.51739,
            0.51702,
            0.51664,
            0.51626,
            0.51588,
            0.51548,
            0.51509,
            0.51469,
            0.51428,
            0.51387,
            0.51345,
            0.51303,
            0.51261,
            0.51217,
            0.51174,
            0.5113,
            0.51085,
            0.5104,
            0.50994,
            0.50948,
            0.50901,
            0.50854,
            0.50807,
            0.50759,
            0.5071,
            0.50661,
            0.50611,
            0.50561,
            0.50511,
            0.5046,
            0.50408,
            0.50356,
            0.50303,
            0.5025,
            0.50197,
            0.50143,
            0.50088,
            0.50034,
            0.49978,
            0.49922,
            0.49866,
            0.49809,
            0.49752,
            0.49694,
            0.49636,
            0.49577,
            0.49518,
            0.49458,
            0.49398,
            0.49337,
            0.49276,
            0.49215,
            0.49153,
            0.4909,
            0.49027,
            0.48964,
            0.489,
            0.48836,
            0.48771,
            0.48706,
            0.48641,
            0.48574,
            0.48508,
            0.48441,
            0.48374,
            0.48306,
            0.48238,
            0.48169,
            0.481,
            0.4803,
            0.4796,
            0.4789,
            0.47819,
            0.47748,
            0.47676,
            0.47604,
            0.47531,
            0.47458,
            0.47385,
            0.47311,
            0.47237,
            0.47162,
            0.47087,
            0.47012,
            0.46936,
            0.4686,
            0.46783,
            0.46706,
            0.46629,
            0.46551,
            0.46473,
            0.46394,
            0.46315,
            0.46236,
            0.46156,
            0.46076,
            0.45996,
            0.45915,
            0.45833,
            0.45752,
            0.4567,
            0.45588,
            0.45505,
            0.45422,
            0.45338,
            0.45255,
            0.45171,
            0.45086,
            0.45001,
            0.44916,
            0.44831,
            0.44745,
            0.44659,
            0.44572,
            0.44486,
            0.44399,
            0.44311,
            0.44223,
            0.44135,
            0.44047,
            0.43958,
            0.43869,
            0.4378,
            0.43691,
            0.43601,
            0.43511,
            0.4342,
            0.4333,
            0.43239,
            0.43147,
            0.43056,
            0.42964,
            0.42872,
            0.4278,
            0.42687,
            0.42594,
            0.42501,
            0.42408,
            0.42315,
            0.42221,
            0.42127,
            0.42033,
            0.41938,
            0.41844,
            0.41749,
            0.41654,
            0.41559,
            0.41463,
            0.41368,
            0.41272,
            0.41176,
            0.4108,
            0.40984,
            0.40887,
            0.40791,
            0.40694,
            0.40597,
            0.405,
            0.40403,
            0.40306,
            0.40208,
            0.40111,
            0.40013,
            0.39915,
            0.39817,
            0.3972,
            0.39622,
            0.39524,
            0.39425,
            0.39327,
            0.39229,
            0.39131,
            0.39032,
            0.38934,
            0.38836,
            0.38737,
            0.38639,
            0.3854,
            0.38442,
            0.38344,
            0.38245,
            0.38147,
            0.38049,
            0.37951,
            0.37853,
            0.37755,
            0.37657,
            0.37559,
            0.37461,
            0.37363,
            0.37266,
            0.37168,
            0.37071,
            0.36974,
            0.36877,
            0.36781,
            0.36684,
            0.36588,
            0.36492,
            0.36396,
            0.363,
            0.36205,
            0.3611,
            0.36015,
            0.3592,
            0.35826,
            0.35732,
            0.35639,
            0.35546,
            0.35453,
            0.35361,
            0.35269,
            0.35177,
            0.35086,
            0.34995,
            0.34905,
            0.34816,
            0.34726,
            0.34638,
            0.3455,
            0.34462,
            0.34375,
            0.34289,
            0.34203,
            0.34118,
            0.34034,
            0.3395,
            0.33867,
            0.33785,
            0.33703,
            0.33623,
            0.33543,
            0.33464,
            0.33385,
            0.33308,
            0.33231,
            0.33156,
            0.33081,
            0.33008,
            0.32935,
            0.32863,
            0.32793,
            0.32723,
            0.32655,
            0.32587,
            0.32521,
            0.32456,
            0.32392,
            0.3233,
            0.32268,
            0.32208,
            0.3215,
            0.32092,
            0.32036,
            0.31982,
            0.31928,
            0.31877,
            0.31826,
            0.31777,
            0.3173,
            0.31684,
            0.3164,
            0.31598,
            0.31557,
            0.31517,
            0.3148,
            0.31444,
            0.31409,
            0.31377,
            0.31346,
            0.31317,
            0.3129,
            0.31264,
            0.31241,
            0.31219,
            0.31199,
            0.31181,
            0.31165,
            0.3115,
            0.31138,
            0.31127,
            0.31118,
            0.31112,
            0.31107,
            0.31104,
            0.31103,
            0.31104,
            0.31106,
            0.31111,
            0.31117,
            0.31125,
            0.31135,
            0.31147,
            0.31161,
            0.31176,
            0.31193,
            0.31212,
            0.31232,
            0.31254,
            0.31277,
            0.31302,
            0.31329,
            0.31357,
            0.31386,
            0.31417,
            0.31448,
            0.31481,
            0.31515,
            0.31551,
            0.31587,
            0.31624,
            0.31662,
            0.317,
            0.3174,
            0.31779,
            0.3182,
            0.3186,
            0.31901,
            0.31943,
            0.31984,
            0.32025,
            0.32066,
            0.32107,
            0.32148,
            0.32188,
            0.32228,
            0.32267,
            0.32305,
            0.32343,
            0.32379,
            0.32415,
            0.32449,
            0.32482,
            0.32514,
            0.32544,
            0.32572,
            0.32599,
            0.32624,
            0.32647,
            0.32668,
            0.32686,
            0.32703,
            0.32717,
            0.32729,
            0.32738,
            0.32745,
            0.32749,
            0.3275,
            0.32748,
            0.32743,
            0.32736,
            0.32725,
            0.32711,
            0.32694,
            0.32674,
            0.3265,
            0.32623,
            0.32593,
            0.32559,
            0.32521,
            0.3248,
            0.32436,
            0.32388,
            0.32336,
            0.32281,
            0.32222,
            0.32159,
            0.32093,
            0.32023,
            0.31949,
            0.31872,
            0.31791,
            0.31706,
            0.31618,
            0.31526,
            0.3143,
            0.31331,
            0.31229,
            0.31123,
            0.31013,
            0.309,
            0.30784,
            0.30664,
            0.30541,
            0.30415,
            0.30285,
            0.30153,
            0.30017,
            0.29878,
            0.29736,
            0.29591,
            0.29444,
            0.29293,
            0.2914,
            0.28984,
            0.28825,
            0.28664,
            0.285,
            0.28334,
            0.28165,
            0.27994,
            0.27821,
            0.27646,
            0.27468,
            0.27289,
            0.27107,
            0.26924,
            0.26739,
            0.26552,
            0.26363,
            0.26172,
            0.25981,
            0.25787,
            0.25592,
            0.25396,
            0.25198,
            0.25,
            0.248,
            0.24599,
            0.24397,
            0.24194,
            0.2399,
            0.23785,
            0.2358,
            0.23373,
            0.23167,
            0.22959,
            0.22751,
            0.22543,
            0.22334,
            0.22124,
            0.21915,
            0.21705,
            0.21495,
            0.21285,
            0.21075,
            0.20865,
            0.20654,
            0.20444,
            0.20234,
            0.20024,
            0.19815,
            0.19605,
            0.19396,
            0.19188,
            0.18979,
            0.18771,
            0.18564,
            0.18357,
            0.18151,
            0.17945,
            0.1774,
            0.17536,
            0.17332,
            0.17129,
            0.16927,
            0.16725,
            0.16525,
            0.16325,
            0.16126,
            0.15928,
            0.15732,
            0.15536,
            0.15341,
            0.15147,
            0.14954,
            0.14763,
            0.14572,
            0.14383,
            0.14194,
            0.14007,
            0.13821,
            0.13637,
            0.13453,
            0.13271,
            0.1309,
            0.12911,
            0.12732,
            0.12555,
            0.12379,
            0.12205,
            0.12032,
            0.1186,
            0.1169,
            0.11521,
            0.11354,
            0.11188,
            0.11023,
            0.1086,
            0.10698,
            0.10537,
            0.10378,
            0.10221,
            0.10065,
            0.0991,
            0.09757,
            0.09605,
            0.09454,
            0.09305,
            0.09158,
            0.09012,
            0.08867,
            0.08724,
            0.08583,
            0.08442,
            0.08304,
            0.08166,
            0.0803,
            0.07896,
            0.07763,
            0.07631,
            0.07501,
            0.07372,
            0.07245,
            0.07119,
            0.06995,
            0.06872,
            0.0675,
            0.06629,
            0.06511,
            0.06393,
            0.06277,
            0.06162,
            0.06048,
            0.05936,
            0.05825,
            0.05716,
            0.05608,
            0.05501,
            0.05395,
            0.05291,
            0.05188,
            0.05086,
            0.04985,
            0.04886,
            0.04788,
            0.04692,
            0.04596,
            0.04502,
            0.04409,
            0.04317,
            0.04226,
            0.04137,
            0.04049,
            0.03962,
            0.03876,
            0.03791,
            0.03707,
            0.03625,
            0.03544,
            0.03463,
            0.03384,
            0.03306,
            0.0323,
            0.03154,
            0.03079,
            0.03006,
            0.02933,
            0.02862,
            0.02791,
            0.02722,
            0.02654,
            0.02587,
            0.02521,
            0.02456,
            0.02392,
            0.02329,
            0.02267,
            0.02206,
            0.02146,
            0.02087,
            0.0203,
            0.01973,
            0.01917,
            0.01862,
            0.01808,
            0.01755,
            0.01704,
            0.01653,
            0.01603,
            0.01554,
            0.01506,
            0.01459,
            0.01413,
            0.01368,
            0.01324,
            0.01281,
            0.01239,
            0.01198,
            0.01158,
            0.01119,
            0.0108,
            0.01043,
            0.01006,
            0.00971,
            0.00936,
            0.00902,
            0.00869,
            0.00837,
            0.00806,
            0.00776,
            0.00746,
            0.00718,
            0.0069,
            0.00663,
            0.00637,
            0.00612,
            0.00587,
            0.00563,
            0.0054,
            0.00518,
            0.00496,
            0.00475,
            0.00455,
            0.00436,
            0.00417,
            0.00399,
            0.00381,
            0.00365,
            0.00348,
            0.00333,
            0.00318,
            0.00303,
            0.00289,
            0.00276,
            0.00263,
            0.00251,
            0.00239,
            0.00228,
            0.00217,
            0.00207,
            0.00197,
            0.00187,
            0.00178,
            0.00169,
            0.00161,
            0.00153,
            0.00145,
            0.00138,
            0.00131,
            0.00124,
            0.00118,
            0.00112,
            0.00106,
            0.00101,
            0.00096,
            0.00091,
            0.00086,
            0.00081,
            0.00077,
            0.00073,
            0.00069,
            0.00066,
            0.00062,
            0.00059,
            0.00056,
            0.00053,
            0.0005,
            0.00047,
            0.00044,
            0.00042,
            0.0004,
            0.00038,
            0.00036,
            0.00034,
            0.00032,
            0.0003,
            0.00028,
            0.00027,
            0.00025,
            0.00024,
            0.00022,
            0.00021,
            0.0002,
            0.00019,
            0.00018,
            0.00017,
            0.00016,
            0.00015,
            0.00014,
            0.00013,
            0.00013,
            0.00012,
            0.00011,
            0.00011,
            0.0001,
            0.00009,
            0.00009,
            0.00008,
            0.00008,
            0.00007,
            0.00007,
            0.00007,
            0.00006,
            0.00006,
            0.00005,
            0.00005,
            0.00005,
            0.00005,
            0.00004,
            0.00004,
            0.00004,
            0.00004,
            0.00003,
            0.00003,
            0.00003,
            0.00003,
            0.00003,
            0.00002,
            0.00002,
            0.00002,
            0.00002,
            0.00002,
            0.00002,
            0.00002,
            0.00002,
            0.00002,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.00001,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
            0.0,
        ],
        dtype=np.float64,
    )
    return arr


def testdata_binary_scores():
    X = np.array(
        [
            -0.05,
            -0.8,
            -1.72,
            -1.28,
            -0.24,
            -1.55,
            22.29,
            -0.34,
            10.51,
            -0.66,
            -0.43,
            22.43,
            -1.54,
            18.6,
            -1.35,
            -1.12,
            -0.08,
            12.99,
            7.53,
            -1.62,
            -1.85,
            -0.68,
            -1.44,
            -1.88,
            8.46,
            -0.89,
            -1.82,
            10.18,
            5.68,
            -1.32,
            -1.54,
            -1.95,
            -2.24,
            7.28,
            5.14,
            -0.21,
            -0.65,
            26.9,
            -0.71,
            6.81,
            7.25,
            -0.43,
            -1.65,
            -2.08,
            8.15,
            -1.12,
            -1.43,
            4.51,
            2.1,
            -1.14,
            -2.48,
            -0.82,
            -1.47,
            10.5,
            4.22,
            -0.0,
            -1.12,
            -1.42,
            1.61,
            -1.02,
            -1.73,
            -2.75,
            22.91,
            -1.49,
            12.39,
            9.82,
            -1.45,
            -0.34,
            20.81,
            14.11,
            -0.21,
            16.02,
            13.47,
            -1.6,
            -1.58,
            11.94,
            9.64,
            4.08,
            13.17,
            18.73,
            -1.19,
            21.58,
            11.53,
            0.73,
            -1.21,
            2.04,
            7.18,
            4.09,
            3.43,
            16.15,
            3.75,
            7.15,
            -1.83,
            14.03,
            -1.55,
            14.13,
            -1.12,
            -0.29,
            -0.29,
            -1.21,
            -1.1,
            6.65,
            -1.48,
            -1.31,
            -1.54,
            12.46,
            5.83,
            -0.66,
            0.23,
            -1.97,
            12.18,
            10.21,
            -0.08,
            -1.2,
            8.09,
            6.77,
            -1.64,
            15.94,
            -0.17,
            -0.21,
            17.19,
            10.85,
            -1.08,
            -0.07,
            0.1,
            13.06,
            -1.42,
            -1.71,
            2.79,
            25.17,
            2.82,
            -0.45,
            -1.05,
            -0.94,
            -1.85,
            -0.74,
            -1.54,
            14.33,
            -0.27,
            -1.01,
            -0.7,
            -1.6,
            14.79,
            6.4,
            -1.1,
            -0.54,
            5.37,
            -1.81,
            9.75,
            -1.57,
            16.28,
            -1.33,
            10.01,
            -0.51,
            18.75,
            1.3,
            -1.79,
            -1.37,
            16.25,
            -0.66,
            -1.37,
            14.75,
            -1.33,
            20.88,
            -1.6,
            -0.85,
            1.6,
            -1.59,
            -1.38,
            16.58,
            1.78,
            23.05,
            -1.25,
            7.52,
            8.59,
            13.74,
            -1.59,
            20.26,
            -1.54,
            3.15,
            -0.99,
            -0.55,
            9.02,
            -1.15,
            -1.41,
            19.43,
            3.06,
            -2.26,
            13.19,
            10.67,
            5.86,
            -0.48,
            -0.81,
            9.91,
            -1.59,
            -0.04,
            -0.2,
            -0.13,
            10.95,
            -1.81,
            -1.29,
            2.02,
            -1.29,
            16.67,
            -1.38,
            12.08,
            -1.99,
            8.62,
            13.3,
            9.94,
            8.75,
            -1.57,
            -0.95,
            7.6,
            2.43,
            21.23,
            15.17,
            9.86,
            11.96,
            7.91,
            -1.44,
            -1.5,
            11.75,
            -0.57,
            9.31,
            10.11,
            -1.58,
            -1.29,
            -1.25,
            -1.57,
            4.35,
            -1.88,
            -1.15,
            -0.88,
            2.27,
            -1.54,
            24.19,
            21.29,
            -1.46,
            -0.78,
            -1.54,
            3.92,
            6.89,
            -1.31,
            -1.49,
            -1.3,
            -1.64,
            1.19,
            0.78,
            4.9,
            -1.49,
            4.8,
            -1.5,
            7.75,
            -1.87,
            -1.32,
            -2.06,
            9.28,
            -1.26,
            5.83,
            -0.06,
            1.47,
            9.27,
            6.61,
            -2.19,
            13.11,
            -0.97,
            8.61,
            -1.76,
            9.85,
            -0.01,
            13.7,
            5.59,
            -0.76,
            5.78,
            8.95,
            -0.19,
            -1.49,
            0.51,
            4.7,
            -1.8,
            -1.44,
            -2.02,
            -1.14,
            11.98,
            -0.06,
            -1.79,
            10.33,
            7.1,
            -0.38,
            4.95,
            8.82,
            3.3,
            5.91,
            31.71,
            -1.93,
            14.18,
            -0.26,
            -0.75,
            14.48,
            -2.09,
            7.44,
            8.61,
            -1.67,
            -0.68,
            6.87,
            -0.4,
            16.32,
            -1.82,
            -0.45,
            13.61,
            -1.34,
            -1.44,
            20.39,
            13.64,
            9.43,
            -1.77,
            -1.0,
            -1.08,
            -1.94,
            -1.04,
            -0.4,
            4.91,
            -1.85,
            -1.21,
            -1.14,
            6.23,
            -1.53,
            -1.06,
            -0.81,
            -1.42,
            -2.02,
            -1.47,
            3.71,
            -1.53,
            -1.46,
            8.76,
            -1.43,
            12.19,
            4.77,
            -1.26,
            -1.57,
            -1.46,
            9.62,
            -1.95,
            -0.61,
            3.2,
            -1.46,
            -1.49,
            19.8,
            -0.72,
            17.92,
            -1.26,
            13.12,
            -1.76,
            22.34,
            -1.6,
            12.59,
            -0.51,
            -0.43,
            1.08,
            -1.25,
            -1.33,
            -1.0,
            -1.29,
            12.96,
            19.53,
            -1.2,
            6.56,
            -1.22,
            -0.68,
            10.08,
            -0.25,
            -1.29,
            8.49,
            -0.05,
            -1.84,
            -1.63,
            -1.8,
            13.08,
            2.83,
            -1.0,
            -0.43,
            -1.55,
            1.88,
            10.32,
            -2.19,
            6.64,
            12.42,
            -1.21,
            -1.57,
            -0.94,
            -0.47,
            -1.48,
            -1.5,
            12.36,
            -1.22,
            18.49,
            -0.89,
            -1.28,
            -1.4,
            16.91,
            -0.82,
            -0.1,
            -2.05,
            12.52,
            -0.98,
            18.3,
            12.99,
            12.65,
            -1.25,
            -1.87,
            23.33,
            -1.64,
            -1.44,
            5.22,
            -1.03,
            -1.42,
            -1.63,
            18.49,
            -0.78,
            7.55,
            8.72,
            0.46,
            -1.61,
            -1.28,
            10.0,
            -0.56,
            0.52,
            -0.25,
            7.96,
            1.43,
            -0.03,
            -1.46,
            0.94,
            10.45,
            15.75,
            -0.76,
            0.4,
            -1.85,
            -1.19,
            14.8,
            12.65,
            18.73,
            12.46,
            13.44,
            -1.24,
            -0.68,
            -0.83,
            8.15,
            -1.69,
            -1.5,
            -0.17,
            -1.33,
            13.43,
            -1.7,
            4.72,
            -1.52,
            12.0,
            14.53,
            -1.6,
            -1.83,
            16.14,
            -2.14,
            -0.95,
            4.56,
            5.76,
            5.09,
            1.7,
            -0.56,
            -0.0,
            -1.04,
            -2.07,
            16.05,
            9.52,
            -1.89,
            10.01,
            31.42,
            -1.42,
            16.92,
            -1.45,
            -1.85,
            11.47,
            -1.58,
            19.57,
            -1.83,
            -1.75,
            -1.6,
            -1.4,
            -0.97,
            -0.88,
            -1.74,
            -2.09,
            -1.45,
            -1.35,
            13.14,
            15.19,
            17.91,
            -1.37,
            6.27,
            -1.85,
            -1.62,
            4.28,
            -0.26,
            20.05,
            -0.78,
            6.25,
            12.72,
            16.04,
            -1.26,
            0.65,
            7.44,
            7.14,
            -1.52,
            4.19,
            -1.95,
            -0.31,
            9.58,
            -1.48,
            -1.4,
            -1.79,
            -1.49,
            -2.08,
            22.43,
            9.33,
            32.83,
            -1.89,
            -2.15,
            -1.77,
            14.75,
            -1.1,
            -1.44,
            -0.78,
            -0.77,
            8.04,
            -0.69,
            2.9,
            19.8,
            -1.37,
            7.33,
            -1.48,
            1.03,
            -1.04,
            11.85,
            -1.35,
            -0.07,
            6.12,
            14.99,
            7.54,
            24.72,
            -1.38,
            -1.32,
            -2.01,
            -1.36,
            -1.64,
            4.92,
            -1.56,
            15.51,
            -0.67,
            -2.2,
            3.09,
            4.27,
            -2.87,
            -0.85,
            -1.69,
            5.54,
            -1.77,
            -0.94,
            -0.13,
            -1.85,
            7.27,
            1.91,
            9.77,
            -1.02,
            -0.59,
            2.12,
            -1.22,
            19.0,
            -0.81,
            23.12,
            5.38,
            -0.62,
            -1.47,
            0.29,
            -0.11,
            9.07,
            10.69,
            16.34,
            8.59,
            -0.73,
            11.16,
            9.11,
            2.13,
            5.94,
            -1.96,
            -0.52,
            9.3,
            -0.83,
            -1.09,
            -0.51,
            -1.34,
            -0.87,
            -0.83,
            -1.11,
            0.16,
            8.94,
            -1.49,
            -0.44,
            5.06,
            -1.5,
            21.96,
            26.02,
            -1.39,
            9.87,
            14.9,
            -0.01,
            16.82,
            5.04,
            -0.07,
            -0.92,
            9.7,
            6.32,
            8.51,
            7.53,
            -2.1,
            3.06,
            -1.3,
            -1.46,
            -0.85,
            2.3,
            -1.7,
            -1.26,
            -1.45,
            -1.35,
            -0.51,
            18.27,
            16.3,
            10.82,
            -1.76,
            6.93,
            16.41,
            -1.03,
            13.83,
            -0.82,
            9.71,
            -0.87,
            -1.59,
            16.79,
            8.82,
            -1.5,
            -0.02,
            4.78,
            22.62,
            18.9,
            12.45,
            -0.18,
            -1.13,
            -1.45,
            -1.3,
            -0.18,
            -0.55,
            14.27,
            2.1,
            18.28,
            -1.33,
            14.01,
            -1.06,
            6.18,
            2.17,
            -1.27,
            -1.51,
            -1.3,
            -0.22,
            -1.3,
            -3.5,
            -1.53,
            -1.06,
            -1.01,
            -1.26,
            24.23,
            -1.01,
            -0.03,
            20.2,
            9.42,
            -1.49,
            -1.04,
            -1.27,
            -1.43,
            7.83,
            -1.28,
            9.11,
            -1.03,
            -1.31,
            -1.56,
            7.01,
            -1.39,
            16.0,
            -1.34,
            10.16,
            -1.48,
            -1.79,
            -0.25,
            29.59,
            11.54,
            -1.37,
            -1.13,
            11.38,
            0.28,
            -0.0,
            -1.39,
            13.71,
            2.04,
            -0.0,
            12.9,
            5.83,
            7.79,
            -1.73,
            3.3,
            -1.96,
            15.6,
            6.54,
            -0.88,
            -1.08,
            -1.0,
            -1.56,
            -1.71,
            -0.47,
            -1.3,
            8.45,
            6.28,
            -0.23,
            -1.6,
            -1.68,
            9.14,
            -1.26,
            -0.33,
            -0.51,
            -1.15,
            0.48,
            -1.52,
            -1.29,
            4.58,
            -0.32,
            9.38,
            17.05,
            -0.85,
            -1.48,
            11.63,
            -0.77,
            -1.21,
            10.93,
            1.94,
            6.21,
            -1.46,
            6.18,
            -1.34,
            -1.73,
            -1.47,
            2.76,
            1.75,
            -1.39,
            18.73,
            14.11,
            -1.55,
            8.99,
            -1.33,
            17.84,
            21.61,
            5.61,
            2.7,
            -1.69,
            -0.47,
            -1.29,
            -1.39,
            -1.7,
            17.97,
            15.13,
            -1.24,
            -1.86,
            9.04,
            -1.3,
            -1.74,
            10.11,
            9.74,
            17.0,
            -0.87,
            -1.47,
            5.13,
            -2.11,
            -1.44,
            25.61,
            4.89,
            23.65,
            -2.02,
            19.82,
            -0.67,
            -1.62,
            -1.61,
            -1.5,
            -1.24,
            7.42,
            0.28,
            10.28,
            -0.25,
            9.58,
            -1.46,
            14.88,
            6.77,
            10.46,
            -0.97,
            3.78,
            -2.16,
            -1.36,
            -1.09,
            -0.91,
            10.72,
            7.52,
            -0.42,
            -1.47,
            -0.37,
            -0.24,
            -0.9,
            4.37,
            -1.54,
            -1.73,
            -1.4,
            -1.39,
            -1.22,
            -0.89,
            5.41,
            3.3,
            -1.82,
            -2.14,
            2.87,
            -1.15,
            2.14,
            22.91,
            -0.67,
            14.13,
            6.13,
            -1.3,
            -1.95,
            22.75,
            -1.86,
            2.68,
            4.08,
            3.98,
            -1.54,
            -1.33,
            1.09,
            6.43,
            -1.39,
            13.9,
            -1.07,
            -1.21,
            -1.23,
            10.21,
            17.93,
            10.32,
            7.55,
            -1.19,
            -1.25,
            -1.13,
            -0.32,
            -0.27,
            11.17,
            -1.05,
            18.13,
            6.5,
            -1.2,
            11.85,
            3.1,
            9.53,
            -0.82,
            -1.15,
            -1.69,
            -1.8,
            -0.39,
            17.06,
            10.68,
            -1.58,
            16.91,
            -1.71,
            -1.53,
            -2.23,
            13.12,
            16.15,
            6.93,
            -1.39,
            -1.43,
            -1.71,
            -1.91,
            -0.89,
            12.52,
            -1.21,
            -1.12,
            13.82,
            -0.29,
            -1.63,
            -1.27,
            -0.03,
            -0.7,
            -1.27,
            19.99,
            -1.58,
            14.51,
            11.71,
            3.5,
            -0.78,
            5.88,
            -1.03,
            -0.1,
            -1.13,
            -1.97,
            -1.08,
            -0.94,
            2.83,
            18.25,
            -0.6,
            9.86,
            -1.52,
            -0.46,
            -0.69,
            -1.54,
            -0.66,
            -1.1,
            -0.16,
            -1.61,
            -0.35,
            -0.01,
            12.36,
            -0.08,
            -0.84,
            -1.33,
            -1.8,
            6.03,
            11.75,
            -1.53,
            26.08,
            -0.5,
            -1.09,
            -1.59,
            -1.9,
            2.86,
            -1.68,
            -2.12,
            2.59,
            3.59,
            -1.94,
            10.42,
            -1.56,
            16.5,
            -1.97,
            5.32,
            5.76,
            10.35,
            3.36,
            -1.35,
            5.22,
            11.72,
            11.98,
            13.14,
            -0.63,
            -1.33,
            -1.45,
            18.79,
            2.83,
            -0.6,
            5.76,
            -0.79,
            13.99,
            9.82,
            30.6,
            -1.13,
            -2.05,
            21.3,
            -1.87,
            17.61,
            -1.25,
            8.64,
            -2.06,
            4.48,
            19.48,
            -0.64,
            15.85,
            4.54,
            -1.57,
            -1.28,
            12.3,
            -1.39,
            -0.04,
            12.81,
            -0.09,
            4.83,
            6.42,
            4.26,
            7.65,
            -0.43,
            -0.23,
            -1.98,
        ],
        dtype=np.float,
    )

    y = np.array(
        [
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            0,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            1,
            1,
            0,
            0,
            0,
            1,
            1,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            1,
            1,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            1,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            0,
            1,
            1,
            1,
            0,
            1,
            1,
            0,
            0,
            1,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
            0,
            0,
            1,
            0,
            1,
            0,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            1,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            1,
            1,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            1,
            1,
        ],
        dtype=np.bool,
    )
    return X, y


def dummy_seed(seed=None):
    if seed is not None:
        np.random.seed(seed)


def get_dummy_xy(seed=0):
    rng = np.random.RandomState(seed)
    xy = rng.rand(2, 100).astype(np.float64)
    return xy


def get_dummy_kpts_pair(wh_stride=(30, 30), wh_num=None):
    _kw0 = dict(wh_stride=wh_stride, dtype=np.float64, wh_num=wh_num)
    _kw1 = dict(seed=12, damping=1.2, **_kw0)
    _kw2 = dict(seed=24, damping=1.6, **_kw0)
    kpts1 = perterbed_grid_kpts(**_kw1)
    kpts2 = perterbed_grid_kpts(**_kw2)
    return kpts1, kpts2


def get_dummy_dpts(num, dtype=np.uint8):
    """
    Random SIFTish keypoints
    """
    from vtool import linalg as ltool

    dpts_ = np.random.rand(num, 128).astype(np.float64)
    dpts_norm = ltool.normalize_rows(dpts_)
    # do SIFT normalization
    dpts_norm[dpts_norm > 0.2] = 0.2
    dpts = (ltool.normalize_rows(dpts_norm) * 255).astype(np.uint8)
    return dpts


def get_dummy_kpts(num=1, dtype=DEFAULT_DTYPE):
    """
    Some testing data

    Args:
        num (int): number of times to duplicate
        dtype (type):

    Returns:
        ndarray[float32_t, ndim=2][ndims=2]: kpts -  keypoints

    CommandLine:
        xdoctest -m ~/code/vtool/vtool/demodata.py get_dummy_kpts

    Example:
        >>> # ENABLE_DOCTEST
        >>> from vtool.demodata import *  # NOQA
        >>> num = 1
        >>> dtype = ktool.KPTS_DTYPE
        >>> kpts = get_dummy_kpts(num, dtype)
        >>> import ubelt as ub
        >>> result = ub.repr2(kpts, precision=2, with_dtype=False)
        >>> print(result)  # xdoctest: +IGNORE_WANT
        np.array([[20.  , 25.  ,  5.22, -5.11, 24.15,  0.  ],
                  [29.  , 25.  ,  2.36, -5.11, 24.15,  0.  ],
                  [30.  , 30.  , 12.22, 12.02, 10.53,  0.  ],
                  [31.  , 29.  , 13.36, 17.63, 14.1 ,  0.  ],
                  [32.  , 31.  , 16.05,  3.41, 11.74,  0.  ]])
    """
    kpts = np.array(
        [
            [20, 25, 5.21657705, -5.11095951, 24.1498699, 0],
            [29, 25, 2.35508823, -5.11095952, 24.1498692, 0],
            [30, 30, 12.2165705, 12.01909553, 10.5286992, 0],
            [31, 29, 13.3555705, 17.63429554, 14.1040992, 0],
            [32, 31, 16.0527005, 3.407312351, 11.7353722, 0],
        ],
        dtype=dtype,
    )
    kpts = np.vstack([kpts] * num)
    return kpts


def dummy_img(w, h, intensity=200):
    """ Creates a demodata test image """
    img = np.zeros((int(h), int(w)), dtype=np.uint8) + intensity
    return img


def get_kpts_dummy_img(kpts, sf=1.0, intensity=200):
    r"""
    Args:
        kpts (ndarray[float32_t, ndim=2]):  keypoints
        sf (float):

    Returns:
        tuple: img

    Example:
        >>> # ENABLE_DOCTEST
        >>> from vtool.demodata import *  # NOQA
        >>> kpts = get_dummy_kpts()
        >>> sf = 1.0
        >>> img =  get_kpts_dummy_img(kpts, sf, 10)
    """
    (x1, x2, y1, y2) = ktool.get_kpts_image_extent(kpts)
    w = x2 - x1
    h = y2 - y1
    img_w = w * sf
    img_h = h * sf
    img = dummy_img(img_w, img_h, intensity=intensity)
    return img


def get_dummy_invV_mats(dtype=DEFAULT_DTYPE):
    invV_mats = np.array(
        (
            ((1.0, 0.0), (0.0, 1.0),),
            ((0.5, 0.0), (0.0, 2.0),),
            ((2.5, 0.0), (0.5, 2.0),),
            ((1.0, 0.0), (0.5, 1.0),),
        ),
        dtype=np.float32,
    )
    return invV_mats


def get_dummy_matching_kpts(dtype=DEFAULT_DTYPE):
    kpts1 = np.array(
        [
            [
                3.28846716e02,
                1.21753590e02,
                1.25637716e01,
                -1.18816503e01,
                1.00417606e01,
                1.14933074e-02,
            ],
            [
                3.01069363e02,
                1.31472857e02,
                1.29744163e01,
                -1.26813604e01,
                1.23529540e01,
                2.56660535e-01,
            ],
            [
                4.08240651e02,
                1.86241170e02,
                1.68589858e01,
                -1.33149406e01,
                1.42353870e01,
                1.20307208e-02,
            ],
            [
                3.88036559e02,
                3.76789856e02,
                1.47105962e01,
                -8.80294520e00,
                1.20673321e01,
                6.02803372e00,
            ],
            [
                2.91987002e02,
                1.56273941e02,
                1.59259660e01,
                -7.87242786e00,
                2.02183781e01,
                1.82204839e-01,
            ],
            [
                2.76012028e02,
                3.58504941e02,
                1.55394668e01,
                -1.52683674e00,
                2.38340761e01,
                6.25445998e00,
            ],
            [
                3.90943404e02,
                3.44728235e02,
                2.09021796e01,
                -1.29564521e01,
                5.58724982e00,
                6.08949162e00,
            ],
            [
                3.13005196e02,
                3.63265206e02,
                9.32637456e00,
                -1.18802434e01,
                2.15849429e01,
                9.10939207e-02,
            ],
            [
                3.49344296e02,
                4.47038587e02,
                1.92400430e01,
                -8.61497903e00,
                1.94933361e01,
                5.97432787e00,
            ],
            [
                4.12149038e02,
                3.85985588e02,
                3.25077165e01,
                -1.86535559e01,
                7.91420083e00,
                6.23798141e00,
            ],
            [
                3.76955263e02,
                3.62479481e02,
                2.50461522e01,
                -6.14592975e00,
                1.45263025e01,
                2.53605042e-01,
            ],
            [
                3.86279299e02,
                3.98880867e02,
                3.92990884e01,
                -1.95396603e01,
                1.51900915e01,
                2.34707827e-01,
            ],
            [
                2.72267165e02,
                3.39945945e02,
                1.80826449e01,
                5.12738475e00,
                5.43937103e01,
                6.00411182e-01,
            ],
        ],
        dtype=dtype,
    )
    ##
    kpts2 = np.array(
        [
            [
                3.09621904e02,
                1.01906467e02,
                1.01749649e01,
                -8.13185135e00,
                9.76679199e00,
                5.98161838e00,
            ],
            [
                2.95794687e02,
                1.32017193e02,
                1.31069994e01,
                -1.24562360e01,
                1.12054328e01,
                2.65517495e-01,
            ],
            [
                3.78841354e02,
                2.90189530e02,
                1.65034851e01,
                -8.23787708e00,
                1.04872841e01,
                5.52809448e-01,
            ],
            [
                3.54223322e02,
                3.56999688e02,
                1.56782369e01,
                -9.34924382e00,
                1.39873022e01,
                1.82464324e-01,
            ],
            [
                3.08208701e02,
                1.10979910e02,
                1.23573375e01,
                -1.32017287e01,
                1.81341743e01,
                6.18054641e00,
            ],
            [
                2.72120364e02,
                3.06051898e02,
                1.41604565e01,
                -6.41663265e-01,
                2.40546104e01,
                9.96961592e-02,
            ],
            [
                3.99782152e02,
                3.84726911e02,
                2.54674401e01,
                -1.13622177e01,
                1.52564237e01,
                2.82467605e-01,
            ],
            [
                2.73039551e02,
                4.09726917e02,
                7.87345363e00,
                -1.11725136e01,
                2.50426481e01,
                6.34441839e-01,
            ],
            [
                3.49597555e02,
                4.07510942e02,
                2.37571881e01,
                -7.80666851e00,
                1.35347776e01,
                5.83382941e00,
            ],
            [
                4.06788317e02,
                3.33934196e02,
                3.04510906e01,
                -1.78787314e01,
                1.28190063e01,
                1.59551101e-01,
            ],
            [
                3.55198510e02,
                3.52797004e02,
                2.31707674e01,
                -5.17600302e00,
                2.02805843e01,
                8.69594936e-02,
            ],
            [
                3.81289714e02,
                4.07277352e02,
                3.63608634e01,
                -2.03970279e01,
                1.69257319e01,
                7.12531509e-03,
            ],
            [
                2.66126484e02,
                4.21403317e02,
                2.23173801e01,
                6.71736273e00,
                5.26069906e01,
                5.96099364e00,
            ],
        ],
        dtype=dtype,
    )
    ##
    fm = np.array(
        [
            [0, 0],
            [1, 1],
            [2, 2],
            [3, 3],
            [4, 4],
            [5, 5],
            [6, 6],
            [7, 7],
            [8, 8],
            [9, 9],
            [10, 10],
            [11, 11],
            [12, 12],
        ],
        dtype=np.int32,
    )
    return kpts1, kpts2, fm


def make_dummy_fm(nKpts):
    fx1_m = np.arange(nKpts)
    fx2_m = np.arange(nKpts)
    fm = np.vstack((fx1_m, fx2_m)).T
    return fm


def force_kpts_feasibility(kpts, xys_nonneg=False):
    # Fix locations to be above 0
    if xys_nonneg:
        kpts[:, ktool.XDIM] = np.abs(kpts[:, ktool.XDIM])
        kpts[:, ktool.XDIM] = np.abs(kpts[:, ktool.XDIM])
    # Fix shape to be pos-semidef
    kpts[:, ktool.SCAX_DIM] = np.abs(kpts[:, ktool.SCAX_DIM])
    kpts[:, ktool.SCAY_DIM] = np.abs(kpts[:, ktool.SCAY_DIM])
    # Fix oris between 0 and tau
    kpts[:, ktool.ORI_DIM] = kpts[:, ktool.ORI_DIM] % TAU
    return kpts


def perterbed_grid_kpts(*args, **kwargs):
    grid_kpts = ktool.get_grid_kpts(*args, **kwargs)
    perterb_kwargs = dict(xy_std=(5, 5), invV_std=(3, 5, 3), ori_std=0.25)
    perterb_kwargs.update(kwargs)
    return perterb_kpts(grid_kpts, **perterb_kwargs)


def perterb_kpts(
    kpts, xy_std=None, invV_std=None, ori_std=None, damping=None, seed=None, **kwargs
):
    """ Adds normally distributed pertibations to keypoints """
    # TODO: Move to ktool
    # Get standard deviations of pertibations
    if xy_std is None:
        xy_std = ktool.get_xys(kpts).std(1) + mtool.eps
    if invV_std is None:
        invV_std = ktool.get_invVs(kpts).std(1) + mtool.eps
    if ori_std is None:
        ori_std = ktool.get_oris(kpts).std() + mtool.eps
    xy_std = np.array(xy_std, dtype=ktool.KPTS_DTYPE)
    invV_std = np.array(invV_std, dtype=ktool.KPTS_DTYPE)
    if damping is not None:
        xy_std /= damping
        invV_std /= damping
        ori_std /= damping
    if seed is not None:
        np.random.seed(seed)
    # Create normally distributed pertibations
    xy_aug = np.random.normal(0, scale=xy_std, size=(len(kpts), 2)).astype(
        ktool.KPTS_DTYPE
    )
    try:
        invV_aug = np.random.normal(0, scale=invV_std, size=(len(kpts), 3)).astype(
            ktool.KPTS_DTYPE
        )
    except ValueError as ex:
        ut.printex(ex, key_list=[(type, 'invV_std')])
        raise
    ori_aug = np.random.normal(0, scale=ori_std, size=(len(kpts), 1)).astype(
        ktool.KPTS_DTYPE
    )
    # Augment keypoints
    aug = np.hstack((xy_aug, invV_aug, ori_aug))
    kpts_ = kpts + aug
    # Ensure keypoint feasibility
    kpts_ = force_kpts_feasibility(kpts_)
    # print(ub.repr2({key: type(val) if not isinstance(val, np.ndarray) else val.dtype for key, val in locals().items()}))
    # assert kpts_.dtype == ktool.KPTS_DTYPE, 'bad cast somewhere kpts_.dtype=%r' % (kpts_.dtype)
    return kpts_


def testdata_dummy_matches():
    r"""
    Returns:
        tuple: matches_testtup

    CommandLine:
        python -m vtool.demodata --test-testdata_dummy_matches --show

    Example:
        >>> # ENABLE_DOCTEST
        >>> from vtool.demodata import *  # NOQA
        >>> matches_testtup = testdata_dummy_matches()
        >>> (kpts1, kpts2, fm, fs, rchip1, rchip2) = matches_testtup
        >>> # xdoctest: +REQUIRES(--show)
        >>> import wbia.plottool as pt
        >>> pt.show_chipmatch2(rchip1, rchip2, kpts1, kpts2, fm, fs)
        >>> pt.set_figtitle('Dummy matches')
        >>> pt.show_if_requested()
    """
    kpts1, kpts2 = get_dummy_kpts_pair((100, 100))
    # fm = np.ascontiguousarray(demodata.make_dummy_fm(len(kpts1)).astype(np.uint))
    fm = np.ascontiguousarray(make_dummy_fm(len(kpts1)).astype(np.int64))
    # print(repr([kpts1, kpts2, fm, xy_thresh_sqrd, scale_thresh_sqrd, ori_thresh]))
    rchip1 = get_kpts_dummy_img(kpts1)
    rchip2 = get_kpts_dummy_img(kpts2)
    fs = np.ones(fm.shape[0])
    return (kpts1, kpts2, fm, fs, rchip1, rchip2)


def get_testdata_kpts(fname=None, with_vecs=False):
    if fname is None:
        kpts = get_dummy_kpts()
        vecs = (np.random.rand(len(kpts), 128) * 255).astype(np.uint8)
        # TODO: demodata vecs
    else:
        from vtool import features as feattool
        import utool as ut

        fpath = ut.grab_test_imgpath(fname)
        kpts, vecs = feattool.extract_features(fpath)
    if with_vecs:
        return kpts, vecs
    else:
        return kpts


def testdata_ratio_matches(fname1='easy1.png', fname2='easy2.png', **kwargs):
    r"""
    Runs simple ratio-test matching between two images.
    Technically this is not demodata data.

    Args:
        fname1 (str):
        fname2 (str):

    Returns:
        tuple : matches_testtup

    CommandLine:
        python -m vtool.demodata --test-testdata_ratio_matches
        python -m vtool.demodata --test-testdata_ratio_matches --help
        python -m vtool.demodata --test-testdata_ratio_matches --show
        python -m vtool.demodata --test-testdata_ratio_matches --show --ratio_thresh=1.1 --rotation_invariance

        python -m vtool.demodata --test-testdata_ratio_matches --show --ratio_thresh=.625 --rotation_invariance --fname1 easy1.png --fname2 easy3.png
        python -m vtool.demodata --test-testdata_ratio_matches --show --ratio_thresh=.625 --no-rotation_invariance --fname1 easy1.png --fname2 easy3.png

    Example:
        >>> # ENABLE_DOCTEST
        >>> from vtool.demodata import *  # NOQA
        >>> import vtool as vt
        >>> fname1 = ut.get_argval('--fname1', type_=str, default='easy1.png')
        >>> fname2 = ut.get_argval('--fname2', type_=str, default='easy2.png')
        >>> default_dict = vt.get_extract_features_default_params()
        >>> default_dict['ratio_thresh'] = .625
        >>> kwargs = ut.argparse_dict(default_dict)
        >>> matches_testtup = testdata_ratio_matches(fname1, fname2, **kwargs)
        >>> (kpts1, kpts2, fm_RAT, fs_RAT, rchip1, rchip2) = matches_testtup
        >>> # xdoctest: +REQUIRES(--show)
        >>> import wbia.plottool as pt
        >>> pt.show_chipmatch2(rchip1, rchip2, kpts1, kpts2, fm_RAT, fs_RAT, ori=True)
        >>> num_matches = len(fm_RAT)
        >>> score_sum = sum(fs_RAT)
        >>> title = 'Simple matches using the Lowe\'s ratio test'
        >>> title += '\n num_matches=%r, score_sum=%.2f' % (num_matches, score_sum)
        >>> pt.set_figtitle(title)
        >>> pt.show_if_requested()
    """
    import utool as ut
    import vtool as vt
    from vtool import image as gtool
    from vtool import features as feattool

    try:
        from vtool._pyflann_backend import pyflann
    except ImportError:
        import pytest

        pytest.skip()
    # Get params
    ratio_thresh = kwargs.get('ratio_thresh', 0.625)
    print('ratio_thresh=%r' % (ratio_thresh,))
    featkw = vt.get_extract_features_default_params()
    ut.update_existing(featkw, kwargs)
    # Read Images
    fpath1 = ut.grab_test_imgpath(fname1)
    fpath2 = ut.grab_test_imgpath(fname2)
    # Extract Features
    kpts1, vecs1 = feattool.extract_features(fpath1, **featkw)
    kpts2, vecs2 = feattool.extract_features(fpath2, **featkw)
    rchip1 = gtool.imread(fpath1)
    rchip2 = gtool.imread(fpath2)
    # Run Algorithm
    def assign_nearest_neighbors(vecs1, vecs2, K=2):
        checks = 800
        flann_params = {'algorithm': 'kdtree', 'trees': 8}
        # pseudo_max_dist_sqrd = (np.sqrt(2) * 512) ** 2
        pseudo_max_dist_sqrd = 2 * (512 ** 2)
        flann = vt.flann_cache(vecs1, flann_params=flann_params)
        try:
            fx2_to_fx1, _fx2_to_dist = flann.nn_index(
                vecs2, num_neighbors=K, checks=checks
            )
        except pyflann.FLANNException:
            print('vecs1.shape = %r' % (vecs1.shape,))
            print('vecs2.shape = %r' % (vecs2.shape,))
            print('vecs1.dtype = %r' % (vecs1.dtype,))
            print('vecs2.dtype = %r' % (vecs2.dtype,))
            raise
        fx2_to_dist = np.divide(_fx2_to_dist, pseudo_max_dist_sqrd)
        return fx2_to_fx1, fx2_to_dist

    def ratio_test(fx2_to_fx1, fx2_to_dist, ratio_thresh):
        fx2_to_ratio = np.divide(fx2_to_dist.T[0], fx2_to_dist.T[1])
        fx2_to_isvalid = fx2_to_ratio < ratio_thresh
        fx2_m = np.where(fx2_to_isvalid)[0]
        fx1_m = fx2_to_fx1.T[0].take(fx2_m)
        fs_RAT = np.subtract(1.0, fx2_to_ratio.take(fx2_m))
        fm_RAT = np.vstack((fx1_m, fx2_m)).T
        # return normalizer info as well
        fx1_m_normalizer = fx2_to_fx1.T[1].take(fx2_m)
        fm_norm_RAT = np.vstack((fx1_m_normalizer, fx2_m)).T
        return fm_RAT, fs_RAT, fm_norm_RAT

    # GET NEAREST NEIGHBORS
    fx2_to_fx1, fx2_to_dist = assign_nearest_neighbors(vecs1, vecs2, K=2)
    fm_RAT, fs_RAT, fm_norm_RAT = ratio_test(fx2_to_fx1, fx2_to_dist, ratio_thresh)
    kpts1 = kpts1.astype(np.float64)
    kpts2 = kpts2.astype(np.float64)
    matches_testtup = (kpts1, kpts2, fm_RAT, fs_RAT, rchip1, rchip2)
    return matches_testtup


if __name__ == '__main__':
    """
    CommandLine:
        xdoctest -m demodata
    """
    import xdoctest

    xdoctest.doctest_module(__file__)
