# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUsagePlansResult',
    'AwaitableGetUsagePlansResult',
    'get_usage_plans',
    'get_usage_plans_output',
]

@pulumi.output_type
class GetUsagePlansResult:
    """
    A collection of values returned by getUsagePlans.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, state=None, usage_plan_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if usage_plan_collections and not isinstance(usage_plan_collections, list):
            raise TypeError("Expected argument 'usage_plan_collections' to be a list")
        pulumi.set(__self__, "usage_plan_collections", usage_plan_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUsagePlansFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the usage plan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="usagePlanCollections")
    def usage_plan_collections(self) -> Sequence['outputs.GetUsagePlansUsagePlanCollectionResult']:
        """
        The list of usage_plan_collection.
        """
        return pulumi.get(self, "usage_plan_collections")


class AwaitableGetUsagePlansResult(GetUsagePlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsagePlansResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            usage_plan_collections=self.usage_plan_collections)


def get_usage_plans(compartment_id: Optional[str] = None,
                    display_name: Optional[str] = None,
                    filters: Optional[Sequence[pulumi.InputType['GetUsagePlansFilterArgs']]] = None,
                    state: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsagePlansResult:
    """
    This data source provides the list of Usage Plans in Oracle Cloud Infrastructure API Gateway service.

    Returns a list of usage plans.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_plans = oci.ApiGateway.get_usage_plans(compartment_id=var["compartment_id"],
        display_name=var["usage_plan_display_name"],
        state=var["usage_plan_state"])
    ```


    :param str compartment_id: The ocid of the compartment in which to list resources.
    :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param str state: A filter to return only resources that match the given lifecycle state. Example: `ACTIVE`
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getUsagePlans:getUsagePlans', __args__, opts=opts, typ=GetUsagePlansResult).value

    return AwaitableGetUsagePlansResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        usage_plan_collections=pulumi.get(__ret__, 'usage_plan_collections'))


@_utilities.lift_output_func(get_usage_plans)
def get_usage_plans_output(compartment_id: Optional[pulumi.Input[str]] = None,
                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUsagePlansFilterArgs']]]]] = None,
                           state: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsagePlansResult]:
    """
    This data source provides the list of Usage Plans in Oracle Cloud Infrastructure API Gateway service.

    Returns a list of usage plans.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_plans = oci.ApiGateway.get_usage_plans(compartment_id=var["compartment_id"],
        display_name=var["usage_plan_display_name"],
        state=var["usage_plan_state"])
    ```


    :param str compartment_id: The ocid of the compartment in which to list resources.
    :param str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
    :param str state: A filter to return only resources that match the given lifecycle state. Example: `ACTIVE`
    """
    ...
