# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstancePoolArgs', 'InstancePool']

@pulumi.input_type
class InstancePoolArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 instance_configuration_id: pulumi.Input[str],
                 placement_configurations: pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]],
                 size: pulumi.Input[int],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_display_name_formatter: Optional[pulumi.Input[str]] = None,
                 instance_hostname_formatter: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InstancePool resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[str] instance_configuration_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]] placement_configurations: (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.
               
               To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param pulumi.Input[int] size: (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_display_name_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        :param pulumi.Input[str] instance_hostname_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        :param pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]] load_balancers: The load balancers to attach to the instance pool.
        :param pulumi.Input[str] state: (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "placement_configurations", placement_configurations)
        pulumi.set(__self__, "size", size)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_display_name_formatter is not None:
            pulumi.set(__self__, "instance_display_name_formatter", instance_display_name_formatter)
        if instance_hostname_formatter is not None:
            pulumi.set(__self__, "instance_hostname_formatter", instance_hostname_formatter)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]]:
        """
        (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.

        To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        """
        return pulumi.get(self, "placement_configurations")

    @placement_configurations.setter
    def placement_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]]):
        pulumi.set(self, "placement_configurations", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceDisplayNameFormatter")
    def instance_display_name_formatter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        """
        return pulumi.get(self, "instance_display_name_formatter")

    @instance_display_name_formatter.setter
    def instance_display_name_formatter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_display_name_formatter", value)

    @property
    @pulumi.getter(name="instanceHostnameFormatter")
    def instance_hostname_formatter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        """
        return pulumi.get(self, "instance_hostname_formatter")

    @instance_hostname_formatter.setter
    def instance_hostname_formatter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_hostname_formatter", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]]]:
        """
        The load balancers to attach to the instance pool.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _InstancePoolState:
    def __init__(__self__, *,
                 actual_size: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 instance_display_name_formatter: Optional[pulumi.Input[str]] = None,
                 instance_hostname_formatter: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]]] = None,
                 placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstancePool resources.
        :param pulumi.Input[int] actual_size: The number of actual instances in the instance pool on the cloud. This attribute will be different when instance pool is used along with autoScaling Configuration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_configuration_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        :param pulumi.Input[str] instance_display_name_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        :param pulumi.Input[str] instance_hostname_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        :param pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]] load_balancers: The load balancers to attach to the instance pool.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]] placement_configurations: (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.
               
               To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param pulumi.Input[int] size: (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        :param pulumi.Input[str] state: (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the instance pool was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        if actual_size is not None:
            pulumi.set(__self__, "actual_size", actual_size)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_display_name_formatter is not None:
            pulumi.set(__self__, "instance_display_name_formatter", instance_display_name_formatter)
        if instance_hostname_formatter is not None:
            pulumi.set(__self__, "instance_hostname_formatter", instance_hostname_formatter)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if placement_configurations is not None:
            pulumi.set(__self__, "placement_configurations", placement_configurations)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="actualSize")
    def actual_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of actual instances in the instance pool on the cloud. This attribute will be different when instance pool is used along with autoScaling Configuration.
        """
        return pulumi.get(self, "actual_size")

    @actual_size.setter
    def actual_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "actual_size", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="instanceDisplayNameFormatter")
    def instance_display_name_formatter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        """
        return pulumi.get(self, "instance_display_name_formatter")

    @instance_display_name_formatter.setter
    def instance_display_name_formatter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_display_name_formatter", value)

    @property
    @pulumi.getter(name="instanceHostnameFormatter")
    def instance_hostname_formatter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        """
        return pulumi.get(self, "instance_hostname_formatter")

    @instance_hostname_formatter.setter
    def instance_hostname_formatter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_hostname_formatter", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]]]:
        """
        The load balancers to attach to the instance pool.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]]]:
        """
        (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.

        To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        """
        return pulumi.get(self, "placement_configurations")

    @placement_configurations.setter
    def placement_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolPlacementConfigurationArgs']]]]):
        pulumi.set(self, "placement_configurations", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the instance pool was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class InstancePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 instance_display_name_formatter: Optional[pulumi.Input[str]] = None,
                 instance_hostname_formatter: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolLoadBalancerArgs']]]]] = None,
                 placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolPlacementConfigurationArgs']]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Instance Pool resource in Oracle Cloud Infrastructure Core service.

        Creates an instance pool.

        To determine whether capacity is available for a specific shape before you create an instance pool,
        use the [CreateComputeCapacityReport](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCapacityReport/CreateComputeCapacityReport)
        operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_pool = oci.core.InstancePool("testInstancePool",
            compartment_id=var["compartment_id"],
            instance_configuration_id=oci_core_instance_configuration["test_instance_configuration"]["id"],
            placement_configurations=[oci.core.InstancePoolPlacementConfigurationArgs(
                availability_domain=var["instance_pool_placement_configurations_availability_domain"],
                fault_domains=var["instance_pool_placement_configurations_fault_domains"],
                primary_subnet_id=oci_core_subnet["test_subnet"]["id"],
                primary_vnic_subnets=oci.core.InstancePoolPlacementConfigurationPrimaryVnicSubnetsArgs(
                    subnet_id=oci_core_subnet["test_subnet"]["id"],
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.InstancePoolPlacementConfigurationPrimaryVnicSubnetsIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=var["instance_pool_placement_configurations_primary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr"],
                    )],
                    is_assign_ipv6ip=var["instance_pool_placement_configurations_primary_vnic_subnets_is_assign_ipv6ip"],
                ),
                secondary_vnic_subnets=[oci.core.InstancePoolPlacementConfigurationSecondaryVnicSubnetArgs(
                    subnet_id=oci_core_subnet["test_subnet"]["id"],
                    display_name=var["instance_pool_placement_configurations_secondary_vnic_subnets_display_name"],
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.InstancePoolPlacementConfigurationSecondaryVnicSubnetIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=var["instance_pool_placement_configurations_secondary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr"],
                    )],
                    is_assign_ipv6ip=var["instance_pool_placement_configurations_secondary_vnic_subnets_is_assign_ipv6ip"],
                )],
            )],
            size=var["instance_pool_size"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["instance_pool_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            instance_display_name_formatter=var["instance_pool_instance_display_name_formatter"],
            instance_hostname_formatter=var["instance_pool_instance_hostname_formatter"],
            load_balancers=[oci.core.InstancePoolLoadBalancerArgs(
                backend_set_name=oci_load_balancer_backend_set["test_backend_set"]["name"],
                load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
                port=var["instance_pool_load_balancers_port"],
                vnic_selection=var["instance_pool_load_balancers_vnic_selection"],
            )])
        ```

        ## Import

        InstancePools can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/instancePool:InstancePool test_instance_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_configuration_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        :param pulumi.Input[str] instance_display_name_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        :param pulumi.Input[str] instance_hostname_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolLoadBalancerArgs']]]] load_balancers: The load balancers to attach to the instance pool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolPlacementConfigurationArgs']]]] placement_configurations: (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.
               
               To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param pulumi.Input[int] size: (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        :param pulumi.Input[str] state: (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Instance Pool resource in Oracle Cloud Infrastructure Core service.

        Creates an instance pool.

        To determine whether capacity is available for a specific shape before you create an instance pool,
        use the [CreateComputeCapacityReport](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCapacityReport/CreateComputeCapacityReport)
        operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_pool = oci.core.InstancePool("testInstancePool",
            compartment_id=var["compartment_id"],
            instance_configuration_id=oci_core_instance_configuration["test_instance_configuration"]["id"],
            placement_configurations=[oci.core.InstancePoolPlacementConfigurationArgs(
                availability_domain=var["instance_pool_placement_configurations_availability_domain"],
                fault_domains=var["instance_pool_placement_configurations_fault_domains"],
                primary_subnet_id=oci_core_subnet["test_subnet"]["id"],
                primary_vnic_subnets=oci.core.InstancePoolPlacementConfigurationPrimaryVnicSubnetsArgs(
                    subnet_id=oci_core_subnet["test_subnet"]["id"],
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.InstancePoolPlacementConfigurationPrimaryVnicSubnetsIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=var["instance_pool_placement_configurations_primary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr"],
                    )],
                    is_assign_ipv6ip=var["instance_pool_placement_configurations_primary_vnic_subnets_is_assign_ipv6ip"],
                ),
                secondary_vnic_subnets=[oci.core.InstancePoolPlacementConfigurationSecondaryVnicSubnetArgs(
                    subnet_id=oci_core_subnet["test_subnet"]["id"],
                    display_name=var["instance_pool_placement_configurations_secondary_vnic_subnets_display_name"],
                    ipv6address_ipv6subnet_cidr_pair_details=[oci.core.InstancePoolPlacementConfigurationSecondaryVnicSubnetIpv6addressIpv6subnetCidrPairDetailArgs(
                        ipv6subnet_cidr=var["instance_pool_placement_configurations_secondary_vnic_subnets_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr"],
                    )],
                    is_assign_ipv6ip=var["instance_pool_placement_configurations_secondary_vnic_subnets_is_assign_ipv6ip"],
                )],
            )],
            size=var["instance_pool_size"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["instance_pool_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            instance_display_name_formatter=var["instance_pool_instance_display_name_formatter"],
            instance_hostname_formatter=var["instance_pool_instance_hostname_formatter"],
            load_balancers=[oci.core.InstancePoolLoadBalancerArgs(
                backend_set_name=oci_load_balancer_backend_set["test_backend_set"]["name"],
                load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
                port=var["instance_pool_load_balancers_port"],
                vnic_selection=var["instance_pool_load_balancers_vnic_selection"],
            )])
        ```

        ## Import

        InstancePools can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/instancePool:InstancePool test_instance_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param InstancePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 instance_display_name_formatter: Optional[pulumi.Input[str]] = None,
                 instance_hostname_formatter: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolLoadBalancerArgs']]]]] = None,
                 placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolPlacementConfigurationArgs']]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePoolArgs.__new__(InstancePoolArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if instance_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_configuration_id'")
            __props__.__dict__["instance_configuration_id"] = instance_configuration_id
            __props__.__dict__["instance_display_name_formatter"] = instance_display_name_formatter
            __props__.__dict__["instance_hostname_formatter"] = instance_hostname_formatter
            __props__.__dict__["load_balancers"] = load_balancers
            if placement_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'placement_configurations'")
            __props__.__dict__["placement_configurations"] = placement_configurations
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["state"] = state
            __props__.__dict__["actual_size"] = None
            __props__.__dict__["time_created"] = None
        super(InstancePool, __self__).__init__(
            'oci:Core/instancePool:InstancePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actual_size: Optional[pulumi.Input[int]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            instance_configuration_id: Optional[pulumi.Input[str]] = None,
            instance_display_name_formatter: Optional[pulumi.Input[str]] = None,
            instance_hostname_formatter: Optional[pulumi.Input[str]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolLoadBalancerArgs']]]]] = None,
            placement_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolPlacementConfigurationArgs']]]]] = None,
            size: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'InstancePool':
        """
        Get an existing InstancePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] actual_size: The number of actual instances in the instance pool on the cloud. This attribute will be different when instance pool is used along with autoScaling Configuration.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_configuration_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        :param pulumi.Input[str] instance_display_name_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        :param pulumi.Input[str] instance_hostname_formatter: (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolLoadBalancerArgs']]]] load_balancers: The load balancers to attach to the instance pool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolPlacementConfigurationArgs']]]] placement_configurations: (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.
               
               To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param pulumi.Input[int] size: (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        :param pulumi.Input[str] state: (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the instance pool was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePoolState.__new__(_InstancePoolState)

        __props__.__dict__["actual_size"] = actual_size
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_configuration_id"] = instance_configuration_id
        __props__.__dict__["instance_display_name_formatter"] = instance_display_name_formatter
        __props__.__dict__["instance_hostname_formatter"] = instance_hostname_formatter
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["placement_configurations"] = placement_configurations
        __props__.__dict__["size"] = size
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return InstancePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actualSize")
    def actual_size(self) -> pulumi.Output[int]:
        """
        The number of actual instances in the instance pool on the cloud. This attribute will be different when instance pool is used along with autoScaling Configuration.
        """
        return pulumi.get(self, "actual_size")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the VNIC. This is also used to match against the instance configuration defined secondary VNIC.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration associated with the instance pool.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceDisplayNameFormatter")
    def instance_display_name_formatter(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly formatter for the instance pool's instances. Instance displaynames follow the format. The formatter does not retroactively change instance's displaynames, only instance displaynames in the future follow the format
        """
        return pulumi.get(self, "instance_display_name_formatter")

    @property
    @pulumi.getter(name="instanceHostnameFormatter")
    def instance_hostname_formatter(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly formatter for the instance pool's instances. Instance hostnames follow the format. The formatter does not retroactively change instance's hostnames, only instance hostnames in the future follow the format
        """
        return pulumi.get(self, "instance_hostname_formatter")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence['outputs.InstancePoolLoadBalancer']]:
        """
        The load balancers to attach to the instance pool.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> pulumi.Output[Sequence['outputs.InstancePoolPlacementConfiguration']]:
        """
        (Updatable) The placement configurations for the instance pool. Provide one placement configuration for each availability domain.

        To use the instance pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        """
        return pulumi.get(self, "placement_configurations")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of instances that should be in the instance pool. Modifying this value will override the size of the instance pool. If the instance pool is linked with autoscaling configuration, autoscaling configuration could resize the instance pool at a later point. The instance pool's actual size may differ from the configured size if it is associated with an autoscaling configuration, instance pool's actual size will be reflected in this size attribute.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the instance pool update operation (ignored at create time and should not be set). Could be set to RUNNING or STOPPED.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the instance pool was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

