# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVmClusterNetworkResult',
    'AwaitableGetVmClusterNetworkResult',
    'get_vm_cluster_network',
    'get_vm_cluster_network_output',
]

@pulumi.output_type
class GetVmClusterNetworkResult:
    """
    A collection of values returned by getVmClusterNetwork.
    """
    def __init__(__self__, action=None, compartment_id=None, defined_tags=None, display_name=None, dns=None, dr_scans=None, exadata_infrastructure_id=None, freeform_tags=None, id=None, lifecycle_details=None, ntps=None, scans=None, state=None, time_created=None, validate_vm_cluster_network=None, vm_cluster_id=None, vm_cluster_network_id=None, vm_networks=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns and not isinstance(dns, list):
            raise TypeError("Expected argument 'dns' to be a list")
        pulumi.set(__self__, "dns", dns)
        if dr_scans and not isinstance(dr_scans, list):
            raise TypeError("Expected argument 'dr_scans' to be a list")
        pulumi.set(__self__, "dr_scans", dr_scans)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ntps and not isinstance(ntps, list):
            raise TypeError("Expected argument 'ntps' to be a list")
        pulumi.set(__self__, "ntps", ntps)
        if scans and not isinstance(scans, list):
            raise TypeError("Expected argument 'scans' to be a list")
        pulumi.set(__self__, "scans", scans)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if validate_vm_cluster_network and not isinstance(validate_vm_cluster_network, bool):
            raise TypeError("Expected argument 'validate_vm_cluster_network' to be a bool")
        pulumi.set(__self__, "validate_vm_cluster_network", validate_vm_cluster_network)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_cluster_network_id and not isinstance(vm_cluster_network_id, str):
            raise TypeError("Expected argument 'vm_cluster_network_id' to be a str")
        pulumi.set(__self__, "vm_cluster_network_id", vm_cluster_network_id)
        if vm_networks and not isinstance(vm_networks, list):
            raise TypeError("Expected argument 'vm_networks' to be a list")
        pulumi.set(__self__, "vm_networks", vm_networks)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the VM cluster network. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def dns(self) -> Sequence[str]:
        """
        The list of DNS server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="drScans")
    def dr_scans(self) -> Sequence['outputs.GetVmClusterNetworkDrScanResult']:
        """
        The SCAN details for DR network
        """
        return pulumi.get(self, "dr_scans")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster network.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def ntps(self) -> Sequence[str]:
        """
        The list of NTP server IP addresses. Maximum of 3 allowed.
        """
        return pulumi.get(self, "ntps")

    @property
    @pulumi.getter
    def scans(self) -> Sequence['outputs.GetVmClusterNetworkScanResult']:
        """
        The SCAN details.
        """
        return pulumi.get(self, "scans")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the VM cluster network nodes. CREATING - The resource is being created REQUIRES_VALIDATION - The resource is created and may not be usable until it is validated. VALIDATING - The resource is being validated and not available to use. VALIDATED - The resource is validated and is available for consumption by VM cluster. VALIDATION_FAILED - The resource validation has failed and might require user input to be corrected. UPDATING - The resource is being updated and not available to use. ALLOCATED - The resource is currently being used by VM cluster. TERMINATING - The resource is being deleted and not available to use. TERMINATED - The resource is deleted and unavailable. FAILED - The resource is in a failed state due to validation or other errors.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time when the VM cluster network was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="validateVmClusterNetwork")
    def validate_vm_cluster_network(self) -> bool:
        return pulumi.get(self, "validate_vm_cluster_network")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated VM Cluster.
        """
        return pulumi.get(self, "vm_cluster_id")

    @property
    @pulumi.getter(name="vmClusterNetworkId")
    def vm_cluster_network_id(self) -> str:
        return pulumi.get(self, "vm_cluster_network_id")

    @property
    @pulumi.getter(name="vmNetworks")
    def vm_networks(self) -> Sequence['outputs.GetVmClusterNetworkVmNetworkResult']:
        """
        Details of the client and backup networks.
        """
        return pulumi.get(self, "vm_networks")


class AwaitableGetVmClusterNetworkResult(GetVmClusterNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterNetworkResult(
            action=self.action,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dns=self.dns,
            dr_scans=self.dr_scans,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            ntps=self.ntps,
            scans=self.scans,
            state=self.state,
            time_created=self.time_created,
            validate_vm_cluster_network=self.validate_vm_cluster_network,
            vm_cluster_id=self.vm_cluster_id,
            vm_cluster_network_id=self.vm_cluster_network_id,
            vm_networks=self.vm_networks)


def get_vm_cluster_network(exadata_infrastructure_id: Optional[str] = None,
                           vm_cluster_network_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterNetworkResult:
    """
    This data source provides details about a specific Vm Cluster Network resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified VM cluster network. Applies to Exadata Cloud@Customer instances only.
    To get information about a cloud VM cluster in an Exadata Cloud Service instance, use the [GetCloudVmCluster ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/GetCloudVmCluster) operation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_network = oci.Database.get_vm_cluster_network(exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"],
        vm_cluster_network_id=oci_database_vm_cluster_network["test_vm_cluster_network"]["id"])
    ```


    :param str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str vm_cluster_network_id: The VM cluster network [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['exadataInfrastructureId'] = exadata_infrastructure_id
    __args__['vmClusterNetworkId'] = vm_cluster_network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterNetwork:getVmClusterNetwork', __args__, opts=opts, typ=GetVmClusterNetworkResult).value

    return AwaitableGetVmClusterNetworkResult(
        action=pulumi.get(__ret__, 'action'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns=pulumi.get(__ret__, 'dns'),
        dr_scans=pulumi.get(__ret__, 'dr_scans'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        ntps=pulumi.get(__ret__, 'ntps'),
        scans=pulumi.get(__ret__, 'scans'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        validate_vm_cluster_network=pulumi.get(__ret__, 'validate_vm_cluster_network'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'),
        vm_cluster_network_id=pulumi.get(__ret__, 'vm_cluster_network_id'),
        vm_networks=pulumi.get(__ret__, 'vm_networks'))


@_utilities.lift_output_func(get_vm_cluster_network)
def get_vm_cluster_network_output(exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                                  vm_cluster_network_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVmClusterNetworkResult]:
    """
    This data source provides details about a specific Vm Cluster Network resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified VM cluster network. Applies to Exadata Cloud@Customer instances only.
    To get information about a cloud VM cluster in an Exadata Cloud Service instance, use the [GetCloudVmCluster ](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/CloudVmCluster/GetCloudVmCluster) operation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_network = oci.Database.get_vm_cluster_network(exadata_infrastructure_id=oci_database_exadata_infrastructure["test_exadata_infrastructure"]["id"],
        vm_cluster_network_id=oci_database_vm_cluster_network["test_vm_cluster_network"]["id"])
    ```


    :param str exadata_infrastructure_id: The Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str vm_cluster_network_id: The VM cluster network [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
