# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkspaceApplicationsResult',
    'AwaitableGetWorkspaceApplicationsResult',
    'get_workspace_applications',
    'get_workspace_applications_output',
]

@pulumi.output_type
class GetWorkspaceApplicationsResult:
    """
    A collection of values returned by getWorkspaceApplications.
    """
    def __init__(__self__, application_summary_collections=None, fields=None, filters=None, id=None, identifiers=None, name=None, name_contains=None, workspace_id=None):
        if application_summary_collections and not isinstance(application_summary_collections, list):
            raise TypeError("Expected argument 'application_summary_collections' to be a list")
        pulumi.set(__self__, "application_summary_collections", application_summary_collections)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifiers and not isinstance(identifiers, list):
            raise TypeError("Expected argument 'identifiers' to be a list")
        pulumi.set(__self__, "identifiers", identifiers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_contains and not isinstance(name_contains, str):
            raise TypeError("Expected argument 'name_contains' to be a str")
        pulumi.set(__self__, "name_contains", name_contains)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationSummaryCollections")
    def application_summary_collections(self) -> Sequence['outputs.GetWorkspaceApplicationsApplicationSummaryCollectionResult']:
        """
        The list of application_summary_collection.
        """
        return pulumi.get(self, "application_summary_collections")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWorkspaceApplicationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifiers(self) -> Optional[Sequence[str]]:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameContains")
    def name_contains(self) -> Optional[str]:
        return pulumi.get(self, "name_contains")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        The OCID of the workspace containing the application. This allows cross workspace deployment to publish an application from a different workspace into the current workspace specified in this operation.
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceApplicationsResult(GetWorkspaceApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceApplicationsResult(
            application_summary_collections=self.application_summary_collections,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            identifiers=self.identifiers,
            name=self.name,
            name_contains=self.name_contains,
            workspace_id=self.workspace_id)


def get_workspace_applications(fields: Optional[Sequence[str]] = None,
                               filters: Optional[Sequence[pulumi.InputType['GetWorkspaceApplicationsFilterArgs']]] = None,
                               identifiers: Optional[Sequence[str]] = None,
                               name: Optional[str] = None,
                               name_contains: Optional[str] = None,
                               workspace_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceApplicationsResult:
    """
    This data source provides the list of Workspace Applications in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a list of applications and provides options to filter the list.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_applications = oci.DataIntegration.get_workspace_applications(workspace_id=oci_dataintegration_workspace["test_workspace"]["id"],
        fields=var["workspace_application_fields"],
        identifiers=var["workspace_application_identifier"],
        name=var["workspace_application_name"],
        name_contains=var["workspace_application_name_contains"])
    ```


    :param Sequence[str] fields: Specifies the fields to get for an object.
    :param Sequence[str] identifiers: Used to filter by the identifier of the published object.
    :param str name: Used to filter by the name of the object.
    :param str name_contains: This parameter can be used to filter objects by the names that match partially or fully with the given value.
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['identifiers'] = identifiers
    __args__['name'] = name
    __args__['nameContains'] = name_contains
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceApplications:getWorkspaceApplications', __args__, opts=opts, typ=GetWorkspaceApplicationsResult).value

    return AwaitableGetWorkspaceApplicationsResult(
        application_summary_collections=pulumi.get(__ret__, 'application_summary_collections'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        identifiers=pulumi.get(__ret__, 'identifiers'),
        name=pulumi.get(__ret__, 'name'),
        name_contains=pulumi.get(__ret__, 'name_contains'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))


@_utilities.lift_output_func(get_workspace_applications)
def get_workspace_applications_output(fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetWorkspaceApplicationsFilterArgs']]]]] = None,
                                      identifiers: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      name: Optional[pulumi.Input[Optional[str]]] = None,
                                      name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                      workspace_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkspaceApplicationsResult]:
    """
    This data source provides the list of Workspace Applications in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a list of applications and provides options to filter the list.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_applications = oci.DataIntegration.get_workspace_applications(workspace_id=oci_dataintegration_workspace["test_workspace"]["id"],
        fields=var["workspace_application_fields"],
        identifiers=var["workspace_application_identifier"],
        name=var["workspace_application_name"],
        name_contains=var["workspace_application_name_contains"])
    ```


    :param Sequence[str] fields: Specifies the fields to get for an object.
    :param Sequence[str] identifiers: Used to filter by the identifier of the published object.
    :param str name: Used to filter by the name of the object.
    :param str name_contains: This parameter can be used to filter objects by the names that match partially or fully with the given value.
    :param str workspace_id: The workspace ID.
    """
    ...
