# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIamWorkRequestsResult',
    'AwaitableGetIamWorkRequestsResult',
    'get_iam_work_requests',
    'get_iam_work_requests_output',
]

@pulumi.output_type
class GetIamWorkRequestsResult:
    """
    A collection of values returned by getIamWorkRequests.
    """
    def __init__(__self__, compartment_id=None, filters=None, iam_work_requests=None, id=None, resource_identifier=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if iam_work_requests and not isinstance(iam_work_requests, list):
            raise TypeError("Expected argument 'iam_work_requests' to be a list")
        pulumi.set(__self__, "iam_work_requests", iam_work_requests)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_identifier and not isinstance(resource_identifier, str):
            raise TypeError("Expected argument 'resource_identifier' to be a str")
        pulumi.set(__self__, "resource_identifier", resource_identifier)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing this IAM work request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIamWorkRequestsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="iamWorkRequests")
    def iam_work_requests(self) -> Sequence['outputs.GetIamWorkRequestsIamWorkRequestResult']:
        """
        The list of iam_work_requests.
        """
        return pulumi.get(self, "iam_work_requests")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[str]:
        return pulumi.get(self, "resource_identifier")


class AwaitableGetIamWorkRequestsResult(GetIamWorkRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamWorkRequestsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            iam_work_requests=self.iam_work_requests,
            id=self.id,
            resource_identifier=self.resource_identifier)


def get_iam_work_requests(compartment_id: Optional[str] = None,
                          filters: Optional[Sequence[pulumi.InputType['GetIamWorkRequestsFilterArgs']]] = None,
                          resource_identifier: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamWorkRequestsResult:
    """
    This data source provides the list of Iam Work Requests in Oracle Cloud Infrastructure Identity service.

    List the IAM work requests in compartment

    - If IAM workrequest  details are retrieved sucessfully, return 202 ACCEPTED.
    - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_requests = oci.Identity.get_iam_work_requests(compartment_id=var["compartment_id"],
        resource_identifier=var["iam_work_request_resource_identifier"])
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str resource_identifier: The identifier of the resource the work request affects.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getIamWorkRequests:getIamWorkRequests', __args__, opts=opts, typ=GetIamWorkRequestsResult).value

    return AwaitableGetIamWorkRequestsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        iam_work_requests=pulumi.get(__ret__, 'iam_work_requests'),
        id=pulumi.get(__ret__, 'id'),
        resource_identifier=pulumi.get(__ret__, 'resource_identifier'))


@_utilities.lift_output_func(get_iam_work_requests)
def get_iam_work_requests_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetIamWorkRequestsFilterArgs']]]]] = None,
                                 resource_identifier: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIamWorkRequestsResult]:
    """
    This data source provides the list of Iam Work Requests in Oracle Cloud Infrastructure Identity service.

    List the IAM work requests in compartment

    - If IAM workrequest  details are retrieved sucessfully, return 202 ACCEPTED.
    - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_requests = oci.Identity.get_iam_work_requests(compartment_id=var["compartment_id"],
        resource_identifier=var["iam_work_request_resource_identifier"])
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str resource_identifier: The identifier of the resource the work request affects.
    """
    ...
