# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'LogConfigurationArgs',
    'LogConfigurationSourceArgs',
    'UnifiedAgentConfigurationGroupAssociationArgs',
    'UnifiedAgentConfigurationServiceConfigurationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs',
    'GetLogGroupsFilterArgs',
    'GetLogSavedSearchesFilterArgs',
    'GetLogsFilterArgs',
    'GetUnifiedAgentConfigurationsFilterArgs',
]

@pulumi.input_type
class LogConfigurationArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['LogConfigurationSourceArgs'],
                 compartment_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['LogConfigurationSourceArgs'] source: The source the log object comes from.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "source", source)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['LogConfigurationSourceArgs']:
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['LogConfigurationSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)


@pulumi.input_type
class LogConfigurationSourceArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 resource: pulumi.Input[str],
                 service: pulumi.Input[str],
                 source_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] category: Log object category.
        :param pulumi.Input[str] resource: The unique identifier of the resource emitting the log.
        :param pulumi.Input[str] service: Service generating log.
        :param pulumi.Input[str] source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[str]:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)


@pulumi.input_type
class UnifiedAgentConfigurationGroupAssociationArgs:
    def __init__(__self__, *,
                 group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_lists: (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        if group_lists is not None:
            pulumi.set(__self__, "group_lists", group_lists)

    @property
    @pulumi.getter(name="groupLists")
    def group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        return pulumi.get(self, "group_lists")

    @group_lists.setter
    def group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_lists", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 destination: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs'],
                 sources: pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]]):
        """
        :param pulumi.Input[str] configuration_type: (Updatable) Type of Unified Agent service configuration.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs'] destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]] sources: (Updatable) Logging source object.
        """
        pulumi.set(__self__, "configuration_type", configuration_type)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs']:
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]]:
        """
        (Updatable) Logging source object.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]]):
        pulumi.set(self, "sources", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationArgs:
    def __init__(__self__, *,
                 log_object_id: pulumi.Input[str],
                 operational_metrics_configuration: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] log_object_id: (Updatable) The OCID of the resource.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs'] operational_metrics_configuration: (Updatable) Unified monitoring agent operational metrics configuration object.
        """
        pulumi.set(__self__, "log_object_id", log_object_id)
        if operational_metrics_configuration is not None:
            pulumi.set(__self__, "operational_metrics_configuration", operational_metrics_configuration)

    @property
    @pulumi.getter(name="logObjectId")
    def log_object_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource.
        """
        return pulumi.get(self, "log_object_id")

    @log_object_id.setter
    def log_object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_object_id", value)

    @property
    @pulumi.getter(name="operationalMetricsConfiguration")
    def operational_metrics_configuration(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs']]:
        """
        (Updatable) Unified monitoring agent operational metrics configuration object.
        """
        return pulumi.get(self, "operational_metrics_configuration")

    @operational_metrics_configuration.setter
    def operational_metrics_configuration(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs']]):
        pulumi.set(self, "operational_metrics_configuration", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs'],
                 source: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs']):
        """
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs'] destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs'] source: (Updatable) Unified monitoring agent operational metrics source object.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs']:
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs']:
        """
        (Updatable) Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs']):
        pulumi.set(self, "source", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs:
    def __init__(__self__, *,
                 record_input: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs'],
                 type: pulumi.Input[str],
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs'] record_input: (Updatable) Record section of OperationalMetricsSource object.
        :param pulumi.Input[str] type: (Updatable) Type of the unified monitoring agent operational metrics source object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metrics: (Updatable) List of unified monitoring agent operational metrics.
        """
        pulumi.set(__self__, "record_input", record_input)
        pulumi.set(__self__, "type", type)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs']:
        """
        (Updatable) Record section of OperationalMetricsSource object.
        """
        return pulumi.get(self, "record_input")

    @record_input.setter
    def record_input(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs']):
        pulumi.set(self, "record_input", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of the unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of unified monitoring agent operational metrics.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metrics", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 resource_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] namespace: (Updatable) Namespace to emit the operational metrics.
        :param pulumi.Input[str] resource_group: (Updatable) Resource group to emit the operational metrics.
        """
        pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) Namespace to emit the operational metrics.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group to emit the operational metrics.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[str],
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs']] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] source_type: (Updatable) Unified schema logging source type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] channels: (Updatable) Windows event log channels.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs'] parser: (Updatable) Source parser object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        pulumi.set(__self__, "source_type", source_type)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Unified schema logging source type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Windows event log channels.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs']]:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @parser.setter
    def parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs']]):
        pulumi.set(self, "parser", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserArgs:
    def __init__(__self__, *,
                 parser_type: pulumi.Input[str],
                 delimiter: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 format_firstline: Optional[pulumi.Input[str]] = None,
                 formats: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 grok_failure_key: Optional[pulumi.Input[str]] = None,
                 grok_name_key: Optional[pulumi.Input[str]] = None,
                 is_estimate_current_event: Optional[pulumi.Input[bool]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 is_merge_cri_fields: Optional[pulumi.Input[bool]] = None,
                 is_null_empty_string: Optional[pulumi.Input[bool]] = None,
                 is_support_colonless_ident: Optional[pulumi.Input[bool]] = None,
                 is_with_priority: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 message_key: Optional[pulumi.Input[str]] = None,
                 multi_line_start_regexp: Optional[pulumi.Input[str]] = None,
                 nested_parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs']] = None,
                 null_value_pattern: Optional[pulumi.Input[str]] = None,
                 patterns: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]]] = None,
                 rfc5424time_format: Optional[pulumi.Input[str]] = None,
                 syslog_parser_type: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None,
                 timeout_in_milliseconds: Optional[pulumi.Input[int]] = None,
                 types: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] parser_type: (Updatable) Type of fluent parser.
        :param pulumi.Input[str] delimiter: (Updatable) CSV delimiter.
        :param pulumi.Input[str] expression: (Updatable) Regex pattern.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] format_firstline: (Updatable) First line pattern format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] formats: (Updatable) Mutiline pattern format.
        :param pulumi.Input[str] grok_failure_key: (Updatable) Grok failure key.
        :param pulumi.Input[str] grok_name_key: (Updatable) Grok name key.
        :param pulumi.Input[bool] is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param pulumi.Input[bool] is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param pulumi.Input[bool] is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param pulumi.Input[bool] is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: (Updatable) CSV keys.
        :param pulumi.Input[str] message_format: (Updatable) Syslog message format.
        :param pulumi.Input[str] message_key: (Updatable) Specifies the field name to contain logs.
        :param pulumi.Input[str] multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs'] nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param pulumi.Input[str] null_value_pattern: (Updatable) Specify the null value pattern.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]] patterns: (Updatable) Grok pattern object.
        :param pulumi.Input[str] rfc5424time_format: (Updatable) RFC 5424 time format.
        :param pulumi.Input[str] syslog_parser_type: (Updatable) Syslog parser type.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        :param pulumi.Input[int] timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param pulumi.Input[Mapping[str, Any]] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @parser_type.setter
    def parser_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "parser_type", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @format_firstline.setter
    def format_firstline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format_firstline", value)

    @property
    @pulumi.getter
    def formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @grok_failure_key.setter
    def grok_failure_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_failure_key", value)

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @grok_name_key.setter
    def grok_name_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_name_key", value)

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @is_estimate_current_event.setter
    def is_estimate_current_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_estimate_current_event", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @is_merge_cri_fields.setter
    def is_merge_cri_fields(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_merge_cri_fields", value)

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @is_null_empty_string.setter
    def is_null_empty_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_null_empty_string", value)

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @is_support_colonless_ident.setter
    def is_support_colonless_ident(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_support_colonless_ident", value)

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @is_with_priority.setter
    def is_with_priority(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_with_priority", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @message_key.setter
    def message_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_key", value)

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @multi_line_start_regexp.setter
    def multi_line_start_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_line_start_regexp", value)

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs']]:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @nested_parser.setter
    def nested_parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs']]):
        pulumi.set(self, "nested_parser", value)

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @null_value_pattern.setter
    def null_value_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_value_pattern", value)

    @property
    @pulumi.getter
    def patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]]]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @patterns.setter
    def patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]]]):
        pulumi.set(self, "patterns", value)

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @rfc5424time_format.setter
    def rfc5424time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rfc5424time_format", value)

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @syslog_parser_type.setter
    def syslog_parser_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "syslog_parser_type", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @timeout_in_milliseconds.setter
    def timeout_in_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_milliseconds", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "types", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs:
    def __init__(__self__, *,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs:
    def __init__(__self__, *,
                 field_time_format: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 field_time_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input[str] pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @field_time_format.setter
    def field_time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_format", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @field_time_zone.setter
    def field_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class GetLogGroupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetLogSavedSearchesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetLogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetUnifiedAgentConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name key to tag this Grok pattern.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


