# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'SddcDatastoreArgs',
    'SddcHcxOnPremLicenseArgs',
    'SddcUpgradeLicenseArgs',
    'SddcVsphereUpgradeObjectArgs',
    'GetExsiHostsFilterArgs',
    'GetSddcsFilterArgs',
    'GetSupportedHostShapesFilterArgs',
    'GetSupportedSkusFilterArgs',
    'GetSupportedVmwareSoftwareVersionsFilterArgs',
]

@pulumi.input_type
class SddcDatastoreArgs:
    def __init__(__self__, *,
                 block_volume_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 datastore_type: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param pulumi.Input[str] datastore_type: Type of the datastore.
        :param pulumi.Input[float] capacity: Size of the Block Storage Volume in GB.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @block_volume_ids.setter
    def block_volume_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "block_volume_ids", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class SddcHcxOnPremLicenseArgs:
    def __init__(__self__, *,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] activation_key: HCX on-premise license key value.
        :param pulumi.Input[str] status: status of HCX on-premise license.
        :param pulumi.Input[str] system_name: Name of the system that consumed the HCX on-premise license
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_name is not None:
            pulumi.set(__self__, "system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[pulumi.Input[str]]:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @activation_key.setter
    def activation_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")

    @system_name.setter
    def system_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_name", value)


@pulumi.input_type
class SddcUpgradeLicenseArgs:
    def __init__(__self__, *,
                 license_key: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] license_key: vSphere license key value.
        :param pulumi.Input[str] license_type: vSphere license type.
        """
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[str]]:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_key", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class SddcVsphereUpgradeObjectArgs:
    def __init__(__self__, *,
                 download_link: Optional[pulumi.Input[str]] = None,
                 link_description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] download_link: Binary object download link.
        :param pulumi.Input[str] link_description: Binary object description.
        """
        if download_link is not None:
            pulumi.set(__self__, "download_link", download_link)
        if link_description is not None:
            pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> Optional[pulumi.Input[str]]:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @download_link.setter
    def download_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "download_link", value)

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> Optional[pulumi.Input[str]]:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")

    @link_description.setter
    def link_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_description", value)


@pulumi.input_type
class GetExsiHostsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSddcsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedHostShapesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedSkusFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: name of SKU
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of SKU
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedVmwareSoftwareVersionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


