# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetExsiHostResult',
    'AwaitableGetExsiHostResult',
    'get_exsi_host',
    'get_exsi_host_output',
]

@pulumi.output_type
class GetExsiHostResult:
    """
    A collection of values returned by getExsiHost.
    """
    def __init__(__self__, billing_contract_end_date=None, billing_donor_host_id=None, capacity_reservation_id=None, compartment_id=None, compute_availability_domain=None, compute_instance_id=None, current_sku=None, defined_tags=None, display_name=None, esxi_host_id=None, failed_esxi_host_id=None, freeform_tags=None, grace_period_end_date=None, host_ocpu_count=None, host_shape_name=None, id=None, is_billing_continuation_in_progress=None, is_billing_swapping_in_progress=None, next_sku=None, non_upgraded_esxi_host_id=None, replacement_esxi_host_id=None, sddc_id=None, state=None, swap_billing_host_id=None, time_created=None, time_updated=None, upgraded_replacement_esxi_host_id=None, vmware_software_version=None):
        if billing_contract_end_date and not isinstance(billing_contract_end_date, str):
            raise TypeError("Expected argument 'billing_contract_end_date' to be a str")
        pulumi.set(__self__, "billing_contract_end_date", billing_contract_end_date)
        if billing_donor_host_id and not isinstance(billing_donor_host_id, str):
            raise TypeError("Expected argument 'billing_donor_host_id' to be a str")
        pulumi.set(__self__, "billing_donor_host_id", billing_donor_host_id)
        if capacity_reservation_id and not isinstance(capacity_reservation_id, str):
            raise TypeError("Expected argument 'capacity_reservation_id' to be a str")
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_availability_domain and not isinstance(compute_availability_domain, str):
            raise TypeError("Expected argument 'compute_availability_domain' to be a str")
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        if compute_instance_id and not isinstance(compute_instance_id, str):
            raise TypeError("Expected argument 'compute_instance_id' to be a str")
        pulumi.set(__self__, "compute_instance_id", compute_instance_id)
        if current_sku and not isinstance(current_sku, str):
            raise TypeError("Expected argument 'current_sku' to be a str")
        pulumi.set(__self__, "current_sku", current_sku)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if esxi_host_id and not isinstance(esxi_host_id, str):
            raise TypeError("Expected argument 'esxi_host_id' to be a str")
        pulumi.set(__self__, "esxi_host_id", esxi_host_id)
        if failed_esxi_host_id and not isinstance(failed_esxi_host_id, str):
            raise TypeError("Expected argument 'failed_esxi_host_id' to be a str")
        pulumi.set(__self__, "failed_esxi_host_id", failed_esxi_host_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if grace_period_end_date and not isinstance(grace_period_end_date, str):
            raise TypeError("Expected argument 'grace_period_end_date' to be a str")
        pulumi.set(__self__, "grace_period_end_date", grace_period_end_date)
        if host_ocpu_count and not isinstance(host_ocpu_count, float):
            raise TypeError("Expected argument 'host_ocpu_count' to be a float")
        pulumi.set(__self__, "host_ocpu_count", host_ocpu_count)
        if host_shape_name and not isinstance(host_shape_name, str):
            raise TypeError("Expected argument 'host_shape_name' to be a str")
        pulumi.set(__self__, "host_shape_name", host_shape_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_billing_continuation_in_progress and not isinstance(is_billing_continuation_in_progress, bool):
            raise TypeError("Expected argument 'is_billing_continuation_in_progress' to be a bool")
        pulumi.set(__self__, "is_billing_continuation_in_progress", is_billing_continuation_in_progress)
        if is_billing_swapping_in_progress and not isinstance(is_billing_swapping_in_progress, bool):
            raise TypeError("Expected argument 'is_billing_swapping_in_progress' to be a bool")
        pulumi.set(__self__, "is_billing_swapping_in_progress", is_billing_swapping_in_progress)
        if next_sku and not isinstance(next_sku, str):
            raise TypeError("Expected argument 'next_sku' to be a str")
        pulumi.set(__self__, "next_sku", next_sku)
        if non_upgraded_esxi_host_id and not isinstance(non_upgraded_esxi_host_id, str):
            raise TypeError("Expected argument 'non_upgraded_esxi_host_id' to be a str")
        pulumi.set(__self__, "non_upgraded_esxi_host_id", non_upgraded_esxi_host_id)
        if replacement_esxi_host_id and not isinstance(replacement_esxi_host_id, str):
            raise TypeError("Expected argument 'replacement_esxi_host_id' to be a str")
        pulumi.set(__self__, "replacement_esxi_host_id", replacement_esxi_host_id)
        if sddc_id and not isinstance(sddc_id, str):
            raise TypeError("Expected argument 'sddc_id' to be a str")
        pulumi.set(__self__, "sddc_id", sddc_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if swap_billing_host_id and not isinstance(swap_billing_host_id, str):
            raise TypeError("Expected argument 'swap_billing_host_id' to be a str")
        pulumi.set(__self__, "swap_billing_host_id", swap_billing_host_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if upgraded_replacement_esxi_host_id and not isinstance(upgraded_replacement_esxi_host_id, str):
            raise TypeError("Expected argument 'upgraded_replacement_esxi_host_id' to be a str")
        pulumi.set(__self__, "upgraded_replacement_esxi_host_id", upgraded_replacement_esxi_host_id)
        if vmware_software_version and not isinstance(vmware_software_version, str):
            raise TypeError("Expected argument 'vmware_software_version' to be a str")
        pulumi.set(__self__, "vmware_software_version", vmware_software_version)

    @property
    @pulumi.getter(name="billingContractEndDate")
    def billing_contract_end_date(self) -> str:
        """
        Current billing cycle end date. If the value in `currentSku` and `nextSku` are different, the value specified in `nextSku` becomes the new `currentSKU` when the `contractEndDate` is reached. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "billing_contract_end_date")

    @property
    @pulumi.getter(name="billingDonorHostId")
    def billing_donor_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deleted ESXi Host with LeftOver billing cycle.
        """
        warnings.warn("""This 'billing_donor_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
        pulumi.log.warn("""billing_donor_host_id is deprecated: This 'billing_donor_host_id' argument has been deprecated and will be computed only.""")

        return pulumi.get(self, "billing_donor_host_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the SDDC.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> str:
        """
        The availability domain of the ESXi host.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> str:
        """
        In terms of implementation, an ESXi host is a Compute instance that is configured with the chosen bundle of VMware software. The `computeInstanceId` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of that Compute instance.
        """
        return pulumi.get(self, "compute_instance_id")

    @property
    @pulumi.getter(name="currentSku")
    def current_sku(self) -> str:
        """
        (**Deprecated**) The billing option currently used by the ESXi host. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        warnings.warn("""The 'current_sku' field has been deprecated. It is no longer supported.""", DeprecationWarning)
        pulumi.log.warn("""current_sku is deprecated: The 'current_sku' field has been deprecated. It is no longer supported.""")

        return pulumi.get(self, "current_sku")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A descriptive name for the ESXi host. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostId")
    def esxi_host_id(self) -> str:
        return pulumi.get(self, "esxi_host_id")

    @property
    @pulumi.getter(name="failedEsxiHostId")
    def failed_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that failed.
        """
        warnings.warn("""This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
        pulumi.log.warn("""failed_esxi_host_id is deprecated: This 'failed_esxi_host_id' argument has been deprecated and will be computed only.""")

        return pulumi.get(self, "failed_esxi_host_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gracePeriodEndDate")
    def grace_period_end_date(self) -> str:
        """
        The date and time when the new esxi host should start billing cycle. [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2021-07-25T21:10:29.600Z`
        """
        return pulumi.get(self, "grace_period_end_date")

    @property
    @pulumi.getter(name="hostOcpuCount")
    def host_ocpu_count(self) -> float:
        """
        The OCPU count of the ESXi host.
        """
        return pulumi.get(self, "host_ocpu_count")

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> str:
        """
        The compute shape name of the ESXi host. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "host_shape_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBillingContinuationInProgress")
    def is_billing_continuation_in_progress(self) -> bool:
        """
        Indicates whether this host is in the progress of billing continuation.
        """
        return pulumi.get(self, "is_billing_continuation_in_progress")

    @property
    @pulumi.getter(name="isBillingSwappingInProgress")
    def is_billing_swapping_in_progress(self) -> bool:
        """
        Indicates whether this host is in the progress of swapping billing.
        """
        return pulumi.get(self, "is_billing_swapping_in_progress")

    @property
    @pulumi.getter(name="nextSku")
    def next_sku(self) -> str:
        """
        (**Deprecated**) The billing option to switch to after the current billing cycle ends. If `nextSku` is null or empty, `currentSku` continues to the next billing cycle. [ListSupportedSkus](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedSkuSummary/ListSupportedSkus).
        """
        warnings.warn("""The 'next_sku' field has been deprecated. It is no longer supported.""", DeprecationWarning)
        pulumi.log.warn("""next_sku is deprecated: The 'next_sku' field has been deprecated. It is no longer supported.""")

        return pulumi.get(self, "next_sku")

    @property
    @pulumi.getter(name="nonUpgradedEsxiHostId")
    def non_upgraded_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that will be upgraded.
        """
        warnings.warn("""This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""", DeprecationWarning)
        pulumi.log.warn("""non_upgraded_esxi_host_id is deprecated: This 'non_upgraded_esxi_host_id' argument has been deprecated and will be computed only.""")

        return pulumi.get(self, "non_upgraded_esxi_host_id")

    @property
    @pulumi.getter(name="replacementEsxiHostId")
    def replacement_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the esxi host that is newly created to replace the failed node.
        """
        return pulumi.get(self, "replacement_esxi_host_id")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> str:
        """
        (**Deprecated**) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the ESXi host belongs to.
        """
        warnings.warn("""The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""", DeprecationWarning)
        pulumi.log.warn("""sddc_id is deprecated: The 'sddc_id' field has been deprecated. Please use 'cluster_id' instead.""")

        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the ESXi host.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="swapBillingHostId")
    def swap_billing_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the active ESXi Host to swap billing with current host.
        """
        return pulumi.get(self, "swap_billing_host_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the ESXi host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the ESXi host was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradedReplacementEsxiHostId")
    def upgraded_replacement_esxi_host_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host that is newly created to upgrade the original host.
        """
        return pulumi.get(self, "upgraded_replacement_esxi_host_id")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> str:
        """
        The version of VMware software that Oracle Cloud VMware Solution installed on the ESXi hosts.
        """
        return pulumi.get(self, "vmware_software_version")


class AwaitableGetExsiHostResult(GetExsiHostResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExsiHostResult(
            billing_contract_end_date=self.billing_contract_end_date,
            billing_donor_host_id=self.billing_donor_host_id,
            capacity_reservation_id=self.capacity_reservation_id,
            compartment_id=self.compartment_id,
            compute_availability_domain=self.compute_availability_domain,
            compute_instance_id=self.compute_instance_id,
            current_sku=self.current_sku,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            esxi_host_id=self.esxi_host_id,
            failed_esxi_host_id=self.failed_esxi_host_id,
            freeform_tags=self.freeform_tags,
            grace_period_end_date=self.grace_period_end_date,
            host_ocpu_count=self.host_ocpu_count,
            host_shape_name=self.host_shape_name,
            id=self.id,
            is_billing_continuation_in_progress=self.is_billing_continuation_in_progress,
            is_billing_swapping_in_progress=self.is_billing_swapping_in_progress,
            next_sku=self.next_sku,
            non_upgraded_esxi_host_id=self.non_upgraded_esxi_host_id,
            replacement_esxi_host_id=self.replacement_esxi_host_id,
            sddc_id=self.sddc_id,
            state=self.state,
            swap_billing_host_id=self.swap_billing_host_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            upgraded_replacement_esxi_host_id=self.upgraded_replacement_esxi_host_id,
            vmware_software_version=self.vmware_software_version)


def get_exsi_host(esxi_host_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExsiHostResult:
    """
    This data source provides details about a specific Esxi Host resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Gets the specified ESXi host's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_esxi_host = oci.Ocvp.get_exsi_host(esxi_host_id=oci_ocvp_esxi_host["test_esxi_host"]["id"])
    ```


    :param str esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
    """
    __args__ = dict()
    __args__['esxiHostId'] = esxi_host_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getExsiHost:getExsiHost', __args__, opts=opts, typ=GetExsiHostResult).value

    return AwaitableGetExsiHostResult(
        billing_contract_end_date=pulumi.get(__ret__, 'billing_contract_end_date'),
        billing_donor_host_id=pulumi.get(__ret__, 'billing_donor_host_id'),
        capacity_reservation_id=pulumi.get(__ret__, 'capacity_reservation_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_availability_domain=pulumi.get(__ret__, 'compute_availability_domain'),
        compute_instance_id=pulumi.get(__ret__, 'compute_instance_id'),
        current_sku=pulumi.get(__ret__, 'current_sku'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        esxi_host_id=pulumi.get(__ret__, 'esxi_host_id'),
        failed_esxi_host_id=pulumi.get(__ret__, 'failed_esxi_host_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        grace_period_end_date=pulumi.get(__ret__, 'grace_period_end_date'),
        host_ocpu_count=pulumi.get(__ret__, 'host_ocpu_count'),
        host_shape_name=pulumi.get(__ret__, 'host_shape_name'),
        id=pulumi.get(__ret__, 'id'),
        is_billing_continuation_in_progress=pulumi.get(__ret__, 'is_billing_continuation_in_progress'),
        is_billing_swapping_in_progress=pulumi.get(__ret__, 'is_billing_swapping_in_progress'),
        next_sku=pulumi.get(__ret__, 'next_sku'),
        non_upgraded_esxi_host_id=pulumi.get(__ret__, 'non_upgraded_esxi_host_id'),
        replacement_esxi_host_id=pulumi.get(__ret__, 'replacement_esxi_host_id'),
        sddc_id=pulumi.get(__ret__, 'sddc_id'),
        state=pulumi.get(__ret__, 'state'),
        swap_billing_host_id=pulumi.get(__ret__, 'swap_billing_host_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        upgraded_replacement_esxi_host_id=pulumi.get(__ret__, 'upgraded_replacement_esxi_host_id'),
        vmware_software_version=pulumi.get(__ret__, 'vmware_software_version'))


@_utilities.lift_output_func(get_exsi_host)
def get_exsi_host_output(esxi_host_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExsiHostResult]:
    """
    This data source provides details about a specific Esxi Host resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Gets the specified ESXi host's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_esxi_host = oci.Ocvp.get_exsi_host(esxi_host_id=oci_ocvp_esxi_host["test_esxi_host"]["id"])
    ```


    :param str esxi_host_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ESXi host.
    """
    ...
