# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOdaPrivateEndpointsResult',
    'AwaitableGetOdaPrivateEndpointsResult',
    'get_oda_private_endpoints',
    'get_oda_private_endpoints_output',
]

@pulumi.output_type
class GetOdaPrivateEndpointsResult:
    """
    A collection of values returned by getOdaPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oda_private_endpoint_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oda_private_endpoint_collections and not isinstance(oda_private_endpoint_collections, list):
            raise TypeError("Expected argument 'oda_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "oda_private_endpoint_collections", oda_private_endpoint_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that the ODA private endpoint belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        User-defined name for the ODA private endpoint. Avoid entering confidential information. You can change this value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOdaPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="odaPrivateEndpointCollections")
    def oda_private_endpoint_collections(self) -> Sequence['outputs.GetOdaPrivateEndpointsOdaPrivateEndpointCollectionResult']:
        """
        The list of oda_private_endpoint_collection.
        """
        return pulumi.get(self, "oda_private_endpoint_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the ODA private endpoint.
        """
        return pulumi.get(self, "state")


class AwaitableGetOdaPrivateEndpointsResult(GetOdaPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOdaPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oda_private_endpoint_collections=self.oda_private_endpoint_collections,
            state=self.state)


def get_oda_private_endpoints(compartment_id: Optional[str] = None,
                              display_name: Optional[str] = None,
                              filters: Optional[Sequence[pulumi.InputType['GetOdaPrivateEndpointsFilterArgs']]] = None,
                              state: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOdaPrivateEndpointsResult:
    """
    This data source provides the list of Oda Private Endpoints in Oracle Cloud Infrastructure Digital Assistant service.

    Returns a page of ODA Private Endpoints that belong to the specified
    compartment.

    If the `opc-next-page` header appears in the response, then
    there are more items to retrieve. To get the next page in the subsequent
    GET request, include the header's value as the `page` query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_private_endpoints = oci.Oda.get_oda_private_endpoints(compartment_id=var["compartment_id"],
        display_name=var["oda_private_endpoint_display_name"],
        state=var["oda_private_endpoint_state"])
    ```


    :param str compartment_id: List the ODA Private Endpoints that belong to this compartment.
    :param str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
    :param str state: List only the ODA Private Endpoints that are in this lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Oda/getOdaPrivateEndpoints:getOdaPrivateEndpoints', __args__, opts=opts, typ=GetOdaPrivateEndpointsResult).value

    return AwaitableGetOdaPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oda_private_endpoint_collections=pulumi.get(__ret__, 'oda_private_endpoint_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_oda_private_endpoints)
def get_oda_private_endpoints_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOdaPrivateEndpointsFilterArgs']]]]] = None,
                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOdaPrivateEndpointsResult]:
    """
    This data source provides the list of Oda Private Endpoints in Oracle Cloud Infrastructure Digital Assistant service.

    Returns a page of ODA Private Endpoints that belong to the specified
    compartment.

    If the `opc-next-page` header appears in the response, then
    there are more items to retrieve. To get the next page in the subsequent
    GET request, include the header's value as the `page` query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_private_endpoints = oci.Oda.get_oda_private_endpoints(compartment_id=var["compartment_id"],
        display_name=var["oda_private_endpoint_display_name"],
        state=var["oda_private_endpoint_state"])
    ```


    :param str compartment_id: List the ODA Private Endpoints that belong to this compartment.
    :param str display_name: List only the information for the Digital Assistant instance with this user-friendly name. These names don't have to be unique and may change.  Example: `My new resource`
    :param str state: List only the ODA Private Endpoints that are in this lifecycle state.
    """
    ...
