# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExadataInsightArgs', 'ExadataInsight']

@pulumi.input_type
class ExadataInsightArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 entity_source: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 exadata_infra_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_sync_enabled: Optional[pulumi.Input[bool]] = None,
                 member_vm_cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExadataInsight resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[str] entity_source: Source of the database entity.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_auto_sync_enabled: (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "entity_source", entity_source)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if enterprise_manager_bridge_id is not None:
            pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if exadata_infra_id is not None:
            pulumi.set(__self__, "exadata_infra_id", exadata_infra_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_sync_enabled is not None:
            pulumi.set(__self__, "is_auto_sync_enabled", is_auto_sync_enabled)
        if member_vm_cluster_details is not None:
            pulumi.set(__self__, "member_vm_cluster_details", member_vm_cluster_details)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> pulumi.Input[str]:
        """
        Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[pulumi.Input[str]]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_bridge_id", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_identifier", value)

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_identifier", value)

    @property
    @pulumi.getter(name="exadataInfraId")
    def exadata_infra_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exadata_infra_id")

    @exadata_infra_id.setter
    def exadata_infra_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infra_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoSyncEnabled")
    def is_auto_sync_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        """
        return pulumi.get(self, "is_auto_sync_enabled")

    @is_auto_sync_enabled.setter
    def is_auto_sync_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_sync_enabled", value)

    @property
    @pulumi.getter(name="memberVmClusterDetails")
    def member_vm_cluster_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailArgs']]]]:
        return pulumi.get(self, "member_vm_cluster_details")

    @member_vm_cluster_details.setter
    def member_vm_cluster_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailArgs']]]]):
        pulumi.set(self, "member_vm_cluster_details", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ExadataInsightState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_display_name: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_name: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_type: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 exadata_display_name: Optional[pulumi.Input[str]] = None,
                 exadata_infra_id: Optional[pulumi.Input[str]] = None,
                 exadata_infra_resource_type: Optional[pulumi.Input[str]] = None,
                 exadata_name: Optional[pulumi.Input[str]] = None,
                 exadata_rack_type: Optional[pulumi.Input[str]] = None,
                 exadata_shape: Optional[pulumi.Input[str]] = None,
                 exadata_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_sync_enabled: Optional[pulumi.Input[bool]] = None,
                 is_virtualized_exadata: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 member_vm_cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExadataInsight resources.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_display_name: Enterprise Manager Entity Display Name
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_entity_name: Enterprise Manager Entity Name
        :param pulumi.Input[str] enterprise_manager_entity_type: Enterprise Manager Entity Type
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] entity_source: Source of the database entity.
        :param pulumi.Input[str] exadata_display_name: The user-friendly name for the Exadata system. The name does not have to be unique.
        :param pulumi.Input[str] exadata_name: The Exadata system name. If the Exadata systems managed by Enterprise Manager, the name is unique amongst the Exadata systems managed by the same Enterprise Manager.
        :param pulumi.Input[str] exadata_rack_type: Exadata rack type.
        :param pulumi.Input[str] exadata_type: Operations Insights internal representation of the the Exadata system type.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_auto_sync_enabled: (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        :param pulumi.Input[bool] is_virtualized_exadata: true if virtualization is used in the Exadata system
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] state: The current state of the Exadata insight.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the Exadata insight was first enabled. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Exadata insight was updated. An RFC3339 formatted datetime string
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if enterprise_manager_bridge_id is not None:
            pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_display_name is not None:
            pulumi.set(__self__, "enterprise_manager_entity_display_name", enterprise_manager_entity_display_name)
        if enterprise_manager_entity_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_entity_name is not None:
            pulumi.set(__self__, "enterprise_manager_entity_name", enterprise_manager_entity_name)
        if enterprise_manager_entity_type is not None:
            pulumi.set(__self__, "enterprise_manager_entity_type", enterprise_manager_entity_type)
        if enterprise_manager_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if entity_source is not None:
            pulumi.set(__self__, "entity_source", entity_source)
        if exadata_display_name is not None:
            pulumi.set(__self__, "exadata_display_name", exadata_display_name)
        if exadata_infra_id is not None:
            pulumi.set(__self__, "exadata_infra_id", exadata_infra_id)
        if exadata_infra_resource_type is not None:
            pulumi.set(__self__, "exadata_infra_resource_type", exadata_infra_resource_type)
        if exadata_name is not None:
            pulumi.set(__self__, "exadata_name", exadata_name)
        if exadata_rack_type is not None:
            pulumi.set(__self__, "exadata_rack_type", exadata_rack_type)
        if exadata_shape is not None:
            pulumi.set(__self__, "exadata_shape", exadata_shape)
        if exadata_type is not None:
            pulumi.set(__self__, "exadata_type", exadata_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_sync_enabled is not None:
            pulumi.set(__self__, "is_auto_sync_enabled", is_auto_sync_enabled)
        if is_virtualized_exadata is not None:
            pulumi.set(__self__, "is_virtualized_exadata", is_virtualized_exadata)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if member_vm_cluster_details is not None:
            pulumi.set(__self__, "member_vm_cluster_details", member_vm_cluster_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[pulumi.Input[str]]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_bridge_id", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @enterprise_manager_entity_display_name.setter
    def enterprise_manager_entity_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_display_name", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_identifier", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @enterprise_manager_entity_name.setter
    def enterprise_manager_entity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_name", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @enterprise_manager_entity_type.setter
    def enterprise_manager_entity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_type", value)

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_identifier", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> Optional[pulumi.Input[str]]:
        """
        Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="exadataDisplayName")
    def exadata_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the Exadata system. The name does not have to be unique.
        """
        return pulumi.get(self, "exadata_display_name")

    @exadata_display_name.setter
    def exadata_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_display_name", value)

    @property
    @pulumi.getter(name="exadataInfraId")
    def exadata_infra_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exadata_infra_id")

    @exadata_infra_id.setter
    def exadata_infra_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infra_id", value)

    @property
    @pulumi.getter(name="exadataInfraResourceType")
    def exadata_infra_resource_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exadata_infra_resource_type")

    @exadata_infra_resource_type.setter
    def exadata_infra_resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infra_resource_type", value)

    @property
    @pulumi.getter(name="exadataName")
    def exadata_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Exadata system name. If the Exadata systems managed by Enterprise Manager, the name is unique amongst the Exadata systems managed by the same Enterprise Manager.
        """
        return pulumi.get(self, "exadata_name")

    @exadata_name.setter
    def exadata_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_name", value)

    @property
    @pulumi.getter(name="exadataRackType")
    def exadata_rack_type(self) -> Optional[pulumi.Input[str]]:
        """
        Exadata rack type.
        """
        return pulumi.get(self, "exadata_rack_type")

    @exadata_rack_type.setter
    def exadata_rack_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_rack_type", value)

    @property
    @pulumi.getter(name="exadataShape")
    def exadata_shape(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exadata_shape")

    @exadata_shape.setter
    def exadata_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_shape", value)

    @property
    @pulumi.getter(name="exadataType")
    def exadata_type(self) -> Optional[pulumi.Input[str]]:
        """
        Operations Insights internal representation of the the Exadata system type.
        """
        return pulumi.get(self, "exadata_type")

    @exadata_type.setter
    def exadata_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoSyncEnabled")
    def is_auto_sync_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        """
        return pulumi.get(self, "is_auto_sync_enabled")

    @is_auto_sync_enabled.setter
    def is_auto_sync_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_sync_enabled", value)

    @property
    @pulumi.getter(name="isVirtualizedExadata")
    def is_virtualized_exadata(self) -> Optional[pulumi.Input[bool]]:
        """
        true if virtualization is used in the Exadata system
        """
        return pulumi.get(self, "is_virtualized_exadata")

    @is_virtualized_exadata.setter
    def is_virtualized_exadata(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_virtualized_exadata", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="memberVmClusterDetails")
    def member_vm_cluster_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailArgs']]]]:
        return pulumi.get(self, "member_vm_cluster_details")

    @member_vm_cluster_details.setter
    def member_vm_cluster_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInsightMemberVmClusterDetailArgs']]]]):
        pulumi.set(self, "member_vm_cluster_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Exadata insight.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the Exadata insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Exadata insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class ExadataInsight(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 exadata_infra_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_sync_enabled: Optional[pulumi.Input[bool]] = None,
                 member_vm_cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInsightMemberVmClusterDetailArgs']]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Exadata Insight resource in Oracle Cloud Infrastructure Opsi service.

        Create an Exadata insight resource for an Exadata system in Operations Insights. The Exadata system will be enabled in Operations Insights. Exadata-related metric collection and analysis will be started.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_insight = oci.opsi.ExadataInsight("testExadataInsight",
            compartment_id=var["compartment_id"],
            enterprise_manager_bridge_id=oci_opsi_enterprise_manager_bridge["test_enterprise_manager_bridge"]["id"],
            enterprise_manager_entity_identifier=var["exadata_insight_enterprise_manager_entity_identifier"],
            enterprise_manager_identifier=var["exadata_insight_enterprise_manager_identifier"],
            entity_source=var["exadata_insight_entity_source"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_auto_sync_enabled=var["exadata_insight_is_auto_sync_enabled"],
            member_vm_cluster_details=[oci.opsi.ExadataInsightMemberVmClusterDetailArgs(
                compartment_id=var["compartment_id"],
                dbm_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                member_database_details=[oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs(
                    compartment_id=var["compartment_id"],
                    connection_details=oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs(
                        hosts=[oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs(
                            host_ip=var["exadata_insight_member_vm_cluster_details_member_database_details_connection_details_hosts_host_ip"],
                            port=var["exadata_insight_member_vm_cluster_details_member_database_details_connection_details_hosts_port"],
                        )],
                        protocol=var["exadata_insight_member_vm_cluster_details_member_database_details_connection_details_protocol"],
                        service_name=oci_core_service["test_service"]["name"],
                    ),
                    credential_details=oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs(
                        credential_type=var["exadata_insight_member_vm_cluster_details_member_database_details_credential_details_credential_type"],
                        credential_source_name=var["exadata_insight_member_vm_cluster_details_member_database_details_credential_details_credential_source_name"],
                        password_secret_id=oci_vault_secret["test_secret"]["id"],
                        role=var["exadata_insight_member_vm_cluster_details_member_database_details_credential_details_role"],
                        user_name=oci_identity_user["test_user"]["name"],
                        wallet_secret_id=oci_vault_secret["test_secret"]["id"],
                    ),
                    database_id=oci_database_database["test_database"]["id"],
                    database_resource_type=var["exadata_insight_member_vm_cluster_details_member_database_details_database_resource_type"],
                    dbm_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                    defined_tags=var["exadata_insight_member_vm_cluster_details_member_database_details_defined_tags"],
                    deployment_type=var["exadata_insight_member_vm_cluster_details_member_database_details_deployment_type"],
                    entity_source=var["exadata_insight_member_vm_cluster_details_member_database_details_entity_source"],
                    freeform_tags=var["exadata_insight_member_vm_cluster_details_member_database_details_freeform_tags"],
                    opsi_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                    service_name=oci_core_service["test_service"]["name"],
                    system_tags=var["exadata_insight_member_vm_cluster_details_member_database_details_system_tags"],
                )],
                opsi_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                vmcluster_id=oci_opsi_vmcluster["test_vmcluster"]["id"],
            )])
        ```

        ## Import

        ExadataInsights can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Opsi/exadataInsight:ExadataInsight test_exadata_insight "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] entity_source: Source of the database entity.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_auto_sync_enabled: (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExadataInsightArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Exadata Insight resource in Oracle Cloud Infrastructure Opsi service.

        Create an Exadata insight resource for an Exadata system in Operations Insights. The Exadata system will be enabled in Operations Insights. Exadata-related metric collection and analysis will be started.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exadata_insight = oci.opsi.ExadataInsight("testExadataInsight",
            compartment_id=var["compartment_id"],
            enterprise_manager_bridge_id=oci_opsi_enterprise_manager_bridge["test_enterprise_manager_bridge"]["id"],
            enterprise_manager_entity_identifier=var["exadata_insight_enterprise_manager_entity_identifier"],
            enterprise_manager_identifier=var["exadata_insight_enterprise_manager_identifier"],
            entity_source=var["exadata_insight_entity_source"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            is_auto_sync_enabled=var["exadata_insight_is_auto_sync_enabled"],
            member_vm_cluster_details=[oci.opsi.ExadataInsightMemberVmClusterDetailArgs(
                compartment_id=var["compartment_id"],
                dbm_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                member_database_details=[oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailArgs(
                    compartment_id=var["compartment_id"],
                    connection_details=oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsArgs(
                        hosts=[oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailConnectionDetailsHostArgs(
                            host_ip=var["exadata_insight_member_vm_cluster_details_member_database_details_connection_details_hosts_host_ip"],
                            port=var["exadata_insight_member_vm_cluster_details_member_database_details_connection_details_hosts_port"],
                        )],
                        protocol=var["exadata_insight_member_vm_cluster_details_member_database_details_connection_details_protocol"],
                        service_name=oci_core_service["test_service"]["name"],
                    ),
                    credential_details=oci.opsi.ExadataInsightMemberVmClusterDetailMemberDatabaseDetailCredentialDetailsArgs(
                        credential_type=var["exadata_insight_member_vm_cluster_details_member_database_details_credential_details_credential_type"],
                        credential_source_name=var["exadata_insight_member_vm_cluster_details_member_database_details_credential_details_credential_source_name"],
                        password_secret_id=oci_vault_secret["test_secret"]["id"],
                        role=var["exadata_insight_member_vm_cluster_details_member_database_details_credential_details_role"],
                        user_name=oci_identity_user["test_user"]["name"],
                        wallet_secret_id=oci_vault_secret["test_secret"]["id"],
                    ),
                    database_id=oci_database_database["test_database"]["id"],
                    database_resource_type=var["exadata_insight_member_vm_cluster_details_member_database_details_database_resource_type"],
                    dbm_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                    defined_tags=var["exadata_insight_member_vm_cluster_details_member_database_details_defined_tags"],
                    deployment_type=var["exadata_insight_member_vm_cluster_details_member_database_details_deployment_type"],
                    entity_source=var["exadata_insight_member_vm_cluster_details_member_database_details_entity_source"],
                    freeform_tags=var["exadata_insight_member_vm_cluster_details_member_database_details_freeform_tags"],
                    opsi_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                    service_name=oci_core_service["test_service"]["name"],
                    system_tags=var["exadata_insight_member_vm_cluster_details_member_database_details_system_tags"],
                )],
                opsi_private_endpoint_id=oci_dataflow_private_endpoint["test_private_endpoint"]["id"],
                vmcluster_id=oci_opsi_vmcluster["test_vmcluster"]["id"],
            )])
        ```

        ## Import

        ExadataInsights can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Opsi/exadataInsight:ExadataInsight test_exadata_insight "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExadataInsightArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExadataInsightArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 exadata_infra_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_sync_enabled: Optional[pulumi.Input[bool]] = None,
                 member_vm_cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInsightMemberVmClusterDetailArgs']]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExadataInsightArgs.__new__(ExadataInsightArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["enterprise_manager_bridge_id"] = enterprise_manager_bridge_id
            __props__.__dict__["enterprise_manager_entity_identifier"] = enterprise_manager_entity_identifier
            __props__.__dict__["enterprise_manager_identifier"] = enterprise_manager_identifier
            if entity_source is None and not opts.urn:
                raise TypeError("Missing required property 'entity_source'")
            __props__.__dict__["entity_source"] = entity_source
            __props__.__dict__["exadata_infra_id"] = exadata_infra_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_sync_enabled"] = is_auto_sync_enabled
            __props__.__dict__["member_vm_cluster_details"] = member_vm_cluster_details
            __props__.__dict__["status"] = status
            __props__.__dict__["enterprise_manager_entity_display_name"] = None
            __props__.__dict__["enterprise_manager_entity_name"] = None
            __props__.__dict__["enterprise_manager_entity_type"] = None
            __props__.__dict__["exadata_display_name"] = None
            __props__.__dict__["exadata_infra_resource_type"] = None
            __props__.__dict__["exadata_name"] = None
            __props__.__dict__["exadata_rack_type"] = None
            __props__.__dict__["exadata_shape"] = None
            __props__.__dict__["exadata_type"] = None
            __props__.__dict__["is_virtualized_exadata"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ExadataInsight, __self__).__init__(
            'oci:Opsi/exadataInsight:ExadataInsight',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_display_name: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_name: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_type: Optional[pulumi.Input[str]] = None,
            enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
            entity_source: Optional[pulumi.Input[str]] = None,
            exadata_display_name: Optional[pulumi.Input[str]] = None,
            exadata_infra_id: Optional[pulumi.Input[str]] = None,
            exadata_infra_resource_type: Optional[pulumi.Input[str]] = None,
            exadata_name: Optional[pulumi.Input[str]] = None,
            exadata_rack_type: Optional[pulumi.Input[str]] = None,
            exadata_shape: Optional[pulumi.Input[str]] = None,
            exadata_type: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_auto_sync_enabled: Optional[pulumi.Input[bool]] = None,
            is_virtualized_exadata: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            member_vm_cluster_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExadataInsightMemberVmClusterDetailArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'ExadataInsight':
        """
        Get an existing ExadataInsight resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_display_name: Enterprise Manager Entity Display Name
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_entity_name: Enterprise Manager Entity Name
        :param pulumi.Input[str] enterprise_manager_entity_type: Enterprise Manager Entity Type
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] entity_source: Source of the database entity.
        :param pulumi.Input[str] exadata_display_name: The user-friendly name for the Exadata system. The name does not have to be unique.
        :param pulumi.Input[str] exadata_name: The Exadata system name. If the Exadata systems managed by Enterprise Manager, the name is unique amongst the Exadata systems managed by the same Enterprise Manager.
        :param pulumi.Input[str] exadata_rack_type: Exadata rack type.
        :param pulumi.Input[str] exadata_type: Operations Insights internal representation of the the Exadata system type.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_auto_sync_enabled: (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        :param pulumi.Input[bool] is_virtualized_exadata: true if virtualization is used in the Exadata system
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] state: The current state of the Exadata insight.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the Exadata insight was first enabled. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Exadata insight was updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExadataInsightState.__new__(_ExadataInsightState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["enterprise_manager_bridge_id"] = enterprise_manager_bridge_id
        __props__.__dict__["enterprise_manager_entity_display_name"] = enterprise_manager_entity_display_name
        __props__.__dict__["enterprise_manager_entity_identifier"] = enterprise_manager_entity_identifier
        __props__.__dict__["enterprise_manager_entity_name"] = enterprise_manager_entity_name
        __props__.__dict__["enterprise_manager_entity_type"] = enterprise_manager_entity_type
        __props__.__dict__["enterprise_manager_identifier"] = enterprise_manager_identifier
        __props__.__dict__["entity_source"] = entity_source
        __props__.__dict__["exadata_display_name"] = exadata_display_name
        __props__.__dict__["exadata_infra_id"] = exadata_infra_id
        __props__.__dict__["exadata_infra_resource_type"] = exadata_infra_resource_type
        __props__.__dict__["exadata_name"] = exadata_name
        __props__.__dict__["exadata_rack_type"] = exadata_rack_type
        __props__.__dict__["exadata_shape"] = exadata_shape
        __props__.__dict__["exadata_type"] = exadata_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_sync_enabled"] = is_auto_sync_enabled
        __props__.__dict__["is_virtualized_exadata"] = is_virtualized_exadata
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["member_vm_cluster_details"] = member_vm_cluster_details
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ExadataInsight(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> pulumi.Output[str]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> pulumi.Output[str]:
        """
        Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @property
    @pulumi.getter(name="exadataDisplayName")
    def exadata_display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the Exadata system. The name does not have to be unique.
        """
        return pulumi.get(self, "exadata_display_name")

    @property
    @pulumi.getter(name="exadataInfraId")
    def exadata_infra_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "exadata_infra_id")

    @property
    @pulumi.getter(name="exadataInfraResourceType")
    def exadata_infra_resource_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "exadata_infra_resource_type")

    @property
    @pulumi.getter(name="exadataName")
    def exadata_name(self) -> pulumi.Output[str]:
        """
        The Exadata system name. If the Exadata systems managed by Enterprise Manager, the name is unique amongst the Exadata systems managed by the same Enterprise Manager.
        """
        return pulumi.get(self, "exadata_name")

    @property
    @pulumi.getter(name="exadataRackType")
    def exadata_rack_type(self) -> pulumi.Output[str]:
        """
        Exadata rack type.
        """
        return pulumi.get(self, "exadata_rack_type")

    @property
    @pulumi.getter(name="exadataShape")
    def exadata_shape(self) -> pulumi.Output[str]:
        return pulumi.get(self, "exadata_shape")

    @property
    @pulumi.getter(name="exadataType")
    def exadata_type(self) -> pulumi.Output[str]:
        """
        Operations Insights internal representation of the the Exadata system type.
        """
        return pulumi.get(self, "exadata_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAutoSyncEnabled")
    def is_auto_sync_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to enable automatic enablement and disablement of related targets from Enterprise Manager. New resources (e.g. Database Insights) will be placed in the same compartment as the related Exadata Insight.
        """
        return pulumi.get(self, "is_auto_sync_enabled")

    @property
    @pulumi.getter(name="isVirtualizedExadata")
    def is_virtualized_exadata(self) -> pulumi.Output[bool]:
        """
        true if virtualization is used in the Exadata system
        """
        return pulumi.get(self, "is_virtualized_exadata")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="memberVmClusterDetails")
    def member_vm_cluster_details(self) -> pulumi.Output[Sequence['outputs.ExadataInsightMemberVmClusterDetail']]:
        return pulumi.get(self, "member_vm_cluster_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Exadata insight.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the Exadata insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the Exadata insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

