# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedInstanceGroupsResult',
    'AwaitableGetManagedInstanceGroupsResult',
    'get_managed_instance_groups',
    'get_managed_instance_groups_output',
]

@pulumi.output_type
class GetManagedInstanceGroupsResult:
    """
    A collection of values returned by getManagedInstanceGroups.
    """
    def __init__(__self__, arch_type=None, compartment_id=None, display_name_contains=None, display_names=None, filters=None, id=None, managed_instance_group_collections=None, managed_instance_group_id=None, os_family=None, software_source_id=None, state=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_group_collections and not isinstance(managed_instance_group_collections, list):
            raise TypeError("Expected argument 'managed_instance_group_collections' to be a list")
        pulumi.set(__self__, "managed_instance_group_collections", managed_instance_group_collections)
        if managed_instance_group_id and not isinstance(managed_instance_group_id, str):
            raise TypeError("Expected argument 'managed_instance_group_id' to be a str")
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[str]:
        """
        The CPU architecture of the instances in the managed instance group.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the tenancy containing the managed instance group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedInstanceGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceGroupCollections")
    def managed_instance_group_collections(self) -> Sequence['outputs.GetManagedInstanceGroupsManagedInstanceGroupCollectionResult']:
        """
        The list of managed_instance_group_collection.
        """
        return pulumi.get(self, "managed_instance_group_collections")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[str]:
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[str]:
        """
        The operating system type of the instances in the managed instance group.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> Optional[str]:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the managed instance group.
        """
        return pulumi.get(self, "state")


class AwaitableGetManagedInstanceGroupsResult(GetManagedInstanceGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedInstanceGroupsResult(
            arch_type=self.arch_type,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            managed_instance_group_collections=self.managed_instance_group_collections,
            managed_instance_group_id=self.managed_instance_group_id,
            os_family=self.os_family,
            software_source_id=self.software_source_id,
            state=self.state)


def get_managed_instance_groups(arch_type: Optional[str] = None,
                                compartment_id: Optional[str] = None,
                                display_name_contains: Optional[str] = None,
                                display_names: Optional[Sequence[str]] = None,
                                filters: Optional[Sequence[pulumi.InputType['GetManagedInstanceGroupsFilterArgs']]] = None,
                                managed_instance_group_id: Optional[str] = None,
                                os_family: Optional[str] = None,
                                software_source_id: Optional[str] = None,
                                state: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedInstanceGroupsResult:
    """
    This data source provides the list of Managed Instance Groups in Oracle Cloud Infrastructure Os Management Hub service.

    Lists managed instance groups that match the specified compartment or managed instance group OCID. Filter the
    list against a variety of criteria including but not limited to its name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_groups = oci.OsManagementHub.get_managed_instance_groups(arch_type=var["managed_instance_group_arch_type"],
        compartment_id=var["compartment_id"],
        display_names=var["managed_instance_group_display_name"],
        display_name_contains=var["managed_instance_group_display_name_contains"],
        managed_instance_group_id=oci_os_management_hub_managed_instance_group["test_managed_instance_group"]["id"],
        os_family=var["managed_instance_group_os_family"],
        software_source_id=oci_os_management_hub_software_source["test_software_source"]["id"],
        state=var["managed_instance_group_state"])
    ```


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: The OCID of the compartment that contains the resources to list.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str managed_instance_group_id: The OCID of the managed instance group for which to list resources.
    :param str os_family: A filter to return only profiles that match the given osFamily.
    :param str software_source_id: The OCID for the software source.
    :param str state: A filter to return only resources their lifecycle state matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['archType'] = arch_type
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['managedInstanceGroupId'] = managed_instance_group_id
    __args__['osFamily'] = os_family
    __args__['softwareSourceId'] = software_source_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagedInstanceGroups:getManagedInstanceGroups', __args__, opts=opts, typ=GetManagedInstanceGroupsResult).value

    return AwaitableGetManagedInstanceGroupsResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_group_collections=pulumi.get(__ret__, 'managed_instance_group_collections'),
        managed_instance_group_id=pulumi.get(__ret__, 'managed_instance_group_id'),
        os_family=pulumi.get(__ret__, 'os_family'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_managed_instance_groups)
def get_managed_instance_groups_output(arch_type: Optional[pulumi.Input[Optional[str]]] = None,
                                       compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                       display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagedInstanceGroupsFilterArgs']]]]] = None,
                                       managed_instance_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       os_family: Optional[pulumi.Input[Optional[str]]] = None,
                                       software_source_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedInstanceGroupsResult]:
    """
    This data source provides the list of Managed Instance Groups in Oracle Cloud Infrastructure Os Management Hub service.

    Lists managed instance groups that match the specified compartment or managed instance group OCID. Filter the
    list against a variety of criteria including but not limited to its name, status, architecture, and OS family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_instance_groups = oci.OsManagementHub.get_managed_instance_groups(arch_type=var["managed_instance_group_arch_type"],
        compartment_id=var["compartment_id"],
        display_names=var["managed_instance_group_display_name"],
        display_name_contains=var["managed_instance_group_display_name_contains"],
        managed_instance_group_id=oci_os_management_hub_managed_instance_group["test_managed_instance_group"]["id"],
        os_family=var["managed_instance_group_os_family"],
        software_source_id=oci_os_management_hub_software_source["test_software_source"]["id"],
        state=var["managed_instance_group_state"])
    ```


    :param str arch_type: A filter to return only profiles that match the given archType.
    :param str compartment_id: The OCID of the compartment that contains the resources to list.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] display_names: A filter to return resources that match the given display names.
    :param str managed_instance_group_id: The OCID of the managed instance group for which to list resources.
    :param str os_family: A filter to return only profiles that match the given osFamily.
    :param str software_source_id: The OCID for the software source.
    :param str state: A filter to return only resources their lifecycle state matches the given lifecycle state.
    """
    ...
