# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetStreamResult',
    'AwaitableGetStreamResult',
    'get_stream',
    'get_stream_output',
]

@pulumi.output_type
class GetStreamResult:
    """
    A collection of values returned by getStream.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, freeform_tags=None, id=None, lifecycle_state_details=None, messages_endpoint=None, name=None, partitions=None, retention_in_hours=None, state=None, stream_id=None, stream_pool_id=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if messages_endpoint and not isinstance(messages_endpoint, str):
            raise TypeError("Expected argument 'messages_endpoint' to be a str")
        pulumi.set(__self__, "messages_endpoint", messages_endpoint)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partitions and not isinstance(partitions, int):
            raise TypeError("Expected argument 'partitions' to be a int")
        pulumi.set(__self__, "partitions", partitions)
        if retention_in_hours and not isinstance(retention_in_hours, int):
            raise TypeError("Expected argument 'retention_in_hours' to be a int")
        pulumi.set(__self__, "retention_in_hours", retention_in_hours)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_id and not isinstance(stream_id, str):
            raise TypeError("Expected argument 'stream_id' to be a str")
        pulumi.set(__self__, "stream_id", stream_id)
        if stream_pool_id and not isinstance(stream_pool_id, str):
            raise TypeError("Expected argument 'stream_pool_id' to be a str")
        pulumi.set(__self__, "stream_pool_id", stream_pool_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the stream.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> str:
        """
        The endpoint to use when creating the StreamClient to consume or publish messages in the stream. If the associated stream pool is private, the endpoint is also private and can only be accessed from inside the stream pool's associated subnet.
        """
        return pulumi.get(self, "messages_endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the stream. Avoid entering confidential information.  Example: `TelemetryEvents`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> int:
        """
        The number of partitions in the stream.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> int:
        """
        The retention period of the stream, in hours. This property is read-only.
        """
        return pulumi.get(self, "retention_in_hours")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> str:
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> str:
        """
        The OCID of the stream pool that contains the stream.
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the stream was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetStreamResult(GetStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_state_details=self.lifecycle_state_details,
            messages_endpoint=self.messages_endpoint,
            name=self.name,
            partitions=self.partitions,
            retention_in_hours=self.retention_in_hours,
            state=self.state,
            stream_id=self.stream_id,
            stream_pool_id=self.stream_pool_id,
            time_created=self.time_created)


def get_stream(stream_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamResult:
    """
    This data source provides details about a specific Stream resource in Oracle Cloud Infrastructure Streaming service.

    Gets detailed information about a stream, including the number of partitions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream = oci.Streaming.get_stream(stream_id=oci_streaming_stream["test_stream"]["id"])
    ```


    :param str stream_id: The OCID of the stream.
    """
    __args__ = dict()
    __args__['streamId'] = stream_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getStream:getStream', __args__, opts=opts, typ=GetStreamResult).value

    return AwaitableGetStreamResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        messages_endpoint=pulumi.get(__ret__, 'messages_endpoint'),
        name=pulumi.get(__ret__, 'name'),
        partitions=pulumi.get(__ret__, 'partitions'),
        retention_in_hours=pulumi.get(__ret__, 'retention_in_hours'),
        state=pulumi.get(__ret__, 'state'),
        stream_id=pulumi.get(__ret__, 'stream_id'),
        stream_pool_id=pulumi.get(__ret__, 'stream_pool_id'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_stream)
def get_stream_output(stream_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamResult]:
    """
    This data source provides details about a specific Stream resource in Oracle Cloud Infrastructure Streaming service.

    Gets detailed information about a stream, including the number of partitions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream = oci.Streaming.get_stream(stream_id=oci_streaming_stream["test_stream"]["id"])
    ```


    :param str stream_id: The OCID of the stream.
    """
    ...
