# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.table_hardlink_column_type import TableHardlinkColumnType
from vrt_lss_studio.models.table_hardlink_filter_list import TableHardlinkFilterList
from vrt_lss_studio.models.table_hardlink_list import TableHardlinkList
from vrt_lss_studio.models.web_hardlink import WebHardlink

from vrt_lss_studio.api_client import ApiClient
from vrt_lss_studio.api_response import ApiResponse
from vrt_lss_studio.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HardlinksApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_hardlink(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_hardlink : Annotated[WebHardlink, Field(description="New essence creation request.")], **kwargs) -> WebHardlink:  # noqa: E501
        """Create hardlink  # noqa: E501

        Create new hardlink.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_hardlink(experiment_key, web_hardlink, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_hardlink: New essence creation request. (required)
        :type web_hardlink: WebHardlink
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebHardlink
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_hardlink_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_hardlink_with_http_info(experiment_key, web_hardlink, **kwargs)  # noqa: E501

    @validate_arguments
    def create_hardlink_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_hardlink : Annotated[WebHardlink, Field(description="New essence creation request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create hardlink  # noqa: E501

        Create new hardlink.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_hardlink_with_http_info(experiment_key, web_hardlink, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_hardlink: New essence creation request. (required)
        :type web_hardlink: WebHardlink
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebHardlink, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_hardlink'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hardlink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_hardlink'] is not None:
            _body_params = _params['web_hardlink']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '201': "WebHardlink",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_hardlink(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> None:  # noqa: E501
        """Remove hardlink  # noqa: E501

        Removing a essence by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_hardlink(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_hardlink_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_hardlink_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_hardlink_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Remove hardlink  # noqa: E501

        Removing a essence by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_hardlink_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hardlink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks/{essence_key}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def disable_hardlinks(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Disable hardlinks request.")], **kwargs) -> None:  # noqa: E501
        """Disable hardlinks  # noqa: E501

        Disable hardlinks in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_hardlinks(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Disable hardlinks request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the disable_hardlinks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.disable_hardlinks_with_http_info(experiment_key, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def disable_hardlinks_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Disable hardlinks request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Disable hardlinks  # noqa: E501

        Disable hardlinks in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_hardlinks_with_http_info(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Disable hardlinks request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_hardlinks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks/batch/ability', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def enable_hardlinks(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Enable hardlinks request.")], **kwargs) -> None:  # noqa: E501
        """Enable hardlinks  # noqa: E501

        Enable hardlinks in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_hardlinks(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Enable hardlinks request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the enable_hardlinks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.enable_hardlinks_with_http_info(experiment_key, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def enable_hardlinks_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Enable hardlinks request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Enable hardlinks  # noqa: E501

        Enable hardlinks in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_hardlinks_with_http_info(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Enable hardlinks request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_hardlinks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks/batch/ability', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_hardlink(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> WebHardlink:  # noqa: E501
        """Read hardlink  # noqa: E501

        Getting hardlink information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_hardlink(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebHardlink
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_hardlink_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_hardlink_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def read_hardlink_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read hardlink  # noqa: E501

        Getting hardlink information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_hardlink_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebHardlink, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_hardlink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebHardlink",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks/{essence_key}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_hardlinks(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableHardlinkColumnType], Field(description="Hardlink table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_hardlink_filter_list : Annotated[Optional[TableHardlinkFilterList], Field(description="Hardlinks filter.")] = None, **kwargs) -> TableHardlinkList:  # noqa: E501
        """List hardlinks  # noqa: E501

        Getting a hardlinks list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_hardlinks(experiment_key, offset, limit, sort_field, sort_direction, table_hardlink_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Hardlink table column name. 
        :type sort_field: TableHardlinkColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_hardlink_filter_list: Hardlinks filter.
        :type table_hardlink_filter_list: TableHardlinkFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableHardlinkList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_hardlinks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_hardlinks_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_hardlink_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_hardlinks_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableHardlinkColumnType], Field(description="Hardlink table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_hardlink_filter_list : Annotated[Optional[TableHardlinkFilterList], Field(description="Hardlinks filter.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List hardlinks  # noqa: E501

        Getting a hardlinks list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_hardlinks_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_hardlink_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Hardlink table column name. 
        :type sort_field: TableHardlinkColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_hardlink_filter_list: Hardlinks filter.
        :type table_hardlink_filter_list: TableHardlinkFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TableHardlinkList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'offset',
            'limit',
            'sort_field',
            'sort_direction',
            'table_hardlink_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_hardlinks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sort_field', _params['sort_field'].value))

        if _params.get('sort_direction') is not None:  # noqa: E501
            _query_params.append(('sort_direction', _params['sort_direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_hardlink_filter_list'] is not None:
            _body_params = _params['table_hardlink_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "TableHardlinkList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks/batch/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_hardlink(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_hardlink : Annotated[WebHardlink, Field(description="Essence update request.")], **kwargs) -> WebHardlink:  # noqa: E501
        """Update hardlink  # noqa: E501

        Updating the hardlink by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_hardlink(experiment_key, web_hardlink, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_hardlink: Essence update request. (required)
        :type web_hardlink: WebHardlink
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebHardlink
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_hardlink_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_hardlink_with_http_info(experiment_key, web_hardlink, **kwargs)  # noqa: E501

    @validate_arguments
    def update_hardlink_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_hardlink : Annotated[WebHardlink, Field(description="Essence update request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update hardlink  # noqa: E501

        Updating the hardlink by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_hardlink_with_http_info(experiment_key, web_hardlink, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_hardlink: Essence update request. (required)
        :type web_hardlink: WebHardlink
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebHardlink, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_hardlink'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hardlink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_hardlink'] is not None:
            _body_params = _params['web_hardlink']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebHardlink",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/hardlinks', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
