# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.table_transport_column_type import TableTransportColumnType
from vrt_lss_studio.models.table_transport_filter_list import TableTransportFilterList
from vrt_lss_studio.models.table_transport_list import TableTransportList
from vrt_lss_studio.models.web_transport import WebTransport
from vrt_lss_studio.models.web_transport_geopoint_list import WebTransportGeopointList

from vrt_lss_studio.api_client import ApiClient
from vrt_lss_studio.api_response import ApiResponse
from vrt_lss_studio.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TransportsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_transport(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_transport : Annotated[WebTransport, Field(description="New essence creation request.")], **kwargs) -> WebTransport:  # noqa: E501
        """Create transport  # noqa: E501

        New essences creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transport(experiment_key, web_transport, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_transport: New essence creation request. (required)
        :type web_transport: WebTransport
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTransport
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_transport_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_transport_with_http_info(experiment_key, web_transport, **kwargs)  # noqa: E501

    @validate_arguments
    def create_transport_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_transport : Annotated[WebTransport, Field(description="New essence creation request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create transport  # noqa: E501

        New essences creation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transport_with_http_info(experiment_key, web_transport, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_transport: New essence creation request. (required)
        :type web_transport: WebTransport
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTransport, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_transport'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transport" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_transport'] is not None:
            _body_params = _params['web_transport']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '201': "WebTransport",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_transport(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> None:  # noqa: E501
        """Remove transport  # noqa: E501

        Removing a transport by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transport(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_transport_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_transport_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_transport_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Remove transport  # noqa: E501

        Removing a transport by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transport_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transport" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports/{essence_key}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def disable_transports(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Disable transports request.")], **kwargs) -> None:  # noqa: E501
        """Disable transports  # noqa: E501

        Disable transports in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_transports(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Disable transports request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the disable_transports_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.disable_transports_with_http_info(experiment_key, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def disable_transports_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Disable transports request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Disable transports  # noqa: E501

        Disable transports in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_transports_with_http_info(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Disable transports request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_transports" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports/batch/ability', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def enable_transports(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Enable transports request.")], **kwargs) -> None:  # noqa: E501
        """Enable transports  # noqa: E501

        Enable transports in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_transports(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Enable transports request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the enable_transports_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.enable_transports_with_http_info(experiment_key, request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def enable_transports_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], request_body : Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001, description="Enable transports request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Enable transports  # noqa: E501

        Enable transports in the calculation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_transports_with_http_info(experiment_key, request_body, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param request_body: Enable transports request. (required)
        :type request_body: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_transports" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['request_body'] is not None:
            _body_params = _params['request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports/batch/ability', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_transport(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> WebTransport:  # noqa: E501
        """Reading transport  # noqa: E501

        Getting transport information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transport(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTransport
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_transport_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_transport_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def read_transport_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], essence_key : Annotated[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(description="Key, unique identifier.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Reading transport  # noqa: E501

        Getting transport information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transport_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTransport, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_transport" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTransport",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports/{essence_key}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_transports(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableTransportColumnType], Field(description="Transport table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_transport_filter_list : Annotated[Optional[TableTransportFilterList], Field(description="Transport filter.")] = None, **kwargs) -> TableTransportList:  # noqa: E501
        """Transport list  # noqa: E501

        Getting a transport list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transports(experiment_key, offset, limit, sort_field, sort_direction, table_transport_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Transport table column name. 
        :type sort_field: TableTransportColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_transport_filter_list: Transport filter.
        :type table_transport_filter_list: TableTransportFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableTransportList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_transports_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_transports_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_transport_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_transports_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableTransportColumnType], Field(description="Transport table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_transport_filter_list : Annotated[Optional[TableTransportFilterList], Field(description="Transport filter.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Transport list  # noqa: E501

        Getting a transport list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transports_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_transport_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Transport table column name. 
        :type sort_field: TableTransportColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_transport_filter_list: Transport filter.
        :type table_transport_filter_list: TableTransportFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TableTransportList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'offset',
            'limit',
            'sort_field',
            'sort_direction',
            'table_transport_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_transports" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sort_field', _params['sort_field'].value))

        if _params.get('sort_direction') is not None:  # noqa: E501
            _query_params.append(('sort_direction', _params['sort_direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_transport_filter_list'] is not None:
            _body_params = _params['table_transport_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "TableTransportList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports/batch/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_transports_geopoints(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, table_transport_filter_list : Annotated[Optional[TableTransportFilterList], Field(description="Transports filter.")] = None, **kwargs) -> WebTransportGeopointList:  # noqa: E501
        """Transport geopoints  # noqa: E501

        Getting a geopoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transports_geopoints(experiment_key, offset, limit, table_transport_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param table_transport_filter_list: Transports filter.
        :type table_transport_filter_list: TableTransportFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTransportGeopointList
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_transports_geopoints_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_transports_geopoints_with_http_info(experiment_key, offset, limit, table_transport_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_transports_geopoints_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], offset : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=0)]], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[Annotated[int, Field(le=10000000, strict=True, ge=1)]], Field(description="The number of items to return.")] = None, table_transport_filter_list : Annotated[Optional[TableTransportFilterList], Field(description="Transports filter.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Transport geopoints  # noqa: E501

        Getting a geopoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transports_geopoints_with_http_info(experiment_key, offset, limit, table_transport_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param table_transport_filter_list: Transports filter.
        :type table_transport_filter_list: TableTransportFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTransportGeopointList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'offset',
            'limit',
            'table_transport_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_transports_geopoints" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_transport_filter_list'] is not None:
            _body_params = _params['table_transport_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTransportGeopointList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports/batch/geopoints', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_transport(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_transport : Annotated[WebTransport, Field(description="Essence update request.")], **kwargs) -> WebTransport:  # noqa: E501
        """Update transport  # noqa: E501

        Updating the essence by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transport(experiment_key, web_transport, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_transport: Essence update request. (required)
        :type web_transport: WebTransport
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebTransport
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_transport_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_transport_with_http_info(experiment_key, web_transport, **kwargs)  # noqa: E501

    @validate_arguments
    def update_transport_with_http_info(self, experiment_key : Annotated[StrictStr, Field(description="Key, unique identifier.")], web_transport : Annotated[WebTransport, Field(description="Essence update request.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update transport  # noqa: E501

        Updating the essence by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transport_with_http_info(experiment_key, web_transport, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_transport: Essence update request. (required)
        :type web_transport: WebTransport
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebTransport, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_transport'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transport" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_transport'] is not None:
            _body_params = _params['web_transport']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebTransport",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/transports', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
