# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.cargo import Cargo
from vrt_lss_studio.models.demand import Demand
from vrt_lss_studio.models.order_compatibilities import OrderCompatibilities

class Order(BaseModel):
    """
    The order for delivery/transportation, contains a list of demands.  # noqa: E501
    """
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Order key, unique identifier.")
    demands: Annotated[List[Demand], Field(min_length=1, max_length=1000)] = Field(description="Demands list.")
    cargos: Optional[Annotated[List[Cargo], Field(min_length=0, max_length=1000)]] = Field(default=None, description="The list of cargoes referred to by the demands of this order. The list must be empty if all demands in the order are of type `WORK`. ")
    compatibilities: Optional[OrderCompatibilities] = None
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties = ["key", "demands", "cargos", "compatibilities", "attributes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Order:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in demands (list)
        _items = []
        if self.demands:
            for _item in self.demands:
                if _item:
                    _items.append(_item.to_dict())
            _dict['demands'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cargos (list)
        _items = []
        if self.cargos:
            for _item in self.cargos:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cargos'] = _items
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if compatibilities (nullable) is None
        # and __fields_set__ contains the field
        if self.compatibilities is None and "compatibilities" in self.__fields_set__:
            _dict['compatibilities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Order:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Order.parse_obj(obj)

        _obj = Order.parse_obj({
            "key": obj.get("key"),
            "demands": [Demand.from_dict(_item) for _item in obj.get("demands")] if obj.get("demands") is not None else None,
            "cargos": [Cargo.from_dict(_item) for _item in obj.get("cargos")] if obj.get("cargos") is not None else None,
            "compatibilities": OrderCompatibilities.from_dict(obj.get("compatibilities")) if obj.get("compatibilities") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj


