# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.performer_tariff import PerformerTariff
from vrt_lss_studio.models.time_window import TimeWindow
from vrt_lss_studio.models.work_and_rest_rules import WorkAndRestRules

class PerformerShift(BaseModel):
    """
    Performer's shift that determines the availability of the resource for planning within its time window.   # noqa: E501
    """
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Shift key, unique identifier.")
    availability_time: Optional[TimeWindow]
    working_time: Optional[TimeWindow]
    start_location_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Start location key.  If not specified, the trip starts from the first order location. ")
    finish_location_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Finish location key.  If not specified, the trip finishes on the last order location. ")
    max_locations: Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]] = Field(default=None, description="Limit of the number of unique locations in one trip. If not specified or null, number of locations is not limited. ")
    max_stops: Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]] = Field(default=None, description="Limit of the number of stops in one trip. If not specified or null, number of stops is not limited. ")
    tariff: Optional[PerformerTariff] = None
    work_and_rest_rules: Optional[WorkAndRestRules] = None
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties = ["key", "availability_time", "working_time", "start_location_key", "finish_location_key", "max_locations", "max_stops", "tariff", "work_and_rest_rules", "attributes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PerformerShift:
        """Create an instance of PerformerShift from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of availability_time
        if self.availability_time:
            _dict['availability_time'] = self.availability_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of working_time
        if self.working_time:
            _dict['working_time'] = self.working_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tariff
        if self.tariff:
            _dict['tariff'] = self.tariff.to_dict()
        # override the default output from pydantic by calling `to_dict()` of work_and_rest_rules
        if self.work_and_rest_rules:
            _dict['work_and_rest_rules'] = self.work_and_rest_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if availability_time (nullable) is None
        # and __fields_set__ contains the field
        if self.availability_time is None and "availability_time" in self.__fields_set__:
            _dict['availability_time'] = None

        # set to None if working_time (nullable) is None
        # and __fields_set__ contains the field
        if self.working_time is None and "working_time" in self.__fields_set__:
            _dict['working_time'] = None

        # set to None if start_location_key (nullable) is None
        # and __fields_set__ contains the field
        if self.start_location_key is None and "start_location_key" in self.__fields_set__:
            _dict['start_location_key'] = None

        # set to None if finish_location_key (nullable) is None
        # and __fields_set__ contains the field
        if self.finish_location_key is None and "finish_location_key" in self.__fields_set__:
            _dict['finish_location_key'] = None

        # set to None if max_locations (nullable) is None
        # and __fields_set__ contains the field
        if self.max_locations is None and "max_locations" in self.__fields_set__:
            _dict['max_locations'] = None

        # set to None if max_stops (nullable) is None
        # and __fields_set__ contains the field
        if self.max_stops is None and "max_stops" in self.__fields_set__:
            _dict['max_stops'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PerformerShift:
        """Create an instance of PerformerShift from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PerformerShift.parse_obj(obj)

        _obj = PerformerShift.parse_obj({
            "key": obj.get("key"),
            "availability_time": TimeWindow.from_dict(obj.get("availability_time")) if obj.get("availability_time") is not None else None,
            "working_time": TimeWindow.from_dict(obj.get("working_time")) if obj.get("working_time") is not None else None,
            "start_location_key": obj.get("start_location_key"),
            "finish_location_key": obj.get("finish_location_key"),
            "max_locations": obj.get("max_locations"),
            "max_stops": obj.get("max_stops"),
            "tariff": PerformerTariff.from_dict(obj.get("tariff")) if obj.get("tariff") is not None else None,
            "work_and_rest_rules": WorkAndRestRules.from_dict(obj.get("work_and_rest_rules")) if obj.get("work_and_rest_rules") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj


