# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json





class TableFilterDurationRange(BaseModel):
    """
    Duration range.  # noqa: E501
    """
    var_from: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ", alias="from")
    to: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    __properties = ["from", "to"]

    @validator('var_from')
    def var_from_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @validator('to')
    def to_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableFilterDurationRange:
        """Create an instance of TableFilterDurationRange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableFilterDurationRange:
        """Create an instance of TableFilterDurationRange from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TableFilterDurationRange.parse_obj(obj)

        _obj = TableFilterDurationRange.parse_obj({
            "var_from": obj.get("from") if obj.get("from") is not None else 'PT0S',
            "to": obj.get("to") if obj.get("to") is not None else 'PT0S'
        })
        return _obj


