# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from vrt_lss_studio.models.basic_state import BasicState
from vrt_lss_studio.models.basic_time_window import BasicTimeWindow
from vrt_lss_studio.models.cargo_rotation_type import CargoRotationType

class TableOrderFields(BaseModel):
    """
    Order\\demand fields for table.  # noqa: E501
    """
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field(default='ORDER', description="Essence type.")
    enabled: Optional[StrictBool] = Field(default=True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(default=True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    state: Optional[BasicState] = None
    type: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Order\\demand type.")
    hard_time_window: Optional[BasicTimeWindow] = None
    soft_time_window: Optional[BasicTimeWindow] = None
    general_drop_time_window: Optional[BasicTimeWindow] = None
    general_pickup_time_window: Optional[BasicTimeWindow] = None
    general_work_time_window: Optional[BasicTimeWindow] = None
    reward: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=0, description="The total reward for orders fulfillment.")
    mass: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Weight in kilograms.")
    volume: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Volume in cubic meters.")
    capacity_a: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Additional capacity parameter (A) for measuring cargoes and compartments in alternative units. For example, to account for cargo in pieces (this parameter is equal to one for a cargo and the maximum number of cargo to hold for a compartment). ")
    capacity_b: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Additional capacity parameter (B) for measuring cargoes and compartments in alternative units. ")
    capacity_c: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Additional capacity parameter (C) for measuring cargoes and compartments in alternative units. ")
    order_features: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    order_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    performer_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    performer_blacklist: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    width: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Width in meters, used to check the transport box capacity.")
    height: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Height in meters, used to check the transport box capacity.")
    length: Optional[Union[Annotated[float, Field(le=1000000, strict=True, ge=0)], Annotated[int, Field(le=1000000, strict=True, ge=0)]]] = Field(default=0, description="Length in meters, used to check the transport box capacity.")
    rotation: Optional[Annotated[List[CargoRotationType], Field(min_length=0, max_length=4)]] = Field(default=None, description="List of possibilities of a object rotations (90 degree step):   * `ALL` - can rotate by any axis   * `YAW` - can yaw   * `PITCH` - can pitch   * `ROLL` - can roll  Empty list means object rotations is prohibited.  More about [cargo placement](#section/Description/Cargo-placement).")
    box_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    cargo_features: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    cargo_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    demands_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="Demands count.")
    trip_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    attributes: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1000000)]] = Field(default='', description="Attributes.")
    __properties = ["essence_key", "essence_type", "enabled", "pristine", "state", "type", "hard_time_window", "soft_time_window", "general_drop_time_window", "general_pickup_time_window", "general_work_time_window", "reward", "mass", "volume", "capacity_a", "capacity_b", "capacity_c", "order_features", "order_restrictions", "performer_restrictions", "performer_blacklist", "width", "height", "length", "rotation", "box_restrictions", "cargo_features", "cargo_restrictions", "demands_count", "trip_key", "trip_name", "attributes"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ORDER', 'DEMAND'):
            raise ValueError("must be one of enum values ('ORDER', 'DEMAND')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableOrderFields:
        """Create an instance of TableOrderFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of hard_time_window
        if self.hard_time_window:
            _dict['hard_time_window'] = self.hard_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of soft_time_window
        if self.soft_time_window:
            _dict['soft_time_window'] = self.soft_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of general_drop_time_window
        if self.general_drop_time_window:
            _dict['general_drop_time_window'] = self.general_drop_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of general_pickup_time_window
        if self.general_pickup_time_window:
            _dict['general_pickup_time_window'] = self.general_pickup_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of general_work_time_window
        if self.general_work_time_window:
            _dict['general_work_time_window'] = self.general_work_time_window.to_dict()
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if hard_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.hard_time_window is None and "hard_time_window" in self.__fields_set__:
            _dict['hard_time_window'] = None

        # set to None if soft_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.soft_time_window is None and "soft_time_window" in self.__fields_set__:
            _dict['soft_time_window'] = None

        # set to None if general_drop_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.general_drop_time_window is None and "general_drop_time_window" in self.__fields_set__:
            _dict['general_drop_time_window'] = None

        # set to None if general_pickup_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.general_pickup_time_window is None and "general_pickup_time_window" in self.__fields_set__:
            _dict['general_pickup_time_window'] = None

        # set to None if general_work_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.general_work_time_window is None and "general_work_time_window" in self.__fields_set__:
            _dict['general_work_time_window'] = None

        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableOrderFields:
        """Create an instance of TableOrderFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TableOrderFields.parse_obj(obj)

        _obj = TableOrderFields.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'ORDER',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "state": obj.get("state"),
            "type": obj.get("type"),
            "hard_time_window": BasicTimeWindow.from_dict(obj.get("hard_time_window")) if obj.get("hard_time_window") is not None else None,
            "soft_time_window": BasicTimeWindow.from_dict(obj.get("soft_time_window")) if obj.get("soft_time_window") is not None else None,
            "general_drop_time_window": BasicTimeWindow.from_dict(obj.get("general_drop_time_window")) if obj.get("general_drop_time_window") is not None else None,
            "general_pickup_time_window": BasicTimeWindow.from_dict(obj.get("general_pickup_time_window")) if obj.get("general_pickup_time_window") is not None else None,
            "general_work_time_window": BasicTimeWindow.from_dict(obj.get("general_work_time_window")) if obj.get("general_work_time_window") is not None else None,
            "reward": obj.get("reward") if obj.get("reward") is not None else 0,
            "mass": obj.get("mass") if obj.get("mass") is not None else 0,
            "volume": obj.get("volume") if obj.get("volume") is not None else 0,
            "capacity_a": obj.get("capacity_a") if obj.get("capacity_a") is not None else 0,
            "capacity_b": obj.get("capacity_b") if obj.get("capacity_b") is not None else 0,
            "capacity_c": obj.get("capacity_c") if obj.get("capacity_c") is not None else 0,
            "order_features": obj.get("order_features"),
            "order_restrictions": obj.get("order_restrictions"),
            "performer_restrictions": obj.get("performer_restrictions"),
            "performer_blacklist": obj.get("performer_blacklist"),
            "width": obj.get("width") if obj.get("width") is not None else 0,
            "height": obj.get("height") if obj.get("height") is not None else 0,
            "length": obj.get("length") if obj.get("length") is not None else 0,
            "rotation": obj.get("rotation"),
            "box_restrictions": obj.get("box_restrictions"),
            "cargo_features": obj.get("cargo_features"),
            "cargo_restrictions": obj.get("cargo_restrictions"),
            "demands_count": obj.get("demands_count") if obj.get("demands_count") is not None else 0,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else ''
        })
        return _obj


