# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from vrt_lss_studio.models.basic_time_window import BasicTimeWindow

class TablePerformerFields(BaseModel):
    """
    Performer and shift fields for table.  # noqa: E501
    """
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field(default='PERFORMER', description="Essence type.")
    enabled: Optional[StrictBool] = Field(default=True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(default=True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    working_time: Optional[BasicTimeWindow] = None
    availability_time: Optional[BasicTimeWindow] = None
    trip_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    location_keys: Optional[Annotated[List[Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]]], Field(min_length=0, max_length=15001)]] = Field(default=None, description="A list of keys.")
    trips_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="The number of trips in which the performer participates (for a shift - 0 or 1).")
    attributes: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=1000000)]] = Field(default='', description="Attributes.")
    __properties = ["essence_key", "essence_type", "enabled", "pristine", "working_time", "availability_time", "trip_key", "trip_name", "location_keys", "trips_count", "attributes"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PERFORMER', 'SHIFT'):
            raise ValueError("must be one of enum values ('PERFORMER', 'SHIFT')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TablePerformerFields:
        """Create an instance of TablePerformerFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of working_time
        if self.working_time:
            _dict['working_time'] = self.working_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of availability_time
        if self.availability_time:
            _dict['availability_time'] = self.availability_time.to_dict()
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        # set to None if working_time (nullable) is None
        # and __fields_set__ contains the field
        if self.working_time is None and "working_time" in self.__fields_set__:
            _dict['working_time'] = None

        # set to None if availability_time (nullable) is None
        # and __fields_set__ contains the field
        if self.availability_time is None and "availability_time" in self.__fields_set__:
            _dict['availability_time'] = None

        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TablePerformerFields:
        """Create an instance of TablePerformerFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TablePerformerFields.parse_obj(obj)

        _obj = TablePerformerFields.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'PERFORMER',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "working_time": BasicTimeWindow.from_dict(obj.get("working_time")) if obj.get("working_time") is not None else None,
            "availability_time": BasicTimeWindow.from_dict(obj.get("availability_time")) if obj.get("availability_time") is not None else None,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "location_keys": obj.get("location_keys"),
            "trips_count": obj.get("trips_count") if obj.get("trips_count") is not None else 0,
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else ''
        })
        return _obj


