# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from vrt_lss_studio.models.linked_essence import LinkedEssence
from vrt_lss_studio.models.location import Location
from vrt_lss_studio.models.table_location_fields import TableLocationFields

class WebLocation(BaseModel):
    """
    Web location.  # noqa: E501
    """
    location: Location
    fields: Optional[TableLocationFields] = None
    linked_essences: Optional[Annotated[List[LinkedEssence], Field(min_length=0, max_length=15001)]] = Field(default=None, description="A list of linked essences.")
    __properties = ["location", "fields", "linked_essences"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebLocation:
        """Create an instance of WebLocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fields
        if self.fields:
            _dict['fields'] = self.fields.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in linked_essences (list)
        _items = []
        if self.linked_essences:
            for _item in self.linked_essences:
                if _item:
                    _items.append(_item.to_dict())
            _dict['linked_essences'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebLocation:
        """Create an instance of WebLocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WebLocation.parse_obj(obj)

        _obj = WebLocation.parse_obj({
            "location": Location.from_dict(obj.get("location")) if obj.get("location") is not None else None,
            "fields": TableLocationFields.from_dict(obj.get("fields")) if obj.get("fields") is not None else None,
            "linked_essences": [LinkedEssence.from_dict(_item) for _item in obj.get("linked_essences")] if obj.get("linked_essences") is not None else None
        })
        return _obj


