# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.20.2252
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from vrt_lss_studio.models.geopoint import Geopoint

class WebPerformerGeopoint(BaseModel):
    """
    Geopoint for map.  # noqa: E501
    """
    geopoint: Geopoint
    performer_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's key.")
    shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Shift key, unique identifier.")
    point_type: StrictStr = Field(description="The point type.")
    trip_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    stop_number: Optional[Annotated[int, Field(le=1000, strict=True, ge=0)]] = Field(default=0, description="Sequence number of the stop in the trip.")
    __properties = ["geopoint", "performer_key", "shift_key", "point_type", "trip_key", "trip_name", "stop_number"]

    @validator('point_type')
    def point_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('START', 'FINISH'):
            raise ValueError("must be one of enum values ('START', 'FINISH')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebPerformerGeopoint:
        """Create an instance of WebPerformerGeopoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebPerformerGeopoint:
        """Create an instance of WebPerformerGeopoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WebPerformerGeopoint.parse_obj(obj)

        _obj = WebPerformerGeopoint.parse_obj({
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "performer_key": obj.get("performer_key"),
            "shift_key": obj.get("shift_key"),
            "point_type": obj.get("point_type"),
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "stop_number": obj.get("stop_number") if obj.get("stop_number") is not None else 0
        })
        return _obj


