"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import ondewo.nlu.common_pb2
import ondewo.nlu.intent_pb2
import ondewo.nlu.project_role_pb2
import ondewo.nlu.user_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AgentView:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _AgentViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AgentView.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AGENT_VIEW_UNSPECIFIED: _AgentView.ValueType  # 0
    """Unspecified agent view: the view is defined by the call:
    - CreateAgent: AGENT_VIEW_SHALLOW
    - UpdateAgent: AGENT_VIEW_SHALLOW
    - GetAgent: AGENT_VIEW_FULL
    - ListAgents: AGENT_VIEW_SHALLOW
    """

    AGENT_VIEW_FULL: _AgentView.ValueType  # 1
    """Full agent view: populate all the fields of the Agent message including configs."""

    AGENT_VIEW_SHALLOW: _AgentView.ValueType  # 2
    """Shallow agent view: populates all the fields except configs."""

    AGENT_VIEW_MINIMUM: _AgentView.ValueType  # 3
    """Minimum view including only agent UUID and agent display name"""

class AgentView(_AgentView, metaclass=_AgentViewEnumTypeWrapper):
    pass

AGENT_VIEW_UNSPECIFIED: AgentView.ValueType  # 0
"""Unspecified agent view: the view is defined by the call:
- CreateAgent: AGENT_VIEW_SHALLOW
- UpdateAgent: AGENT_VIEW_SHALLOW
- GetAgent: AGENT_VIEW_FULL
- ListAgents: AGENT_VIEW_SHALLOW
"""

AGENT_VIEW_FULL: AgentView.ValueType  # 1
"""Full agent view: populate all the fields of the Agent message including configs."""

AGENT_VIEW_SHALLOW: AgentView.ValueType  # 2
"""Shallow agent view: populates all the fields except configs."""

AGENT_VIEW_MINIMUM: AgentView.ValueType  # 3
"""Minimum view including only agent UUID and agent display name"""

global___AgentView = AgentView


class _InitiationProtocol:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _InitiationProtocolEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InitiationProtocol.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AS_SOON_AS_POSSIBLE: _InitiationProtocol.ValueType  # 0
    """after cache successfully built and after each model trained the agent will be updated"""

    WHEN_TRAINED: _InitiationProtocol.ValueType  # 1
    """after cache successfully built and all the active models successfully trained"""

    NEVER: _InitiationProtocol.ValueType  # 2
    """do not initiate"""

class InitiationProtocol(_InitiationProtocol, metaclass=_InitiationProtocolEnumTypeWrapper):
    """Defines when to initiate newly created agent when training started"""
    pass

AS_SOON_AS_POSSIBLE: InitiationProtocol.ValueType  # 0
"""after cache successfully built and after each model trained the agent will be updated"""

WHEN_TRAINED: InitiationProtocol.ValueType  # 1
"""after cache successfully built and all the active models successfully trained"""

NEVER: InitiationProtocol.ValueType  # 2
"""do not initiate"""

global___InitiationProtocol = InitiationProtocol


class _ReportType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ReportTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReportType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ALL: _ReportType.ValueType  # 0
    """will return all reports as files of specified format compressed into a single zipfile"""

    INTENT_PER_LANGUAGE: _ReportType.ValueType  # 1
    """statistics of the language specific part of the intent database"""

    ENTITY_PER_LANGUAGE: _ReportType.ValueType  # 2
    """statistics of the language specific part of the entity database"""

    ENTITY_COLLISION: _ReportType.ValueType  # 3
    """report on collision of the entity synonyms"""

    INTENT_GENERAL: _ReportType.ValueType  # 4
    """report of statistics of the general (relevant to all supported languages) part of intent database"""

class ReportType(_ReportType, metaclass=_ReportTypeEnumTypeWrapper):
    pass

ALL: ReportType.ValueType  # 0
"""will return all reports as files of specified format compressed into a single zipfile"""

INTENT_PER_LANGUAGE: ReportType.ValueType  # 1
"""statistics of the language specific part of the intent database"""

ENTITY_PER_LANGUAGE: ReportType.ValueType  # 2
"""statistics of the language specific part of the entity database"""

ENTITY_COLLISION: ReportType.ValueType  # 3
"""report on collision of the entity synonyms"""

INTENT_GENERAL: ReportType.ValueType  # 4
"""report of statistics of the general (relevant to all supported languages) part of intent database"""

global___ReportType = ReportType


class _ReportFormat:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ReportFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReportFormat.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CSV: _ReportFormat.ValueType  # 0
    HTML: _ReportFormat.ValueType  # 1
    JSON: _ReportFormat.ValueType  # 2
class ReportFormat(_ReportFormat, metaclass=_ReportFormatEnumTypeWrapper):
    pass

CSV: ReportFormat.ValueType  # 0
HTML: ReportFormat.ValueType  # 1
JSON: ReportFormat.ValueType  # 2
global___ReportFormat = ReportFormat


class _AgentStatus:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _AgentStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AgentStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ACTIVE: _AgentStatus.ValueType  # 0
    """If project is active, all its endpoints are active"""

    INACTIVE: _AgentStatus.ValueType  # 1
    """If project is inactive:
    * members of the project do not see the project anymore except users with project role "PROJECT_ADMIN" and users with server role "SERVER_ADMIN"
    * nothing is allowed (no endpoint) on the project except "SetAgentStatus" by PROJECT_ADMIN or SERVER_ADMIN
    """

class AgentStatus(_AgentStatus, metaclass=_AgentStatusEnumTypeWrapper):
    """fixme: add endpoint to set agent owner

    """
    pass

ACTIVE: AgentStatus.ValueType  # 0
"""If project is active, all its endpoints are active"""

INACTIVE: AgentStatus.ValueType  # 1
"""If project is inactive:
* members of the project do not see the project anymore except users with project role "PROJECT_ADMIN" and users with server role "SERVER_ADMIN"
* nothing is allowed (no endpoint) on the project except "SetAgentStatus" by PROJECT_ADMIN or SERVER_ADMIN
"""

global___AgentStatus = AgentStatus


class Agent(google.protobuf.message.Message):
    """Project/Agent messages"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    DEFAULT_LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    TIME_ZONE_FIELD_NUMBER: builtins.int
    NLU_PLATFORM_FIELD_NUMBER: builtins.int
    CONFIGS_FIELD_NUMBER: builtins.int
    OWNER_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project of this agent.
    Format: `projects/<Project ID>/agent`.
    Read-only in the Agent message
    """

    display_name: typing.Text
    """Required. The name of this agent."""

    default_language_code: typing.Text
    """Required. The default language of the agent as a language tag. See
    [Language Support](https://dialogflow.com/docs/reference/language) for a
    list of the currently supported language codes.
    This field cannot be set by the `Update` method.
    """

    @property
    def supported_language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. The list of all languages supported by this agent (except for the
        `default_language_code`).
        """
        pass
    time_zone: typing.Text
    """Required. The time zone of this agent from the
    [time zone database](https://www.iana.org/time-zones), e.g.,
    America/New_York, Europe/Paris.
    """

    nlu_platform: typing.Text
    """Required. Specifies the format of the agent data."""

    @property
    def configs(self) -> google.protobuf.struct_pb2.Struct:
        """Optional. Agent configuration as OndewoConfig converted to Struct format."""
        pass
    owner_id: typing.Text
    """Optional. User id of the project owner. If empty, in CreateAgent call it is set to user id in the call
    metadata.
    Read-only in the Agent message
    """

    status: global___AgentStatus.ValueType
    """Optional. Status of the agent
    Read-only in the Agent message
    """

    description: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        display_name: typing.Text = ...,
        default_language_code: typing.Text = ...,
        supported_language_codes: typing.Optional[typing.Iterable[typing.Text]] = ...,
        time_zone: typing.Text = ...,
        nlu_platform: typing.Text = ...,
        configs: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        owner_id: typing.Text = ...,
        status: global___AgentStatus.ValueType = ...,
        description: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["configs",b"configs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["configs",b"configs","default_language_code",b"default_language_code","description",b"description","display_name",b"display_name","nlu_platform",b"nlu_platform","owner_id",b"owner_id","parent",b"parent","status",b"status","supported_language_codes",b"supported_language_codes","time_zone",b"time_zone"]) -> None: ...
global___Agent = Agent

class AgentWithOwner(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    @property
    def agent(self) -> global___Agent: ...
    @property
    def owner(self) -> ondewo.nlu.user_pb2.User: ...
    def __init__(self,
        *,
        agent: typing.Optional[global___Agent] = ...,
        owner: typing.Optional[ondewo.nlu.user_pb2.User] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent","owner",b"owner"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","owner",b"owner"]) -> None: ...
global___AgentWithOwner = AgentWithOwner

class AgentOfUserWithOwner(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_WITH_OWNER_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_FIELD_NUMBER: builtins.int
    @property
    def agent_with_owner(self) -> global___AgentWithOwner:
        """Required. Agent message and User message of its owner."""
        pass
    @property
    def project_role(self) -> ondewo.nlu.project_role_pb2.ProjectRole:
        """Required. The role of the user in the project in SHALLOW view (only ID and name fields are populated)"""
        pass
    def __init__(self,
        *,
        agent_with_owner: typing.Optional[global___AgentWithOwner] = ...,
        project_role: typing.Optional[ondewo.nlu.project_role_pb2.ProjectRole] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_with_owner",b"agent_with_owner","project_role",b"project_role"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_with_owner",b"agent_with_owner","project_role",b"project_role"]) -> None: ...
global___AgentOfUserWithOwner = AgentOfUserWithOwner

class CreateAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    @property
    def agent(self) -> global___Agent: ...
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (sparse view by default)"""

    def __init__(self,
        *,
        agent: typing.Optional[global___Agent] = ...,
        agent_view: global___AgentView.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_view",b"agent_view"]) -> None: ...
global___CreateAgentRequest = CreateAgentRequest

class UpdateAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def agent(self) -> global___Agent: ...
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (sparse view by default)"""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Optional. The mask to control which fields get updated."""
        pass
    def __init__(self,
        *,
        agent: typing.Optional[global___Agent] = ...,
        agent_view: global___AgentView.ValueType = ...,
        update_mask: typing.Optional[google.protobuf.field_mask_pb2.FieldMask] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent","update_mask",b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_view",b"agent_view","update_mask",b"update_mask"]) -> None: ...
global___UpdateAgentRequest = UpdateAgentRequest

class DeleteAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    parent: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent"]) -> None: ...
global___DeleteAgentRequest = DeleteAgentRequest

class GetAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.GetAgent][google.cloud.dialogflow.v2.Agents.GetAgent]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to fetch is associated with.
    Format: `projects/<Project ID>/agents`.
    """

    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (full view by default)"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        agent_view: global___AgentView.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_view",b"agent_view","parent",b"parent"]) -> None: ...
global___GetAgentRequest = GetAgentRequest

class ListAgentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    SORT_BY_FIELD_FIELD_NUMBER: builtins.int
    agent_view: global___AgentView.ValueType
    """Optional. Specify the view of the returned agent (full view by default)"""

    page_token: typing.Text
    """Optional. The next_page_token value returned from a previous list request."""

    @property
    def sort_by_field(self) -> global___AgentSorting:
        """Optional. Defines the sorting of the list. Default, no sorting."""
        pass
    def __init__(self,
        *,
        agent_view: global___AgentView.ValueType = ...,
        page_token: typing.Text = ...,
        sort_by_field: typing.Optional[global___AgentSorting] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["sort_by_field",b"sort_by_field"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_view",b"agent_view","page_token",b"page_token","sort_by_field",b"sort_by_field"]) -> None: ...
global___ListAgentsRequest = ListAgentsRequest

class ListAgentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENTS_WITH_OWNERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def agents_with_owners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AgentWithOwner]:
        """The list of agent and their owners. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
        pass
    next_page_token: typing.Text
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """

    def __init__(self,
        *,
        agents_with_owners: typing.Optional[typing.Iterable[global___AgentWithOwner]] = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agents_with_owners",b"agents_with_owners","next_page_token",b"next_page_token"]) -> None: ...
global___ListAgentsResponse = ListAgentsResponse

class ListAgentsOfUserResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENTS_OF_USER_WITH_OWNERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def agents_of_user_with_owners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AgentOfUserWithOwner]:
        """The list of agents with their owners of the given user. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
        pass
    next_page_token: typing.Text
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """

    def __init__(self,
        *,
        agents_of_user_with_owners: typing.Optional[typing.Iterable[global___AgentOfUserWithOwner]] = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agents_of_user_with_owners",b"agents_of_user_with_owners","next_page_token",b"next_page_token"]) -> None: ...
global___ListAgentsOfUserResponse = ListAgentsOfUserResponse

class TrainAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    INITIATION_PROTOCOL_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to train is associated with.
    Format: `projects/<Project ID>`.
    """

    branch: typing.Text
    initiation_protocol: global___InitiationProtocol.ValueType
    def __init__(self,
        *,
        parent: typing.Text = ...,
        branch: typing.Text = ...,
        initiation_protocol: global___InitiationProtocol.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch",b"branch","initiation_protocol",b"initiation_protocol","parent",b"parent"]) -> None: ...
global___TrainAgentRequest = TrainAgentRequest

class BuildCacheRequest(google.protobuf.message.Message):
    """The request message for [Agents.TrainAgentBuildCache][google.cloud.dialogflow.v2.Agents.BuildCache]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to build cache is associated with.
    Format: `projects/<Project ID>`.
    """

    branch: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        branch: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch",b"branch","parent",b"parent"]) -> None: ...
global___BuildCacheRequest = BuildCacheRequest

class ExportAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.ExportAgent][google.cloud.dialogflow.v2.Agents.ExportAgent]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    AGENT_URI_FIELD_NUMBER: builtins.int
    COMPRESSION_LEVEL_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to export is associated with.
    Format: `projects/<Project ID>`.
    """

    agent_uri: typing.Text
    """Optional. The Google Cloud Storage URI to export the agent to.
    Note: The URI must start with
    "gs://". If left unspecified, the serialized agent is returned inline.
    """

    compression_level: builtins.int
    """Optional. The compression level of the zip file created.
    Valid range 1-9; the grpc-default value 0 will be mapped to 1,
    other values cause an error in the request validation handler.
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        agent_uri: typing.Text = ...,
        compression_level: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_uri",b"agent_uri","compression_level",b"compression_level","parent",b"parent"]) -> None: ...
global___ExportAgentRequest = ExportAgentRequest

class ExportAgentResponse(google.protobuf.message.Message):
    """The response message for [Agents.ExportAgent][google.cloud.dialogflow.v2.Agents.ExportAgent]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AGENT_URI_FIELD_NUMBER: builtins.int
    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    agent_uri: typing.Text
    """The URI to a file containing the exported agent. This field is populated
    only if `agent_uri` is specified in `ExportAgentRequest`.
    """

    agent_content: builtins.bytes
    """The exported agent.

    Example for how to export an agent to a zip file via a command line:

    curl \\
      'https://dialogflow.googleapis.com/v2/projects/<project_name>/agent:export'\\
      -X POST \\
      -H 'Authorization: Bearer '$(gcloud auth print-access-token) \\
      -H 'Accept: application/json' \\
      -H 'Content-Type: application/json' \\
      --compressed \\
      --data-binary '{}' \\
    | grep agentContent | sed -e 's/.*"agentContent": "\\([^"]*\\)".*/\\1/' \\
    | base64 --decode > <agent zip file>
    """

    def __init__(self,
        *,
        agent_uri: typing.Text = ...,
        agent_content: builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_content",b"agent_content","agent_uri",b"agent_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_content",b"agent_content","agent_uri",b"agent_uri"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["agent",b"agent"]) -> typing.Optional[typing_extensions.Literal["agent_uri","agent_content"]]: ...
global___ExportAgentResponse = ExportAgentResponse

class ExportBenchmarkAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    COMPRESSION_LEVEL_FIELD_NUMBER: builtins.int
    TEST_SIZE_FIELD_NUMBER: builtins.int
    TRAIN_SIZE_FIELD_NUMBER: builtins.int
    RANDOM_STATE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Agent related info
    Required. The project that the agent to export is associated with.
    Format: `projects/<Project ID>`.
    """

    compression_level: builtins.int
    """Optional. The compression level of the zip file created.
    Valid range 1-9; the grpc-default value 0 will be mapped to 1,
    other values cause an error in the request validation handler.
    """

    test_size: builtins.float
    """Train-test split related parameters, for further info,
    check https://scikit-learn.org/stable/modules/generated/sklearn.model_selection.train_test_split.html
    default values come from API definition above
    Optional: bigger than zero
    """

    train_size: builtins.float
    """Optional: bigger than zero"""

    random_state: builtins.int
    """Optional: random seed"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        compression_level: builtins.int = ...,
        test_size: builtins.float = ...,
        train_size: builtins.float = ...,
        random_state: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["compression_level",b"compression_level","parent",b"parent","random_state",b"random_state","test_size",b"test_size","train_size",b"train_size"]) -> None: ...
global___ExportBenchmarkAgentRequest = ExportBenchmarkAgentRequest

class ExportBenchmarkAgentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class TrainingPhrasesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text
        @property
        def value(self) -> ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse: ...
        def __init__(self,
            *,
            key: typing.Text = ...,
            value: typing.Optional[ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key",b"key","value",b"value"]) -> None: ...

    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    TRAINING_PHRASES_FIELD_NUMBER: builtins.int
    agent_content: builtins.bytes
    @property
    def training_phrases(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse]:
        """Key is the language code, value is the corresponding ListTrainingPhrasesResponse"""
        pass
    def __init__(self,
        *,
        agent_content: builtins.bytes = ...,
        training_phrases: typing.Optional[typing.Mapping[typing.Text, ondewo.nlu.intent_pb2.ListTrainingPhrasesResponse]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_content",b"agent_content","training_phrases",b"training_phrases"]) -> None: ...
global___ExportBenchmarkAgentResponse = ExportBenchmarkAgentResponse

class OptimizeRankingMatchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    OPTIMIZATION_CONFIGS_FIELD_NUMBER: builtins.int
    IN_PLACE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    @property
    def optimization_configs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RankingMatchOptimizationConfig]:
        """optimization config will contain all possible optimizations, with which we will come up in the future"""
        pass
    in_place: builtins.bool
    """if in_place is true then the config of the agent on the server will be updated, if False then config
    with optimized thresholds will be returned but not updated on the server
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_codes: typing.Optional[typing.Iterable[typing.Text]] = ...,
        optimization_configs: typing.Optional[typing.Iterable[global___RankingMatchOptimizationConfig]] = ...,
        in_place: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["in_place",b"in_place","language_codes",b"language_codes","optimization_configs",b"optimization_configs","parent",b"parent"]) -> None: ...
global___OptimizeRankingMatchRequest = OptimizeRankingMatchRequest

class RankingMatchOptimizationConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    N_SPLITS_FIELD_NUMBER: builtins.int
    RANDOM_SEED_FIELD_NUMBER: builtins.int
    INITIAL_THRESHOLDS_FIELD_NUMBER: builtins.int
    language_code: typing.Text
    n_splits: builtins.int
    random_seed: builtins.int
    @property
    def initial_thresholds(self) -> google.protobuf.struct_pb2.Struct:
        """initial thresholds are optional, if not given will be taken from the current config
        example {'OndewoIntentSimilarityMatch': 0.59, 'OndewoIntentNamedSimilarityMatch': 0.39}
        """
        pass
    def __init__(self,
        *,
        language_code: typing.Text = ...,
        n_splits: builtins.int = ...,
        random_seed: builtins.int = ...,
        initial_thresholds: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["initial_thresholds",b"initial_thresholds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["initial_thresholds",b"initial_thresholds","language_code",b"language_code","n_splits",b"n_splits","random_seed",b"random_seed"]) -> None: ...
global___RankingMatchOptimizationConfig = RankingMatchOptimizationConfig

class OptimizeRankingMatchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    OPTIMIZATION_INFO_FIELD_NUMBER: builtins.int
    OPTIMIZED_ONDEWO_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def optimization_info(self) -> google.protobuf.struct_pb2.Struct: ...
    @property
    def optimized_ondewo_config(self) -> google.protobuf.struct_pb2.Struct: ...
    def __init__(self,
        *,
        optimization_info: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        optimized_ondewo_config: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["optimization_info",b"optimization_info","optimized_ondewo_config",b"optimized_ondewo_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["optimization_info",b"optimization_info","optimized_ondewo_config",b"optimized_ondewo_config"]) -> None: ...
global___OptimizeRankingMatchResponse = OptimizeRankingMatchResponse

class ImportAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.ImportAgent][google.cloud.dialogflow.v2.Agents.ImportAgent]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    AGENT_URI_FIELD_NUMBER: builtins.int
    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to import is associated with.
    Format: `projects/<Project ID>`.
    """

    agent_uri: typing.Text
    """The URI to a Google Cloud Storage file containing the agent to import.
    Note: The URI must start with "gs://".
    """

    agent_content: builtins.bytes
    """The agent to import.

    Example for how to import an agent via the command line:

    curl \\
      'https://dialogflow.googleapis.com/v2/projects/<project_name>/agent:import\\
       -X POST \\
       -H 'Authorization: Bearer '$(gcloud auth print-access-token) \\
       -H 'Accept: application/json' \\
       -H 'Content-Type: application/json' \\
       --compressed \\
       --data-binary "{
          'agentContent': '$(cat <agent zip file> | base64 -w 0)'
       }"
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        agent_uri: typing.Text = ...,
        agent_content: builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_content",b"agent_content","agent_uri",b"agent_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_content",b"agent_content","agent_uri",b"agent_uri","parent",b"parent"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["agent",b"agent"]) -> typing.Optional[typing_extensions.Literal["agent_uri","agent_content"]]: ...
global___ImportAgentRequest = ImportAgentRequest

class RestoreAgentRequest(google.protobuf.message.Message):
    """The request message for [Agents.RestoreAgent][google.cloud.dialogflow.v2.Agents.RestoreAgent]."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    AGENT_URI_FIELD_NUMBER: builtins.int
    AGENT_CONTENT_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to restore is associated with.
    Format: `projects/<Project ID>`.
    """

    agent_uri: typing.Text
    """The URI to a Google Cloud Storage file containing the agent to restore.
    Note: The URI must start with "gs://".
    """

    agent_content: builtins.bytes
    """The agent to restore.

    Example for how to restore an agent via the command line:

    curl \\
      'https://dialogflow.googleapis.com/v2/projects/<project_name>/agent:restore\\
       -X POST \\
       -H 'Authorization: Bearer '$(gcloud auth print-access-token) \\
       -H 'Accept: application/json' \\
       -H 'Content-Type: application/json' \\
       --compressed \\
       --data-binary "{
           'agentContent': '$(cat <agent zip file> | base64 -w 0)'
       }" \\
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        agent_uri: typing.Text = ...,
        agent_content: builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_content",b"agent_content","agent_uri",b"agent_uri"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent",b"agent","agent_content",b"agent_content","agent_uri",b"agent_uri","parent",b"parent"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["agent",b"agent"]) -> typing.Optional[typing_extensions.Literal["agent_uri","agent_content"]]: ...
global___RestoreAgentRequest = RestoreAgentRequest

class GetAgentStatisticsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project to get statistics from.
    Format: `projects/<Project ID>`.
    """

    format: global___ReportFormat.ValueType
    language_code: typing.Text
    type: global___ReportType.ValueType
    def __init__(self,
        *,
        parent: typing.Text = ...,
        format: global___ReportFormat.ValueType = ...,
        language_code: typing.Text = ...,
        type: global___ReportType.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["format",b"format","language_code",b"language_code","parent",b"parent","type",b"type"]) -> None: ...
global___GetAgentStatisticsRequest = GetAgentStatisticsRequest

class GetAgentStatisticsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REPORTS_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    reports: builtins.bytes
    """Statistic info."""

    format: global___ReportFormat.ValueType
    type: global___ReportType.ValueType
    def __init__(self,
        *,
        reports: builtins.bytes = ...,
        format: global___ReportFormat.ValueType = ...,
        type: global___ReportType.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["format",b"format","reports",b"reports","type",b"type"]) -> None: ...
global___GetAgentStatisticsResponse = GetAgentStatisticsResponse

class AddUserToProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    PROJECT_ROLE_ID_FIELD_NUMBER: builtins.int
    parent: typing.Text
    user_id: typing.Text
    project_role_id: builtins.int
    def __init__(self,
        *,
        parent: typing.Text = ...,
        user_id: typing.Text = ...,
        project_role_id: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent","project_role_id",b"project_role_id","user_id",b"user_id"]) -> None: ...
global___AddUserToProjectRequest = AddUserToProjectRequest

class RemoveUserFromProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    parent: typing.Text
    user_id: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        user_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent","user_id",b"user_id"]) -> None: ...
global___RemoveUserFromProjectRequest = RemoveUserFromProjectRequest

class ListUsersInProjectRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    page_token: typing.Text
    """Optional. The next_page_token value returned from a previous list request."""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token",b"page_token","parent",b"parent"]) -> None: ...
global___ListUsersInProjectRequest = ListUsersInProjectRequest

class UserInProject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """ID of the project"""

    @property
    def user(self) -> ondewo.nlu.user_pb2.User:
        """User object"""
        pass
    role_id: builtins.int
    """ID of the project role of the user"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        user: typing.Optional[ondewo.nlu.user_pb2.User] = ...,
        role_id: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["user",b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent","role_id",b"role_id","user",b"user"]) -> None: ...
global___UserInProject = UserInProject

class ListUsersInProjectResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    USERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UserInProject]:
        """The list of users in a project. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
        pass
    next_page_token: typing.Text
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """

    def __init__(self,
        *,
        users: typing.Optional[typing.Iterable[global___UserInProject]] = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token",b"next_page_token","users",b"users"]) -> None: ...
global___ListUsersInProjectResponse = ListUsersInProjectResponse

class GetPlatformInfoResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    VERSION_FIELD_NUMBER: builtins.int
    COMMIT_HASH_FIELD_NUMBER: builtins.int
    version: typing.Text
    commit_hash: typing.Text
    def __init__(self,
        *,
        version: typing.Text = ...,
        commit_hash: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["commit_hash",b"commit_hash","version",b"version"]) -> None: ...
global___GetPlatformInfoResponse = GetPlatformInfoResponse

class ListProjectPermissionsRequest(google.protobuf.message.Message):
    """Project permissions"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    page_token: typing.Text
    """Optional. The next_page_token value returned from a previous list request."""

    def __init__(self,
        *,
        page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token",b"page_token"]) -> None: ...
global___ListProjectPermissionsRequest = ListProjectPermissionsRequest

class ListProjectPermissionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PERMISSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """The list of project permissions. There will be a maximum number of items
        returned based on the page_token field in the request.
        """
        pass
    next_page_token: typing.Text
    """Token to retrieve the next page of results, or empty if there are no
    more results in the list.
    """

    def __init__(self,
        *,
        permissions: typing.Optional[typing.Iterable[typing.Text]] = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token",b"next_page_token","permissions",b"permissions"]) -> None: ...
global___ListProjectPermissionsResponse = ListProjectPermissionsResponse

class SetAgentStatusRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    AGENT_VIEW_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project of which to set the status.
    Format: `projects/<Project ID>/agent`.
    """

    status: global___AgentStatus.ValueType
    """Required. Status of the agent"""

    agent_view: global___AgentView.ValueType
    """Optional. View of the returned agent"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        status: global___AgentStatus.ValueType = ...,
        agent_view: global___AgentView.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_view",b"agent_view","parent",b"parent","status",b"status"]) -> None: ...
global___SetAgentStatusRequest = SetAgentStatusRequest

class AgentSorting(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _AgentSortingField:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _AgentSortingFieldEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AgentSorting._AgentSortingField.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_AGENT_SORTING: AgentSorting._AgentSortingField.ValueType  # 0
        SORT_AGENT_BY_NAME: AgentSorting._AgentSortingField.ValueType  # 1
        SORT_AGENT_BY_CREATION_DATE: AgentSorting._AgentSortingField.ValueType  # 2
        SORT_AGENT_BY_LAST_UPDATED: AgentSorting._AgentSortingField.ValueType  # 3
        SORT_AGENT_BY_OWNER_NAME: AgentSorting._AgentSortingField.ValueType  # 4
    class AgentSortingField(_AgentSortingField, metaclass=_AgentSortingFieldEnumTypeWrapper):
        pass

    NO_AGENT_SORTING: AgentSorting.AgentSortingField.ValueType  # 0
    SORT_AGENT_BY_NAME: AgentSorting.AgentSortingField.ValueType  # 1
    SORT_AGENT_BY_CREATION_DATE: AgentSorting.AgentSortingField.ValueType  # 2
    SORT_AGENT_BY_LAST_UPDATED: AgentSorting.AgentSortingField.ValueType  # 3
    SORT_AGENT_BY_OWNER_NAME: AgentSorting.AgentSortingField.ValueType  # 4

    SORTING_FIELD_FIELD_NUMBER: builtins.int
    SORTING_MODE_FIELD_NUMBER: builtins.int
    sorting_field: global___AgentSorting.AgentSortingField.ValueType
    sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType
    def __init__(self,
        *,
        sorting_field: global___AgentSorting.AgentSortingField.ValueType = ...,
        sorting_mode: ondewo.nlu.common_pb2.SortingMode.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["sorting_field",b"sorting_field","sorting_mode",b"sorting_mode"]) -> None: ...
global___AgentSorting = AgentSorting

class SetResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_FILE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    name: typing.Text
    type: typing.Text
    resource_file: builtins.bytes
    language_code: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        name: typing.Text = ...,
        type: typing.Text = ...,
        resource_file: builtins.bytes = ...,
        language_code: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","name",b"name","parent",b"parent","resource_file",b"resource_file","type",b"type"]) -> None: ...
global___SetResourcesRequest = SetResourcesRequest

class DeleteResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    name: typing.Text
    type: typing.Text
    language_code: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        name: typing.Text = ...,
        type: typing.Text = ...,
        language_code: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","name",b"name","parent",b"parent","type",b"type"]) -> None: ...
global___DeleteResourcesRequest = DeleteResourcesRequest

class ExportResourcesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    name: typing.Text
    type: typing.Text
    language_code: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        name: typing.Text = ...,
        type: typing.Text = ...,
        language_code: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","name",b"name","parent",b"parent","type",b"type"]) -> None: ...
global___ExportResourcesRequest = ExportResourcesRequest

class ExportResourcesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    RESOURCE_FILE_FIELD_NUMBER: builtins.int
    parent: typing.Text
    name: typing.Text
    type: typing.Text
    language_code: typing.Text
    resource_file: builtins.bytes
    def __init__(self,
        *,
        parent: typing.Text = ...,
        name: typing.Text = ...,
        type: typing.Text = ...,
        language_code: typing.Text = ...,
        resource_file: builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","name",b"name","parent",b"parent","resource_file",b"resource_file","type",b"type"]) -> None: ...
global___ExportResourcesResponse = ExportResourcesResponse

class GetModelStatusesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    CACHE_VERSION_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent to fetch is associated with.
    Format: `projects/<Project ID>/agent`.
    """

    cache_version: builtins.int
    language_code: typing.Text
    model_name: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        cache_version: builtins.int = ...,
        language_code: typing.Text = ...,
        model_name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_version",b"cache_version","language_code",b"language_code","model_name",b"model_name","parent",b"parent"]) -> None: ...
global___GetModelStatusesRequest = GetModelStatusesRequest

class ModelStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _StatusName:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StatusNameEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ModelStatus._StatusName.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: ModelStatus._StatusName.ValueType  # 0
        INITIALIZING: ModelStatus._StatusName.ValueType  # 1
        INITIALIZED: ModelStatus._StatusName.ValueType  # 2
        LOADING_DATA: ModelStatus._StatusName.ValueType  # 3
        TRAINING: ModelStatus._StatusName.ValueType  # 4
        TESTING: ModelStatus._StatusName.ValueType  # 5
        TRAINED: ModelStatus._StatusName.ValueType  # 6
    class StatusName(_StatusName, metaclass=_StatusNameEnumTypeWrapper):
        pass

    UNKNOWN: ModelStatus.StatusName.ValueType  # 0
    INITIALIZING: ModelStatus.StatusName.ValueType  # 1
    INITIALIZED: ModelStatus.StatusName.ValueType  # 2
    LOADING_DATA: ModelStatus.StatusName.ValueType  # 3
    TRAINING: ModelStatus.StatusName.ValueType  # 4
    TESTING: ModelStatus.StatusName.ValueType  # 5
    TRAINED: ModelStatus.StatusName.ValueType  # 6

    CACHE_VERSION_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    STATUS_SET_TIME_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    cache_version: builtins.int
    language_code: typing.Text
    model_name: typing.Text
    @property
    def status_set_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    config: typing.Text
    status: global___ModelStatus.StatusName.ValueType
    def __init__(self,
        *,
        cache_version: builtins.int = ...,
        language_code: typing.Text = ...,
        model_name: typing.Text = ...,
        status_set_time: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        config: typing.Text = ...,
        status: global___ModelStatus.StatusName.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["status_set_time",b"status_set_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_version",b"cache_version","config",b"config","language_code",b"language_code","model_name",b"model_name","status",b"status","status_set_time",b"status_set_time"]) -> None: ...
global___ModelStatus = ModelStatus

class GetModelStatusesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MODEL_STATUSES_FIELD_NUMBER: builtins.int
    @property
    def model_statuses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelStatus]: ...
    def __init__(self,
        *,
        model_statuses: typing.Optional[typing.Iterable[global___ModelStatus]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_statuses",b"model_statuses"]) -> None: ...
global___GetModelStatusesResponse = GetModelStatusesResponse

class CustomPlatformInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PLATFORM_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    POSITION_FIELD_NUMBER: builtins.int
    platform: ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType
    """Required. ID of the Platform.
    Custom Intent.Message.Platform placeholder. Note: it will not work with non-placeholders values
    """

    display_name: typing.Text
    """Required.
    Name to be displayed.
    """

    position: builtins.int
    """Optional.
    Sorting position of the GetPlatformMappingRequest.
    """

    def __init__(self,
        *,
        platform: ondewo.nlu.intent_pb2.Intent.Message.Platform.ValueType = ...,
        display_name: typing.Text = ...,
        position: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["display_name",b"display_name","platform",b"platform","position",b"position"]) -> None: ...
global___CustomPlatformInfo = CustomPlatformInfo

class GetPlatformMappingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent is associated with.
    Format: `projects/<Project ID>/agent`.
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent"]) -> None: ...
global___GetPlatformMappingRequest = GetPlatformMappingRequest

class PlatformMapping(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    PLATFORM_INFO_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent is associated with.
    Format: `projects/<Project ID>/agent`.
    """

    @property
    def platform_info(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CustomPlatformInfo]:
        """Required.
        If not set, it will set it empty.
        """
        pass
    def __init__(self,
        *,
        parent: typing.Text = ...,
        platform_info: typing.Optional[typing.Iterable[global___CustomPlatformInfo]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent","platform_info",b"platform_info"]) -> None: ...
global___PlatformMapping = PlatformMapping

class FullTextSearchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _QueryType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _QueryTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[FullTextSearchRequest._QueryType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALL: FullTextSearchRequest._QueryType.ValueType  # 0
        """just a placeholder, has to start with zero"""

        OndewoEntityQuery: FullTextSearchRequest._QueryType.ValueType  # 1
        OndewoEntityTypeQuery: FullTextSearchRequest._QueryType.ValueType  # 2
        OndewoEntitySynonymQuery: FullTextSearchRequest._QueryType.ValueType  # 3
        OndewoIntentQuery: FullTextSearchRequest._QueryType.ValueType  # 4
        OndewoIntentContextInQuery: FullTextSearchRequest._QueryType.ValueType  # 5
        OndewoIntentContextOutQuery: FullTextSearchRequest._QueryType.ValueType  # 6
        OndewoIntentUsersaysQuery: FullTextSearchRequest._QueryType.ValueType  # 7
        OndewoIntentTagsQuery: FullTextSearchRequest._QueryType.ValueType  # 8
        OndewoIntentParametersQuery: FullTextSearchRequest._QueryType.ValueType  # 9
        OndewoIntentResponseQuery: FullTextSearchRequest._QueryType.ValueType  # 10
    class QueryType(_QueryType, metaclass=_QueryTypeEnumTypeWrapper):
        pass

    ALL: FullTextSearchRequest.QueryType.ValueType  # 0
    """just a placeholder, has to start with zero"""

    OndewoEntityQuery: FullTextSearchRequest.QueryType.ValueType  # 1
    OndewoEntityTypeQuery: FullTextSearchRequest.QueryType.ValueType  # 2
    OndewoEntitySynonymQuery: FullTextSearchRequest.QueryType.ValueType  # 3
    OndewoIntentQuery: FullTextSearchRequest.QueryType.ValueType  # 4
    OndewoIntentContextInQuery: FullTextSearchRequest.QueryType.ValueType  # 5
    OndewoIntentContextOutQuery: FullTextSearchRequest.QueryType.ValueType  # 6
    OndewoIntentUsersaysQuery: FullTextSearchRequest.QueryType.ValueType  # 7
    OndewoIntentTagsQuery: FullTextSearchRequest.QueryType.ValueType  # 8
    OndewoIntentParametersQuery: FullTextSearchRequest.QueryType.ValueType  # 9
    OndewoIntentResponseQuery: FullTextSearchRequest.QueryType.ValueType  # 10

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The project that the agent is associated with.
    Format: `projects/<Project ID>/agent`.
    """

    language_code: typing.Text
    """In which language to search for"""

    term: typing.Text
    """What to search for in the elastic server"""

    page_token: typing.Text
    """Composite string: current_index-0--page_size-10"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        term: typing.Text = ...,
        page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","page_token",b"page_token","parent",b"parent","term",b"term"]) -> None: ...
global___FullTextSearchRequest = FullTextSearchRequest

class FullTextSearchResponseEntityType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class EntityTypeSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["display_name",b"display_name","language",b"language","name",b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def entity_type_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseEntityType.EntityTypeSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        entity_type_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseEntityType.EntityTypeSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","entity_type_results",b"entity_type_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseEntityType = FullTextSearchResponseEntityType

class FullTextSearchResponseEntity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class EntitySearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        display_name: typing.Text
        entity_type_name: typing.Text
        entity_type_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            display_name: typing.Text = ...,
            entity_type_name: typing.Text = ...,
            entity_type_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["display_name",b"display_name","entity_type_display_name",b"entity_type_display_name","entity_type_name",b"entity_type_name","language",b"language","name",b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ENTITY_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def entity_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseEntity.EntitySearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        entity_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseEntity.EntitySearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","entity_results",b"entity_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseEntity = FullTextSearchResponseEntity

class FullTextSearchResponseEntitySynonym(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class EntitySynonymSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_NAME_FIELD_NUMBER: builtins.int
        ENTITY_TYPE_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_NAME_FIELD_NUMBER: builtins.int
        ENTITY_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        display_name: typing.Text
        entity_type_name: typing.Text
        entity_type_display_name: typing.Text
        entity_name: typing.Text
        entity_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            display_name: typing.Text = ...,
            entity_type_name: typing.Text = ...,
            entity_type_display_name: typing.Text = ...,
            entity_name: typing.Text = ...,
            entity_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["display_name",b"display_name","entity_display_name",b"entity_display_name","entity_name",b"entity_name","entity_type_display_name",b"entity_type_display_name","entity_type_name",b"entity_type_name","language",b"language","name",b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    ENTITY_SYNONYM_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def entity_synonym_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseEntitySynonym.EntitySynonymSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        entity_synonym_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseEntitySynonym.EntitySynonymSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","entity_synonym_results",b"entity_synonym_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseEntitySynonym = FullTextSearchResponseEntitySynonym

class FullTextSearchResponseIntent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        DISPLAY_NAME_FIELD_NUMBER: builtins.int
        DOMAIN_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        display_name: typing.Text
        domain_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            display_name: typing.Text = ...,
            domain_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["display_name",b"display_name","domain_name",b"domain_name","language",b"language","name",b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntent.IntentSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntent.IntentSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_results",b"intent_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntent = FullTextSearchResponseIntent

class FullTextSearchResponseIntentContextIn(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentContextInSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        intent_name: typing.Text
        intent_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            intent_name: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["intent_display_name",b"intent_display_name","intent_name",b"intent_name","language",b"language","name",b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_CONTEXT_IN_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_context_in_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentContextIn.IntentContextInSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_context_in_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntentContextIn.IntentContextInSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_context_in_results",b"intent_context_in_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntentContextIn = FullTextSearchResponseIntentContextIn

class FullTextSearchResponseIntentContextOut(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentContextOutSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        intent_name: typing.Text
        intent_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            intent_name: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["intent_display_name",b"intent_display_name","intent_name",b"intent_name","language",b"language","name",b"name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_CONTEXT_OUT_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_context_out_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentContextOut.IntentContextOutSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_context_out_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntentContextOut.IntentContextOutSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_context_out_results",b"intent_context_out_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntentContextOut = FullTextSearchResponseIntentContextOut

class FullTextSearchResponseIntentUsersays(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentUsersaysSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        TEXT_FIELD_NUMBER: builtins.int
        TEXT_AS_ENTITY_TYPES_FIELD_NUMBER: builtins.int
        TEXT_AS_ENTITY_VALUES_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        text: typing.Text
        text_as_entity_types: typing.Text
        text_as_entity_values: typing.Text
        type: typing.Text
        intent_name: typing.Text
        intent_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            text: typing.Text = ...,
            text_as_entity_types: typing.Text = ...,
            text_as_entity_values: typing.Text = ...,
            type: typing.Text = ...,
            intent_name: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["intent_display_name",b"intent_display_name","intent_name",b"intent_name","language",b"language","name",b"name","text",b"text","text_as_entity_types",b"text_as_entity_types","text_as_entity_values",b"text_as_entity_values","type",b"type"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_USERSAYS_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_usersays_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentUsersays.IntentUsersaysSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_usersays_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntentUsersays.IntentUsersaysSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_usersays_results",b"intent_usersays_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntentUsersays = FullTextSearchResponseIntentUsersays

class FullTextSearchResponseIntentTags(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentTagsSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        TEXT_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        name: typing.Text
        text: typing.Text
        intent_name: typing.Text
        intent_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            name: typing.Text = ...,
            text: typing.Text = ...,
            intent_name: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["intent_display_name",b"intent_display_name","intent_name",b"intent_name","language",b"language","name",b"name","text",b"text"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_TAGS_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_tags_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentTags.IntentTagsSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_tags_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntentTags.IntentTagsSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_tags_results",b"intent_tags_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntentTags = FullTextSearchResponseIntentTags

class FullTextSearchResponseIntentResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentResponseSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TEXT_FIELD_NUMBER: builtins.int
        PLATFORM_FIELD_NUMBER: builtins.int
        RESPONSE_TYPE_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        text: typing.Text
        platform: typing.Text
        response_type: typing.Text
        intent_name: typing.Text
        intent_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            text: typing.Text = ...,
            platform: typing.Text = ...,
            response_type: typing.Text = ...,
            intent_name: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["intent_display_name",b"intent_display_name","intent_name",b"intent_name","language",b"language","platform",b"platform","response_type",b"response_type","text",b"text"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_RESPONSE_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_response_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentResponse.IntentResponseSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_response_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntentResponse.IntentResponseSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_response_results",b"intent_response_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntentResponse = FullTextSearchResponseIntentResponse

class FullTextSearchResponseIntentParameters(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class IntentParametersSearchResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        PARAMETER_NAME_FIELD_NUMBER: builtins.int
        PARAMETER_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        INTENT_NAME_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        LANGUAGE_FIELD_NUMBER: builtins.int
        parameter_name: typing.Text
        parameter_display_name: typing.Text
        intent_name: typing.Text
        intent_display_name: typing.Text
        language: typing.Text
        def __init__(self,
            *,
            parameter_name: typing.Text = ...,
            parameter_display_name: typing.Text = ...,
            intent_name: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            language: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["intent_display_name",b"intent_display_name","intent_name",b"intent_name","language",b"language","parameter_display_name",b"parameter_display_name","parameter_name",b"parameter_name"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    INTENT_PARAMETERS_RESULTS_FIELD_NUMBER: builtins.int
    TERM_FIELD_NUMBER: builtins.int
    ELASTIC_QUERY_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    language_code: typing.Text
    @property
    def intent_parameters_results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTextSearchResponseIntentParameters.IntentParametersSearchResult]: ...
    term: typing.Text
    elastic_query: typing.Text
    time: builtins.float
    next_page_token: typing.Text
    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        intent_parameters_results: typing.Optional[typing.Iterable[global___FullTextSearchResponseIntentParameters.IntentParametersSearchResult]] = ...,
        term: typing.Text = ...,
        elastic_query: typing.Text = ...,
        time: builtins.float = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elastic_query",b"elastic_query","intent_parameters_results",b"intent_parameters_results","language_code",b"language_code","next_page_token",b"next_page_token","parent",b"parent","term",b"term","time",b"time"]) -> None: ...
global___FullTextSearchResponseIntentParameters = FullTextSearchResponseIntentParameters

class ReindexAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    BRANCH_NAME_FIELD_NUMBER: builtins.int
    INDEX_TYPES_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """projects/<project_id>/agent"""

    branch_name: typing.Text
    """Optional, useful for versioning reasons in the future"""

    @property
    def index_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___FullTextSearchRequest.QueryType.ValueType]:
        """Optional, useful for reindexing specific indices in the future"""
        pass
    def __init__(self,
        *,
        parent: typing.Text = ...,
        branch_name: typing.Text = ...,
        index_types: typing.Optional[typing.Iterable[global___FullTextSearchRequest.QueryType.ValueType]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch_name",b"branch_name","index_types",b"index_types","parent",b"parent"]) -> None: ...
global___ReindexAgentRequest = ReindexAgentRequest
