"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.rpc.status_pb2
import google.type.latlng_pb2
import ondewo.nlu.context_pb2
import ondewo.nlu.entity_type_pb2
import ondewo.nlu.intent_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AudioEncoding:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _AudioEncodingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AudioEncoding.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUDIO_ENCODING_UNSPECIFIED: _AudioEncoding.ValueType  # 0
    """Not specified."""

    AUDIO_ENCODING_LINEAR_16: _AudioEncoding.ValueType  # 1
    """Uncompressed 16-bit signed little-endian samples (Linear PCM)."""

    AUDIO_ENCODING_FLAC: _AudioEncoding.ValueType  # 2
    """[`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
    Codec) is the recommended encoding because it is lossless (therefore
    recognition is not compromised) and requires only about half the
    bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
    24-bit samples, however, not all fields in `STREAMINFO` are supported.
    """

    AUDIO_ENCODING_MULAW: _AudioEncoding.ValueType  # 3
    """8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law."""

    AUDIO_ENCODING_AMR: _AudioEncoding.ValueType  # 4
    """Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000."""

    AUDIO_ENCODING_AMR_WB: _AudioEncoding.ValueType  # 5
    """Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000."""

    AUDIO_ENCODING_OGG_OPUS: _AudioEncoding.ValueType  # 6
    """Opus encoded audio frames in Ogg container
    ([OggOpus](https://wiki.xiph.org/OggOpus)).
    `sample_rate_hertz` must be 16000.
    """

    AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE: _AudioEncoding.ValueType  # 7
    """Although the use of lossy encodings is not recommended, if a very low
    bitrate encoding is required, `OGG_OPUS` is highly preferred over
    Speex encoding. The [Speex](https://speex.org/) encoding supported by
    Dialogflow API has a header byte in each block, as in MIME type
    `audio/x-speex-with-header-byte`.
    It is a variant of the RTP Speex encoding defined in
    [RFC 5574](https://tools.ietf.org/html/rfc5574).
    The stream is a sequence of blocks, one block per RTP packet. Each block
    starts with a byte containing the length of the block, in bytes, followed
    by one or more frames of Speex data, padded to an integral number of
    bytes (octets) as specified in RFC 5574. In other words, each RTP header
    is replaced with a single byte containing the block length. Only Speex
    wideband is supported. `sample_rate_hertz` must be 16000.
    """

class AudioEncoding(_AudioEncoding, metaclass=_AudioEncodingEnumTypeWrapper):
    """Audio encoding of the audio content sent in the conversational query request.
    Refer to the [Cloud Speech API documentation](/speech/docs/basics) for more
    details.
    """
    pass

AUDIO_ENCODING_UNSPECIFIED: AudioEncoding.ValueType  # 0
"""Not specified."""

AUDIO_ENCODING_LINEAR_16: AudioEncoding.ValueType  # 1
"""Uncompressed 16-bit signed little-endian samples (Linear PCM)."""

AUDIO_ENCODING_FLAC: AudioEncoding.ValueType  # 2
"""[`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
Codec) is the recommended encoding because it is lossless (therefore
recognition is not compromised) and requires only about half the
bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
24-bit samples, however, not all fields in `STREAMINFO` are supported.
"""

AUDIO_ENCODING_MULAW: AudioEncoding.ValueType  # 3
"""8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law."""

AUDIO_ENCODING_AMR: AudioEncoding.ValueType  # 4
"""Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000."""

AUDIO_ENCODING_AMR_WB: AudioEncoding.ValueType  # 5
"""Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000."""

AUDIO_ENCODING_OGG_OPUS: AudioEncoding.ValueType  # 6
"""Opus encoded audio frames in Ogg container
([OggOpus](https://wiki.xiph.org/OggOpus)).
`sample_rate_hertz` must be 16000.
"""

AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE: AudioEncoding.ValueType  # 7
"""Although the use of lossy encodings is not recommended, if a very low
bitrate encoding is required, `OGG_OPUS` is highly preferred over
Speex encoding. The [Speex](https://speex.org/) encoding supported by
Dialogflow API has a header byte in each block, as in MIME type
`audio/x-speex-with-header-byte`.
It is a variant of the RTP Speex encoding defined in
[RFC 5574](https://tools.ietf.org/html/rfc5574).
The stream is a sequence of blocks, one block per RTP packet. Each block
starts with a byte containing the length of the block, in bytes, followed
by one or more frames of Speex data, padded to an integral number of
bytes (octets) as specified in RFC 5574. In other words, each RTP header
is replaced with a single byte containing the block length. Only Speex
wideband is supported. `sample_rate_hertz` must be 16000.
"""

global___AudioEncoding = AudioEncoding


class DetectIntentRequest(google.protobuf.message.Message):
    """The request to detect user's intent."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_FIELD_NUMBER: builtins.int
    QUERY_PARAMS_FIELD_NUMBER: builtins.int
    QUERY_INPUT_FIELD_NUMBER: builtins.int
    INPUT_AUDIO_FIELD_NUMBER: builtins.int
    session: typing.Text
    """Required. The name of the session this query is sent to. Format:
    `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
    caller to choose an appropriate session ID. It can be a random number or
    some type of user identifier (preferably hashed). The length of the session
    ID must not exceed 36 bytes.
    """

    @property
    def query_params(self) -> global___QueryParameters:
        """Optional. The parameters of this query."""
        pass
    @property
    def query_input(self) -> global___QueryInput:
        """Required. The input specification. It can be set to:

        1.  an audio config
            which instructs the speech recognizer how to process the speech audio,

        2.  a conversational query in the form of text, or

        3.  an event that specifies which intent to trigger.
        """
        pass
    input_audio: builtins.bytes
    """Optional. The natural language speech audio to be processed. This field
    should be populated iff `query_input` is set to an input audio config.
    A single request can contain up to 1 minute of speech audio data.
    """

    def __init__(self,
        *,
        session: typing.Text = ...,
        query_params: typing.Optional[global___QueryParameters] = ...,
        query_input: typing.Optional[global___QueryInput] = ...,
        input_audio: builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_input",b"query_input","query_params",b"query_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["input_audio",b"input_audio","query_input",b"query_input","query_params",b"query_params","session",b"session"]) -> None: ...
global___DetectIntentRequest = DetectIntentRequest

class DetectIntentResponse(google.protobuf.message.Message):
    """The message returned from the DetectIntent method."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESPONSE_ID_FIELD_NUMBER: builtins.int
    QUERY_RESULT_FIELD_NUMBER: builtins.int
    WEBHOOK_STATUS_FIELD_NUMBER: builtins.int
    response_id: typing.Text
    """The unique identifier of the response. It can be used to
    locate a response in the training example set or for reporting issues.
    """

    @property
    def query_result(self) -> global___QueryResult:
        """The results of the conversational query or event processing."""
        pass
    @property
    def webhook_status(self) -> google.rpc.status_pb2.Status:
        """Specifies the status of the webhook request. `webhook_status`
        is never populated in webhook requests.
        """
        pass
    def __init__(self,
        *,
        response_id: typing.Text = ...,
        query_result: typing.Optional[global___QueryResult] = ...,
        webhook_status: typing.Optional[google.rpc.status_pb2.Status] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_result",b"query_result","webhook_status",b"webhook_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["query_result",b"query_result","response_id",b"response_id","webhook_status",b"webhook_status"]) -> None: ...
global___DetectIntentResponse = DetectIntentResponse

class QueryParameters(google.protobuf.message.Message):
    """Represents the parameters of the conversational query."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TIME_ZONE_FIELD_NUMBER: builtins.int
    GEO_LOCATION_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    RESET_CONTEXTS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    time_zone: typing.Text
    """Optional. The time zone of this conversational query from the
    [time zone database](https://www.iana.org/time-zones), e.g.,
    America/New_York, Europe/Paris. If not provided, the time zone specified in
    agent settings is used.
    """

    @property
    def geo_location(self) -> google.type.latlng_pb2.LatLng:
        """Optional. The geo location of this conversational query."""
        pass
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """Optional. The collection of contexts to be activated before this query is
        executed.
        """
        pass
    reset_contexts: builtins.bool
    """Optional. Specifies whether to delete all contexts in the current session
    before the new ones are activated.
    """

    @property
    def payload(self) -> google.protobuf.struct_pb2.Struct:
        """Optional. This field can be used to pass custom data into the webhook
        associated with the agent. Arbitrary JSON objects are supported.
        """
        pass
    def __init__(self,
        *,
        time_zone: typing.Text = ...,
        geo_location: typing.Optional[google.type.latlng_pb2.LatLng] = ...,
        contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        reset_contexts: builtins.bool = ...,
        payload: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geo_location",b"geo_location","payload",b"payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contexts",b"contexts","geo_location",b"geo_location","payload",b"payload","reset_contexts",b"reset_contexts","time_zone",b"time_zone"]) -> None: ...
global___QueryParameters = QueryParameters

class QueryInput(google.protobuf.message.Message):
    """Represents the query input. It can contain either:

    1.  An audio config which
        instructs the speech recognizer how to process the speech audio.

    2.  A conversational query in the form of text,.

    3.  An event that specifies which intent to trigger.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUDIO_CONFIG_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    @property
    def audio_config(self) -> global___InputAudioConfig:
        """Instructs the speech recognizer how to process the speech audio."""
        pass
    @property
    def text(self) -> global___TextInput:
        """The natural language text to be processed."""
        pass
    @property
    def event(self) -> global___EventInput:
        """The event to be processed."""
        pass
    def __init__(self,
        *,
        audio_config: typing.Optional[global___InputAudioConfig] = ...,
        text: typing.Optional[global___TextInput] = ...,
        event: typing.Optional[global___EventInput] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["audio_config",b"audio_config","event",b"event","input",b"input","text",b"text"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_config",b"audio_config","event",b"event","input",b"input","text",b"text"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["input",b"input"]) -> typing.Optional[typing_extensions.Literal["audio_config","text","event"]]: ...
global___QueryInput = QueryInput

class QueryResult(google.protobuf.message.Message):
    """Represents the result of conversational query or event processing."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    QUERY_TEXT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SPEECH_RECOGNITION_CONFIDENCE_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    ALL_REQUIRED_PARAMS_PRESENT_FIELD_NUMBER: builtins.int
    FULFILLMENT_TEXT_FIELD_NUMBER: builtins.int
    FULFILLMENT_MESSAGES_FIELD_NUMBER: builtins.int
    WEBHOOK_SOURCE_FIELD_NUMBER: builtins.int
    WEBHOOK_PAYLOAD_FIELD_NUMBER: builtins.int
    OUTPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    INTENT_FIELD_NUMBER: builtins.int
    INTENT_DETECTION_CONFIDENCE_FIELD_NUMBER: builtins.int
    DIAGNOSTIC_INFO_FIELD_NUMBER: builtins.int
    query_text: typing.Text
    """The original conversational query text:
    - If natural language text was provided as input, `query_text` contains
      a copy of the input.
    - If natural language speech audio was provided as input, `query_text`
      contains the speech recognition result. If speech recognizer produced
      multiple alternatives, a particular one is picked.
    - If an event was provided as input, `query_text` is not set.
    """

    language_code: typing.Text
    """The language that was triggered during intent detection.
    See [Language Support](https://dialogflow.com/docs/reference/language)
    for a list of the currently supported language codes.
    """

    speech_recognition_confidence: builtins.float
    """The Speech recognition confidence between 0.0 and 1.0. A higher number
    indicates an estimated greater likelihood that the recognized words are
    correct. The default of 0.0 is a sentinel value indicating that confidence
    was not set.

    You should not rely on this field as it isn't guaranteed to be accurate, or
    even set. In particular this field isn't set in Webhook calls and for
    StreamingDetectIntent since the streaming endpoint has separate confidence
    estimates per portion of the audio in StreamingRecognitionResult.
    """

    action: typing.Text
    """The action name from the matched intent."""

    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """The collection of extracted parameters."""
        pass
    all_required_params_present: builtins.bool
    """This field is set to:
    - `false` if the matched intent has required parameters and not all of
       the required parameter values have been collected.
    - `true` if all required parameter values have been collected, or if the
       matched intent doesn't contain any required parameters.
    """

    fulfillment_text: typing.Text
    """The text to be pronounced to the user or shown on the screen."""

    @property
    def fulfillment_messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent.Message]:
        """The collection of rich messages to present to the user."""
        pass
    webhook_source: typing.Text
    """If the query was fulfilled by a webhook call, this field is set to the
    value of the `source` field returned in the webhook response.
    """

    @property
    def webhook_payload(self) -> google.protobuf.struct_pb2.Struct:
        """If the query was fulfilled by a webhook call, this field is set to the
        value of the `payload` field returned in the webhook response.
        """
        pass
    @property
    def output_contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The collection of output contexts. If applicable,
        `output_contexts.parameters` contains entries with name
        `<parameter name>.original` containing the original parameter values
        before the query.
        """
        pass
    @property
    def intent(self) -> ondewo.nlu.intent_pb2.Intent:
        """The intent that matched the conversational query. Some, not
        all fields are filled in this message, including but not limited to:
        `name`, `display_name` and `webhook_state`.
        """
        pass
    intent_detection_confidence: builtins.float
    """The intent detection confidence. Values range from 0.0
    (completely uncertain) to 1.0 (completely certain).
    """

    @property
    def diagnostic_info(self) -> google.protobuf.struct_pb2.Struct:
        """The free-form diagnostic info. For example, this field
        could contain webhook call latency.
        """
        pass
    def __init__(self,
        *,
        query_text: typing.Text = ...,
        language_code: typing.Text = ...,
        speech_recognition_confidence: builtins.float = ...,
        action: typing.Text = ...,
        parameters: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        all_required_params_present: builtins.bool = ...,
        fulfillment_text: typing.Text = ...,
        fulfillment_messages: typing.Optional[typing.Iterable[ondewo.nlu.intent_pb2.Intent.Message]] = ...,
        webhook_source: typing.Text = ...,
        webhook_payload: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        output_contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        intent: typing.Optional[ondewo.nlu.intent_pb2.Intent] = ...,
        intent_detection_confidence: builtins.float = ...,
        diagnostic_info: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["diagnostic_info",b"diagnostic_info","intent",b"intent","parameters",b"parameters","webhook_payload",b"webhook_payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action",b"action","all_required_params_present",b"all_required_params_present","diagnostic_info",b"diagnostic_info","fulfillment_messages",b"fulfillment_messages","fulfillment_text",b"fulfillment_text","intent",b"intent","intent_detection_confidence",b"intent_detection_confidence","language_code",b"language_code","output_contexts",b"output_contexts","parameters",b"parameters","query_text",b"query_text","speech_recognition_confidence",b"speech_recognition_confidence","webhook_payload",b"webhook_payload","webhook_source",b"webhook_source"]) -> None: ...
global___QueryResult = QueryResult

class StreamingDetectIntentRequest(google.protobuf.message.Message):
    """The top-level message sent by the client to the
    `StreamingDetectIntent` method.

    Multiple request messages should be sent in order:

    1.  The first message must contain `session`, `query_input` plus optionally
        `query_params` and/or `single_utterance`. The message must not contain `input_audio`.

    2.  If `query_input` was set to a streaming input audio config,
        all subsequent messages must contain only `input_audio`.
        Otherwise, finish the request stream.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_FIELD_NUMBER: builtins.int
    QUERY_PARAMS_FIELD_NUMBER: builtins.int
    QUERY_INPUT_FIELD_NUMBER: builtins.int
    SINGLE_UTTERANCE_FIELD_NUMBER: builtins.int
    INPUT_AUDIO_FIELD_NUMBER: builtins.int
    session: typing.Text
    """Required. The name of the session the query is sent to.
    Format of the session name:
    `projects/<Project ID>/agent/sessions/<Session ID>`. It’s up to the API
    caller to choose an appropriate <Session ID>. It can be a random number or
    some type of user identifier (preferably hashed). The length of the session
    ID must not exceed 36 characters.
    """

    @property
    def query_params(self) -> global___QueryParameters:
        """Optional. The parameters of this query."""
        pass
    @property
    def query_input(self) -> global___QueryInput:
        """Required. The input specification. It can be set to:

        1.  an audio config which instructs the speech recognizer how to process
            the speech audio,

        2.  a conversational query in the form of text, or

        3.  an event that specifies which intent to trigger.
        """
        pass
    single_utterance: builtins.bool
    """Optional. If `false` (default), recognition does not cease until the
    client closes the stream.
    If `true`, the recognizer will detect a single spoken utterance in input
    audio. Recognition ceases when it detects the audio's voice has
    stopped or paused. In this case, once a detected intent is received, the
    client should close the stream and start a new request with a new stream as
    needed.
    This setting is ignored when `query_input` is a piece of text or an event.
    """

    input_audio: builtins.bytes
    """Optional. The input audio content to be recognized. Must be sent if
    `query_input` was set to a streaming input audio config. The complete audio
    over all streaming messages must not exceed 1 minute.
    """

    def __init__(self,
        *,
        session: typing.Text = ...,
        query_params: typing.Optional[global___QueryParameters] = ...,
        query_input: typing.Optional[global___QueryInput] = ...,
        single_utterance: builtins.bool = ...,
        input_audio: builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_input",b"query_input","query_params",b"query_params"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["input_audio",b"input_audio","query_input",b"query_input","query_params",b"query_params","session",b"session","single_utterance",b"single_utterance"]) -> None: ...
global___StreamingDetectIntentRequest = StreamingDetectIntentRequest

class StreamingDetectIntentResponse(google.protobuf.message.Message):
    """The top-level message returned from the
    `StreamingDetectIntent` method.

    Multiple response messages can be returned in order:

    1.  If the input was set to streaming audio, the first one or more messages
        contain `recognition_result`. Each `recognition_result` represents a more
        complete transcript of what the user said. The last `recognition_result`
        has `is_final` set to `true`.

    2.  The next message contains `response_id`, `query_result`
        and optionally `webhook_status` if a WebHook was called.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    RESPONSE_ID_FIELD_NUMBER: builtins.int
    RECOGNITION_RESULT_FIELD_NUMBER: builtins.int
    QUERY_RESULT_FIELD_NUMBER: builtins.int
    WEBHOOK_STATUS_FIELD_NUMBER: builtins.int
    response_id: typing.Text
    """The unique identifier of the response. It can be used to
    locate a response in the training example set or for reporting issues.
    """

    @property
    def recognition_result(self) -> global___StreamingRecognitionResult:
        """The result of speech recognition."""
        pass
    @property
    def query_result(self) -> global___QueryResult:
        """The result of the conversational query or event processing."""
        pass
    @property
    def webhook_status(self) -> google.rpc.status_pb2.Status:
        """Specifies the status of the webhook request."""
        pass
    def __init__(self,
        *,
        response_id: typing.Text = ...,
        recognition_result: typing.Optional[global___StreamingRecognitionResult] = ...,
        query_result: typing.Optional[global___QueryResult] = ...,
        webhook_status: typing.Optional[google.rpc.status_pb2.Status] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["query_result",b"query_result","recognition_result",b"recognition_result","webhook_status",b"webhook_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["query_result",b"query_result","recognition_result",b"recognition_result","response_id",b"response_id","webhook_status",b"webhook_status"]) -> None: ...
global___StreamingDetectIntentResponse = StreamingDetectIntentResponse

class StreamingRecognitionResult(google.protobuf.message.Message):
    """Contains a speech recognition result corresponding to a portion of the audio
    that is currently being processed or an indication that this is the end
    of the single requested utterance.

    Example:

    1.  transcript: "tube"

    2.  transcript: "to be a"

    3.  transcript: "to be"

    4.  transcript: "to be or not to be"
        is_final: true

    5.  transcript: " that's"

    6.  transcript: " that is"

    7.  recognition_event_type: `RECOGNITION_EVENT_END_OF_SINGLE_UTTERANCE`

    8.  transcript: " that is the question"
        is_final: true

    Only two of the responses contain final results (#4 and #8 indicated by
    `is_final: true`). Concatenating these generates the full transcript: "to be
    or not to be that is the question".

    In each response we populate:

    *  for `MESSAGE_TYPE_TRANSCRIPT`: `transcript` and possibly `is_final`.

    *  for `MESSAGE_TYPE_END_OF_SINGLE_UTTERANCE`: only `event_type`.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _MessageType:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _MessageTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StreamingRecognitionResult._MessageType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MESSAGE_TYPE_UNSPECIFIED: StreamingRecognitionResult._MessageType.ValueType  # 0
        """Not specified. Should never be used."""

        TRANSCRIPT: StreamingRecognitionResult._MessageType.ValueType  # 1
        """Message contains a (possibly partial) transcript."""

        END_OF_SINGLE_UTTERANCE: StreamingRecognitionResult._MessageType.ValueType  # 2
        """Event indicates that the server has detected the end of the user's speech
        utterance and expects no additional speech. Therefore, the server will
        not process additional audio (although it may subsequently return
        additional results). The client should stop sending additional audio
        data, half-close the gRPC connection, and wait for any additional results
        until the server closes the gRPC connection. This message is only sent if
        `single_utterance` was set to `true`, and is not used otherwise.
        """

    class MessageType(_MessageType, metaclass=_MessageTypeEnumTypeWrapper):
        """Type of the response message."""
        pass

    MESSAGE_TYPE_UNSPECIFIED: StreamingRecognitionResult.MessageType.ValueType  # 0
    """Not specified. Should never be used."""

    TRANSCRIPT: StreamingRecognitionResult.MessageType.ValueType  # 1
    """Message contains a (possibly partial) transcript."""

    END_OF_SINGLE_UTTERANCE: StreamingRecognitionResult.MessageType.ValueType  # 2
    """Event indicates that the server has detected the end of the user's speech
    utterance and expects no additional speech. Therefore, the server will
    not process additional audio (although it may subsequently return
    additional results). The client should stop sending additional audio
    data, half-close the gRPC connection, and wait for any additional results
    until the server closes the gRPC connection. This message is only sent if
    `single_utterance` was set to `true`, and is not used otherwise.
    """


    MESSAGE_TYPE_FIELD_NUMBER: builtins.int
    TRANSCRIPT_FIELD_NUMBER: builtins.int
    IS_FINAL_FIELD_NUMBER: builtins.int
    CONFIDENCE_FIELD_NUMBER: builtins.int
    message_type: global___StreamingRecognitionResult.MessageType.ValueType
    """Type of the result message."""

    transcript: typing.Text
    """Transcript text representing the words that the user spoke.
    Populated if and only if `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
    """

    is_final: builtins.bool
    """The default of 0.0 is a sentinel value indicating `confidence` was not set.
    If `false`, the `StreamingRecognitionResult` represents an
    interim result that may change. If `true`, the recognizer will not return
    any further hypotheses about this piece of the audio. May only be populated
    for `event_type` = `RECOGNITION_EVENT_TRANSCRIPT`.
    """

    confidence: builtins.float
    """The Speech confidence between 0.0 and 1.0 for the current portion of audio.
    A higher number indicates an estimated greater likelihood that the
    recognized words are correct. The default of 0.0 is a sentinel value
    indicating that confidence was not set.

    This field is typically only provided if `is_final` is true and you should
    not rely on it being accurate or even set.
    """

    def __init__(self,
        *,
        message_type: global___StreamingRecognitionResult.MessageType.ValueType = ...,
        transcript: typing.Text = ...,
        is_final: builtins.bool = ...,
        confidence: builtins.float = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["confidence",b"confidence","is_final",b"is_final","message_type",b"message_type","transcript",b"transcript"]) -> None: ...
global___StreamingRecognitionResult = StreamingRecognitionResult

class InputAudioConfig(google.protobuf.message.Message):
    """Instructs the speech recognizer how to process the audio content."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    AUDIO_ENCODING_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_HERTZ_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    PHRASE_HINTS_FIELD_NUMBER: builtins.int
    audio_encoding: global___AudioEncoding.ValueType
    """Required. Audio encoding of the audio content to process."""

    sample_rate_hertz: builtins.int
    """Required. Sample rate (in Hertz) of the audio content sent in the query.
    Refer to [Cloud Speech API documentation](/speech/docs/basics) for more
    details.
    """

    language_code: typing.Text
    """Required. The language of the supplied audio. Dialogflow does not do
    translations. See [Language
    Support](https://dialogflow.com/docs/languages) for a list of the
    currently supported language codes. Note that queries in the same session
    do not necessarily need to specify the same language.
    """

    @property
    def phrase_hints(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. The collection of phrase hints which are used to boost accuracy
        of speech recognition.
        Refer to [Cloud Speech API documentation](/speech/docs/basics#phrase-hints)
        for more details.
        """
        pass
    def __init__(self,
        *,
        audio_encoding: global___AudioEncoding.ValueType = ...,
        sample_rate_hertz: builtins.int = ...,
        language_code: typing.Text = ...,
        phrase_hints: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["audio_encoding",b"audio_encoding","language_code",b"language_code","phrase_hints",b"phrase_hints","sample_rate_hertz",b"sample_rate_hertz"]) -> None: ...
global___InputAudioConfig = InputAudioConfig

class TextInput(google.protobuf.message.Message):
    """Represents the natural language text to be processed."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TEXT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    text: typing.Text
    """Required. The UTF-8 encoded natural language text to be processed.
    Text length must not exceed 256 bytes.
    """

    language_code: typing.Text
    """Required. The language of this conversational query. See [Language
    Support](https://dialogflow.com/docs/languages) for a list of the
    currently supported language codes. Note that queries in the same session
    do not necessarily need to specify the same language.
    """

    def __init__(self,
        *,
        text: typing.Text = ...,
        language_code: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","text",b"text"]) -> None: ...
global___TextInput = TextInput

class EventInput(google.protobuf.message.Message):
    """Events allow for matching intents by event name instead of the natural
    language input. For instance, input `<event: { name: “welcome_event”,
    parameters: { name: “Sam” } }>` can trigger a personalized welcome response.
    The parameter `name` may be used by the agent in the response:
    `“Hello #welcome_event.name! What can I do for you today?”`.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    name: typing.Text
    """Required. The unique identifier of the event."""

    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """Optional. The collection of parameters associated with the event."""
        pass
    language_code: typing.Text
    """Required. The language of this query. See [Language
    Support](https://dialogflow.com/docs/languages) for a list of the
    currently supported language codes. Note that queries in the same session
    do not necessarily need to specify the same language.
    """

    def __init__(self,
        *,
        name: typing.Text = ...,
        parameters: typing.Optional[google.protobuf.struct_pb2.Struct] = ...,
        language_code: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["parameters",b"parameters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["language_code",b"language_code","name",b"name","parameters",b"parameters"]) -> None: ...
global___EventInput = EventInput

class Session(google.protobuf.message.Message):
    """*** SESSION RELATED MESSAGES *** //"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _View:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Session._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: Session._View.ValueType  # 0
        """Endpoints decide whether to return the full or the sparse view"""

        VIEW_FULL: Session._View.ValueType  # 1
        """All fields are populated."""

        VIEW_SPARSE: Session._View.ValueType  # 2
        """Only some fields are populated in the response."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """Represents the options for views of a session.
        A session can be a sizable object. Therefore, we provide a resource view that
        does not return all data
        """
        pass

    VIEW_UNSPECIFIED: Session.View.ValueType  # 0
    """Endpoints decide whether to return the full or the sparse view"""

    VIEW_FULL: Session.View.ValueType  # 1
    """All fields are populated."""

    VIEW_SPARSE: Session.View.ValueType  # 2
    """Only some fields are populated in the response."""


    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_STEPS_FIELD_NUMBER: builtins.int
    SESSION_INFO_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    """The unique identifier of the session"""

    @property
    def session_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionStep]:
        """The list of all the steps of the session"""
        pass
    @property
    def session_info(self) -> global___SessionInfo: ...
    def __init__(self,
        *,
        session_id: typing.Text = ...,
        session_steps: typing.Optional[typing.Iterable[global___SessionStep]] = ...,
        session_info: typing.Optional[global___SessionInfo] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_info",b"session_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id",b"session_id","session_info",b"session_info","session_steps",b"session_steps"]) -> None: ...
global___Session = Session

class SessionStep(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DETECT_INTENT_REQUEST_FIELD_NUMBER: builtins.int
    DETECT_INTENT_RESPONSE_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    @property
    def detect_intent_request(self) -> global___DetectIntentRequest: ...
    @property
    def detect_intent_response(self) -> global___DetectIntentResponse: ...
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The contexts which were active at the beginning of this step"""
        pass
    def __init__(self,
        *,
        detect_intent_request: typing.Optional[global___DetectIntentRequest] = ...,
        detect_intent_response: typing.Optional[global___DetectIntentResponse] = ...,
        contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["detect_intent_request",b"detect_intent_request","detect_intent_response",b"detect_intent_response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contexts",b"contexts","detect_intent_request",b"detect_intent_request","detect_intent_response",b"detect_intent_response"]) -> None: ...
global___SessionStep = SessionStep

class TrackSessionStepRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_STEP_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    @property
    def session_step(self) -> global___SessionStep: ...
    session_view: global___Session.View.ValueType
    def __init__(self,
        *,
        session_id: typing.Text = ...,
        session_step: typing.Optional[global___SessionStep] = ...,
        session_view: global___Session.View.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_step",b"session_step"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id",b"session_id","session_step",b"session_step","session_view",b"session_view"]) -> None: ...
global___TrackSessionStepRequest = TrackSessionStepRequest

class ListSessionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    SESSION_FILTER_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """The parent for which sessions should be listed
    Format: `projects/<PROJECT_ID>/agent`.
    """

    session_view: global___Session.View.ValueType
    """An enum specifying the amount of information to be returned per session"""

    page_token: typing.Text
    """Optional. The next_page_token value returned from a previous list request."""

    @property
    def session_filter(self) -> global___SessionFilter:
        """Optional. A filter to narrow the response down to sessions of interest."""
        pass
    def __init__(self,
        *,
        parent: typing.Text = ...,
        session_view: global___Session.View.ValueType = ...,
        page_token: typing.Text = ...,
        session_filter: typing.Optional[global___SessionFilter] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_filter",b"session_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token",b"page_token","parent",b"parent","session_filter",b"session_filter","session_view",b"session_view"]) -> None: ...
global___ListSessionsRequest = ListSessionsRequest

class SessionFilter(google.protobuf.message.Message):
    """A SessionFilter can be used in some requests to return only sessions matching certain filter conditions.

    All fields below are  optional. Multiple fields specified at the same time are chained via AND.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    MATCHED_INTENTS_FIELD_NUMBER: builtins.int
    MATCHED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    MIN_INTENTS_CONFIDENCE_MIN_FIELD_NUMBER: builtins.int
    MIN_INTENTS_CONFIDENCE_MAX_FIELD_NUMBER: builtins.int
    MIN_ENTITY_TYPES_CONFIDENCE_MIN_FIELD_NUMBER: builtins.int
    MIN_ENTITY_TYPES_CONFIDENCE_MAX_FIELD_NUMBER: builtins.int
    EARLIEST_FIELD_NUMBER: builtins.int
    LATEST_FIELD_NUMBER: builtins.int
    MIN_NUMBER_TURNS_FIELD_NUMBER: builtins.int
    MAX_NUMBER_TURNS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    INTENT_TAGS_FIELD_NUMBER: builtins.int
    SESSION_IDS_FIELD_NUMBER: builtins.int
    INPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    OUTPUT_CONTEXTS_FIELD_NUMBER: builtins.int
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Match only sessions with all of the following language_codes"""
        pass
    @property
    def matched_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent]:
        """Match only sessions during which all of the following intents were detected
        NOTE: only name and display name fields are used for comparison
        """
        pass
    @property
    def matched_entity_types(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.entity_type_pb2.EntityType]:
        """Match only sessions during which all of the following entity types were recognized
        NOTE: only name and display name fields are used for comparison
        """
        pass
    min_intents_confidence_min: builtins.float
    """Match only sessions where the minimum confidence for intent detection along the session falls in the following range
    defaults to -1 if not set
    """

    min_intents_confidence_max: builtins.float
    """defaults to +1 if not set"""

    min_entity_types_confidence_min: builtins.float
    """Match only sessions where the minimum confidence for entity recognition along the session falls in the following range
    defaults to -1 if not set
    """

    min_entity_types_confidence_max: builtins.float
    """defaults to +1 if not set"""

    earliest: builtins.float
    """Match only sessions whose time range falls within the following range (in UNIX epochs)
    defaults to 0 if not set
    """

    latest: builtins.float
    """defaults to current epoch if not set"""

    min_number_turns: builtins.int
    """Match only sessions for which the number of turns (interaction steps) falls in the following range
    defaults to 0 if not set
    """

    max_number_turns: builtins.int
    """defaults to MAXINT if not set"""

    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Match only session which have all of the following labels assigned"""
        pass
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Match only session which had all of the following user_ids interacting with them."""
        pass
    @property
    def intent_tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Match only session which have all of the following intent tags assigned"""
        pass
    @property
    def session_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Match only sessions whose IDs are specified here"""
        pass
    @property
    def input_contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """Match only sessions whose session info contains at least one step having all the contexts specified here"""
        pass
    @property
    def output_contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]: ...
    def __init__(self,
        *,
        language_codes: typing.Optional[typing.Iterable[typing.Text]] = ...,
        matched_intents: typing.Optional[typing.Iterable[ondewo.nlu.intent_pb2.Intent]] = ...,
        matched_entity_types: typing.Optional[typing.Iterable[ondewo.nlu.entity_type_pb2.EntityType]] = ...,
        min_intents_confidence_min: builtins.float = ...,
        min_intents_confidence_max: builtins.float = ...,
        min_entity_types_confidence_min: builtins.float = ...,
        min_entity_types_confidence_max: builtins.float = ...,
        earliest: builtins.float = ...,
        latest: builtins.float = ...,
        min_number_turns: builtins.int = ...,
        max_number_turns: builtins.int = ...,
        labels: typing.Optional[typing.Iterable[typing.Text]] = ...,
        user_ids: typing.Optional[typing.Iterable[typing.Text]] = ...,
        intent_tags: typing.Optional[typing.Iterable[typing.Text]] = ...,
        session_ids: typing.Optional[typing.Iterable[typing.Text]] = ...,
        input_contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        output_contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["earliest",b"earliest","input_contexts",b"input_contexts","intent_tags",b"intent_tags","labels",b"labels","language_codes",b"language_codes","latest",b"latest","matched_entity_types",b"matched_entity_types","matched_intents",b"matched_intents","max_number_turns",b"max_number_turns","min_entity_types_confidence_max",b"min_entity_types_confidence_max","min_entity_types_confidence_min",b"min_entity_types_confidence_min","min_intents_confidence_max",b"min_intents_confidence_max","min_intents_confidence_min",b"min_intents_confidence_min","min_number_turns",b"min_number_turns","output_contexts",b"output_contexts","session_ids",b"session_ids","user_ids",b"user_ids"]) -> None: ...
global___SessionFilter = SessionFilter

class SessionInfo(google.protobuf.message.Message):
    """A SessionInfo contains some general information about a session.

    This information can be returned inside a Session object for consumption by a client.
    Or it can be used by the backend to check whether the Session matches a given SessionFilter.

    All fields below are  optional. Multiple fields specified at the same time are chained
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class ContextSteps(google.protobuf.message.Message):
        """The list of contexts of each step collected in an outer list"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        CONTEXTS_FIELD_NUMBER: builtins.int
        @property
        def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]: ...
        def __init__(self,
            *,
            contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["contexts",b"contexts"]) -> None: ...

    LANGUAGE_CODES_FIELD_NUMBER: builtins.int
    MATCHED_INTENTS_FIELD_NUMBER: builtins.int
    MATCHED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    MIN_INTENTS_CONFIDENCE_FIELD_NUMBER: builtins.int
    MIN_ENTITY_TYPES_CONFIDENCE_FIELD_NUMBER: builtins.int
    EARLIEST_FIELD_NUMBER: builtins.int
    LATEST_FIELD_NUMBER: builtins.int
    NUMBER_TURNS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    INTENT_TAGS_FIELD_NUMBER: builtins.int
    INPUT_CONTEXT_STEPS_FIELD_NUMBER: builtins.int
    OUTPUT_CONTEXT_STEPS_FIELD_NUMBER: builtins.int
    @property
    def language_codes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """The language codes used in the given session."""
        pass
    @property
    def matched_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent]:
        """A list of intents which have been matched"""
        pass
    @property
    def matched_entity_types(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.entity_type_pb2.EntityType]:
        """A list of entity types which have been matched"""
        pass
    min_intents_confidence: builtins.float
    """The minimum confidence for intent recognition along the session"""

    min_entity_types_confidence: builtins.float
    """The minimum confidence for entity recognition along the session"""

    earliest: builtins.float
    """The start and end dates of the given session (in UNIX epochs)"""

    latest: builtins.float
    number_turns: builtins.int
    """The number of turns (interaction steps) in the given session"""

    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """The list of labels of the given session"""
        pass
    @property
    def user_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """The user_ids of the users which were interacting within the given session"""
        pass
    @property
    def intent_tags(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """The list of intent tags in the given session"""
        pass
    @property
    def input_context_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionInfo.ContextSteps]: ...
    @property
    def output_context_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionInfo.ContextSteps]: ...
    def __init__(self,
        *,
        language_codes: typing.Optional[typing.Iterable[typing.Text]] = ...,
        matched_intents: typing.Optional[typing.Iterable[ondewo.nlu.intent_pb2.Intent]] = ...,
        matched_entity_types: typing.Optional[typing.Iterable[ondewo.nlu.entity_type_pb2.EntityType]] = ...,
        min_intents_confidence: builtins.float = ...,
        min_entity_types_confidence: builtins.float = ...,
        earliest: builtins.float = ...,
        latest: builtins.float = ...,
        number_turns: builtins.int = ...,
        labels: typing.Optional[typing.Iterable[typing.Text]] = ...,
        user_ids: typing.Optional[typing.Iterable[typing.Text]] = ...,
        intent_tags: typing.Optional[typing.Iterable[typing.Text]] = ...,
        input_context_steps: typing.Optional[typing.Iterable[global___SessionInfo.ContextSteps]] = ...,
        output_context_steps: typing.Optional[typing.Iterable[global___SessionInfo.ContextSteps]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["earliest",b"earliest","input_context_steps",b"input_context_steps","intent_tags",b"intent_tags","labels",b"labels","language_codes",b"language_codes","latest",b"latest","matched_entity_types",b"matched_entity_types","matched_intents",b"matched_intents","min_entity_types_confidence",b"min_entity_types_confidence","min_intents_confidence",b"min_intents_confidence","number_turns",b"number_turns","output_context_steps",b"output_context_steps","user_ids",b"user_ids"]) -> None: ...
global___SessionInfo = SessionInfo

class ListSessionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def sessions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Session]:
        """The requested sessions"""
        pass
    next_page_token: typing.Text
    """Token to retrieve the next page of results, or empty if there are no more results in the list"""

    def __init__(self,
        *,
        sessions: typing.Optional[typing.Iterable[global___Session]] = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token",b"next_page_token","sessions",b"sessions"]) -> None: ...
global___ListSessionsResponse = ListSessionsResponse

class GetSessionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    """The session to be returned
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_ID>`.
    """

    session_view: global___Session.View.ValueType
    """whether to return a full or sparse view; if unspecified full view is returned"""

    def __init__(self,
        *,
        session_id: typing.Text = ...,
        session_view: global___Session.View.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id",b"session_id","session_view",b"session_view"]) -> None: ...
global___GetSessionRequest = GetSessionRequest

class CreateSessionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    SESSION_UUID_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Creates a session that collects all the conversation interactions between the machine and a user
    The unique identifier of an Agent
    Format: `projects/<PROJECT_ID>/agent`.
    Required.
    """

    session_uuid: typing.Text
    """The unique UUID of a Session
    Format: UUID Version 4, e.g. 2f59fad2-06bc-4730-9920-d3148f28f357
    Optional. If not provided, it will be auto-generated
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        session_uuid: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent","session_uuid",b"session_uuid"]) -> None: ...
global___CreateSessionRequest = CreateSessionRequest

class DeleteSessionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    """Required. The session to be deleted
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_UUID>`.
    """

    def __init__(self,
        *,
        session_id: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id",b"session_id"]) -> None: ...
global___DeleteSessionRequest = DeleteSessionRequest

class CreateSessionReviewRequest(google.protobuf.message.Message):
    """*** SESSION-REVIEW RELATED MESSAGES *** //"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    PARENT_REVIEW_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    """The unique identifier for the session under review
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_ID>`.
    """

    parent_review_id: typing.Text
    """Optional: The unique identifier of the parent review
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_ID>/reviews/<SESSION_REVIEW_ID>`.
    """

    @property
    def session_review(self) -> global___SessionReview:
        """The reviews for all steps in the session"""
        pass
    session_review_view: global___SessionReview.View.ValueType
    def __init__(self,
        *,
        session_id: typing.Text = ...,
        parent_review_id: typing.Text = ...,
        session_review: typing.Optional[global___SessionReview] = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["session_review",b"session_review"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent_review_id",b"parent_review_id","session_id",b"session_id","session_review",b"session_review","session_review_view",b"session_review_view"]) -> None: ...
global___CreateSessionReviewRequest = CreateSessionReviewRequest

class SessionReview(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _View:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SessionReview._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: SessionReview._View.ValueType  # 0
        """Endpoints decide whether to return the full or the sparse view"""

        VIEW_FULL: SessionReview._View.ValueType  # 1
        """All fields are populated."""

        VIEW_SPARSE: SessionReview._View.ValueType  # 2
        """Only some fields are populated in the response."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """Represents the options for views of a session_review.
        A session_review can be a sizable object. Therefore, we provide a resource view that
        does not return all data
        """
        pass

    VIEW_UNSPECIFIED: SessionReview.View.ValueType  # 0
    """Endpoints decide whether to return the full or the sparse view"""

    VIEW_FULL: SessionReview.View.ValueType  # 1
    """All fields are populated."""

    VIEW_SPARSE: SessionReview.View.ValueType  # 2
    """Only some fields are populated in the response."""


    SESSION_REVIEW_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_STEPS_FIELD_NUMBER: builtins.int
    session_review_id: typing.Text
    """The unique identifier for the given review
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_ID>/reviews/<SESSION_REVIEW_ID>`.
    """

    @property
    def session_review_steps(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionReviewStep]:
        """The reviews for all steps in the session"""
        pass
    def __init__(self,
        *,
        session_review_id: typing.Text = ...,
        session_review_steps: typing.Optional[typing.Iterable[global___SessionReviewStep]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_review_id",b"session_review_id","session_review_steps",b"session_review_steps"]) -> None: ...
global___SessionReview = SessionReview

class SessionReviewStep(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ANNOTATED_USERSAYS_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    DETECTED_INTENTS_FIELD_NUMBER: builtins.int
    CONTEXTS_FIELD_NUMBER: builtins.int
    CONTEXTS_OUT_FIELD_NUMBER: builtins.int
    @property
    def annotated_usersays(self) -> ondewo.nlu.intent_pb2.Intent.TrainingPhrase:
        """The user says with markup of the detected entity types"""
        pass
    language_code: typing.Text
    """The language code"""

    @property
    def detected_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DetectedIntent]:
        """Unique detected intents ordered by descending confidence"""
        pass
    @property
    def contexts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The contexts which were active at the beginning of this step"""
        pass
    @property
    def contexts_out(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.context_pb2.Context]:
        """The output contexts of this step"""
        pass
    def __init__(self,
        *,
        annotated_usersays: typing.Optional[ondewo.nlu.intent_pb2.Intent.TrainingPhrase] = ...,
        language_code: typing.Text = ...,
        detected_intents: typing.Optional[typing.Iterable[global___DetectedIntent]] = ...,
        contexts: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        contexts_out: typing.Optional[typing.Iterable[ondewo.nlu.context_pb2.Context]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["annotated_usersays",b"annotated_usersays"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotated_usersays",b"annotated_usersays","contexts",b"contexts","contexts_out",b"contexts_out","detected_intents",b"detected_intents","language_code",b"language_code"]) -> None: ...
global___SessionReviewStep = SessionReviewStep

class DetectedIntent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    INTENT_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    FULFILLMENT_MESSAGES_FIELD_NUMBER: builtins.int
    REQUIRED_PARAM_MISSING_FIELD_NUMBER: builtins.int
    @property
    def intent(self) -> ondewo.nlu.intent_pb2.Intent:
        """intent"""
        pass
    score: builtins.float
    """score of intent detection"""

    algorithm: typing.Text
    """intent detection algorithm"""

    @property
    def fulfillment_messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent.Message]:
        """collection of rich messages to present to the user
        This field is set only for the first detected intent. For the rest of the intents the messages are not
          resolved and the raw messages for the current language code are available in self.intent.messages
        """
        pass
    required_param_missing: builtins.bool
    """This field is set to:
    - `true` if the matched intent has required parameters and not all of
       the required parameter values have been collected.
    - `false` if all required parameter values have been collected, or if the
       matched intent doesn't contain any required parameters.
    """

    def __init__(self,
        *,
        intent: typing.Optional[ondewo.nlu.intent_pb2.Intent] = ...,
        score: builtins.float = ...,
        algorithm: typing.Text = ...,
        fulfillment_messages: typing.Optional[typing.Iterable[ondewo.nlu.intent_pb2.Intent.Message]] = ...,
        required_param_missing: builtins.bool = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["intent",b"intent"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["algorithm",b"algorithm","fulfillment_messages",b"fulfillment_messages","intent",b"intent","required_param_missing",b"required_param_missing","score",b"score"]) -> None: ...
global___DetectedIntent = DetectedIntent

class ListSessionLabelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """The parent for which the labels for all sessions should be listed
    Format: `projects/<PROJECT_ID>/agent`.
    """

    def __init__(self,
        *,
        parent: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent",b"parent"]) -> None: ...
global___ListSessionLabelsRequest = ListSessionLabelsRequest

class ListSessionLabelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LABELS_FIELD_NUMBER: builtins.int
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        labels: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels",b"labels"]) -> None: ...
global___ListSessionLabelsResponse = ListSessionLabelsResponse

class AddSessionLabelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    session_view: global___Session.View.ValueType
    def __init__(self,
        *,
        session_id: typing.Text = ...,
        labels: typing.Optional[typing.Iterable[typing.Text]] = ...,
        session_view: global___Session.View.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels",b"labels","session_id",b"session_id","session_view",b"session_view"]) -> None: ...
global___AddSessionLabelsRequest = AddSessionLabelsRequest

class RemoveSessionLabelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SESSION_VIEW_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    @property
    def labels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    session_view: global___Session.View.ValueType
    def __init__(self,
        *,
        session_id: typing.Text = ...,
        labels: typing.Optional[typing.Iterable[typing.Text]] = ...,
        session_view: global___Session.View.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["labels",b"labels","session_id",b"session_id","session_view",b"session_view"]) -> None: ...
global___RemoveSessionLabelsRequest = RemoveSessionLabelsRequest

class ListSessionReviewsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    """The unique identifier for the session for which reviews should be listed
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_ID>`.
    """

    session_review_view: global___SessionReview.View.ValueType
    """An enum specifying the amount of information to be returned per session review"""

    page_token: typing.Text
    """Optional. The next_page_token value returned from a previous list request."""

    def __init__(self,
        *,
        session_id: typing.Text = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
        page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page_token",b"page_token","session_id",b"session_id","session_review_view",b"session_review_view"]) -> None: ...
global___ListSessionReviewsRequest = ListSessionReviewsRequest

class ListSessionReviewsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_REVIEWS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def session_reviews(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SessionReview]:
        """The requested session reviews"""
        pass
    next_page_token: typing.Text
    """Token to retrieve the next page of results, or empty if there are no more results in the list"""

    def __init__(self,
        *,
        session_reviews: typing.Optional[typing.Iterable[global___SessionReview]] = ...,
        next_page_token: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token",b"next_page_token","session_reviews",b"session_reviews"]) -> None: ...
global___ListSessionReviewsResponse = ListSessionReviewsResponse

class GetSessionReviewRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_REVIEW_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    session_review_id: typing.Text
    """The unique identifier of the session review to be returned"""

    session_review_view: global___SessionReview.View.ValueType
    def __init__(self,
        *,
        session_review_id: typing.Text = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_review_id",b"session_review_id","session_review_view",b"session_review_view"]) -> None: ...
global___GetSessionReviewRequest = GetSessionReviewRequest

class GetLatestSessionReviewRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_ID_FIELD_NUMBER: builtins.int
    SESSION_REVIEW_VIEW_FIELD_NUMBER: builtins.int
    session_id: typing.Text
    """The unique identifier of the session for which the latest review should be returned
    Format: `projects/<PROJECT_ID>/agent/sessions/<SESSION_ID>`.
    """

    session_review_view: global___SessionReview.View.ValueType
    """An enum specifying the amount of information to be returned for the desired session review"""

    def __init__(self,
        *,
        session_id: typing.Text = ...,
        session_review_view: global___SessionReview.View.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["session_id",b"session_id","session_review_view",b"session_review_view"]) -> None: ...
global___GetLatestSessionReviewRequest = GetLatestSessionReviewRequest
