"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import ondewo.nlu.entity_type_pb2
import ondewo.nlu.intent_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ReannotateEntitiesOptions:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _ReannotateEntitiesOptionsEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ReannotateEntitiesOptions.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    REANNOTATE_NEVER: _ReannotateEntitiesOptions.ValueType  # 0
    """Never re-annotate training phrases"""

    REANNOTATE_ALWAYS: _ReannotateEntitiesOptions.ValueType  # 1
    """Always re-annotate training phrases"""

    REANNOTATE_IF_EMPTY: _ReannotateEntitiesOptions.ValueType  # 2
    """Re-annotate training phrases if there are no annotations"""

    REANNOTATE_AFTER_DELETION: _ReannotateEntitiesOptions.ValueType  # 3
    """Re-annotate if training phrases have been deleted"""

    REANNOTATE_IF_EMPTY_OR_AFTER_DELETION: _ReannotateEntitiesOptions.ValueType  # 4
    """Re-annotate if there are no annotations or if training phrases have been deleted"""

class ReannotateEntitiesOptions(_ReannotateEntitiesOptions, metaclass=_ReannotateEntitiesOptionsEnumTypeWrapper):
    """Encapsulates entity re-annotation options"""
    pass

REANNOTATE_NEVER: ReannotateEntitiesOptions.ValueType  # 0
"""Never re-annotate training phrases"""

REANNOTATE_ALWAYS: ReannotateEntitiesOptions.ValueType  # 1
"""Always re-annotate training phrases"""

REANNOTATE_IF_EMPTY: ReannotateEntitiesOptions.ValueType  # 2
"""Re-annotate training phrases if there are no annotations"""

REANNOTATE_AFTER_DELETION: ReannotateEntitiesOptions.ValueType  # 3
"""Re-annotate if training phrases have been deleted"""

REANNOTATE_IF_EMPTY_OR_AFTER_DELETION: ReannotateEntitiesOptions.ValueType  # 4
"""Re-annotate if there are no annotations or if training phrases have been deleted"""

global___ReannotateEntitiesOptions = ReannotateEntitiesOptions


class ValidateRegexRequest(google.protobuf.message.Message):
    """The request to validate regexes."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REGEX_FIELD_NUMBER: builtins.int
    regex: typing.Text
    """String containing the regex."""

    def __init__(self,
        *,
        regex: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["regex",b"regex"]) -> None: ...
global___ValidateRegexRequest = ValidateRegexRequest

class ValidateRegexResponse(google.protobuf.message.Message):
    """The response of the regex validation"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ERROR_MESSAGES_FIELD_NUMBER: builtins.int
    @property
    def error_messages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Error messages"""
        pass
    def __init__(self,
        *,
        error_messages: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_messages",b"error_messages"]) -> None: ...
global___ValidateRegexResponse = ValidateRegexResponse

class ValidateEmbeddedRegexRequest(google.protobuf.message.Message):
    """Validation request for entity type values"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ENTITY_TYPE_FIELD_NUMBER: builtins.int
    @property
    def entity_type(self) -> ondewo.nlu.entity_type_pb2.EntityType.Entity: ...
    def __init__(self,
        *,
        entity_type: typing.Optional[ondewo.nlu.entity_type_pb2.EntityType.Entity] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity_type",b"entity_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity_type",b"entity_type"]) -> None: ...
global___ValidateEmbeddedRegexRequest = ValidateEmbeddedRegexRequest

class ValidateEmbeddedRegexResponse(google.protobuf.message.Message):
    """Response of the entity type validation"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ERROR_MESSAGES_FIELD_NUMBER: builtins.int
    @property
    def error_messages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """List of error message from the validation"""
        pass
    def __init__(self,
        *,
        error_messages: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_messages",b"error_messages"]) -> None: ...
global___ValidateEmbeddedRegexResponse = ValidateEmbeddedRegexResponse

class CleanAllIntentsRequest(google.protobuf.message.Message):
    """The request to clean the all intents."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    SUBSTRING_WHITE_LIST_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_CLEANER_OPTIONS_FIELD_NUMBER: builtins.int
    REANNOTATE_ENTITIES_OPTIONS_FIELD_NUMBER: builtins.int
    NUMBER_OF_WORKERS_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The agent to list all intents from.
    Format: `projects/<Project ID>/agent`.
    """

    language_code: typing.Text
    """Optional. The language to list training phrases, parameters and rich
    messages for. If not specified, the agent's default language is used.
    Note: languages must be enabled in the agent before they can be used.
    """

    special_characters: typing.Text
    """Optional. Characters to be recognized as special characters for cleaning.
    Overrides the default: '.,;!?:'
    """

    @property
    def substring_white_list(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. List of substring that shall not be cleaned/deleted.
        Example: ['St.', 'U.S.', 'sys.', '24.12.', 'Nr.', 'TelNr.']
        Default = None
        """
        pass
    dry_run: builtins.bool
    """Required. Do not apply changes to the database if set to True"""

    @property
    def training_phrase_cleaner_options(self) -> global___TrainingPhraseCleanerOptions:
        """Optional. Options for the cleaning of the training phrases."""
        pass
    reannotate_entities_options: global___ReannotateEntitiesOptions.ValueType
    """Optional. Options for re-annotation of entities (default = REANNOTATE_NEVER)"""

    number_of_workers: builtins.int
    """Optional. Number of threads used to accomplish the task"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        special_characters: typing.Text = ...,
        substring_white_list: typing.Optional[typing.Iterable[typing.Text]] = ...,
        dry_run: builtins.bool = ...,
        training_phrase_cleaner_options: typing.Optional[global___TrainingPhraseCleanerOptions] = ...,
        reannotate_entities_options: global___ReannotateEntitiesOptions.ValueType = ...,
        number_of_workers: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dry_run",b"dry_run","language_code",b"language_code","number_of_workers",b"number_of_workers","parent",b"parent","reannotate_entities_options",b"reannotate_entities_options","special_characters",b"special_characters","substring_white_list",b"substring_white_list","training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> None: ...
global___CleanAllIntentsRequest = CleanAllIntentsRequest

class CleanAllIntentsResponse(google.protobuf.message.Message):
    """Response corresponding to the CleanAllIntents Request"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CLEANED_INTENTS_FIELD_NUMBER: builtins.int
    INTENT_UPDATE_LIST_FIELD_NUMBER: builtins.int
    @property
    def cleaned_intents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent]:
        """Required. List of updates performed on intents"""
        pass
    @property
    def intent_update_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IntentUpdate]:
        """Optional. List of updates applied to intents"""
        pass
    def __init__(self,
        *,
        cleaned_intents: typing.Optional[typing.Iterable[ondewo.nlu.intent_pb2.Intent]] = ...,
        intent_update_list: typing.Optional[typing.Iterable[global___IntentUpdate]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cleaned_intents",b"cleaned_intents","intent_update_list",b"intent_update_list"]) -> None: ...
global___CleanAllIntentsResponse = CleanAllIntentsResponse

class CleanIntentRequest(google.protobuf.message.Message):
    """The request message to clean a single intents."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    INTENT_NAME_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    SUBSTRING_WHITE_LIST_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_CLEANER_OPTIONS_FIELD_NUMBER: builtins.int
    REANNOTATE_ENTITIES_OPTIONS_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The agent to list all intents from.
    Format: `projects/<Project ID>/agent`.
    """

    intent_name: typing.Text
    """Required. The name of the intent.
    Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
    """

    language_code: typing.Text
    """Optional. The language to list training phrases, parameters and rich
    messages for. If not specified, the agent's default language is used.
    Note: languages must be enabled in the agent before they can be used.
    """

    special_characters: typing.Text
    """Optional. Characters to be recognized as special characters for cleaning.
    Overrides the default: '.,;!?:'
    """

    @property
    def substring_white_list(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. List of substring that shall not be cleaned/deleted.
        Example: ['St.', 'U.S.', 'sys.', '24.12.', 'Nr.', 'TelNr.']
        Default = None
        """
        pass
    dry_run: builtins.bool
    """Required. Do not apply changes to the database if set to True"""

    @property
    def training_phrase_cleaner_options(self) -> global___TrainingPhraseCleanerOptions:
        """Optional. Options for the cleaning of the training phrases."""
        pass
    reannotate_entities_options: global___ReannotateEntitiesOptions.ValueType
    """Optional. Options for re-annotation of entities (default = REANNOTATE_NEVER)"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        intent_name: typing.Text = ...,
        language_code: typing.Text = ...,
        special_characters: typing.Text = ...,
        substring_white_list: typing.Optional[typing.Iterable[typing.Text]] = ...,
        dry_run: builtins.bool = ...,
        training_phrase_cleaner_options: typing.Optional[global___TrainingPhraseCleanerOptions] = ...,
        reannotate_entities_options: global___ReannotateEntitiesOptions.ValueType = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dry_run",b"dry_run","intent_name",b"intent_name","language_code",b"language_code","parent",b"parent","reannotate_entities_options",b"reannotate_entities_options","special_characters",b"special_characters","substring_white_list",b"substring_white_list","training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> None: ...
global___CleanIntentRequest = CleanIntentRequest

class CleanIntentResponse(google.protobuf.message.Message):
    """The response message to clean a single intents."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CLEANED_INTENT_FIELD_NUMBER: builtins.int
    INTENT_UPDATE_FIELD_NUMBER: builtins.int
    @property
    def cleaned_intent(self) -> ondewo.nlu.intent_pb2.Intent:
        """Required. Cleaned Intent"""
        pass
    @property
    def intent_update(self) -> global___IntentUpdate:
        """Optional. Updates applied to intent"""
        pass
    def __init__(self,
        *,
        cleaned_intent: typing.Optional[ondewo.nlu.intent_pb2.Intent] = ...,
        intent_update: typing.Optional[global___IntentUpdate] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cleaned_intent",b"cleaned_intent","intent_update",b"intent_update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cleaned_intent",b"cleaned_intent","intent_update",b"intent_update"]) -> None: ...
global___CleanIntentResponse = CleanIntentResponse

class TrainingPhraseCleanerOptions(google.protobuf.message.Message):
    """Options for cleaning the training phrases"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DELETE_REPEATED_WHITESPACES_FIELD_NUMBER: builtins.int
    DELETE_LEADING_SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    DELETE_TRAILING_SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    delete_repeated_whitespaces: builtins.bool
    """Whether or not to delete repeated whitespaces"""

    delete_leading_special_characters: builtins.bool
    """Whether of not to delete leading special characters"""

    delete_trailing_special_characters: builtins.bool
    """Whether of not to delete trailing special characters"""

    def __init__(self,
        *,
        delete_repeated_whitespaces: builtins.bool = ...,
        delete_leading_special_characters: builtins.bool = ...,
        delete_trailing_special_characters: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["delete_leading_special_characters",b"delete_leading_special_characters","delete_repeated_whitespaces",b"delete_repeated_whitespaces","delete_trailing_special_characters",b"delete_trailing_special_characters"]) -> None: ...
global___TrainingPhraseCleanerOptions = TrainingPhraseCleanerOptions

class StringUpdate(google.protobuf.message.Message):
    """Message to keep track of updated strings"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NEW_FIELD_NUMBER: builtins.int
    OLD_FIELD_NUMBER: builtins.int
    new: typing.Text
    """New version of the string"""

    old: typing.Text
    """Old version of the string"""

    def __init__(self,
        *,
        new: typing.Text = ...,
        old: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["new",b"new","old",b"old"]) -> None: ...
global___StringUpdate = StringUpdate

class IntentUpdate(google.protobuf.message.Message):
    """Stores updates applied to an intent"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class TrainingPhraseUpdate(google.protobuf.message.Message):
        """Message to track the updates made to a training phrase"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TRAINING_PHRASE_UPDATE_FIELD_NUMBER: builtins.int
        ENTITY_UPDATES_FIELD_NUMBER: builtins.int
        ENTITIES_REANNOTATED_FIELD_NUMBER: builtins.int
        CONTAINS_UPDATE_VARIABLE_FIELD_NUMBER: builtins.int
        @property
        def training_phrase_update(self) -> global___StringUpdate:
            """Stores updates of training phrases"""
            pass
        @property
        def entity_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StringUpdate]:
            """Stores updates of entity strings"""
            pass
        @property
        def entities_reannotated(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
            """Stores re-annotated entity strings"""
            pass
        contains_update_variable: builtins.bool
        """Will be switched to True if at least one update has been performed"""

        def __init__(self,
            *,
            training_phrase_update: typing.Optional[global___StringUpdate] = ...,
            entity_updates: typing.Optional[typing.Iterable[global___StringUpdate]] = ...,
            entities_reannotated: typing.Optional[typing.Iterable[typing.Text]] = ...,
            contains_update_variable: builtins.bool = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["training_phrase_update",b"training_phrase_update"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["contains_update_variable",b"contains_update_variable","entities_reannotated",b"entities_reannotated","entity_updates",b"entity_updates","training_phrase_update",b"training_phrase_update"]) -> None: ...

    INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_UPDATE_LIST_FIELD_NUMBER: builtins.int
    DELETED_PARAMETERS_FIELD_NUMBER: builtins.int
    intent_display_name: typing.Text
    """The display name of the intent"""

    @property
    def training_phrase_update_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___IntentUpdate.TrainingPhraseUpdate]:
        """List of the updated training phrases"""
        pass
    @property
    def deleted_parameters(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """List of the deleted parameters"""
        pass
    def __init__(self,
        *,
        intent_display_name: typing.Text = ...,
        training_phrase_update_list: typing.Optional[typing.Iterable[global___IntentUpdate.TrainingPhraseUpdate]] = ...,
        deleted_parameters: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["deleted_parameters",b"deleted_parameters","intent_display_name",b"intent_display_name","training_phrase_update_list",b"training_phrase_update_list"]) -> None: ...
global___IntentUpdate = IntentUpdate

class EntityTypeUpdate(google.protobuf.message.Message):
    """Stores updates applied to an entity type"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class EntityUpdate(google.protobuf.message.Message):
        """Stores updates applied to an entity"""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        ENTITY_VALUE_UPDATE_FIELD_NUMBER: builtins.int
        ENTITY_SYNONYM_UPDATES_FIELD_NUMBER: builtins.int
        @property
        def entity_value_update(self) -> global___StringUpdate:
            """Updates made to the entity value"""
            pass
        @property
        def entity_synonym_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StringUpdate]:
            """Updates made to the entity synonyms"""
            pass
        def __init__(self,
            *,
            entity_value_update: typing.Optional[global___StringUpdate] = ...,
            entity_synonym_updates: typing.Optional[typing.Iterable[global___StringUpdate]] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["entity_value_update",b"entity_value_update"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["entity_synonym_updates",b"entity_synonym_updates","entity_value_update",b"entity_value_update"]) -> None: ...

    ENTITY_TYPE_NAME_FIELD_NUMBER: builtins.int
    VALUES_UPDATE_LIST_FIELD_NUMBER: builtins.int
    entity_type_name: typing.Text
    """The entity type name"""

    @property
    def values_update_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EntityTypeUpdate.EntityUpdate]:
        """List of the updated entities"""
        pass
    def __init__(self,
        *,
        entity_type_name: typing.Text = ...,
        values_update_list: typing.Optional[typing.Iterable[global___EntityTypeUpdate.EntityUpdate]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity_type_name",b"entity_type_name","values_update_list",b"values_update_list"]) -> None: ...
global___EntityTypeUpdate = EntityTypeUpdate

class CleanAllEntityTypesRequest(google.protobuf.message.Message):
    """Request to clean the entity types"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    SUBSTRING_WHITE_LIST_FIELD_NUMBER: builtins.int
    MAX_ENTITY_COUNT_UPDATE_FIELD_NUMBER: builtins.int
    FORBIDDEN_ENTITY_TYPE_PATTERNS_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    NUMBER_OF_WORKERS_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The agent to list all intents from.
    Format: `projects/<Project ID>/agent`.
    """

    language_code: typing.Text
    """Optional. The language to list training phrases, parameters and rich
    messages for. If not specified, the agent's default language is used.
    Note: languages must be enabled in the agent before they can be used.
    """

    special_characters: typing.Text
    """Optional. Characters to be recognized as special characters for cleaning.
    Overrides the default: '.,;!?:'
    """

    @property
    def substring_white_list(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. List of substring that shall not be cleaned/deleted.
        Example: ['St.', 'U.S.', 'sys.', '24.12.', 'Nr.', 'TelNr.']
        """
        pass
    max_entity_count_update: builtins.int
    """Optional. Entity type that contain more than max_entity_count_update entities will
    not be cleaned. Relevant for auto-generated entity values (e.g. City Names)
    Default = 10000
    """

    @property
    def forbidden_entity_type_patterns(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. List of strings or regexes. Entity types will be deleted if their display
        name matches an element of this list
        Example: ['sys.ignore.'] -> would delete entity types with display names sys.ignore.*
        """
        pass
    dry_run: builtins.bool
    """Required. Do not apply changes to the database if set to True"""

    number_of_workers: builtins.int
    """Optional. Number of threads used to accomplish the task"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        special_characters: typing.Text = ...,
        substring_white_list: typing.Optional[typing.Iterable[typing.Text]] = ...,
        max_entity_count_update: builtins.int = ...,
        forbidden_entity_type_patterns: typing.Optional[typing.Iterable[typing.Text]] = ...,
        dry_run: builtins.bool = ...,
        number_of_workers: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dry_run",b"dry_run","forbidden_entity_type_patterns",b"forbidden_entity_type_patterns","language_code",b"language_code","max_entity_count_update",b"max_entity_count_update","number_of_workers",b"number_of_workers","parent",b"parent","special_characters",b"special_characters","substring_white_list",b"substring_white_list"]) -> None: ...
global___CleanAllEntityTypesRequest = CleanAllEntityTypesRequest

class CleanAllEntityTypesResponse(google.protobuf.message.Message):
    """Response from entity type cleaner"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CLEANED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    DELETED_ENTITY_TYPES_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_UPDATES_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_DELETIONS_FIELD_NUMBER: builtins.int
    @property
    def cleaned_entity_types(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.entity_type_pb2.EntityType]:
        """Required. List of updated entity types"""
        pass
    @property
    def deleted_entity_types(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.entity_type_pb2.EntityType]:
        """Optional. List of updated entity types"""
        pass
    @property
    def entity_type_updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EntityTypeUpdate]:
        """Optional. List of updates performed on entity types"""
        pass
    @property
    def entity_type_deletions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EntityTypeUpdate]:
        """Optional. List of the deleted entity types"""
        pass
    def __init__(self,
        *,
        cleaned_entity_types: typing.Optional[typing.Iterable[ondewo.nlu.entity_type_pb2.EntityType]] = ...,
        deleted_entity_types: typing.Optional[typing.Iterable[ondewo.nlu.entity_type_pb2.EntityType]] = ...,
        entity_type_updates: typing.Optional[typing.Iterable[global___EntityTypeUpdate]] = ...,
        entity_type_deletions: typing.Optional[typing.Iterable[global___EntityTypeUpdate]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cleaned_entity_types",b"cleaned_entity_types","deleted_entity_types",b"deleted_entity_types","entity_type_deletions",b"entity_type_deletions","entity_type_updates",b"entity_type_updates"]) -> None: ...
global___CleanAllEntityTypesResponse = CleanAllEntityTypesResponse

class CleanEntityTypeRequest(google.protobuf.message.Message):
    """Request to clean a single entity type"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_NAME_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    SUBSTRING_WHITE_LIST_FIELD_NUMBER: builtins.int
    MAX_ENTITY_COUNT_UPDATE_FIELD_NUMBER: builtins.int
    DRY_RUN_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The agent to list all intents from.
    Format: `projects/<Project ID>/agent`.
    """

    entity_type_name: typing.Text
    """Required. The name of the entity_type"""

    language_code: typing.Text
    """Optional. The language to list training phrases, parameters and rich
    messages for. If not specified, the agent's default language is used.
    Note: languages must be enabled in the agent before they can be used.
    """

    special_characters: typing.Text
    """Optional. Characters to be recognized as special characters for cleaning.
    Overrides the default: '.,;!?:'
    """

    @property
    def substring_white_list(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Optional. List of substring that shall not be cleaned/deleted.
        Example: ['St.', 'U.S.', 'sys.', '24.12.', 'Nr.', 'TelNr.']
        """
        pass
    max_entity_count_update: builtins.int
    """Optional. Entity type that contain more than max_entity_count_update entities will
    not be cleaned. Relevant for auto-generated entity values (e.g. City Names)
    Default = 10000
    """

    dry_run: builtins.bool
    """Required. Do not apply changes to the database if set to True"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        entity_type_name: typing.Text = ...,
        language_code: typing.Text = ...,
        special_characters: typing.Text = ...,
        substring_white_list: typing.Optional[typing.Iterable[typing.Text]] = ...,
        max_entity_count_update: builtins.int = ...,
        dry_run: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dry_run",b"dry_run","entity_type_name",b"entity_type_name","language_code",b"language_code","max_entity_count_update",b"max_entity_count_update","parent",b"parent","special_characters",b"special_characters","substring_white_list",b"substring_white_list"]) -> None: ...
global___CleanEntityTypeRequest = CleanEntityTypeRequest

class CleanEntityTypeResponse(google.protobuf.message.Message):
    """Response from entity type cleaner"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CLEANED_ENTITY_TYPE_FIELD_NUMBER: builtins.int
    ENTITY_TYPE_UPDATE_FIELD_NUMBER: builtins.int
    @property
    def cleaned_entity_type(self) -> ondewo.nlu.entity_type_pb2.EntityType:
        """Required. The cleaned entity type"""
        pass
    @property
    def entity_type_update(self) -> global___EntityTypeUpdate:
        """Optional. The updated entity type"""
        pass
    def __init__(self,
        *,
        cleaned_entity_type: typing.Optional[ondewo.nlu.entity_type_pb2.EntityType] = ...,
        entity_type_update: typing.Optional[global___EntityTypeUpdate] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cleaned_entity_type",b"cleaned_entity_type","entity_type_update",b"entity_type_update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cleaned_entity_type",b"cleaned_entity_type","entity_type_update",b"entity_type_update"]) -> None: ...
global___CleanEntityTypeResponse = CleanEntityTypeResponse

class AddTrainingPhrasesRequest(google.protobuf.message.Message):
    """Request message to AddTrainingPhrase rpc"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class TrainingPhraseForIntent(google.protobuf.message.Message):
        """Message that contains the new training phrase, together with the intent display name
        and, optionally the entity annotations
        """
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        TRAINING_PHRASE_FIELD_NUMBER: builtins.int
        INTENT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
        ENTITIES_FIELD_NUMBER: builtins.int
        training_phrase: typing.Text
        """Required. New training phrase to be added"""

        intent_display_name: typing.Text
        """Required. Corresponding display name of the intent"""

        @property
        def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[ondewo.nlu.intent_pb2.Intent.TrainingPhrase.Entity]:
            """Optional. Entity annotations"""
            pass
        def __init__(self,
            *,
            training_phrase: typing.Text = ...,
            intent_display_name: typing.Text = ...,
            entities: typing.Optional[typing.Iterable[ondewo.nlu.intent_pb2.Intent.TrainingPhrase.Entity]] = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["entities",b"entities","intent_display_name",b"intent_display_name","training_phrase",b"training_phrase"]) -> None: ...

    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_LIST_FIELD_NUMBER: builtins.int
    EXTRACT_ENTITIES_FIELD_NUMBER: builtins.int
    SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_CLEANER_OPTIONS_FIELD_NUMBER: builtins.int
    NUMBER_OF_WORKERS_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The agent to list all intents from.
    Format: `projects/<Project ID>/agent`.
    """

    language_code: typing.Text
    """Required. The language to list training phrases, parameters and rich
    messages for. If not specified, the agent's default language is used.
    Note: languages must be enabled in the agent before they can be used.
    """

    @property
    def training_phrase_list(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AddTrainingPhrasesRequest.TrainingPhraseForIntent]:
        """Required. List of training phrases to be added to the intent"""
        pass
    extract_entities: builtins.bool
    """Optional. Whether or not to extract entities for the new training phrases"""

    special_characters: typing.Text
    """Optional. Characters to be recognized as special characters for cleaning
    the training phrases. Overrides the default: '.,;!?:'
    """

    @property
    def training_phrase_cleaner_options(self) -> global___TrainingPhraseCleanerOptions:
        """Optional. Options for the training phrase cleaner to override the default settings"""
        pass
    number_of_workers: builtins.int
    """Optional. Number of threads used to accomplish the task"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        training_phrase_list: typing.Optional[typing.Iterable[global___AddTrainingPhrasesRequest.TrainingPhraseForIntent]] = ...,
        extract_entities: builtins.bool = ...,
        special_characters: typing.Text = ...,
        training_phrase_cleaner_options: typing.Optional[global___TrainingPhraseCleanerOptions] = ...,
        number_of_workers: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extract_entities",b"extract_entities","language_code",b"language_code","number_of_workers",b"number_of_workers","parent",b"parent","special_characters",b"special_characters","training_phrase_cleaner_options",b"training_phrase_cleaner_options","training_phrase_list",b"training_phrase_list"]) -> None: ...
global___AddTrainingPhrasesRequest = AddTrainingPhrasesRequest

class AddTrainingPhrasesResponse(google.protobuf.message.Message):
    """Response message to AddTrainingPhrase rpc"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ERROR_MESSAGES_FIELD_NUMBER: builtins.int
    @property
    def error_messages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]:
        """Required. If something goes wrong, error messages will be conveyed via a repeated string"""
        pass
    def __init__(self,
        *,
        error_messages: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error_messages",b"error_messages"]) -> None: ...
global___AddTrainingPhrasesResponse = AddTrainingPhrasesResponse

class AddTrainingPhrasesFromCSVRequest(google.protobuf.message.Message):
    """Request message to AddTrainingPhraseFromCSV rpc"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    PARENT_FIELD_NUMBER: builtins.int
    LANGUAGE_CODE_FIELD_NUMBER: builtins.int
    CSV_CONTENTS_FIELD_NUMBER: builtins.int
    EXTRACT_ENTITIES_FIELD_NUMBER: builtins.int
    SPECIAL_CHARACTERS_FIELD_NUMBER: builtins.int
    TRAINING_PHRASE_CLEANER_OPTIONS_FIELD_NUMBER: builtins.int
    NUMBER_OF_WORKERS_FIELD_NUMBER: builtins.int
    parent: typing.Text
    """Required. The agent to list all intents from.
    Format: `projects/<Project ID>/agent`.
    """

    language_code: typing.Text
    """Required. The language to list training phrases, parameters and rich
    messages for. If not specified, the agent's default language is used.
    Note: languages must be enabled in the agent before they can be used.
    """

    csv_contents: builtins.bytes
    """Required. Contents of the .csv file containing training phrases to be added to the intents"""

    extract_entities: builtins.bool
    """Optional. Whether or not to extract entities for the new training phrases"""

    special_characters: typing.Text
    """Optional. Before new training phrases are added to their corresponding intent,
    they are cleaned with cleaning scripts. These cleaning scripts remove certain special characters,
    if they are found at the beginning of the text or if they appear in annotations.
    Overrides the default: '.,;!?:'
    """

    @property
    def training_phrase_cleaner_options(self) -> global___TrainingPhraseCleanerOptions:
        """Optional. Options for the training phrase cleaner to override the default settings"""
        pass
    number_of_workers: builtins.int
    """Optional. Number of threads used to accomplish the task"""

    def __init__(self,
        *,
        parent: typing.Text = ...,
        language_code: typing.Text = ...,
        csv_contents: builtins.bytes = ...,
        extract_entities: builtins.bool = ...,
        special_characters: typing.Text = ...,
        training_phrase_cleaner_options: typing.Optional[global___TrainingPhraseCleanerOptions] = ...,
        number_of_workers: builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["csv_contents",b"csv_contents","extract_entities",b"extract_entities","language_code",b"language_code","number_of_workers",b"number_of_workers","parent",b"parent","special_characters",b"special_characters","training_phrase_cleaner_options",b"training_phrase_cleaner_options"]) -> None: ...
global___AddTrainingPhrasesFromCSVRequest = AddTrainingPhrasesFromCSVRequest
