# Generated by Django 5.2 on 2025-04-19 11:30

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Role",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("description", models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name="Policy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("action", models.CharField(max_length=100)),
                ("resource_type", models.CharField(max_length=100)),
                ("description", models.TextField(blank=True)),
            ],
            options={
                "verbose_name": "policy",
                "verbose_name_plural": "policies",
                "ordering": ["action", "resource_type"],
                "unique_together": {("action", "resource_type")},
            },
        ),
        migrations.CreateModel(
            name="RolePolicy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "policy",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="drf_iam.policy"
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="drf_iam.role"
                    ),
                ),
            ],
            options={
                "verbose_name": "role policy",
                "verbose_name_plural": "role policies",
                "ordering": ["role", "policy"],
                "unique_together": {("role", "policy")},
            },
        ),
        migrations.AddField(
            model_name="role",
            name="policies",
            field=models.ManyToManyField(
                blank=True,
                db_index=True,
                related_name="policies",
                related_query_name="policies",
                through="drf_iam.RolePolicy",
                to="drf_iam.policy",
            ),
        ),
    ]
