# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .stream_input_query_parameters_optimize_streaming_latency import (
    StreamInputQueryParametersOptimizeStreamingLatency,
)
from .text_to_speech_output_format_enum import TextToSpeechOutputFormatEnum
from .text_to_speech_apply_text_normalization_enum import (
    TextToSpeechApplyTextNormalizationEnum,
)
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class StreamInputQueryParameters(UncheckedBaseModel):
    model_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The model ID to use
    """

    language_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ISO 639-1 language code (for Turbo v2.5 and Flash v2.5 models only)
    """

    enable_logging: typing.Optional[str] = pydantic.Field(default=None)
    """
    Whether to enable logging of the request
    """

    enable_ssml_parsing: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to enable SSML parsing
    """

    optimize_streaming_latency: typing.Optional[StreamInputQueryParametersOptimizeStreamingLatency] = pydantic.Field(
        default=None
    )
    """
    Latency optimization level (deprecated)
    """

    output_format: typing.Optional[TextToSpeechOutputFormatEnum] = None
    inactivity_timeout: typing.Optional[float] = pydantic.Field(default=None)
    """
    Timeout for inactivity before connection is closed
    """

    sync_alignment: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to include timing data with every audio chunk
    """

    auto_mode: typing.Optional[bool] = pydantic.Field(default=None)
    """
    This parameter focuses on reducing the latency by disabling the chunk schedule and all buffers. It is only recommended when sending full sentences or phrases, sending partial phrases will result in highly reduced quality. By default it's set to false.
    """

    apply_text_normalization: typing.Optional[TextToSpeechApplyTextNormalizationEnum] = None
    seed: typing.Optional[int] = pydantic.Field(default=None)
    """
    If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed. Must be an integer between 0 and 4294967295.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
