# This file was auto-generated by Fern from our API Definition.

import typing
from ....core.client_wrapper import SyncClientWrapper
from .captcha.client import CaptchaClient
from .... import core
from ....core.request_options import RequestOptions
from ....types.request_pvc_manual_verification_response_model import (
    RequestPvcManualVerificationResponseModel,
)
from ....core.jsonable_encoder import jsonable_encoder
from ....core.unchecked_base_model import construct_type
from ....errors.unprocessable_entity_error import UnprocessableEntityError
from ....types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ....core.api_error import ApiError
from ....core.client_wrapper import AsyncClientWrapper
from .captcha.client import AsyncCaptchaClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VerificationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.captcha = CaptchaClient(client_wrapper=self._client_wrapper)

    def request(
        self,
        voice_id: str,
        *,
        files: typing.List[core.File],
        extra_text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RequestPvcManualVerificationResponseModel:
        """
        Request manual verification for a PVC voice.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        files : typing.List[core.File]
            See core.File for more documentation

        extra_text : typing.Optional[str]
            Extra text to be used in the manual verification process.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RequestPvcManualVerificationResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.voices.pvc.verification.request(
            voice_id="21m00Tcm4TlvDq8ikWAM",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/voices/pvc/{jsonable_encoder(voice_id)}/verification",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            data={
                "extra_text": extra_text,
            },
            files={
                "files": files,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RequestPvcManualVerificationResponseModel,
                    construct_type(
                        type_=RequestPvcManualVerificationResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncVerificationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.captcha = AsyncCaptchaClient(client_wrapper=self._client_wrapper)

    async def request(
        self,
        voice_id: str,
        *,
        files: typing.List[core.File],
        extra_text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RequestPvcManualVerificationResponseModel:
        """
        Request manual verification for a PVC voice.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        files : typing.List[core.File]
            See core.File for more documentation

        extra_text : typing.Optional[str]
            Extra text to be used in the manual verification process.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RequestPvcManualVerificationResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.voices.pvc.verification.request(
                voice_id="21m00Tcm4TlvDq8ikWAM",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/voices/pvc/{jsonable_encoder(voice_id)}/verification",
            base_url=self._client_wrapper.get_environment().base,
            method="POST",
            data={
                "extra_text": extra_text,
            },
            files={
                "files": files,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RequestPvcManualVerificationResponseModel,
                    construct_type(
                        type_=RequestPvcManualVerificationResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
