from .data import load_local_csv

REGISTRY = [
    {
        "dataset_name": "ShawnMenz/DAN_jailbreak",
        "num_prompts": 666,
        "tokens": 224196,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/ShawnMenz/DAN_jailbreak",
    },
    {
        "dataset_name": "deepset/prompt-injections",
        "num_prompts": 203,
        "tokens": 6988,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/deepset/prompt-injections",
    },
    {
        "dataset_name": "rubend18/ChatGPT-Jailbreak-Prompts",
        "num_prompts": 79,
        "tokens": 26971,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/rubend18/ChatGPT-Jailbreak-Prompts",
    },
    {
        "dataset_name": "notrichardren/refuse-to-answer-prompts",
        "num_prompts": 522,
        "tokens": 7172,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/notrichardren/refuse-to-answer-prompts",
    },
    {
        "dataset_name": "Lemhf14/EasyJailbreak_Datasets",
        "num_prompts": 1630,
        "tokens": 19758,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/Lemhf14/EasyJailbreak_Datasets",
    },
    {
        "dataset_name": "markush1/LLM-Jailbreak-Classifier",
        "num_prompts": 1119,
        "tokens": 19758,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/markush1/LLM-Jailbreak-Classifier",
    },
    {
        "dataset_name": "JailbreakV-28K/JailBreakV-28k",
        "num_prompts": 28300,
        "tokens": 1975800,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": True,
        "dynamic": False,
        "url": "https://huggingface.co/JailbreakV-28K/JailBreakV-28k",
    },
    {
        "dataset_name": "ShawnMenz/jailbreak_sft_rm_ds",
        "num_prompts": 371000,
        "tokens": 1975800,
        "approx_cost": 0.0,
        "source": "Hugging Face Datasets",
        "selected": False,
        "dynamic": False,
        "url": "https://huggingface.co/ShawnMenz/jailbreak_sft_rm_ds",
    },
    {
        "dataset_name": "Steganography",
        "num_prompts": 10,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Local mutation dataset",
        "selected": False,
        "dynamic": True,
        "url": "",
    },
    {
        "dataset_name": "GPT fuzzer",
        "num_prompts": 10,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Local mutation dataset",
        "selected": False,
        "dynamic": True,
        "url": "",
    },
    {
        "dataset_name": "Agentic Security",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Local dataset",
        "selected": False,
        "dynamic": True,
        "url": "",
    },
    {
        "dataset_name": "jailbreak_llms/2023_05_07",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Github",
        "selected": False,
        "dynamic": True,
        "url": "https://github.com/verazuo/jailbreak_llms",
    },
    {
        "dataset_name": "jailbreak_llms/2023_12_25.csv",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Github",
        "selected": False,
        "dynamic": True,
        "url": "https://github.com/verazuo/jailbreak_llms",
    },
    {
        "dataset_name": "Malwaregen",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Local dataset",
        "selected": False,
        "dynamic": True,
        "url": "",
    },
    {
        "dataset_name": "Hallucination",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Local dataset",
        "selected": False,
        "dynamic": True,
        "url": "",
    },
    {
        "dataset_name": "DataLeak",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Local dataset",
        "selected": False,
        "dynamic": True,
        "url": "",
    },
    {
        "dataset_name": "llm-adaptive-attacks",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Github: tml-epfl/llm-adaptive-attacks#0.0.1",
        "selected": False,
        "dynamic": True,
        "url": "https://github.com/tml-epfl/llm-adaptive-attacks",
    },
    {
        "dataset_name": "Garak",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Github: https://github.com/leondz/garak#v0.9.0.1",
        "selected": False,
        "url": "https://github.com/leondz/garak2",
        "dynamic": True,
    },
    {
        "dataset_name": "InspectAI",
        "num_prompts": 0,
        "tokens": 0,
        "approx_cost": 0.0,
        "source": "Github: https://github.com/UKGovernmentBEIS/inspect_ai",
        "selected": False,
        "url": "https://github.com/UKGovernmentBEIS/inspect_ai",
        "dynamic": True,
    },
    {
        "dataset_name": "Custom CSV",
        "num_prompts": len(load_local_csv().prompts),
        "tokens": load_local_csv().tokens,
        "approx_cost": 0.0,
        "source": f"Local file dataset: {load_local_csv().metadata['src']}",
        "selected": len(load_local_csv().prompts),
        "url": "",
    },
]
