"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
export class Hello {
  public sayHello() {
    return 'hello, world!';
  }
}
*/
//import * as path from 'path';
//import { AssetCode, LayerVersion, Runtime, LayerVersionProps } from 'aws-cdk-lib/aws-lambda';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
class ToolsLayer extends constructs_1.Construct {
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope, id, props) {
        super(scope, id);
        this.layerVersion = new aws_lambda_1.LayerVersion(this, `${props?.layerVersionName}-ToolsLayer`, {
            compatibleRuntimes: [aws_lambda_1.Runtime.NODEJS_16_X],
            //code: AssetCode.fromAsset(path.join(__dirname, './powertools')),
            //code: AssetCode.fromAsset('./src/powertools'),
            code: aws_lambda_1.Code.fromAsset('src/powertools'),
            description: `${props?.layerVersionName} Tools Shared Layer`,
            layerVersionName: `${props?.layerVersionName}-tools`,
        });
    }
}
exports.ToolsLayer = ToolsLayer;
_a = JSII_RTTI_SYMBOL_1;
ToolsLayer[_a] = { fqn: "vaughntech-nodejs-powertools-lambdalayer.ToolsLayer", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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