Print["Testing the calculation of beta functions for the ALP"];

Get["matcher`"];

rges = Get[FileNameJoin[{"ALP_UV_MM", "RGEResult.dat"}]];

(* We take the result from arXiv:2012.09017 *)

literatureresultsALPUVMM = ({
     \[Beta][g1] -> 41/6 g1^3,
     \[Beta][g2] -> -19/6 g2^3,
     \[Beta][g3] -> -7 g3^3,
     \[Beta][alphaOkappas] -> 0,
     \[Beta][alphaOkappasphi] -> 0,
     \[Beta][alphaOlambda] -> 1/2 lambdasphi^2
       - 6 yu[fl1, fl2] yubar[fl3, fl2] yu[fl3, fl4] yubar[fl1, fl4]
       - 6 yd[fl1, fl2] ydbar[fl3, fl2] yd[fl3, fl4] ydbar[fl1, fl4]
       - 2 yl[fl1, fl2] ylbar[fl3, fl2] yl[fl3, fl4] ylbar[fl1, fl4]
       + 3/8 g1^4
       + 9/8 g2^4
       + 3/4 g1^2 g2^2
       + (24 lam - 3 g1^2 - 9 g2^2 + 4 yl[fl1, fl2] ylbar[fl1, fl2] + 
          12 yu[fl1, fl2] yubar[fl1, fl2] + 
          12 yd[fl1, fl2] ydbar[fl1, fl2]) lam,
     \[Beta][alphaOlambdas] -> 3 lambdas^2 + 12 lambdasphi^2,
     \[Beta][
       alphaOlambdasphi] -> (lambdas + 4 lambdasphi + 
         2 yl[fl1, fl2] ylbar[fl1, fl2] + 
         6 yu[fl1, fl2] yubar[fl1, fl2] + 
         6 yd[fl1, fl2] ydbar[fl1, fl2] + 12 lam - 3/2 g1^2 - 
         9/2 g2^2) lambdasphi,
     \[Beta][alphaOms2] -> 4 lambdasphi muH^2 + lambdas ms^2,
     \[Beta][alphaOmuH2] -> 
      lambdasphi ms^2 + (2 yl[fl1, fl2] ylbar[fl1, fl2] + 
          6 yu[fl1, fl2] yubar[fl1, fl2] + 
          6 yd[fl1, fl2] ydbar[fl1, fl2] - 3/2 g1^2 - 9/2 g2^2 + 
          12 lam) muH^2,
     \[Beta][alphaOs] -> 0,
     \[Beta][alphaOs3] -> 0,
     \[Beta][alphaOsB] -> 0,
     \[Beta][alphaOsBt] -> 41/3 g1^2 WCOsBt,
     \[Beta][alphaOsG] -> 0,
     \[Beta][alphaOsGt] -> -14 g3^2 WCOsGt,
     \[Beta][alphaOsW] -> 0,
     \[Beta][alphaOsWt] -> -19/3 g2^2 WCOsWt,
     \[Beta][alphaOlambdau[fl97_, fl99_]] -> 
      3/2 yu[fl97, fl1] yubar[fl2, fl1] yu[fl2, fl99] - 
       3/2 yd[fl97, fl1] ydbar[fl2, fl1] yu[fl2, 
         fl99] + (yl[fl1, fl2] ylbar[fl1, fl2] + 
          3 yu[fl1, fl2] yubar[fl1, fl2] + 
          3 yd[fl1, fl2] ydbar[fl1, fl2] - 17/12 g1^2 - 9/4 g2^2 - 
          8 g3^2) yu[fl97, fl99],
     \[Beta][alphaOlambdad[fl97_, fl99_]] -> 
      3/2 yd[fl97, fl1] ydbar[fl2, fl1] yd[fl2, fl99] - 
       3/2 yu[fl97, fl1] yubar[fl2, fl1] yd[fl2, 
         fl99] + (yl[fl1, fl2] ylbar[fl1, fl2] + 
          3 yu[fl1, fl2] yubar[fl1, fl2] + 
          3 yd[fl1, fl2] ydbar[fl1, fl2] - 5/12 g1^2 - 9/4 g2^2 - 
          8 g3^2) yd[fl97, fl99],
     \[Beta][alphaOlambdae[fl97_, fl99_]] -> 
      3/2 yl[fl97, fl1] ylbar[fl2, fl1] yl[fl2, 
         fl99] + (yl[fl1, fl2] ylbar[fl1, fl2] + 
          3 yu[fl1, fl2] yubar[fl1, fl2] + 
          3 yd[fl1, fl2] ydbar[fl1, fl2] - 15/4 g1^2 - 9/4 g2^2) yl[
         fl97, fl99],
     \[Beta][alphaOsuphi[fl97_, fl99_]] -> 
      2 ((lambdasphi - 17/24 g1^2 - 9/8 g2^2 - 4 g3^2 + 
            1/2 \[Gamma]\[Phi]Y) WCOsuphi[fl97, fl99] - 
         3/4 yd[fl97, fl1] ydbar[fl2, fl1] WCOsuphi[fl2, fl99] + 
         5/4 yu[fl97, fl1] yubar[fl2, fl1] WCOsuphi[fl2, fl99] + 
         WCOsuphi[fl97, fl1] yubar[fl2, fl1] yu[fl2, fl99] + 
         yd[fl97, fl1] WCOsdphi[fl2, fl1] yu[fl2, fl99] - 
         1/2 WCOsdphi[fl97, fl1] ydbar[fl2, fl1] yu[fl2, 
           fl99] - (17/6 g1^2 WCOsBt + 9/2 g2^2 WCOsWt + 
            16 g3^2 WCOsGt + yl[fl1, fl2] WCOsephi[fl1, fl2] + 
            3 yd[fl1, fl2] WCOsdphi[fl1, fl2] - 
            3 WCOsuphi[fl1, fl2] yubar[fl1, fl2]) yu[fl97, fl99]),
     \[Beta][alphaOsdphi[fl97_, fl99_]] -> 
      2 ((lambdasphi - 5/24 g1^2 - 9/8 g2^2 - 4 g3^2 + 
            1/2 \[Gamma]\[Phi]Y) WCOsdphi[fl97, fl99] - 
         3/4 yu[fl97, fl1] yubar[fl2, fl1] WCOsdphi[fl2, fl99] + 
         5/4 yd[fl97, fl1] ydbar[fl2, fl1] WCOsdphi[fl2, fl99] + 
         WCOsdphi[fl97, fl1] ydbar[fl2, fl1] yd[fl2, fl99] + 
         yu[fl97, fl1] WCOsuphi[fl2, fl1] yd[fl2, fl99] - 
         1/2 WCOsuphi[fl97, fl1] yubar[fl2, fl1] yd[fl2, 
           fl99] - (5/6 g1^2 WCOsBt + 9/2 g2^2 WCOsWt + 
            16 g3^2 WCOsGt - (yl[fl1, fl2] WCOsephi[fl1, fl2] + 
              3 yd[fl1, fl2] WCOsdphi[fl1, fl2] - 
              3 WCOsuphi[fl1, fl2] yubar[fl1, fl2])) yd[fl97, fl99]),
     \[Beta][alphaOsephi[fl97_, fl99_]] -> 
      2 ((lambdasphi - 15/8 g1^2 - 9/8 g2^2 + 
            1/2 \[Gamma]\[Phi]Y) WCOsephi[fl97, fl99] + 
         5/4 yl[fl97, fl1] ylbar[fl2, fl1] WCOsephi[fl2, fl99] + 
         WCOsephi[fl97, fl1] ylbar[fl2, fl1] yl[fl2, 
           
           fl99] - (15/2 g1^2 WCOsBt + 
            9/2 g2^2 WCOsWt - (yl[fl1, fl2] WCOsephi[fl1, fl2] + 
              3 yd[fl1, fl2] WCOsdphi[fl1, fl2] - 
              3 WCOsuphi[fl1, fl2] yubar[fl1, fl2])) yl[fl97, 
           fl99])} /. 
    Rule[a_, b_] :> Rule[a, Expand[b/16/Pi^2]]) /. {\[Gamma]\[Phi]Y ->
     yl[fl1, fl2] ylbar[fl1, fl2] + 3 yu[fl1, fl2] yubar[fl1, fl2] + 
     3 yd[fl1, fl2] ydbar[fl1, fl2]};

(*


In 2012.09017 CP conservation was assumed and a slightly different basis used
Here is the translation (we call alpha our wc and c or ctilde the ones in 2012.0917)
alphasuphi=ctildesuphi+I csuphi, ...

The CP conservation condition is given by ctildesuphi=csphi=ckappas=cs5=cs3=cs=csB=csW=csG=0,
implying alphasuphibar=-alphasuphi. 



*)

cpconservation = {kappasphi -> 0, kappas -> 0, WCOs -> 0, WCOs3 -> 0, 
   WCOs5 -> 0, WCOsB -> 0, WCOsW -> 0, WCOsG -> 0, 
   WCOsuphibar[f1_, f2_] -> -WCOsuphi[f1, f2], 
   WCOsdphibar[f1_, f2_] -> -WCOsdphi[f1, f2], 
   WCOsephibar[f1_, f2_] -> -WCOsephi[f1, f2]};
realyukawas = {yubar[a__] -> yu[a], ydbar[a__] -> yd[a], 
   ylbar[a__] -> yl[a]};

betas = rges /. cpconservation;
(*// Simplify;*)

ustothem = {\[Beta][
    alphaOsuphi[f1_, f2_]] -> -I \[Beta][
     alphaOsuphi[f1, f2]], \[Beta][
    alphaOsdphi[f1_, f2_]] -> -I \[Beta][
     alphaOsdphi[f1, f2]], \[Beta][
    alphaOsephi[f1_, f2_]] -> -I \[Beta][alphaOsephi[f1, f2]], 
  WCOsuphi[a_, b_] :> I WCOsuphi[a, b], 
  WCOsdphi[a_, b_] :> I WCOsdphi[a, b], 
  WCOsephi[a_, b_] :> I WCOsephi[a, b], \[Beta][alphaOs] -> 
   0, \[Beta][alphaOs3] -> 0, \[Beta][alphaOs5] -> 
   0, \[Beta][alphaOkappas] -> 0, \[Beta][alphaOkappasphi] -> 0};

listadelta = {KroneckerDelta[a_, b_] f_[c_, b_] -> f[c, a], 
  KroneckerDelta[a_, b_] f_[b_, c_] -> f[a, c], 
  KroneckerDelta[b_, a_] f_[c_, b_] -> f[c, a], 
  KroneckerDelta[b_, a_] f_[b_, c_] -> f[a, c]};

res={}
Do[
 diferencia = 
  DummyZeroQ[((literatureresultsALPUVMM[[i, 
          2]]) - (RemoveUnderscore[literatureresultsALPUVMM[[i, 1]]] /. 
            ustothem /. betas /. ustothem /. listadelta /. iCPV->-1 )) /. 
     realyukawas // Simplify];
     AppendTo[res,diferencia];
 , {i, Length[literatureresultsALPUVMM]}];

Print["\n\n\n"];
If[Length[res]>0&&Length[DeleteCases[res,0]]==0,Print["Test for ALP_UV_MM ok"],
Print["There was a problem with the test for ALP_UV_MM"]; Exit[1]]
Print["\n\n\n"];
