(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "newbasis";

M$Information = {
  Authors      -> {"J. Santiago"}, 
  Version      -> "1.0",
  Date         -> "20. 10. 2021",
  Institutions -> {"CAFPE and Universidad de Granada"},
  Emails       -> {"jsantiago@ugr.es"}
};

FeynmanGauge = True;

(* ************************** *)
(* ************************** *)
(* ************************** *)
(* ************************** *)
(* ************************** *)


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)

  (* Internal Parameters *)

(* Renormalizable couplings *)

  alphaNBK4 == {
    ParameterType -> Internal
  },

  alphaNBR == {
    ParameterType -> Internal
  },

  alphaNBH == {
    ParameterType -> Internal
  },

  alphaNBT == {
    ParameterType -> Internal
  },

  alphaNBHB == {
    ParameterType -> Internal
  }

};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LNP := Block[{ii,mu,nu},
     alphaNBK4 DC[DC[Phibar[ii],mu],mu] DC[DC[Phi[ii],nu],nu]
    +alphaNBR Phibar[ii] Phi[ii] DC[Phibar[jj],mu] DC[Phi[jj],mu]
    +alphaNBH 1/2*del[Phibar[ii] Phi[ii],mu] del[Phibar[jj] Phi[jj],mu]
    +alphaNBT 1/2 (Phibar[ii] DC[Phi[ii],mu] - DC[Phibar[ii],mu] Phi[ii]) (Phibar[jj] DC[Phi[jj],mu]-DC[Phibar[jj],mu] Phi[jj])
    +alphaNBHB I g1 DC[Phibar[ii],mu] DC[Phi[ii],nu] FS[B,mu,nu]
];

Ltot := LSM + LNP;