Print["Testing a Green basis change"];

Get["matcher`"];


eft = "SMEFT_Green_Bpreserving_MM";
full = "newbasis_MM";


Get[FileNameJoin[{full,"MatchingResult.dat"}]];

literature = {
   alphaOH -> \[Lambda]^2 WCNBK4 + \[Lambda] WCNBR,
   alphaOHBox -> -1/2 WCNBH + 1/2 WCNBR - 1/2 WCNBT + g1^2/4 WCNBHB,
   alphaOHD -> -2 WCNBT + g1^2 WCNBHB,
   alphaOHB -> -g1^2/4 WCNBHB,
   alphaOHWB -> -g1 g2/4 WCNBHB,
   alphaOHq1[fl99_, fl97_] -> 
    g1^2/2 (1/6) KroneckerDelta[fl99, fl97] WCNBHB,
   alphaOHl1[fl99_, fl97_] -> 
    g1^2/2 (-1/2) KroneckerDelta[fl99, fl97] WCNBHB,
   alphaOHu[fl99_, fl97_] -> 
    g1^2/2 (2/3) KroneckerDelta[fl99, fl97] WCNBHB,
   alphaOHd[fl99_, fl97_] -> 
    g1^2/2 (-1/3) KroneckerDelta[fl99, fl97] WCNBHB,
   alphaOHe[fl99_, fl97_] -> 
    g1^2/2 (-1) KroneckerDelta[fl99, fl97] WCNBHB,
   alphaOuH[fl99_, fl97_] -> \[Lambda] yu[fl99, fl97] WCNBK4 + 
     1/2 yu[fl99, fl97] WCNBR,
   alphaOdH[fl99_, fl97_] -> \[Lambda] yd[fl99, fl97] WCNBK4 + 
     1/2 yd[fl99, fl97] WCNBR,
   alphaOeH[fl99_, fl97_] -> \[Lambda] yl[fl99, fl97] WCNBK4 + 
     1/2 yl[fl99, fl97] WCNBR
   };


ustothem = {lam -> \[Lambda]/2};


check = DeleteCases[
   literature /. 
    Rule[a_, b_] :> 
     Rule[a, b - (RemoveUnderscore[a] /. MatchingResult[[3]] /. ustothem)], 
   Rule[a_, 0]];


Print["\n\n\n"];
If[Length[check] == 0, 
 Print["All cross checks are good!"], 
 Print["There were problems!!!", check]; Exit[1]]
Print["\n\n\n"];


