(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(*thisdir=NotebookDirectory[];
Print[thisdir];
$FeynRulesPath=SetDirectory["/home/jsantiago/Research/FeynRules/feynrules-current"];
<<FeynRules`;
SetDirectory[thisdir];
FR$Loop=True;
(*<<FR2MM`;*)*)
Print["******************************************************"]
Print["**  ",Style["Welcome to matchmaker-eft",Orange],"                        **"];
Print["**  ",Style["Please refer to XXX when using this program",Blue],"      **"];
Print["******************************************************"]



BeginPackage["matchmakereft`"]


CleanModel::usage="";
CreateModel::usage="";
MatchModeltoEFTAmplitudes::usage="";
MatchModeltoEFTAmplitudesOnlyTree::usage="";
ComputeWilsonCoefficients::usage="";
MatchModeltoEFT::usage="";
MatchModeltoEFTOnlyTree::usage="";
ComputeRGEModeltoEFT::usage="";
CheckLinearDependence::usage="";


Begin["`Private`"]


(*$matchmakerpath="REPLACEPATH"
$matchmakerpath="/home/jsantiago/.local/lib/python3.9/site-packages/matchmakereft/"*)


CleanModel[model_]:=Block[{pythoncode},
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>model<>"'\nmmo.clean_model(models)";
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
]


CreateModel[frfiles__]:=Block[{filelist,pythoncode,str},
filelist=List[frfiles];
Print[Style["Creating model "<>StringReplace[filelist[[-1]],".fr"->"_MM"],Blue]];
Print["This might take some time, please be patient"];
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>StringRiffle[filelist]<>"'\nmmo.create_model(models)";
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
];


MatchModeltoEFTAmplitudes[modelF_,modelE_]:=Block[{pythoncode},
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>StringRiffle[{modelF,modelE}]<>"'\nmmo.match_model_to_eft_amplitudes(models)";
Print[Style["Computing amplitudes to match model "<>modelF<>" onto EFT "<>modelE,Blue]];
Print["This might take some time, please be patient"];
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
];


CheckLinearDependence[modelE_]:=Block[{pythoncode},
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>modelE<>"'\nmmo.check_linear_dependence(models)";
Print[Style["Checking if the operators in EFT "<>modelE<>" are (off-shell) linearly independent.",Blue]];
Print["This might take some time, please be patient"];
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
];


MatchModeltoEFTAmplitudesOnlyTree[modelF_,modelE_]:=Block[{pythoncode},
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>StringRiffle[{modelF,modelE}]<>"'\nmmo.match_model_to_eft_amplitudes_onlytree(models)";
Print[Style["Computing amplitudes to match model "<>modelF<>" onto EFT "<>modelE,Blue]];
Print["This might take some time, please be patient"];
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
];


ComputeWilsonCoefficients[modelF_,modelE_]:=Block[{pythoncode},
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>StringRiffle[{modelF,modelE}]<>"'\nmmo.compute_wilson_coefficients(models)";
Print[Style["Computing the Wilson Coefficients for the matching of model "<>modelF<>" onto EFT "<>modelE,Blue]];
Print["This might take some time, please be patient"];
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
];


MatchModeltoEFT[modelF_,modelE_]:=Block[{},
MatchModeltoEFTAmplitudes[modelF,modelE];
ComputeWilsonCoefficients[modelF,modelE];];


MatchModeltoEFTOnlyTree[modelF_,modelE_]:=Block[{},
MatchModeltoEFTAmplitudesOnlyTree[modelF,modelE];
ComputeWilsonCoefficients[modelF,modelE];];


ComputeRGEModeltoEFT[modelF_,modelE_]:=Block[{pythoncode},
pythoncode="from matchmakereft.libs import mm_offline as mmo\nmodels='"<>StringRiffle[{modelF,modelE}]<>"'\nmmo.compute_rge_model_to_eft(models)";
Print[Style["Computing the beta functions for UV EFT "<>modelF<>" onto EFT "<>modelE,Blue]];
Print["This might take some time, please be patient"];
str=OpenWrite["temp.py"];
WriteString[str,pythoncode];
Close[str];
Print[RunProcess[$SystemShell,"StandardOutput","python3 temp.py"]];
DeleteFile["temp.py"];
]





End[]


EndPackage[]
