def _cmake_to_bool(s):
    return s.upper() not in ['', '0','FALSE','OFF','N','NO','IGNORE','NOTFOUND']

is_python_package    = _cmake_to_bool("TRUE")

BUILD_STUB_FILES     = _cmake_to_bool("ON")
BUILD_UMFPACK        = _cmake_to_bool("")
ENABLE_UNIT_TESTS    = _cmake_to_bool("OFF")
INSTALL_DEPENDENCIES = _cmake_to_bool("OFF")
USE_CCACHE           = _cmake_to_bool("ON")
USE_HYPRE            = _cmake_to_bool("OFF")
USE_LAPACK           = _cmake_to_bool("ON")
USE_MKL              = _cmake_to_bool("ON")
USE_MKL              = _cmake_to_bool("ON")
USE_MUMPS            = _cmake_to_bool("OFF")
USE_PARDISO          = _cmake_to_bool("OFF")
USE_UMFPACK          = _cmake_to_bool("OFF")

NETGEN_DIR = "/opt/_internal/cpython-3.10.14"

NGSOLVE_COMPILE_DEFINITIONS         = "HAVE_NETGEN_SOURCES;HAVE_DLFCN_H;HAVE_CXA_DEMANGLE;USE_TIMEOFDAY;TCL;LAPACK;USE_PARDISO;NGS_PYTHON"
NGSOLVE_COMPILE_DEFINITIONS_PRIVATE = "USE_MKL"
NGSOLVE_COMPILE_INCLUDE_DIRS        = ""
NGSOLVE_COMPILE_OPTIONS             = "$<$<COMPILE_LANGUAGE:CXX>:-std=c++17>;-DMAX_SYS_DIM=3"

NGSOLVE_INSTALL_DIR_PYTHON   = "lib/python3.10/site-packages"
NGSOLVE_INSTALL_DIR_BIN      = "bin"
NGSOLVE_INSTALL_DIR_LIB      = "lib/python3.10/site-packages/netgen_mesher.libs"
NGSOLVE_INSTALL_DIR_INCLUDE  = "include/netgen"
NGSOLVE_INSTALL_DIR_CMAKE    = "lib/cmake/ngsolve"
NGSOLVE_INSTALL_DIR_RES      = "share"

NGSOLVE_VERSION = "6.2.2406"
NGSOLVE_VERSION_GIT = "v6.2.2406-0-g6f16aa5a2"
NGSOLVE_VERSION_PYTHON = "6.2.2406"

NGSOLVE_VERSION_MAJOR = "6"
NGSOLVE_VERSION_MINOR = "2"
NGSOLVE_VERSION_TWEAK = "0"
NGSOLVE_VERSION_PATCH = "2406"
NGSOLVE_VERSION_HASH = "g6f16aa5a2"

CMAKE_CXX_COMPILER           = "/opt/rh/gcc-toolset-12/root/usr/bin/c++"
CMAKE_CUDA_COMPILER          = ""
CMAKE_C_COMPILER             = "/opt/rh/gcc-toolset-12/root/usr/bin/cc"
CMAKE_LINKER                 = "/opt/rh/gcc-toolset-12/root/usr/bin/ld"
CMAKE_INSTALL_PREFIX         = "/builds/ngsolve/ngsolve/_skbuild/linux-x86_64-3.10/cmake-install"
CMAKE_CXX_COMPILER_LAUNCHER  = "/usr/bin/ccache"

version = NGSOLVE_VERSION_GIT

def get_cmake_dir():
    import os.path as p
    d_python = p.dirname(p.dirname(p.dirname(__file__)))
    py_to_cmake = p.relpath(
            NGSOLVE_INSTALL_DIR_CMAKE,
            NGSOLVE_INSTALL_DIR_PYTHON
            )
    return p.normpath(p.join(d_python,py_to_cmake))
