"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .sales_invoice_discount import SalesInvoiceDiscount, SalesInvoiceDiscountTypedDict
from .sales_invoice_email_details import (
    SalesInvoiceEmailDetails,
    SalesInvoiceEmailDetailsTypedDict,
)
from .sales_invoice_line_item import SalesInvoiceLineItem, SalesInvoiceLineItemTypedDict
from .sales_invoice_payment_details import (
    SalesInvoicePaymentDetails,
    SalesInvoicePaymentDetailsTypedDict,
)
from .sales_invoice_payment_term import SalesInvoicePaymentTerm
from .sales_invoice_recipient import (
    SalesInvoiceRecipient,
    SalesInvoiceRecipientTypedDict,
)
from .sales_invoice_status import SalesInvoiceStatus
from .sales_invoice_vat_mode import SalesInvoiceVatMode
from .sales_invoice_vat_scheme import SalesInvoiceVatScheme
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntitySalesInvoiceMetadataTypedDict(TypedDict):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """


class EntitySalesInvoiceMetadata(BaseModel):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """


class EntitySalesInvoiceTypedDict(TypedDict):
    id: NotRequired[str]
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    status: NotRequired[SalesInvoiceStatus]
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """
    vat_scheme: NotRequired[SalesInvoiceVatScheme]
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""
    vat_mode: NotRequired[SalesInvoiceVatMode]
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """
    memo: NotRequired[Nullable[str]]
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""
    metadata: NotRequired[Nullable[EntitySalesInvoiceMetadataTypedDict]]
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    payment_term: NotRequired[Nullable[SalesInvoicePaymentTerm]]
    r"""The payment term to be set on the invoice."""
    payment_details: NotRequired[Nullable[SalesInvoicePaymentDetailsTypedDict]]
    email_details: NotRequired[Nullable[SalesInvoiceEmailDetailsTypedDict]]
    customer_id: NotRequired[str]
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If
    provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`.
    """
    mandate_id: NotRequired[str]
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided,
    `customerId` becomes required as well. Only allowed for invoices with status `paid`.
    """
    recipient_identifier: NotRequired[str]
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """
    recipient: NotRequired[Nullable[SalesInvoiceRecipientTypedDict]]
    lines: NotRequired[Nullable[List[SalesInvoiceLineItemTypedDict]]]
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """
    discount: NotRequired[Nullable[SalesInvoiceDiscountTypedDict]]
    is_e_invoice: NotRequired[bool]
    r"""This indicates whether the invoice is an e-invoice. The default value is `false` and can't be changed
    after the invoice has been issued.

    When `emailDetails` is provided, an additional email is sent to the recipient.
    """
    amount_due: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotal_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_vat_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    discounted_subtotal_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class EntitySalesInvoice(BaseModel):
    id: Optional[str] = None

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    status: Optional[SalesInvoiceStatus] = None
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """

    vat_scheme: Annotated[
        Optional[SalesInvoiceVatScheme], pydantic.Field(alias="vatScheme")
    ] = None
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it."""

    vat_mode: Annotated[
        Optional[SalesInvoiceVatMode], pydantic.Field(alias="vatMode")
    ] = None
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the
    price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.
    """

    memo: OptionalNullable[str] = UNSET
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""

    metadata: OptionalNullable[EntitySalesInvoiceMetadata] = UNSET
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    payment_term: Annotated[
        OptionalNullable[SalesInvoicePaymentTerm], pydantic.Field(alias="paymentTerm")
    ] = UNSET
    r"""The payment term to be set on the invoice."""

    payment_details: Annotated[
        OptionalNullable[SalesInvoicePaymentDetails],
        pydantic.Field(alias="paymentDetails"),
    ] = UNSET

    email_details: Annotated[
        OptionalNullable[SalesInvoiceEmailDetails], pydantic.Field(alias="emailDetails")
    ] = UNSET

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If
    provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`.
    """

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided,
    `customerId` becomes required as well. Only allowed for invoices with status `paid`.
    """

    recipient_identifier: Annotated[
        Optional[str], pydantic.Field(alias="recipientIdentifier")
    ] = None
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """

    recipient: OptionalNullable[SalesInvoiceRecipient] = UNSET

    lines: OptionalNullable[List[SalesInvoiceLineItem]] = UNSET
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """

    discount: OptionalNullable[SalesInvoiceDiscount] = UNSET

    is_e_invoice: Annotated[Optional[bool], pydantic.Field(alias="isEInvoice")] = None
    r"""This indicates whether the invoice is an e-invoice. The default value is `false` and can't be changed
    after the invoice has been issued.

    When `emailDetails` is provided, an additional email is sent to the recipient.
    """

    amount_due: Annotated[Optional[Amount], pydantic.Field(alias="amountDue")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotal_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="subtotalAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[Optional[Amount], pydantic.Field(alias="totalAmount")] = (
        None
    )
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_vat_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="totalVatAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    discounted_subtotal_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="discountedSubtotalAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "testmode",
            "profileId",
            "status",
            "vatScheme",
            "vatMode",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "customerId",
            "mandateId",
            "recipientIdentifier",
            "recipient",
            "lines",
            "discount",
            "isEInvoice",
            "amountDue",
            "subtotalAmount",
            "totalAmount",
            "totalVatAmount",
            "discountedSubtotalAmount",
        ]
        nullable_fields = [
            "testmode",
            "profileId",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "recipient",
            "lines",
            "discount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
